/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.pool.PoolStats;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.inference.external.http.HttpClient;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.IdleConnectionEvictor;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpClientManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(HttpClientManager.class);
    public static final Setting<Integer> MAX_TOTAL_CONNECTIONS = Setting.intSetting((String)"xpack.inference.http.max_total_connections", (int)50, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> MAX_ROUTE_CONNECTIONS = Setting.intSetting((String)"xpack.inference.http.max_route_connections", (int)20, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME = TimeValue.timeValueMinutes((long)1L);
    public static final Setting<TimeValue> CONNECTION_EVICTION_THREAD_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.inference.http.connection_eviction_interval", (TimeValue)DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_CONNECTION_MAX_IDLE_TIME_SETTING = DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME;
    public static final Setting<TimeValue> CONNECTION_MAX_IDLE_TIME_SETTING = Setting.timeSetting((String)"xpack.inference.http.connection_eviction_max_idle_time", (TimeValue)DEFAULT_CONNECTION_MAX_IDLE_TIME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ThreadPool threadPool;
    private final PoolingNHttpClientConnectionManager connectionManager;
    private IdleConnectionEvictor connectionEvictor;
    private final HttpClient httpClient;
    private volatile TimeValue evictionInterval;
    private volatile TimeValue connectionMaxIdle;

    public static HttpClientManager create(Settings settings, ThreadPool threadPool, ClusterService clusterService, ThrottlerManager throttlerManager) {
        PoolingNHttpClientConnectionManager connectionManager = HttpClientManager.createConnectionManager();
        return new HttpClientManager(settings, connectionManager, threadPool, clusterService, throttlerManager);
    }

    public static HttpClientManager create(Settings settings, ThreadPool threadPool, ClusterService clusterService, ThrottlerManager throttlerManager, SSLService sslService) {
        SSLIOSessionStrategy sslioSessionStrategy = sslService.sslIOSessionStrategy(sslService.getSSLConfiguration("xpack.inference.elastic.http.ssl."));
        PoolingNHttpClientConnectionManager connectionManager = HttpClientManager.createConnectionManager(sslioSessionStrategy);
        return new HttpClientManager(settings, connectionManager, threadPool, clusterService, throttlerManager);
    }

    HttpClientManager(Settings settings, PoolingNHttpClientConnectionManager connectionManager, ThreadPool threadPool, ClusterService clusterService, ThrottlerManager throttlerManager) {
        this.threadPool = threadPool;
        this.connectionManager = connectionManager;
        this.setMaxConnections((Integer)MAX_TOTAL_CONNECTIONS.get(settings));
        this.setMaxRouteConnections((Integer)MAX_ROUTE_CONNECTIONS.get(settings));
        this.httpClient = HttpClient.create(new HttpSettings(settings, clusterService), threadPool, connectionManager, throttlerManager);
        this.evictionInterval = (TimeValue)CONNECTION_EVICTION_THREAD_INTERVAL_SETTING.get(settings);
        this.connectionMaxIdle = (TimeValue)CONNECTION_MAX_IDLE_TIME_SETTING.get(settings);
        this.connectionEvictor = this.createConnectionEvictor();
        this.addSettingsUpdateConsumers(clusterService);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(SSLIOSessionStrategy sslStrategy) {
        DefaultConnectingIOReactor ioReactor;
        try {
            IOReactorConfig.Builder configBuilder = IOReactorConfig.custom().setSoKeepAlive(true);
            ioReactor = new DefaultConnectingIOReactor(configBuilder.build());
        }
        catch (IOReactorException e) {
            String message = "Failed to initialize HTTP client manager with SSL.";
            logger.error(message, (Throwable)e);
            throw new ElasticsearchException(message, (Throwable)e, new Object[0]);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)sslStrategy).build();
        return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, registry);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager() {
        DefaultConnectingIOReactor ioReactor;
        try {
            IOReactorConfig.Builder configBuilder = IOReactorConfig.custom().setSoKeepAlive(true);
            ioReactor = new DefaultConnectingIOReactor(configBuilder.build());
        }
        catch (IOReactorException e) {
            String message = "Failed to initialize the inference http client manager";
            logger.error(message, (Throwable)e);
            throw new ElasticsearchException(message, (Throwable)e, new Object[0]);
        }
        return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_TOTAL_CONNECTIONS, this::setMaxConnections);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_ROUTE_CONNECTIONS, this::setMaxRouteConnections);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_EVICTION_THREAD_INTERVAL_SETTING, this::setEvictionInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_MAX_IDLE_TIME_SETTING, this::setConnectionMaxIdle);
    }

    private IdleConnectionEvictor createConnectionEvictor() {
        return new IdleConnectionEvictor(this.threadPool, (NHttpClientConnectionManager)this.connectionManager, this.evictionInterval, this.connectionMaxIdle);
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(MAX_TOTAL_CONNECTIONS, MAX_ROUTE_CONNECTIONS, CONNECTION_EVICTION_THREAD_INTERVAL_SETTING, CONNECTION_MAX_IDLE_TIME_SETTING);
    }

    public void start() {
        this.httpClient.start();
        this.connectionEvictor.start();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public PoolStats getPoolStats() {
        return this.connectionManager.getTotalStats();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
        this.connectionEvictor.close();
    }

    private void setMaxConnections(int maxConnections) {
        this.connectionManager.setMaxTotal(maxConnections);
    }

    private void setMaxRouteConnections(int maxConnections) {
        this.connectionManager.setDefaultMaxPerRoute(maxConnections);
    }

    boolean isEvictionThreadRunning() {
        return this.connectionEvictor.isRunning();
    }

    void setEvictionInterval(TimeValue evictionInterval) {
        logger.debug(() -> Strings.format((String)"Eviction thread's interval time updated to [%s]", (Object[])new Object[]{evictionInterval}));
        this.evictionInterval = evictionInterval;
        this.connectionEvictor.close();
        this.connectionEvictor = this.createConnectionEvictor();
        this.connectionEvictor.start();
    }

    void setConnectionMaxIdle(TimeValue connectionMaxIdle) {
        logger.debug(() -> Strings.format((String)"Eviction thread's max idle time updated to [%s]", (Object[])new Object[]{connectionMaxIdle}));
        this.connectionMaxIdle = connectionMaxIdle;
        this.connectionEvictor.setMaxIdleTime(connectionMaxIdle);
    }
}

