/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.azureaistudio;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.azureaistudio.AzureAiStudioChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.azureaistudio.AzureAiStudioRequest;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionTaskSettings;

public class AzureAiStudioChatCompletionRequest
extends AzureAiStudioRequest {
    private final List<String> input;
    private final AzureAiStudioChatCompletionModel completionModel;
    private final boolean stream;

    public AzureAiStudioChatCompletionRequest(AzureAiStudioChatCompletionModel model, List<String> input, boolean stream) {
        super(model);
        this.input = Objects.requireNonNull(input);
        this.completionModel = Objects.requireNonNull(model);
        this.stream = stream;
    }

    public boolean isRealtimeEndpoint() {
        return this.isRealtimeEndpoint;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)this.createRequestEntity()).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.setAuthHeader((HttpEntityEnclosingRequestBase)httpPost, this.completionModel);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public boolean isStreaming() {
        return this.stream;
    }

    private AzureAiStudioChatCompletionRequestEntity createRequestEntity() {
        AzureAiStudioChatCompletionTaskSettings taskSettings = this.completionModel.getTaskSettings();
        AzureAiStudioChatCompletionServiceSettings serviceSettings = this.completionModel.getServiceSettings();
        return new AzureAiStudioChatCompletionRequestEntity(this.input, serviceSettings.endpointType(), taskSettings.temperature(), taskSettings.topP(), taskSettings.doSample(), taskSettings.maxNewTokens(), this.isStreaming());
    }
}

