/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.anthropic;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class AnthropicChatCompletionResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Anthropic chat completions response";

    public static ChatCompletionResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "content", FAILED_TO_FIND_FIELD_TEMPLATE);
            List<ChatCompletionResults.Result> completionResults = AnthropicChatCompletionResponseEntity.doParse(jsonParser);
            ChatCompletionResults chatCompletionResults = new ChatCompletionResults(completionResults);
            return chatCompletionResults;
        }
    }

    private static List<ChatCompletionResults.Result> doParse(XContentParser parser) throws IOException {
        List parsedResults = XContentParserUtils.parseList((XContentParser)parser, listParser -> {
            TextObject parsedObject = TextObject.parse(parser);
            if (parsedObject.type == null || !parsedObject.type.equals("text") || parsedObject.text == null) {
                return null;
            }
            return new ChatCompletionResults.Result(parsedObject.text);
        });
        parsedResults.removeIf(Objects::isNull);
        return parsedResults;
    }

    private record TextObject(@Nullable String type, @Nullable String text) {
        private static final ParseField TEXT = new ParseField("text", new String[0]);
        private static final ParseField TYPE = new ParseField("type", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("anthropic_chat_completions_response", true, Builder::new);

        public static TextObject parse(XContentParser parser) throws IOException {
            Builder builder = (Builder)PARSER.apply(parser, null);
            return builder.build();
        }

        static {
            PARSER.declareString(Builder::setText, TEXT);
            PARSER.declareString(Builder::setType, TYPE);
        }

        private static final class Builder {
            private String type;
            private String text;

            private Builder() {
            }

            public Builder setType(String type) {
                this.type = type;
                return this;
            }

            public Builder setText(String text) {
                this.text = text;
                return this;
            }

            public TextObject build() {
                return new TextObject(this.type, this.text);
            }
        }
    }
}

