/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class HuggingFaceModel
extends Model {
    private final HuggingFaceRateLimitServiceSettings rateLimitServiceSettings;
    private final SecureString apiKey;

    public HuggingFaceModel(ModelConfigurations configurations, ModelSecrets secrets, HuggingFaceRateLimitServiceSettings rateLimitServiceSettings, @Nullable ApiKeySecrets apiKeySecrets) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    public HuggingFaceRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public abstract Integer getTokenLimit();

    public abstract ExecutableAction accept(HuggingFaceActionVisitor var1);
}

