/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;
import org.elasticsearch.xpack.watcher.transform.script.WatcherTransformScript;

public class ExecutableScriptTransform
extends ExecutableTransform<ScriptTransform, ScriptTransform.Result> {
    private final ScriptService scriptService;

    public ExecutableScriptTransform(ScriptTransform transform, Logger logger, ScriptService scriptService) {
        super((Transform)transform, logger);
        this.scriptService = scriptService;
        Script script = transform.getScript();
        scriptService.compile(script, WatcherTransformScript.CONTEXT);
    }

    public ScriptTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        try {
            return this.doExecute(ctx, payload);
        }
        catch (Exception e) {
            this.logger.error(() -> Strings.format((String)"failed to execute [%s] transform for [%s]", (Object[])new Object[]{"script", ctx.id()}), (Throwable)e);
            return new ScriptTransform.Result(e);
        }
    }

    ScriptTransform.Result doExecute(WatchExecutionContext ctx, Payload payload) throws IOException {
        Script script = ((ScriptTransform)this.transform).getScript();
        WatcherTransformScript.Factory factory = (WatcherTransformScript.Factory)this.scriptService.compile(script, WatcherTransformScript.CONTEXT);
        WatcherTransformScript transformScript = factory.newInstance(script.getParams(), ctx, payload);
        Object value = transformScript.execute();
        if (value instanceof Map) {
            Payload.Simple simplePayload = new Payload.Simple((Map)value);
            return new ScriptTransform.Result((Payload)simplePayload);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_value", value);
        return new ScriptTransform.Result((Payload)new Payload.Simple(data));
    }
}

