/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.EntryPair;
import org.ojalgo.type.keyvalue.EntrySet;
import org.ojalgo.type.keyvalue.Paired;

public class IndexedMap<K, V>
extends AbstractMap<K, V>
implements Paired<K, V> {
    private final EntrySet<K, V> myEntrySet;

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, byte defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        byte[] values = new byte[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectByte<Enum>(keys, values));
    }

    public static <K extends Enum<K>, V> IndexedMap<K, V> of(Class<K> keyType, Class<V> valueType) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        Object[] values = (Object[])Array.newInstance(valueType, keys.length);
        for (int i = 0; i < values.length; ++i) {
            try {
                values[i] = valueType.newInstance();
                continue;
            }
            catch (IllegalAccessException | InstantiationException exception) {
                values[i] = null;
            }
        }
        return new IndexedMap<Enum, Object>(new EntrySet.ObjectObject<Enum, Object>(keys, values));
    }

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, double defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        double[] values = new double[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectDouble<Enum>(keys, values));
    }

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, float defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        float[] values = new float[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectFloat<Enum>(keys, values));
    }

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, int defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        int[] values = new int[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectInt<Enum>(keys, values));
    }

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, long defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        long[] values = new long[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectLong<Enum>(keys, values));
    }

    public static <K extends Enum<K>> MappedPrimitives<K> of(Class<K> keyType, short defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        short[] values = new short[keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new MappedPrimitives<Enum>((EntrySet.KeyedPrimitives<Enum>)new EntrySet.ObjectShort<Enum>(keys, values));
    }

    public static <K extends Enum<K>, V> IndexedMap<K, V> of(Class<K> keyType, V defaultValue) {
        Enum[] keys = (Enum[])keyType.getEnumConstants();
        Object[] values = (Object[])Array.newInstance(defaultValue.getClass(), keys.length);
        for (int i = 0; i < values.length; ++i) {
            values[i] = defaultValue;
        }
        return new IndexedMap<Enum, Object>(new EntrySet.ObjectObject<Enum, Object>(keys, values));
    }

    IndexedMap(EntrySet<K, V> entries) {
        this.myEntrySet = entries;
    }

    public EntrySet<K, V> entrySet() {
        return this.myEntrySet;
    }

    @Override
    public K getKey(int index) {
        return this.myEntrySet.getKey(index);
    }

    @Override
    public EntryPair<K, V> getPair(int index) {
        return this.myEntrySet.getPair(index);
    }

    @Override
    public V getValue(int index) {
        return this.myEntrySet.getValue(index);
    }

    @Override
    public int size() {
        return this.myEntrySet.size();
    }

    public static final class MappedPrimitives<K>
    extends IndexedMap<K, PrimitiveNumber>
    implements Access1D<PrimitiveNumber>,
    Mutate1D {
        private final EntrySet.KeyedPrimitives<K> myEntries;

        MappedPrimitives(EntrySet.KeyedPrimitives<K> entries) {
            super(entries);
            this.myEntries = entries;
        }

        @Override
        public byte byteValue(long index) {
            return this.myEntries.byteValue(index);
        }

        @Override
        public long count() {
            return this.myEntries.count();
        }

        @Override
        public double doubleValue(long index) {
            return this.myEntries.doubleValue(index);
        }

        @Override
        public float floatValue(long index) {
            return this.myEntries.floatValue(index);
        }

        @Override
        public PrimitiveNumber get(long index) {
            return this.myEntries.get(index);
        }

        @Override
        public int intValue(long index) {
            return this.myEntries.intValue(index);
        }

        @Override
        public long longValue(long index) {
            return this.myEntries.longValue(index);
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myEntries.set(index, value);
        }

        @Override
        public void set(long index, double value) {
            this.myEntries.set(index, value);
        }

        @Override
        public void set(long index, float value) {
            this.myEntries.set(index, value);
        }

        @Override
        public short shortValue(long index) {
            return this.myEntries.shortValue(index);
        }
    }
}

