/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.pool.PoolStats;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetInferenceDiagnosticsAction
extends ActionType<Response> {
    public static final GetInferenceDiagnosticsAction INSTANCE = new GetInferenceDiagnosticsAction();
    public static final String NAME = "cluster:monitor/xpack/inference/diagnostics/get";

    public GetInferenceDiagnosticsAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse
    implements ToXContentFragment {
        static final String CONNECTION_POOL_STATS_FIELD_NAME = "connection_pool_stats";
        private final ConnectionPoolStats connectionPoolStats;

        public NodeResponse(DiscoveryNode node, PoolStats poolStats) {
            super(node);
            this.connectionPoolStats = ConnectionPoolStats.of(poolStats);
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.connectionPoolStats = new ConnectionPoolStats(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.connectionPoolStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(CONNECTION_POOL_STATS_FIELD_NAME, (ToXContent)this.connectionPoolStats, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse response = (NodeResponse)((Object)o);
            return Objects.equals(this.connectionPoolStats, response.connectionPoolStats);
        }

        public int hashCode() {
            return Objects.hash(this.connectionPoolStats);
        }

        ConnectionPoolStats getConnectionPoolStats() {
            return this.connectionPoolStats;
        }

        static class ConnectionPoolStats
        implements ToXContentObject,
        Writeable {
            static final String LEASED_CONNECTIONS = "leased_connections";
            static final String PENDING_CONNECTIONS = "pending_connections";
            static final String AVAILABLE_CONNECTIONS = "available_connections";
            static final String MAX_CONNECTIONS = "max_connections";
            private final int leasedConnections;
            private final int pendingConnections;
            private final int availableConnections;
            private final int maxConnections;

            static ConnectionPoolStats of(PoolStats poolStats) {
                return new ConnectionPoolStats(poolStats.getLeased(), poolStats.getPending(), poolStats.getAvailable(), poolStats.getMax());
            }

            ConnectionPoolStats(int leasedConnections, int pendingConnections, int availableConnections, int maxConnections) {
                this.leasedConnections = leasedConnections;
                this.pendingConnections = pendingConnections;
                this.availableConnections = availableConnections;
                this.maxConnections = maxConnections;
            }

            ConnectionPoolStats(StreamInput in) throws IOException {
                this.leasedConnections = in.readVInt();
                this.pendingConnections = in.readVInt();
                this.availableConnections = in.readVInt();
                this.maxConnections = in.readVInt();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(LEASED_CONNECTIONS, this.leasedConnections);
                builder.field(PENDING_CONNECTIONS, this.pendingConnections);
                builder.field(AVAILABLE_CONNECTIONS, this.availableConnections);
                builder.field(MAX_CONNECTIONS, this.maxConnections);
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeVInt(this.leasedConnections);
                out.writeVInt(this.pendingConnections);
                out.writeVInt(this.availableConnections);
                out.writeVInt(this.maxConnections);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ConnectionPoolStats that = (ConnectionPoolStats)o;
                return this.leasedConnections == that.leasedConnections && this.pendingConnections == that.pendingConnections && this.availableConnections == that.availableConnections && this.maxConnections == that.maxConnections;
            }

            public int hashCode() {
                return Objects.hash(this.leasedConnections, this.pendingConnections, this.availableConnections, this.maxConnections);
            }

            int getLeasedConnections() {
                return this.leasedConnections;
            }

            int getPendingConnections() {
                return this.pendingConnections;
            }

            int getAvailableConnections() {
                return this.availableConnections;
            }

            int getMaxConnections() {
                return this.maxConnections;
            }
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (Map.Entry entry : this.getNodesMap().entrySet()) {
                NodeResponse response = (NodeResponse)((Object)entry.getValue());
                builder.startObject((String)entry.getKey());
                response.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.getNodes(), that.getNodes()) && Objects.equals(this.failures(), that.failures());
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.failures());
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest() {
        }
    }

    public static class Request
    extends BaseNodesRequest {
        public Request() {
            super((String[])null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && ((Object)((Object)this)).getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hash(GetInferenceDiagnosticsAction.NAME);
        }
    }
}

