/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.rolemapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authc.support.mapper.TemplateRoleName;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class PutRoleMappingRequest
extends ActionRequest
implements WriteRequest<PutRoleMappingRequest> {
    private String name = null;
    private boolean enabled = true;
    private List<String> roles = Collections.emptyList();
    private List<TemplateRoleName> roleTemplates = Collections.emptyList();
    private RoleMapperExpression rules = null;
    private Map<String, Object> metadata = Collections.emptyMap();
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public PutRoleMappingRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.enabled = in.readBoolean();
        this.roles = in.readStringCollectionAsList();
        this.roleTemplates = in.readCollectionAsList(TemplateRoleName::new);
        this.rules = ExpressionParser.readExpression(in);
        this.metadata = in.readGenericMap();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public PutRoleMappingRequest() {
    }

    public ActionRequestValidationException validate() {
        return this.validate(true);
    }

    public ActionRequestValidationException validate(boolean validateMetadata) {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError((String)"role-mapping name is missing", validationException);
        }
        if (this.roles.isEmpty() && this.roleTemplates.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"role-mapping roles or role-templates are missing", (ActionRequestValidationException)validationException);
        }
        if (this.roles.size() > 0 && this.roleTemplates.size() > 0) {
            validationException = ValidateActions.addValidationError((String)"role-mapping cannot have both roles and role-templates", (ActionRequestValidationException)validationException);
        }
        if (this.rules == null) {
            validationException = ValidateActions.addValidationError((String)"role-mapping rules are missing", (ActionRequestValidationException)validationException);
        }
        if (validateMetadata && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = this.metadata.containsKey("_read_only") ? ValidateActions.addValidationError((String)"metadata contains [_read_only] flag. You cannot create or update role-mappings with a read-only flag", (ActionRequestValidationException)validationException) : ValidateActions.addValidationError((String)"metadata keys may not start with [_]", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<TemplateRoleName> getRoleTemplates() {
        return Collections.unmodifiableList(this.roleTemplates);
    }

    public void setRoles(List<String> roles) {
        this.roles = new ArrayList<String>(roles);
    }

    public void setRoleTemplates(List<TemplateRoleName> templates) {
        this.roleTemplates = new ArrayList<TemplateRoleName>(templates);
    }

    public RoleMapperExpression getRules() {
        return this.rules;
    }

    public void setRules(RoleMapperExpression expression) {
        this.rules = expression;
    }

    public PutRoleMappingRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeBoolean(this.enabled);
        out.writeStringCollection(this.roles);
        out.writeCollection(this.roleTemplates);
        ExpressionParser.writeExpression(this.rules, out);
        out.writeGenericMap(this.metadata);
        this.refreshPolicy.writeTo(out);
    }

    public ExpressionRoleMapping getMapping() {
        return new ExpressionRoleMapping(this.name, this.rules, this.roles, this.roleTemplates, this.metadata, this.enabled);
    }
}

