/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import co.elastic.logging.log4j2.EcsLayout;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.ECSJsonLayout;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.RateLimitingFilter;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.deprecation.Deprecation;
import org.elasticsearch.xpack.deprecation.logging.DeprecationIndexingAppender;

public class DeprecationIndexingComponent
extends AbstractLifecycleComponent
implements ClusterStateListener {
    public static final Setting<TimeValue> DEPRECATION_INDEXING_FLUSH_INTERVAL = Setting.timeSetting((String)"cluster.deprecation_indexing.flush_interval", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(DeprecationIndexingComponent.class);
    private final DeprecationIndexingAppender appender;
    private final BulkProcessor2 processor;
    private final ConcurrentLinkedQueue<Runnable> pendingRequestsBuffer = new ConcurrentLinkedQueue();
    private final RateLimitingFilter rateLimitingFilterForIndexing;
    private final ClusterService clusterService;
    private final AtomicBoolean flushEnabled = new AtomicBoolean(false);

    private DeprecationIndexingComponent(Client client, Settings settings, RateLimitingFilter rateLimitingFilterForIndexing, boolean enableDeprecationLogIndexingDefault, ClusterService clusterService) {
        this.rateLimitingFilterForIndexing = rateLimitingFilterForIndexing;
        this.clusterService = clusterService;
        this.processor = this.getBulkProcessor((Client)new OriginSettingClient(client, "deprecation"), settings);
        Consumer<IndexRequest> consumer = arg_0 -> ((BulkProcessor2)this.processor).add(arg_0);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        EcsLayout ecsLayout = ((ECSJsonLayout.Builder)ECSJsonLayout.newBuilder().setDataset("elasticsearch.deprecation").setConfiguration(configuration)).build();
        this.appender = new DeprecationIndexingAppender("deprecation_indexing_appender", (Filter)rateLimitingFilterForIndexing, (Layout<String>)ecsLayout, consumer);
        this.enableDeprecationLogIndexing(enableDeprecationLogIndexingDefault);
    }

    public static DeprecationIndexingComponent createDeprecationIndexingComponent(Client client, Settings settings, RateLimitingFilter rateLimitingFilterForIndexing, boolean enableDeprecationLogIndexingDefault, ClusterService clusterService) {
        DeprecationIndexingComponent deprecationIndexingComponent = new DeprecationIndexingComponent(client, settings, rateLimitingFilterForIndexing, enableDeprecationLogIndexingDefault, clusterService);
        clusterService.addListener((ClusterStateListener)deprecationIndexingComponent);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(Deprecation.WRITE_DEPRECATION_LOGS_TO_INDEX, deprecationIndexingComponent::enableDeprecationLogIndexing);
        return deprecationIndexingComponent;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.flushEnabled.get()) {
            return;
        }
        if (!event.metadataChanged()) {
            return;
        }
        IndexLifecycleMetadata indexLifecycleMetadata = (IndexLifecycleMetadata)event.state().metadata().custom("index_lifecycle");
        if (event.state().getMetadata().templatesV2().containsKey(".deprecation-indexing-template-9") && indexLifecycleMetadata != null && indexLifecycleMetadata.getPolicies().containsKey(".deprecation-indexing-ilm-policy")) {
            this.flushEnabled.set(true);
            this.flushBuffer();
            logger.debug("Deprecation log indexing started, because both template and ilm policy are loaded");
            this.clusterService.removeListener((ClusterStateListener)this);
        }
    }

    private void flushBuffer() {
        Runnable pendingRequest = this.pendingRequestsBuffer.poll();
        while (pendingRequest != null) {
            pendingRequest.run();
            pendingRequest = this.pendingRequestsBuffer.poll();
        }
    }

    protected void doStart() {
        logger.info("deprecation component started");
        this.appender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
    }

    protected void doStop() {
        Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
        this.flushEnabled.set(false);
        this.appender.stop();
    }

    protected void doClose() {
        this.processor.close();
    }

    public void enableDeprecationLogIndexing(boolean newEnabled) {
        if (this.appender.isEnabled() != newEnabled) {
            this.appender.setEnabled(newEnabled);
            if (newEnabled) {
                this.rateLimitingFilterForIndexing.reset();
            }
        }
    }

    private BulkProcessor2 getBulkProcessor(Client client, Settings settings) {
        TimeValue flushInterval = (TimeValue)DEPRECATION_INDEXING_FLUSH_INTERVAL.get(settings);
        DeprecationBulkListener listener = new DeprecationBulkListener();
        return BulkProcessor2.builder((bulkRequest, actionListener) -> {
            if (this.flushEnabled.get()) {
                logger.trace("Flush is enabled, sending a bulk request");
                client.bulk(bulkRequest, actionListener);
                this.flushBuffer();
            } else {
                logger.trace("Flush is disabled, scheduling a bulk request");
                this.pendingRequestsBuffer.offer(() -> client.bulk(bulkRequest, actionListener));
            }
        }, (BulkProcessor2.Listener)listener, (ThreadPool)client.threadPool()).setMaxNumberOfRetries(3).setFlushInterval(flushInterval).build();
    }

    private static class DeprecationBulkListener
    implements BulkProcessor2.Listener {
        private DeprecationBulkListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            long numberOfActions = request.numberOfActions();
            if (logger.isTraceEnabled()) {
                logger.trace("indexed [{}] deprecation documents into [{}]", (Object)numberOfActions, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
            }
            if (response.hasFailures()) {
                List failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).map(r -> r.getId() + " " + r.getFailureMessage()).collect(Collectors.toList());
                logger.error("Bulk write of deprecation logs encountered some failures: [{}]", failures);
            }
        }

        public void afterBulk(long executionId, BulkRequest request, Exception failure) {
            logger.error("Bulk write of " + request.numberOfActions() + " deprecation logs failed: " + failure.getMessage(), (Throwable)failure);
        }
    }
}

