/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.ExceptionCollectionHandling;

public class TransportCloseJobAction
extends TransportTasksAction<JobTask, CloseJobAction.Request, CloseJobAction.Response, CloseJobAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportCloseJobAction.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final AnomalyDetectionAuditor auditor;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;

    @Inject
    public TransportCloseJobAction(TransportService transportService, Client client, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, AnomalyDetectionAuditor auditor, PersistentTasksService persistentTasksService, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider) {
        super("cluster:admin/xpack/ml/job/close", clusterService, transportService, actionFilters, CloseJobAction.Request::new, CloseJobAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.auditor = auditor;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
    }

    protected void doExecute(Task task, CloseJobAction.Request request, ActionListener<CloseJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!request.isLocal() && !nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, CloseJobAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            }
        } else {
            boolean isForce = request.isForce();
            TimeValue timeout = request.getCloseTimeout();
            PersistentTasksCustomMetadata tasksMetadata = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            this.jobConfigProvider.expandJobsIds(request.getJobId(), request.allowNoMatch(), true, tasksMetadata, isForce, null, (ActionListener<SortedSet<String>>)listener.delegateFailureAndWrap((delegate, expandedJobIds) -> this.validate((Collection<String>)expandedJobIds, isForce, tasksMetadata, (ActionListener<OpenAndClosingIds>)delegate.delegateFailureAndWrap((delegate2, response) -> this.stopDatafeedsIfNecessary((OpenAndClosingIds)response, isForce, timeout, tasksMetadata, (ActionListener<Boolean>)delegate2.delegateFailureAndWrap((delegate3, bool) -> {
                request.setOpenJobIds(response.openJobIds.toArray(new String[0]));
                if (response.openJobIds.isEmpty() && response.closingJobIds.isEmpty()) {
                    delegate3.onResponse((Object)new CloseJobAction.Response(true));
                    return;
                }
                if (isForce) {
                    ArrayList<String> jobIdsToForceClose = new ArrayList<String>(response.openJobIds);
                    jobIdsToForceClose.addAll(response.closingJobIds);
                    this.forceCloseJob(state, request, jobIdsToForceClose, (ActionListener<CloseJobAction.Response>)delegate3);
                } else {
                    HashSet<String> executorNodes = new HashSet<String>();
                    PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
                    for (String resolvedJobId : request.getOpenJobIds()) {
                        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)resolvedJobId, (PersistentTasksCustomMetadata)tasks);
                        if (jobTask == null) {
                            String msg = "Requested job [" + resolvedJobId + "] be stopped, but job's task could not be found.";
                            assert (jobTask != null) : msg;
                            logger.error(msg);
                            continue;
                        }
                        if (jobTask.isAssigned()) {
                            executorNodes.add(jobTask.getExecutorNode());
                            continue;
                        }
                        this.persistentTasksService.sendRemoveRequest(jobTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.trace(() -> Strings.format((String)"[%s] removed task to close unassigned job", (Object[])new Object[]{resolvedJobId})), e -> logger.error(() -> Strings.format((String)"[%s] failed to remove task to close unassigned job", (Object[])new Object[]{resolvedJobId}), (Throwable)e)));
                    }
                    request.setNodes(executorNodes.toArray(new String[0]));
                    this.normalCloseJob(state, task, request, response.openJobIds, response.closingJobIds, (ActionListener<CloseJobAction.Response>)delegate3);
                }
            }))))));
        }
    }

    void validate(Collection<String> expandedJobIds, boolean forceClose, PersistentTasksCustomMetadata tasksMetadata, ActionListener<OpenAndClosingIds> listener) {
        OpenAndClosingIds ids = new OpenAndClosingIds();
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (String jobId : expandedJobIds) {
            TransportCloseJobAction.addJobAccordingToState(jobId, tasksMetadata, ids.openJobIds, ids.closingJobIds, failedJobs);
        }
        if (!forceClose && failedJobs.size() > 0) {
            if (expandedJobIds.size() == 1) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"cannot close job [{}] because it failed, use force close", (Object[])new Object[]{expandedJobIds.iterator().next()}));
                return;
            }
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"one or more jobs have state failed, use force close", (Object[])new Object[0]));
            return;
        }
        ids.openJobIds.addAll(failedJobs);
        listener.onResponse((Object)ids);
    }

    void stopDatafeedsIfNecessary(OpenAndClosingIds jobIds, boolean isForce, TimeValue timeout, PersistentTasksCustomMetadata tasksMetadata, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedIdsForJobIds(jobIds.openJobIds, (ActionListener<Set<String>>)listener.delegateFailureAndWrap((delegate, datafeedIds) -> {
            List<String> runningDatafeedIds = datafeedIds.stream().filter(datafeedId -> MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetadata)tasksMetadata) != DatafeedState.STOPPED).collect(Collectors.toList());
            if (runningDatafeedIds.isEmpty()) {
                delegate.onResponse((Object)false);
            } else if (isForce) {
                this.isolateDatafeeds(jobIds.openJobIds, runningDatafeedIds, (ActionListener<Void>)delegate.delegateFailureAndWrap((l, r) -> this.stopDatafeeds(runningDatafeedIds, true, timeout, (ActionListener<Boolean>)l)));
            } else {
                this.stopDatafeeds(runningDatafeedIds, false, timeout, (ActionListener<Boolean>)delegate);
            }
        }));
    }

    private void stopDatafeeds(List<String> runningDatafeedIds, boolean isForce, TimeValue timeout, ActionListener<Boolean> listener) {
        StopDatafeedAction.Request request = new StopDatafeedAction.Request(String.join((CharSequence)",", runningDatafeedIds));
        request.setForce(isForce);
        request.setStopTimeout(timeout);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)r.isStopped()), e -> listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"failed to close jobs as one or more had started datafeeds that could not be stopped: started datafeeds [{}], error stopping them [{}]", (Throwable)e, (Object[])new Object[]{request.getDatafeedId(), e.getMessage()}))));
    }

    void isolateDatafeeds(List<String> openJobs, List<String> runningDatafeedIds, ActionListener<Void> listener) {
        GroupedActionListener groupedListener = new GroupedActionListener(runningDatafeedIds.size(), ActionListener.wrap(c -> listener.onResponse(null), e -> {
            logger.info("could not isolate all datafeeds while force closing jobs " + String.valueOf(openJobs), (Throwable)e);
            listener.onResponse(null);
        }));
        for (String runningDatafeedId : runningDatafeedIds) {
            IsolateDatafeedAction.Request request = new IsolateDatafeedAction.Request(runningDatafeedId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)groupedListener);
        }
    }

    static void addJobAccordingToState(String jobId, PersistentTasksCustomMetadata tasksMetadata, List<String> openJobs, List<String> closingJobs, List<String> failedJobs) {
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetadata)tasksMetadata);
        switch (jobState) {
            case CLOSING: {
                closingJobs.add(jobId);
                break;
            }
            case FAILED: {
                failedJobs.add(jobId);
                break;
            }
            case OPENING: 
            case OPENED: {
                openJobs.add(jobId);
            }
        }
    }

    static WaitForCloseRequest buildWaitForCloseRequest(List<String> openJobIds, List<String> closingJobIds, PersistentTasksCustomMetadata tasks, AnomalyDetectionAuditor auditor) {
        PersistentTasksCustomMetadata.PersistentTask jobTask;
        WaitForCloseRequest waitForCloseRequest = new WaitForCloseRequest();
        for (String jobId : openJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            auditor.info(jobId, "Job is closing");
            waitForCloseRequest.persistentTasks.add(jobTask);
            waitForCloseRequest.jobsToFinalize.add(jobId);
        }
        for (String jobId : closingJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            waitForCloseRequest.persistentTasks.add(jobTask);
        }
        return waitForCloseRequest;
    }

    protected void taskOperation(CancellableTask actionTask, CloseJobAction.Request request, final JobTask jobTask, final ActionListener<CloseJobAction.Response> listener) {
        JobTaskState taskState = new JobTaskState(JobState.CLOSING, jobTask.getAllocationId(), "close job (api)", Instant.now());
        jobTask.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(this){

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    logger.trace(() -> Strings.format((String)"[%s] [%s] failed to close job due to resource not found exception", (Object[])new Object[]{jobTask.getJobId(), jobTask.getId()}), (Throwable)e);
                    jobTask.closeJob("close job (api)");
                    listener.onResponse((Object)new CloseJobAction.Response(true));
                } else {
                    listener.onFailure(e);
                }
            }

            protected void doRun() {
                jobTask.closeJob("close job (api)");
                listener.onResponse((Object)new CloseJobAction.Response(true));
            }
        }), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                logger.trace(() -> Strings.format((String)"[%s] [%s] failed to update job to closing due to resource not found exception", (Object[])new Object[]{jobTask.getJobId(), jobTask.getId()}), (Throwable)e);
                listener.onResponse((Object)new CloseJobAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    protected CloseJobAction.Response newResponse(CloseJobAction.Request request, List<CloseJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getOpenJobIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.taskOperationFailureToStatusException((TaskOperationFailure)taskOperationFailures.get(0));
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw failedNodeExceptions.get(0);
            }
            return new CloseJobAction.Response(true);
        }
        return new CloseJobAction.Response(tasks.stream().allMatch(CloseJobAction.Response::isClosed));
    }

    private void forceCloseJob(ClusterState currentState, final CloseJobAction.Request request, List<String> jobIdsToForceClose, final ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        final int numberOfJobs = jobIdsToForceClose.size();
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(numberOfJobs);
        for (String jobId : jobIdsToForceClose) {
            PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            this.auditor.info(jobId, "Job is closing (forced)");
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(this){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                    if (counter.incrementAndGet() == numberOfJobs) {
                        2.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                public void onFailure(Exception e) {
                    int slot = counter.incrementAndGet();
                    if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                        failures.set(slot - 1, (Object)e);
                    }
                    if (slot == numberOfJobs) {
                        2.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                private static void sendResponseOrFailure(String jobId, ActionListener<CloseJobAction.Response> listener2, AtomicArray<Exception> failures2) {
                    List caughtExceptions = failures2.asList();
                    if (caughtExceptions.isEmpty()) {
                        listener2.onResponse((Object)new CloseJobAction.Response(true));
                        return;
                    }
                    String msg = "Failed to force close job [" + jobId + "] with [" + caughtExceptions.size() + "] failures, rethrowing first. All Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                    ElasticsearchStatusException e = ExceptionCollectionHandling.exceptionArrayToStatusException(failures2, msg);
                    listener2.onFailure((Exception)e);
                }
            });
        }
    }

    private void normalCloseJob(ClusterState currentState, Task task, CloseJobAction.Request request, List<String> openJobIds, List<String> closingJobIds, ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        WaitForCloseRequest waitForCloseRequest = TransportCloseJobAction.buildWaitForCloseRequest(openJobIds, closingJobIds, tasks, this.auditor);
        if (!waitForCloseRequest.hasJobsToWaitFor()) {
            listener.onResponse((Object)new CloseJobAction.Response(true));
            return;
        }
        Set movedJobs = ConcurrentCollections.newConcurrentSet();
        ActionListener intermediateListener = listener.delegateFailureAndWrap((delegate, response) -> {
            for (String jobId : movedJobs) {
                PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
                this.persistentTasksService.sendRemoveRequest(jobTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.trace("[{}] removed persistent task for relocated job", (Object)jobId), e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        logger.debug("[{}] relocated job task already removed", (Object)jobId);
                    } else {
                        logger.error("[" + jobId + "] failed to remove task to stop relocated job", (Throwable)e);
                    }
                }));
            }
            delegate.onResponse(response);
        });
        boolean noOpenJobsToClose = openJobIds.isEmpty();
        if (noOpenJobsToClose) {
            this.waitForJobClosed(request, waitForCloseRequest, new CloseJobAction.Response(true), (ActionListener<CloseJobAction.Response>)intermediateListener, movedJobs);
            return;
        }
        ActionListener finalListener = intermediateListener.delegateFailureAndWrap((l, r) -> this.waitForJobClosed(request, waitForCloseRequest, (CloseJobAction.Response)r, (ActionListener<CloseJobAction.Response>)l, movedJobs));
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    void waitForJobClosed(CloseJobAction.Request request, WaitForCloseRequest waitForCloseRequest, CloseJobAction.Response response, ActionListener<CloseJobAction.Response> listener, Set<String> movedJobs) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> {
            for (PersistentTasksCustomMetadata.PersistentTask<?> originalPersistentTask : waitForCloseRequest.persistentTasks) {
                String originalPersistentTaskId = originalPersistentTask.getId();
                PersistentTasksCustomMetadata.PersistentTask currentPersistentTask = persistentTasksCustomMetadata.getTask(originalPersistentTaskId);
                if (currentPersistentTask == null) continue;
                if (Objects.equals(originalPersistentTask.getExecutorNode(), currentPersistentTask.getExecutorNode()) && originalPersistentTask.getAllocationId() == currentPersistentTask.getAllocationId()) {
                    return false;
                }
                OpenJobAction.JobParams params = (OpenJobAction.JobParams)originalPersistentTask.getParams();
                if (!movedJobs.add(params.getJobId())) continue;
                logger.info("Job [{}] changed assignment while waiting for it to be closed", (Object)params.getJobId());
            }
            return true;
        }, request.getCloseTimeout(), listener.safeMap(r -> response));
    }

    static class OpenAndClosingIds {
        List<String> openJobIds = new ArrayList<String>();
        final List<String> closingJobIds = new ArrayList<String>();

        OpenAndClosingIds() {
        }
    }

    static class WaitForCloseRequest {
        final List<PersistentTasksCustomMetadata.PersistentTask<?>> persistentTasks = new ArrayList();
        final List<String> jobsToFinalize = new ArrayList<String>();

        WaitForCloseRequest() {
        }

        public boolean hasJobsToWaitFor() {
            return !this.persistentTasks.isEmpty();
        }
    }
}

