/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;

public class RetryableUpdateModelSnapshotAction
extends RetryableAction<PutJobAction.Response> {
    private static final Logger logger = LogManager.getLogger(RetryableUpdateModelSnapshotAction.class);
    private final Client client;
    private final UpdateJobAction.Request updateRequest;
    private volatile boolean hasFailedAtLeastOnce;

    public RetryableUpdateModelSnapshotAction(Client client, UpdateJobAction.Request updateRequest, ActionListener<PutJobAction.Response> listener) {
        super(logger, client.threadPool(), TimeValue.timeValueSeconds((long)15L), TimeValue.timeValueMinutes((long)2L), TimeValue.timeValueMinutes((long)5L), listener, (Executor)client.threadPool().executor("ml_utility"));
        this.client = client;
        this.updateRequest = updateRequest;
    }

    public void tryAction(ActionListener<PutJobAction.Response> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)UpdateJobAction.INSTANCE, (ActionRequest)this.updateRequest, listener);
    }

    public boolean shouldRetry(Exception e) {
        if (!this.hasFailedAtLeastOnce) {
            this.hasFailedAtLeastOnce = true;
            logger.warn(() -> "[" + this.updateRequest.getJobId() + "] Failed to update job with new model snapshot id; attempting retry", (Throwable)e);
        }
        return true;
    }
}

