/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;

public class AttributeSet
implements Set<Attribute> {
    public static final AttributeSet EMPTY = new AttributeSet(AttributeMap.emptyAttributeMap());
    private static final Object PRESENT = new Object();
    private final AttributeMap<Object> delegate;

    private AttributeSet(AttributeMap<Object> delegate) {
        this.delegate = delegate;
    }

    public AttributeSet combine(AttributeSet other) {
        return new AttributeSet(this.delegate.combine(other.delegate));
    }

    public AttributeSet subtract(AttributeSet other) {
        return new AttributeSet(this.delegate.subtract(other.delegate));
    }

    public AttributeSet intersect(AttributeSet other) {
        return new AttributeSet(this.delegate.intersect(other.delegate));
    }

    public boolean subsetOf(AttributeSet other) {
        return this.delegate.subsetOf(other.delegate);
    }

    public Set<String> names() {
        return this.delegate.attributeNames();
    }

    @Override
    public void forEach(Consumer<? super Attribute> action) {
        this.delegate.forEach((? super Attribute k, ? super E v) -> action.accept((Attribute)k));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.delegate.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.keySet().toArray(a);
    }

    @Override
    public boolean add(Attribute e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Attribute> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Attribute> spliterator() {
        return this.delegate.keySet().spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super Attribute> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<Attribute> stream() {
        return this.delegate.keySet().stream();
    }

    @Override
    public Stream<Attribute> parallelStream() {
        return this.delegate.keySet().parallelStream();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AttributeSet) {
            AttributeSet as = (AttributeSet)((Object)obj);
            obj = as.delegate;
        }
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.keySet().toString();
    }

    public Builder asBuilder() {
        return new Builder().addAll(this);
    }

    public static AttributeSet of(Attribute ... attrs) {
        AttributeMap.Builder<Object> mapBuilder = AttributeMap.builder();
        for (Attribute a : attrs) {
            mapBuilder.put(a, PRESENT);
        }
        return new AttributeSet(mapBuilder.build());
    }

    public static AttributeSet of(Collection<? extends Attribute> c) {
        AttributeMap.Builder<Object> mapBuilder = AttributeMap.builder();
        for (Attribute attribute : c) {
            mapBuilder.put(attribute, PRESENT);
        }
        return new AttributeSet(mapBuilder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AttributeMap.Builder<Object> mapBuilder = AttributeMap.builder();

        private Builder() {
        }

        public Builder add(Attribute attr) {
            this.mapBuilder.put(attr, PRESENT);
            return this;
        }

        public boolean remove(Object o) {
            return this.mapBuilder.remove(o) != null;
        }

        public Builder addAll(AttributeSet other) {
            this.mapBuilder.putAll(other.delegate);
            return this;
        }

        public Builder addAll(Builder other) {
            this.mapBuilder.putAll(other.mapBuilder.build());
            return this;
        }

        public Builder addAll(Collection<? extends Attribute> c) {
            for (Attribute attribute : c) {
                this.mapBuilder.put(attribute, PRESENT);
            }
            return this;
        }

        public boolean removeIf(Predicate<? super Attribute> filter) {
            return this.mapBuilder.keySet().removeIf(filter);
        }

        public boolean contains(Object o) {
            return this.mapBuilder.containsKey(o);
        }

        public boolean isEmpty() {
            return this.mapBuilder.isEmpty();
        }

        public AttributeSet build() {
            return new AttributeSet(this.mapBuilder.build());
        }
    }
}

