/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SearchAfterTermsEnum;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.versionfield.VersionEncoder;
import org.elasticsearch.xpack.versionfield.VersionFieldWildcardQuery;
import org.elasticsearch.xpack.versionfield.VersionStringDocValuesField;

public class VersionStringFieldMapper
extends FieldMapper {
    private static final byte[] MIN_VALUE = new byte[16];
    private static final byte[] MAX_VALUE = new byte[16];
    public static final String CONTENT_TYPE = "version";
    public static final FieldMapper.TypeParser PARSER;
    private final FieldType fieldType;
    public static final DocValueFormat VERSION_DOCVALUE;

    private VersionStringFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.BuilderParams buildParams) {
        super(simpleName, mappedFieldType, buildParams);
        this.fieldType = VersionStringFieldMapper.freezeAndDeduplicateFieldType((FieldType)fieldType);
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    public VersionStringFieldType fieldType() {
        return (VersionStringFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String versionString = parser.textOrNull();
        if (versionString == null) {
            return;
        }
        VersionEncoder.EncodedVersion encoding = VersionEncoder.encodeVersion(versionString);
        BytesRef encodedVersion = encoding.bytesRef;
        context.doc().add((IndexableField)new Field(this.fieldType().name(), encodedVersion, (IndexableFieldType)this.fieldType));
        context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), encodedVersion));
    }

    public Iterator<Mapper> iterator() {
        ArrayList subIterators = new ArrayList();
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new SortedSetDocValuesSyntheticFieldLoaderLayer(this, this.fullPath()){

            protected BytesRef convert(BytesRef value) {
                return VersionEncoder.decodeVersion(value);
            }

            protected BytesRef preserve(BytesRef value) {
                return value;
            }
        }}));
    }

    static {
        Arrays.fill(MIN_VALUE, (byte)0);
        Arrays.fill(MAX_VALUE, (byte)-1);
        PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
        VERSION_DOCVALUE = new DocValueFormat(){

            public String getWriteableName() {
                return VersionStringFieldMapper.CONTENT_TYPE;
            }

            public void writeTo(StreamOutput out) {
            }

            public String format(BytesRef value) {
                return VersionEncoder.decodeVersion(value).utf8ToString();
            }

            public BytesRef parseBytesRef(Object value) {
                return VersionEncoder.encodeVersion((String)value.toString()).bytesRef;
            }

            public String toString() {
                return this.getWriteableName();
            }
        };
    }

    public static final class VersionStringFieldType
    extends TermBasedFieldType {
        private VersionStringFieldType(String name, FieldType fieldType, Map<String, String> meta) {
            super(name, true, false, true, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), meta);
        }

        public String typeName() {
            return VersionStringFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return this.wildcardQuery(value + "*", method, caseInsensitive, context);
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            return new RegexpQuery(this, new Term(this.name(), new BytesRef((CharSequence)value)), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, method == null ? MultiTermQuery.CONSTANT_SCORE_REWRITE : method, true){

                protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
                    return new FilteredTermsEnum(terms.iterator(), false){

                        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                            BytesRef decoded = VersionEncoder.decodeVersion(term);
                            boolean accepted = (this).compiled.runAutomaton.run(decoded.bytes, decoded.offset, decoded.length);
                            if (accepted) {
                                return FilteredTermsEnum.AcceptStatus.YES;
                            }
                            return FilteredTermsEnum.AcceptStatus.NO;
                        }
                    };
                }
            };
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            return new FuzzyQuery(this, new Term(this.name(), (BytesRef)value), fuzziness.asDistance(BytesRefs.toString((Object)value)), prefixLength, maxExpansions, transpositions, rewriteMethod == null ? FuzzyQuery.defaultRewriteMethod((int)maxExpansions) : rewriteMethod){

                protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
                    final ByteRunAutomaton runAutomaton = this.getAutomata().runAutomaton;
                    return new FilteredTermsEnum(this, terms.iterator(), false){

                        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                            BytesRef decoded = VersionEncoder.decodeVersion(term);
                            boolean accepted = runAutomaton.run(decoded.bytes, decoded.offset, decoded.length);
                            if (accepted) {
                                return FilteredTermsEnum.AcceptStatus.YES;
                            }
                            return FilteredTermsEnum.AcceptStatus.NO;
                        }
                    };
                }
            };
        }

        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            return method == null ? new VersionFieldWildcardQuery(new Term(this.name(), value), caseInsensitive) : new VersionFieldWildcardQuery(new Term(this.name(), value), caseInsensitive, method);
        }

        protected BytesRef indexedValueForSearch(Object value) {
            String valueAsString;
            if (value instanceof String) {
                valueAsString = (String)value;
            } else if (value instanceof BytesRef) {
                valueAsString = ((BytesRef)value).utf8ToString();
            } else {
                throw new IllegalArgumentException("Illegal value type: " + String.valueOf(value.getClass()) + ", value: " + String.valueOf(value));
            }
            return VersionEncoder.encodeVersion((String)valueAsString).bytesRef;
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            this.failIfNoDocValues();
            return new BlockDocValuesReader.BytesRefsFromOrdsBlockLoader(this.name());
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, VersionStringDocValuesField::new);
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return VERSION_DOCVALUE.format((BytesRef)value);
        }

        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return VERSION_DOCVALUE;
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            BytesRef lower = lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm);
            BytesRef upper = upperTerm == null ? null : this.indexedValueForSearch(upperTerm);
            return new TermRangeQuery(this.name(), lower, upper, includeLower, includeUpper);
        }

        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
            BytesRef searchBytes;
            Terms terms = MultiTerms.getTerms((IndexReader)reader, (String)this.name());
            if (terms == null) {
                return null;
            }
            CompiledAutomaton prefixAutomaton = VersionEncoder.prefixAutomaton(prefix, caseInsensitive);
            BytesRef bytesRef = searchBytes = searchAfter == null ? null : VersionEncoder.encodeVersion((String)searchAfter).bytesRef;
            if (prefixAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                TermsEnum iterator;
                TermsEnum result = iterator = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum(result, searchBytes);
                }
                return result;
            }
            return terms.intersect(prefixAutomaton, searchBytes);
        }
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        Builder(String name) {
            super(name);
        }

        private VersionStringFieldType buildFieldType(MapperBuilderContext context, FieldType fieldtype) {
            return new VersionStringFieldType(context.buildFullName(this.leafName()), fieldtype, (Map)this.meta.getValue());
        }

        public VersionStringFieldMapper build(MapperBuilderContext context) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            return new VersionStringFieldMapper(this.leafName(), fieldtype, (MappedFieldType)this.buildFieldType(context, fieldtype), this.builderParams((Mapper.Builder)this, context));
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }
}

