/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;

abstract class NonIsoDateTimeFunction
extends BaseDateTimeFunction {
    private final NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor;

    NonIsoDateTimeFunction(Source source, Expression field, ZoneId zoneId, NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor) {
        super(source, field, zoneId);
        this.extractor = extractor;
    }

    public ScriptTemplate asScript() {
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}." + StringUtils.underscoreToLowerCamelCase((String)this.extractor.name()) + "(" + script.template() + ", {})");
        ParamsBuilder params = ParamsBuilder.paramsBuilder().script(script.params()).variable((Object)this.zoneId().getId());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    protected Processor makeProcessor() {
        return new NonIsoDateTimeProcessor(this.extractor, this.zoneId());
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }
}

