/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.CasePipe;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Case
extends ConditionalFunction {
    private final List<IfConditional> conditions;
    private final Expression elseResult;

    public Case(Source source, List<Expression> expressions) {
        super(source, expressions);
        this.conditions = expressions.subList(0, expressions.size() - 1);
        this.elseResult = expressions.get(expressions.size() - 1);
    }

    public List<IfConditional> conditions() {
        return this.conditions;
    }

    public Expression elseResult() {
        return this.elseResult;
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            if (this.conditions.isEmpty()) {
                this.dataType = this.elseResult().dataType();
            } else {
                this.dataType = DataTypes.NULL;
                for (IfConditional conditional : this.conditions) {
                    this.dataType = SqlDataTypeConverter.commonType(this.dataType, conditional.dataType());
                }
                this.dataType = SqlDataTypeConverter.commonType(this.dataType, this.elseResult.dataType());
            }
        }
        return this.dataType;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Case(this.source(), newChildren);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Case::new, (Object)this.children());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        DataType expectedResultDataType = null;
        for (IfConditional ifConditional : this.conditions) {
            if (DataTypes.isNull((DataType)ifConditional.result().dataType())) continue;
            expectedResultDataType = ifConditional.result().dataType();
            break;
        }
        if (expectedResultDataType == null) {
            expectedResultDataType = this.elseResult().dataType();
        }
        for (IfConditional conditional : this.conditions) {
            if (conditional.condition().dataType() != DataTypes.BOOLEAN) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"condition of [{}] must be [boolean], found value [{}] type [{}]", (Object[])new Object[]{conditional.sourceText(), Expressions.name((Expression)conditional.condition()), conditional.condition().dataType().typeName()}));
            }
            if (SqlDataTypes.areCompatible(expectedResultDataType, conditional.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"result of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{conditional.sourceText(), expectedResultDataType.typeName(), Expressions.name((Expression)conditional.result()), conditional.dataType().typeName()}));
        }
        if (!SqlDataTypes.areCompatible(expectedResultDataType, this.elseResult.dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"ELSE clause of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{this.elseResult.sourceText(), expectedResultDataType.typeName(), Expressions.name((Expression)this.elseResult), this.elseResult.dataType().typeName()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public boolean foldable() {
        if (this.conditions.isEmpty() && this.elseResult.foldable()) {
            return true;
        }
        if (this.conditions.size() == 1 && this.conditions.get(0).condition().foldable()) {
            if (this.conditions.get(0).condition().fold() == Boolean.TRUE) {
                return this.conditions().get(0).result().foldable();
            }
            return this.elseResult().foldable();
        }
        return false;
    }

    public Object fold() {
        if (!this.conditions.isEmpty() && this.conditions.get(0).condition().fold() == Boolean.TRUE) {
            return this.conditions.get(0).result().fold();
        }
        return this.elseResult.fold();
    }

    protected Pipe makePipe() {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>(this.conditions.size() + 1);
        for (IfConditional ifConditional : this.conditions) {
            pipes.add(Expressions.pipe((Expression)ifConditional.condition()));
            pipes.add(Expressions.pipe((Expression)ifConditional.result()));
        }
        pipes.add(Expressions.pipe((Expression)this.elseResult));
        return new CasePipe(this.source(), (Expression)this, pipes);
    }

    public ScriptTemplate asScript() {
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (IfConditional ifConditional : this.conditions) {
            templates.add(this.asScript(ifConditional.condition()));
            templates.add(this.asScript(ifConditional.result()));
        }
        templates.add(this.asScript(this.elseResult));
        StringBuilder sb = new StringBuilder();
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        for (int i = 0; i < templates.size(); ++i) {
            ScriptTemplate scriptTemplate = (ScriptTemplate)templates.get(i);
            if (i < templates.size() - 1) {
                if (i % 2 == 0) {
                    sb.append(Scripts.nullSafeFilter((ScriptTemplate)scriptTemplate).template()).append(" ? ");
                } else {
                    sb.append(scriptTemplate.template()).append(" : ");
                }
            } else {
                sb.append(scriptTemplate.template());
            }
            params.script(scriptTemplate.params());
        }
        return new ScriptTemplate(this.formatTemplate(sb.toString()), params.build(), this.dataType());
    }
}

