/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class TopHitsAgg
extends LeafAgg {
    private final AggSource sortSource;
    private final SortOrder sortOrder;
    private final DataType fieldDataType;
    private final DataType sortFieldDataType;

    public TopHitsAgg(String id, AggSource source, DataType fieldDataType, AggSource sortSource, DataType sortFieldDataType, SortOrder sortOrder) {
        super(id, source);
        this.fieldDataType = fieldDataType;
        this.sortSource = sortSource;
        this.sortOrder = sortOrder;
        this.sortFieldDataType = sortFieldDataType;
    }

    @Override
    AggregationBuilder toBuilder() {
        ArrayList<Object> sortBuilderList = new ArrayList<Object>(2);
        if (this.sortSource != null) {
            if (this.sortSource.fieldName() != null) {
                sortBuilderList.add(((FieldSortBuilder)new FieldSortBuilder(this.sortSource.fieldName()).order(this.sortOrder)).missing((Object)Sort.Missing.LAST.searchOrder()).unmappedType(this.sortFieldDataType.esType()));
            } else if (this.sortSource.script() != null) {
                sortBuilderList.add(new ScriptSortBuilder(Scripts.nullSafeSort((ScriptTemplate)this.sortSource.script()).toPainless(), this.source().script().outputType().scriptSortType()).order(this.sortOrder));
            }
        }
        if (this.source().fieldName() != null) {
            sortBuilderList.add(((FieldSortBuilder)new FieldSortBuilder(this.source().fieldName()).order(this.sortOrder)).missing((Object)Sort.Missing.LAST.searchOrder()).unmappedType(this.fieldDataType.esType()));
        } else {
            sortBuilderList.add(new ScriptSortBuilder(Scripts.nullSafeSort((ScriptTemplate)this.source().script()).toPainless(), this.source().script().outputType().scriptSortType()).order(this.sortOrder));
        }
        TopHitsAggregationBuilder builder = AggregationBuilders.topHits((String)this.id());
        if (this.source().fieldName() != null) {
            builder.docValueField(this.source().fieldName(), SqlDataTypes.format(this.fieldDataType));
        } else {
            builder.scriptField(this.id(), this.source().script().toPainless());
        }
        return builder.sorts(sortBuilderList).size(1);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sortSource, this.sortOrder, this.fieldDataType, this.sortFieldDataType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopHitsAgg that = (TopHitsAgg)o;
        return Objects.equals(this.sortSource, that.sortSource) && this.sortOrder == that.sortOrder && Objects.equals(this.fieldDataType, that.fieldDataType) && Objects.equals(this.sortFieldDataType, that.sortFieldDataType);
    }
}

