/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.lang.reflect.Field;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.CheckAllocator;
import org.apache.arrow.util.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAllocationManagerOption {
    public static final @UnknownKeyFor @NonNull @Initialized String ALLOCATION_MANAGER_TYPE_ENV_NAME = "ARROW_ALLOCATION_MANAGER_TYPE";
    public static final @UnknownKeyFor @NonNull @Initialized String ALLOCATION_MANAGER_TYPE_PROPERTY_NAME = "arrow.allocation.manager.type";
    static final @UnknownKeyFor @NonNull @Initialized Logger LOGGER = LoggerFactory.getLogger(DefaultAllocationManagerOption.class);
    private static  @Nullable @UnknownKeyFor @Initialized AllocationManager.Factory DEFAULT_ALLOCATION_MANAGER_FACTORY = null;

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized AllocationManagerType getDefaultAllocationManagerType() {
        AllocationManagerType ret = AllocationManagerType.Unknown;
        try {
            String envValue = System.getenv(ALLOCATION_MANAGER_TYPE_ENV_NAME);
            ret = AllocationManagerType.valueOf(envValue);
        }
        catch (IllegalArgumentException | NullPointerException envValue) {
            // empty catch block
        }
        try {
            String propValue = System.getProperty(ALLOCATION_MANAGER_TYPE_PROPERTY_NAME);
            ret = AllocationManagerType.valueOf(propValue);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return ret;
    }

    static  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getDefaultAllocationManagerFactory() {
        if (DEFAULT_ALLOCATION_MANAGER_FACTORY != null) {
            return DEFAULT_ALLOCATION_MANAGER_FACTORY;
        }
        AllocationManagerType type = DefaultAllocationManagerOption.getDefaultAllocationManagerType();
        switch (type.ordinal()) {
            case 0: {
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getNettyFactory();
                break;
            }
            case 1: {
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getUnsafeFactory();
                break;
            }
            case 2: {
                LOGGER.info("allocation manager type not specified, using netty as the default type");
                DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getFactory(CheckAllocator.check());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown allocation manager type: " + (Object)((Object)type));
            }
        }
        return DEFAULT_ALLOCATION_MANAGER_FACTORY;
    }

    private static  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getFactory(@UnknownKeyFor @NonNull @Initialized String clazzName) {
        try {
            Field field = Class.forName(clazzName).getDeclaredField("FACTORY");
            field.setAccessible(true);
            return (AllocationManager.Factory)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Allocation Manager for " + clazzName, e);
        }
    }

    private static  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getUnsafeFactory() {
        try {
            return DefaultAllocationManagerOption.getFactory("org.apache.arrow.memory.unsafe.UnsafeAllocationManager");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Please add arrow-memory-unsafe to your classpath, No DefaultAllocationManager found to instantiate an UnsafeAllocationManager", e);
        }
    }

    private static  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getNettyFactory() {
        try {
            return DefaultAllocationManagerOption.getFactory("org.apache.arrow.memory.netty.NettyAllocationManager");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Please add arrow-memory-netty to your classpath, No DefaultAllocationManager found to instantiate an NettyAllocationManager", e);
        }
    }

    public static enum AllocationManagerType {
        Netty,
        Unsafe,
        Unknown;

    }
}

