# **Naxsi Directives**

This section explains all the directives, with examples, that are available when the Naxsi module (`ngx_http_naxsi_module.so`) is enabled.

## **SecRulesEnabled**

> ℹ️ Info
>
> NGINX block: `location`

This directive is mandatory to `enable` naxsi in a NGINX `location`.

### Example:

```nginx
location / {
    SecRulesEnabled;
}
```

## **CheckRule**

> ℹ️ Info
>
> NGINX block: `location`

This directive is required to instruct Naxsi on which action to take when there is a rule match.

The directive requires you to specify a **score** with a variable name and its min/max value (for example `$FOO_BAR >= 4`); the score is then followed by an action to take (`LOG`, `BLOCK`, `DROP`, or `ALLOW`) when is met.

> 📣 Important
>
> Score variable names must starts with a "dollar sign" `$` and can contains "underscores" `_`.

> ⚠️ Warning
>
> The action `BLOCK` will behave like `DROP` only when `LearningMode` is not enabled.

### Example:

```nginx
location / {
    CheckRule "$FOO_UU >= 8" LOG;
    CheckRule "$BARRRR < 99" DROP;
    CheckRule "$SOMETHING <= 33" BLOCK;
}
```

## **LibInjectionXss**

> ℹ️ Info
>
> NGINX block: `location`

When defined, this directive enables [libinjection's](https://github.com/libinjection/libinjection) xss detection on *all* requests.

> 📣 Important
>
> The detected XSS will increase the score `$LIBINJECTION_XSS` by `1` for each match; this means that is required to define `$LIBINJECTION_XSS` as a `CheckRule`.

### Example:

```nginx
location / {
    # enable libinjection xss
    LibInjectionXss;
    # define LIBINJECTION_XSS for libinjection
    CheckRule "$LIBINJECTION_XSS >= 8" BLOCK;
}
```

## **LibInjectionSql**

> ℹ️ Info
>
> NGINX block: `location`

When defined, this directive enables [libinjection's](https://github.com/libinjection/libinjection) sqli detection on *all* requests.

> 📣 Important
>
> The detected SQLi will increase the score `$LIBINJECTION_SQL` by `1` for each match; this means that is required to define `$LIBINJECTION_SQL` as a `CheckRule`.

### Example:

```nginx
location / {
    # enable libinjection sqli
    LibInjectionSql;
    # define LIBINJECTION_SQL for libinjection
    CheckRule "$LIBINJECTION_SQL >= 8" BLOCK;
}
```

## **LearningMode**

> ℹ️ Info
>
> NGINX block: `location`

This directive instructs Naxsi that to not honor `CheckRules` which defines actions as `BLOCK` in a NGINX `location`.

All the `BLOCK` actions will be interpreted as `LOG`; this is a useful mode when deploying a new web application and detect all false positives that might be generated by the WAF.

> 📣 Important
>
> Keep in mind that internal rules (those with an `id` inferior to 1000) will drop the request even in learning mode, because it means something fishy is going on and Naxsi can't correctly process the request. You can of course apply whitelists if those are false positives.

### Example:

```nginx
location / {
    # enable Naxsi learning mode
    LearningMode;
}
```

## **DeniedUrl** 

> ℹ️ Info
>
> NGINX block: `location`

This directive is used to define where Naxsi has to redirect (it's an NGINX's internal redirect) when blocking, dropping or logging requests.

The following headers that are added are when blocking, dropping or logging requests:
 - `x-orig_url`
 - `x-orig_args`
 - `x-naxsi_sig`

> 💡 Tip
>
> It is **strongly** suggested to mark the `DeniedUrl` location as `internal` to prevent possible pre-detection of the WAF as per example.

### Example:

```nginx
location / {
    DeniedUrl "/RequestDenied";
}

location /RequestDenied {
    # Mark this location as internal only to prevent possible pre-detection of the WAF
    internal;
    # return code of the location.
    return 403;
}
```

## **MainRule** 

> ℹ️ Info
>
> NGINX block: `http`

This directive is required to declare a **global** [rule](rules.md) or a [whitelist](whitelist.md).

> 💡 Tip
>
> You can define these within a config file and use the `include` directive to include them within the NGINX configuration.

You can find within the [Naxsi source code a list of global rules](https://github.com/wargio/naxsi/blob/main/naxsi_rules/) which provides a basic ruleset to protect any web application; these rules requires to include the following `CheckRules`:

```nginx
    CheckRule "$SQL >= 8" BLOCK;
    CheckRule "$RFI >= 8" BLOCK;
    CheckRule "$TRAVERSAL >= 5" BLOCK;
    CheckRule "$UPLOAD >= 5" BLOCK;
    CheckRule "$XSS >= 8" BLOCK;
    CheckRule "$UWA >= 8" BLOCK;
    CheckRule "$EVADE >= 8" BLOCK;
```

### Example:

```nginx
http {
    # global whitelist
    MainRule wl:12345 "mz:$URL:/robots.txt|URL";
    # global rule
    MainRule id:45678 "s:$UWA:8" "str:nmap" "mz:$HEADERS_VAR:User-Agent" "msg:nmap in user-agent";
}
```

## **BasicRule** 

> ℹ️ Info
>
> NGINX block: `location`

This directive is required to declare a **location-specific** (i.e. not global) [rule](rules.md) or a [whitelist](whitelist.md).

> 💡 Tip
>
> You can define these within a config file and use the `include` directive to include them within the NGINX configuration.

> 💡 Tip
>
> You can find within the [Naxsi source code a list of location-specific whitelist](https://github.com/wargio/naxsi/tree/main/naxsi_rules/whitelists) which can be used for known web applications like Wordpress, Etherpad, Drupal, and more...

### Example:

```nginx
location / {
    # location-specific whitelist
    BasicRule wl:12345 "mz:$URL:/robots.txt|URL";
    # location-specific rule
    BasicRule id:45678 "s:$UWA:8" "str:nmap" "mz:$HEADERS_VAR:User-Agent" "msg:nmap in user-agent";
}
```

## **IgnoreIP** 

> ℹ️ Info
>
> NGINX block: `location`

This directive can be used to whitelist requests from certain IPs.

> 💡 Tip
>
> You can define these within a config file and use the `include` directive to include them within the NGINX configuration.

### Example:

```nginx
location / {
    IgnoreIP "1.2.3.4";
    IgnoreIP "2001:4860:4860::8844";
}
```

## **IgnoreCIDR** 

> ℹ️ Info
>
> NGINX block: `location`

This directive can be used to whitelist requests from certain IP ranges.

> 💡 Tip
>
> You can define these within a config file and use the `include` directive to include them within the NGINX configuration.

### Example:

```nginx
location / {
    IgnoreCIDR "192.168.0.0/24";
    IgnoreCIDR "2001:4860:4860::/112";
}
```
