/************************************************************************/
/*                                                                      */
/*                Copyright 2011 by Ullrich Koethe                      */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

#ifndef VIGRA_CONVEX_HULL_TEST_HXX
#define VIGRA_CONVEX_HULL_TEST_HXX

#include <vigra/tinyvector.hxx>

typedef vigra::TinyVector<double, 2> P;

P convexHullReference[] = {
    P(141.0,   5.0),
    P(128.0,  16.0),
    P(127.0,  17.0),
    P(125.0,  20.0),
    P(124.0,  23.0),
    P(178.0, 476.0),
    P(188.0, 511.0),
    P(455.0, 511.0),
    P(455.0, 510.0),
    P(297.0,  88.0),
    P(293.0,  84.0),
    P(254.0,  49.0),
    P(251.0,  47.0),
    P(186.0,  15.0),
    P(176.0,  11.0),
    P(159.0,   5.0),
    P(141.0,   5.0)
};

P convexHullInputs[] = {
    P(124.0, 23.0), P(125.0, 20.0), P(125.0, 23.0), P(126.0, 19.0), 
    P(126.0, 20.0), P(127.0, 17.0), P(127.0, 18.0), P(127.0, 35.0), 
    P(127.0, 36.0), P(127.0, 37.0), P(127.0, 38.0), P(128.0, 16.0), 
    P(128.0, 33.0), P(128.0, 40.0), P(128.0, 41.0), P(128.0, 42.0), 
    P(128.0, 43.0), P(128.0, 44.0), P(128.0, 45.0), P(128.0, 46.0), 
    P(128.0, 47.0), P(128.0, 48.0), P(129.0, 16.0), P(129.0, 29.0), 
    P(129.0, 30.0), P(129.0, 31.0), P(130.0, 16.0), P(130.0, 50.0), 
    P(131.0, 50.0), P(132.0, 15.0), P(134.0, 52.0), P(134.0, 53.0), 
    P(134.0, 54.0), P(134.0, 55.0), P(136.0, 12.0), P(137.0, 11.0), 
    P(137.0, 58.0), P(138.0, 58.0), P(140.0, 6.0), P(140.0, 7.0), 
    P(141.0, 5.0), P(141.0, 60.0), P(142.0, 5.0), P(144.0, 6.0), 
    P(145.0, 6.0), P(147.0, 7.0), P(148.0, 66.0), P(149.0, 8.0), 
    P(150.0, 8.0), P(150.0, 67.0), P(151.0, 8.0), P(153.0, 8.0), 
    P(153.0, 9.0), P(154.0, 71.0), P(155.0, 73.0), P(155.0, 74.0), 
    P(156.0, 7.0), P(156.0, 76.0), P(156.0, 77.0), P(157.0, 77.0), 
    P(157.0, 78.0), P(159.0, 5.0), P(159.0, 6.0), P(159.0, 78.0), 
    P(160.0, 78.0), P(161.0, 6.0), P(161.0, 78.0), P(163.0, 8.0), 
    P(163.0, 78.0), P(163.0, 79.0), P(164.0, 9.0), P(164.0, 85.0), 
    P(164.0, 86.0), P(164.0, 87.0), P(165.0, 78.0), P(165.0, 84.0), 
    P(165.0, 89.0), P(165.0, 90.0), P(165.0, 91.0), P(166.0, 10.0), 
    P(167.0, 10.0), P(167.0, 82.0), P(167.0, 94.0), P(167.0, 97.0), 
    P(167.0, 98.0), P(168.0, 10.0), P(168.0, 95.0), P(168.0, 96.0), 
    P(169.0, 99.0), P(169.0, 100.0), P(170.0, 50.0), P(170.0, 51.0), 
    P(171.0, 12.0), P(171.0, 49.0), P(171.0, 99.0), P(172.0, 12.0), 
    P(172.0, 49.0), P(172.0, 53.0), P(172.0, 99.0), P(172.0, 105.0), 
    P(173.0, 12.0), P(173.0, 53.0), P(173.0, 100.0), P(173.0, 101.0), 
    P(173.0, 102.0), P(173.0, 103.0), P(173.0, 105.0), P(174.0, 51.0), 
    P(174.0, 52.0), P(175.0, 11.0), P(175.0, 109.0), P(175.0, 110.0), 
    P(175.0, 111.0), P(175.0, 113.0), P(175.0, 114.0), P(175.0, 115.0), 
    P(175.0, 116.0), P(175.0, 117.0), P(175.0, 118.0), P(175.0, 119.0), 
    P(175.0, 120.0), P(175.0, 121.0), P(175.0, 122.0), P(175.0, 132.0), 
    P(175.0, 133.0), P(175.0, 134.0), P(175.0, 135.0), P(175.0, 142.0), 
    P(175.0, 143.0), P(175.0, 147.0), P(175.0, 148.0), P(176.0, 11.0), 
    P(176.0, 123.0), P(176.0, 145.0), P(176.0, 173.0), P(176.0, 224.0), 
    P(176.0, 227.0), P(176.0, 228.0), P(176.0, 236.0), P(176.0, 237.0), 
    P(176.0, 238.0), P(176.0, 239.0), P(176.0, 240.0), P(176.0, 241.0), 
    P(177.0, 124.0), P(177.0, 129.0), P(177.0, 150.0), P(177.0, 173.0), 
    P(177.0, 221.0), P(177.0, 222.0), P(177.0, 224.0), P(177.0, 230.0), 
    P(177.0, 234.0), P(177.0, 243.0), P(177.0, 248.0), P(177.0, 249.0), 
    P(177.0, 250.0), P(177.0, 251.0), P(178.0, 126.0), P(178.0, 127.0), 
    P(178.0, 150.0), P(178.0, 182.0), P(178.0, 183.0), P(178.0, 184.0), 
    P(178.0, 185.0), P(178.0, 186.0), P(178.0, 187.0), P(178.0, 188.0), 
    P(178.0, 189.0), P(178.0, 190.0), P(178.0, 205.0), P(178.0, 206.0), 
    P(178.0, 207.0), P(178.0, 208.0), P(178.0, 209.0), P(178.0, 210.0), 
    P(178.0, 218.0), P(178.0, 219.0), P(178.0, 232.0), P(178.0, 245.0), 
    P(178.0, 246.0), P(178.0, 252.0), P(178.0, 253.0), P(178.0, 254.0), 
    P(178.0, 255.0), P(178.0, 473.0), P(178.0, 474.0), P(178.0, 475.0), 
    P(178.0, 476.0), P(179.0, 13.0), P(179.0, 168.0), P(179.0, 169.0), 
    P(179.0, 177.0), P(179.0, 179.0), P(179.0, 180.0), P(179.0, 192.0), 
    P(179.0, 200.0), P(179.0, 201.0), P(179.0, 204.0), P(179.0, 212.0), 
    P(179.0, 213.0), P(179.0, 214.0), P(179.0, 215.0), P(179.0, 216.0), 
    P(179.0, 257.0), P(179.0, 258.0), P(179.0, 259.0), P(179.0, 260.0), 
    P(180.0, 13.0), P(180.0, 155.0), P(180.0, 156.0), P(180.0, 166.0), 
    P(180.0, 194.0), P(180.0, 196.0), P(180.0, 197.0), P(180.0, 198.0), 
    P(180.0, 203.0), P(180.0, 262.0), P(180.0, 263.0), P(180.0, 264.0), 
    P(180.0, 265.0), P(180.0, 275.0), P(180.0, 276.0), P(180.0, 372.0), 
    P(180.0, 373.0), P(180.0, 471.0), P(180.0, 478.0), P(181.0, 153.0), 
    P(181.0, 156.0), P(181.0, 157.0), P(181.0, 158.0), P(181.0, 159.0), 
    P(181.0, 160.0), P(181.0, 161.0), P(181.0, 162.0), P(181.0, 163.0), 
    P(181.0, 164.0), P(181.0, 267.0), P(181.0, 268.0), P(181.0, 269.0), 
    P(181.0, 270.0), P(181.0, 272.0), P(181.0, 273.0), P(181.0, 471.0), 
    P(181.0, 478.0), P(182.0, 14.0), P(182.0, 58.0), P(182.0, 59.0), 
    P(182.0, 277.0), P(182.0, 278.0), P(182.0, 370.0), P(182.0, 375.0), 
    P(182.0, 448.0), P(182.0, 449.0), P(182.0, 450.0), P(182.0, 451.0), 
    P(182.0, 471.0), P(183.0, 14.0), P(183.0, 278.0), P(183.0, 285.0), 
    P(183.0, 286.0), P(183.0, 287.0), P(183.0, 288.0), P(183.0, 289.0), 
    P(183.0, 453.0), P(183.0, 454.0), P(183.0, 455.0), P(183.0, 456.0), 
    P(183.0, 457.0), P(183.0, 458.0), P(183.0, 459.0), P(183.0, 460.0), 
    P(183.0, 461.0), P(183.0, 462.0), P(183.0, 463.0), P(183.0, 471.0), 
    P(183.0, 480.0), P(184.0, 57.0), P(184.0, 280.0), P(184.0, 281.0), 
    P(184.0, 282.0), P(184.0, 283.0), P(184.0, 291.0), P(184.0, 292.0), 
    P(184.0, 319.0), P(184.0, 320.0), P(184.0, 369.0), P(184.0, 376.0), 
    P(184.0, 439.0), P(184.0, 440.0), P(184.0, 445.0), P(184.0, 465.0), 
    P(184.0, 468.0), P(184.0, 469.0), P(184.0, 470.0), P(184.0, 482.0), 
    P(184.0, 483.0), P(184.0, 484.0), P(185.0, 15.0), P(185.0, 294.0), 
    P(185.0, 295.0), P(185.0, 307.0), P(185.0, 308.0), P(185.0, 309.0), 
    P(185.0, 316.0), P(185.0, 317.0), P(185.0, 336.0), P(185.0, 337.0), 
    P(185.0, 338.0), P(185.0, 339.0), P(185.0, 369.0), P(185.0, 376.0), 
    P(185.0, 437.0), P(185.0, 442.0), P(185.0, 443.0), P(185.0, 485.0), 
    P(186.0, 15.0), P(186.0, 297.0), P(186.0, 298.0), P(186.0, 299.0), 
    P(186.0, 303.0), P(186.0, 304.0), P(186.0, 305.0), P(186.0, 311.0), 
    P(186.0, 312.0), P(186.0, 313.0), P(186.0, 314.0), P(186.0, 334.0), 
    P(186.0, 340.0), P(186.0, 369.0), P(186.0, 419.0), P(186.0, 420.0), 
    P(187.0, 60.0), P(187.0, 301.0), P(187.0, 328.0), P(187.0, 329.0), 
    P(187.0, 330.0), P(187.0, 331.0), P(187.0, 332.0), P(187.0, 375.0), 
    P(187.0, 389.0), P(187.0, 398.0), P(187.0, 399.0), P(187.0, 400.0), 
    P(187.0, 487.0), P(187.0, 488.0), P(188.0, 65.0), P(188.0, 325.0), 
    P(188.0, 326.0), P(188.0, 367.0), P(188.0, 387.0), P(188.0, 389.0), 
    P(188.0, 391.0), P(188.0, 392.0), P(188.0, 395.0), P(188.0, 408.0), 
    P(188.0, 409.0), P(188.0, 410.0), P(188.0, 411.0), P(188.0, 412.0), 
    P(188.0, 413.0), P(188.0, 414.0), P(188.0, 415.0), P(188.0, 416.0), 
    P(188.0, 431.0), P(188.0, 432.0), P(188.0, 433.0), P(188.0, 490.0), 
    P(188.0, 491.0), P(188.0, 492.0), P(188.0, 493.0), P(188.0, 494.0), 
    P(188.0, 495.0), P(188.0, 503.0), P(188.0, 504.0), P(188.0, 510.0), 
    P(188.0, 511.0), P(189.0, 19.0), P(189.0, 62.0), P(189.0, 343.0), 
    P(189.0, 365.0), P(189.0, 375.0), P(189.0, 384.0), P(189.0, 385.0), 
    P(189.0, 395.0), P(189.0, 402.0), P(189.0, 423.0), P(189.0, 429.0), 
    P(189.0, 500.0), P(189.0, 501.0), P(189.0, 506.0), P(189.0, 507.0), 
    P(189.0, 508.0), P(190.0, 19.0), P(190.0, 20.0), P(190.0, 345.0), 
    P(190.0, 346.0), P(190.0, 376.0), P(190.0, 377.0), P(190.0, 380.0), 
    P(190.0, 381.0), P(190.0, 382.0), P(190.0, 403.0), P(190.0, 404.0), 
    P(190.0, 405.0), P(190.0, 423.0), P(190.0, 498.0), P(191.0, 21.0), 
    P(191.0, 68.0), P(191.0, 348.0), P(191.0, 349.0), P(191.0, 362.0), 
    P(191.0, 424.0), P(191.0, 425.0), P(191.0, 426.0), P(192.0, 23.0), 
    P(192.0, 64.0), P(192.0, 70.0), P(192.0, 71.0), P(192.0, 351.0), 
    P(192.0, 352.0), P(192.0, 353.0), P(192.0, 355.0), P(192.0, 360.0), 
    P(193.0, 73.0), P(193.0, 355.0), P(193.0, 357.0), P(193.0, 358.0), 
    P(195.0, 26.0), P(195.0, 67.0), P(195.0, 507.0), P(196.0, 68.0), 
    P(196.0, 77.0), P(196.0, 78.0), P(196.0, 79.0), P(196.0, 80.0), 
    P(196.0, 81.0), P(196.0, 82.0), P(196.0, 508.0), P(196.0, 511.0), 
    P(197.0, 26.0), P(197.0, 68.0), P(198.0, 26.0), P(198.0, 68.0), 
    P(198.0, 85.0), P(199.0, 26.0), P(199.0, 68.0), P(199.0, 86.0), 
    P(200.0, 68.0), P(200.0, 86.0), P(201.0, 28.0), P(201.0, 29.0), 
    P(201.0, 30.0), P(201.0, 68.0), P(202.0, 88.0), P(202.0, 89.0), 
    P(202.0, 92.0), P(202.0, 93.0), P(202.0, 94.0), P(203.0, 32.0), 
    P(203.0, 96.0), P(204.0, 32.0), P(204.0, 70.0), P(205.0, 99.0), 
    P(205.0, 101.0), P(205.0, 103.0), P(205.0, 104.0), P(205.0, 105.0), 
    P(205.0, 106.0), P(205.0, 107.0), P(205.0, 108.0), P(206.0, 33.0), 
    P(206.0, 71.0), P(206.0, 101.0), P(206.0, 110.0), P(206.0, 111.0), 
    P(207.0, 33.0), P(207.0, 71.0), P(207.0, 113.0), P(207.0, 114.0), 
    P(207.0, 115.0), P(207.0, 116.0), P(207.0, 119.0), P(208.0, 71.0), 
    P(209.0, 32.0), P(209.0, 121.0), P(210.0, 32.0), P(210.0, 72.0), 
    P(210.0, 121.0), P(211.0, 32.0), P(211.0, 122.0), P(211.0, 130.0), 
    P(211.0, 131.0), P(211.0, 132.0), P(211.0, 133.0), P(211.0, 134.0), 
    P(211.0, 135.0), P(211.0, 136.0), P(211.0, 137.0), P(211.0, 138.0), 
    P(211.0, 139.0), P(211.0, 140.0), P(212.0, 32.0), P(212.0, 124.0), 
    P(212.0, 125.0), P(212.0, 126.0), P(212.0, 127.0), P(212.0, 128.0), 
    P(212.0, 142.0), P(212.0, 143.0), P(212.0, 144.0), P(213.0, 33.0), 
    P(213.0, 34.0), P(213.0, 75.0), P(213.0, 166.0), P(213.0, 167.0), 
    P(213.0, 168.0), P(214.0, 35.0), P(214.0, 147.0), P(214.0, 161.0), 
    P(214.0, 162.0), P(214.0, 163.0), P(214.0, 164.0), P(214.0, 170.0), 
    P(214.0, 171.0), P(215.0, 77.0), P(215.0, 148.0), P(215.0, 155.0), 
    P(215.0, 156.0), P(215.0, 157.0), P(215.0, 158.0), P(215.0, 159.0), 
    P(215.0, 173.0), P(215.0, 181.0), P(215.0, 182.0), P(215.0, 183.0), 
    P(215.0, 184.0), P(215.0, 185.0), P(215.0, 186.0), P(215.0, 187.0), 
    P(215.0, 188.0), P(215.0, 215.0), P(215.0, 216.0), P(216.0, 148.0), 
    P(216.0, 179.0), P(216.0, 192.0), P(216.0, 193.0), P(216.0, 194.0), 
    P(216.0, 195.0), P(216.0, 213.0), P(216.0, 218.0), P(216.0, 219.0), 
    P(216.0, 220.0), P(216.0, 221.0), P(216.0, 228.0), P(216.0, 229.0), 
    P(216.0, 230.0), P(216.0, 231.0), P(216.0, 233.0), P(217.0, 37.0), 
    P(217.0, 148.0), P(217.0, 153.0), P(217.0, 176.0), P(217.0, 177.0), 
    P(217.0, 197.0), P(217.0, 198.0), P(217.0, 223.0), P(217.0, 224.0), 
    P(217.0, 225.0), P(217.0, 226.0), P(217.0, 235.0), P(217.0, 236.0), 
    P(217.0, 237.0), P(217.0, 239.0), P(217.0, 240.0), P(217.0, 241.0), 
    P(218.0, 149.0), P(218.0, 150.0), P(218.0, 151.0), P(218.0, 152.0), 
    P(218.0, 200.0), P(218.0, 201.0), P(218.0, 243.0), P(218.0, 244.0), 
    P(218.0, 245.0), P(218.0, 246.0), P(218.0, 247.0), P(218.0, 248.0), 
    P(218.0, 261.0), P(219.0, 210.0), P(219.0, 250.0), P(219.0, 251.0), 
    P(219.0, 252.0), P(219.0, 254.0), P(219.0, 256.0), P(219.0, 257.0), 
    P(219.0, 259.0), P(219.0, 260.0), P(219.0, 263.0), P(219.0, 264.0), 
    P(219.0, 265.0), P(220.0, 39.0), P(220.0, 204.0), P(220.0, 254.0), 
    P(220.0, 259.0), P(220.0, 266.0), P(221.0, 206.0), P(221.0, 207.0), 
    P(221.0, 208.0), P(222.0, 40.0), P(222.0, 83.0), P(222.0, 286.0), 
    P(222.0, 287.0), P(222.0, 288.0), P(223.0, 40.0), P(223.0, 290.0), 
    P(224.0, 40.0), P(224.0, 84.0), P(224.0, 270.0), P(224.0, 271.0), 
    P(224.0, 272.0), P(224.0, 273.0), P(224.0, 274.0), P(224.0, 275.0), 
    P(224.0, 280.0), P(224.0, 287.0), P(224.0, 288.0), P(225.0, 40.0), 
    P(225.0, 84.0), P(225.0, 277.0), P(225.0, 278.0), P(225.0, 282.0), 
    P(225.0, 286.0), P(225.0, 287.0), P(225.0, 293.0), P(225.0, 302.0), 
    P(226.0, 40.0), P(226.0, 282.0), P(226.0, 304.0), P(226.0, 318.0), 
    P(226.0, 319.0), P(226.0, 320.0), P(226.0, 321.0), P(226.0, 322.0), 
    P(226.0, 323.0), P(226.0, 324.0), P(226.0, 325.0), P(227.0, 40.0), 
    P(227.0, 85.0), P(227.0, 296.0), P(227.0, 297.0), P(227.0, 298.0), 
    P(227.0, 299.0), P(227.0, 306.0), P(227.0, 327.0), P(228.0, 306.0), 
    P(228.0, 314.0), P(228.0, 315.0), P(228.0, 329.0), P(229.0, 86.0), 
    P(229.0, 306.0), P(229.0, 312.0), P(229.0, 356.0), P(229.0, 357.0), 
    P(229.0, 358.0), P(230.0, 306.0), P(230.0, 333.0), P(230.0, 335.0), 
    P(230.0, 361.0), P(231.0, 87.0), P(231.0, 307.0), P(231.0, 308.0), 
    P(231.0, 309.0), P(231.0, 333.0), P(231.0, 353.0), P(231.0, 361.0), 
    P(231.0, 363.0), P(232.0, 44.0), P(232.0, 335.0), P(232.0, 336.0), 
    P(232.0, 351.0), P(232.0, 352.0), P(232.0, 365.0), P(232.0, 394.0), 
    P(232.0, 395.0), P(232.0, 399.0), P(232.0, 413.0), P(232.0, 414.0), 
    P(232.0, 415.0), P(232.0, 428.0), P(232.0, 429.0), P(232.0, 430.0), 
    P(232.0, 431.0), P(232.0, 450.0), P(233.0, 336.0), P(233.0, 337.0), 
    P(233.0, 338.0), P(233.0, 340.0), P(233.0, 350.0), P(233.0, 351.0), 
    P(233.0, 391.0), P(233.0, 392.0), P(233.0, 397.0), P(233.0, 398.0), 
    P(233.0, 402.0), P(233.0, 403.0), P(233.0, 404.0), P(233.0, 405.0), 
    P(233.0, 411.0), P(233.0, 412.0), P(233.0, 416.0), P(233.0, 420.0), 
    P(233.0, 421.0), P(233.0, 422.0), P(233.0, 424.0), P(233.0, 425.0), 
    P(233.0, 433.0), P(233.0, 450.0), P(233.0, 452.0), P(234.0, 43.0), 
    P(234.0, 340.0), P(234.0, 341.0), P(234.0, 350.0), P(234.0, 368.0), 
    P(234.0, 381.0), P(234.0, 382.0), P(234.0, 383.0), P(234.0, 384.0), 
    P(234.0, 385.0), P(234.0, 388.0), P(234.0, 389.0), P(234.0, 407.0), 
    P(234.0, 408.0), P(234.0, 417.0), P(234.0, 418.0), P(234.0, 434.0), 
    P(234.0, 452.0), P(235.0, 43.0), P(235.0, 369.0), P(235.0, 378.0), 
    P(235.0, 379.0), P(235.0, 434.0), P(235.0, 453.0), P(235.0, 465.0), 
    P(235.0, 471.0), P(235.0, 473.0), P(235.0, 474.0), P(236.0, 43.0), 
    P(236.0, 92.0), P(236.0, 349.0), P(236.0, 370.0), P(236.0, 371.0), 
    P(236.0, 372.0), P(236.0, 373.0), P(236.0, 374.0), P(236.0, 375.0), 
    P(236.0, 376.0), P(236.0, 435.0), P(236.0, 446.0), P(237.0, 338.0), 
    P(237.0, 455.0), P(237.0, 471.0), P(238.0, 44.0), P(238.0, 94.0), 
    P(238.0, 468.0), P(238.0, 469.0), P(238.0, 470.0), P(238.0, 474.0), 
    P(238.0, 475.0), P(239.0, 95.0), P(239.0, 336.0), P(239.0, 439.0), 
    P(239.0, 441.0), P(239.0, 443.0), P(239.0, 473.0), P(240.0, 336.0), 
    P(240.0, 337.0), P(240.0, 346.0), P(240.0, 441.0), P(240.0, 466.0), 
    P(240.0, 473.0), P(240.0, 474.0), P(241.0, 46.0), P(241.0, 98.0), 
    P(241.0, 337.0), P(241.0, 339.0), P(241.0, 340.0), P(241.0, 345.0), 
    P(241.0, 458.0), P(241.0, 466.0), P(241.0, 474.0), P(241.0, 475.0), 
    P(242.0, 99.0), P(242.0, 342.0), P(242.0, 343.0), P(243.0, 48.0), 
    P(243.0, 459.0), P(243.0, 465.0), P(243.0, 474.0), P(244.0, 48.0), 
    P(244.0, 460.0), P(244.0, 461.0), P(244.0, 462.0), P(244.0, 463.0), 
    P(244.0, 464.0), P(244.0, 474.0), P(245.0, 48.0), P(245.0, 102.0), 
    P(245.0, 474.0), P(246.0, 104.0), P(246.0, 105.0), P(246.0, 106.0), 
    P(246.0, 107.0), P(246.0, 108.0), P(246.0, 474.0), P(247.0, 110.0), 
    P(247.0, 475.0), P(247.0, 483.0), P(247.0, 484.0), P(247.0, 485.0), 
    P(247.0, 486.0), P(247.0, 487.0), P(247.0, 488.0), P(247.0, 489.0), 
    P(247.0, 490.0), P(248.0, 477.0), P(248.0, 478.0), P(248.0, 480.0), 
    P(248.0, 481.0), P(249.0, 47.0), P(249.0, 112.0), P(249.0, 493.0), 
    P(250.0, 47.0), P(250.0, 494.0), P(251.0, 47.0), P(251.0, 494.0), 
    P(252.0, 114.0), P(252.0, 502.0), P(252.0, 503.0), P(253.0, 114.0), 
    P(253.0, 496.0), P(253.0, 497.0), P(253.0, 498.0), P(253.0, 499.0), 
    P(253.0, 500.0), P(253.0, 503.0), P(254.0, 49.0), P(254.0, 115.0), 
    P(254.0, 507.0), P(254.0, 509.0), P(254.0, 511.0), P(255.0, 117.0), 
    P(255.0, 118.0), P(255.0, 509.0), P(256.0, 52.0), P(256.0, 54.0), 
    P(256.0, 55.0), P(256.0, 56.0), P(256.0, 57.0), P(256.0, 58.0), 
    P(257.0, 52.0), P(257.0, 60.0), P(257.0, 121.0), P(257.0, 122.0), 
    P(257.0, 123.0), P(257.0, 124.0), P(257.0, 193.0), P(257.0, 194.0), 
    P(257.0, 195.0), P(257.0, 196.0), P(258.0, 126.0), P(258.0, 127.0), 
    P(258.0, 190.0), P(258.0, 191.0), P(258.0, 197.0), P(259.0, 129.0), 
    P(259.0, 166.0), P(259.0, 167.0), P(259.0, 168.0), P(259.0, 169.0), 
    P(259.0, 170.0), P(259.0, 171.0), P(260.0, 64.0), P(260.0, 131.0), 
    P(260.0, 163.0), P(260.0, 164.0), P(260.0, 173.0), P(260.0, 188.0), 
    P(260.0, 197.0), P(260.0, 198.0), P(261.0, 65.0), P(261.0, 144.0), 
    P(261.0, 161.0), P(261.0, 188.0), P(262.0, 65.0), P(262.0, 142.0), 
    P(262.0, 144.0), P(262.0, 146.0), P(262.0, 147.0), P(262.0, 148.0), 
    P(262.0, 149.0), P(262.0, 150.0), P(262.0, 151.0), P(262.0, 152.0), 
    P(262.0, 158.0), P(262.0, 159.0), P(262.0, 188.0), P(262.0, 206.0), 
    P(262.0, 207.0), P(262.0, 208.0), P(263.0, 135.0), P(263.0, 136.0), 
    P(263.0, 154.0), P(263.0, 155.0), P(263.0, 156.0), P(263.0, 176.0), 
    P(263.0, 188.0), P(263.0, 195.0), P(264.0, 138.0), P(264.0, 139.0), 
    P(264.0, 176.0), P(264.0, 203.0), P(265.0, 67.0), P(265.0, 177.0), 
    P(265.0, 186.0), P(265.0, 193.0), P(265.0, 194.0), P(265.0, 201.0), 
    P(265.0, 212.0), P(266.0, 67.0), P(266.0, 181.0), P(266.0, 182.0), 
    P(266.0, 183.0), P(266.0, 184.0), P(266.0, 194.0), P(266.0, 196.0), 
    P(266.0, 198.0), P(266.0, 199.0), P(266.0, 214.0), P(266.0, 215.0), 
    P(267.0, 67.0), P(268.0, 67.0), P(268.0, 218.0), P(268.0, 219.0), 
    P(268.0, 220.0), P(268.0, 221.0), P(268.0, 222.0), P(268.0, 247.0), 
    P(268.0, 248.0), P(268.0, 249.0), P(268.0, 250.0), P(268.0, 251.0), 
    P(270.0, 69.0), P(270.0, 70.0), P(270.0, 244.0), P(270.0, 253.0), 
    P(270.0, 258.0), P(271.0, 71.0), P(271.0, 226.0), P(271.0, 227.0), 
    P(271.0, 228.0), P(271.0, 230.0), P(271.0, 231.0), P(271.0, 232.0), 
    P(271.0, 233.0), P(271.0, 237.0), P(271.0, 238.0), P(271.0, 239.0), 
    P(271.0, 240.0), P(271.0, 241.0), P(271.0, 242.0), P(271.0, 253.0), 
    P(271.0, 256.0), P(271.0, 258.0), P(272.0, 234.0), P(272.0, 236.0), 
    P(272.0, 253.0), P(272.0, 261.0), P(272.0, 319.0), P(273.0, 72.0), 
    P(273.0, 262.0), P(273.0, 319.0), P(274.0, 262.0), P(274.0, 284.0), 
    P(274.0, 317.0), P(274.0, 321.0), P(275.0, 262.0), P(275.0, 279.0), 
    P(275.0, 281.0), P(275.0, 282.0), P(275.0, 284.0), P(275.0, 286.0), 
    P(275.0, 317.0), P(275.0, 321.0), P(275.0, 324.0), P(275.0, 325.0), 
    P(275.0, 326.0), P(275.0, 327.0), P(276.0, 74.0), P(276.0, 262.0), 
    P(276.0, 277.0), P(276.0, 279.0), P(276.0, 287.0), P(276.0, 322.0), 
    P(277.0, 276.0), P(277.0, 287.0), P(277.0, 318.0), P(277.0, 329.0), 
    P(278.0, 276.0), P(278.0, 287.0), P(278.0, 319.0), P(278.0, 320.0), 
    P(278.0, 329.0), P(279.0, 76.0), P(279.0, 262.0), P(279.0, 263.0), 
    P(279.0, 287.0), P(279.0, 321.0), P(279.0, 329.0), P(280.0, 76.0), 
    P(280.0, 263.0), P(280.0, 321.0), P(281.0, 265.0), P(281.0, 266.0), 
    P(281.0, 267.0), P(281.0, 274.0), P(281.0, 328.0), P(282.0, 78.0), 
    P(282.0, 269.0), P(282.0, 270.0), P(282.0, 271.0), P(282.0, 272.0), 
    P(282.0, 273.0), P(282.0, 290.0), P(282.0, 291.0), P(283.0, 78.0), 
    P(283.0, 79.0), P(283.0, 293.0), P(283.0, 294.0), P(283.0, 299.0), 
    P(283.0, 300.0), P(283.0, 303.0), P(283.0, 323.0), P(283.0, 329.0), 
    P(284.0, 79.0), P(284.0, 296.0), P(284.0, 297.0), P(284.0, 303.0), 
    P(284.0, 305.0), P(284.0, 306.0), P(284.0, 307.0), P(284.0, 323.0), 
    P(285.0, 309.0), P(285.0, 310.0), P(285.0, 311.0), P(285.0, 312.0), 
    P(285.0, 313.0), P(286.0, 80.0), P(286.0, 81.0), P(286.0, 315.0), 
    P(286.0, 322.0), P(286.0, 332.0), P(286.0, 333.0), P(287.0, 316.0), 
    P(287.0, 317.0), P(287.0, 335.0), P(287.0, 336.0), P(287.0, 337.0), 
    P(287.0, 338.0), P(287.0, 339.0), P(287.0, 340.0), P(288.0, 82.0), 
    P(288.0, 317.0), P(288.0, 319.0), P(288.0, 320.0), P(288.0, 342.0), 
    P(289.0, 83.0), P(289.0, 344.0), P(289.0, 345.0), P(289.0, 346.0), 
    P(289.0, 347.0), P(289.0, 348.0), P(289.0, 349.0), P(289.0, 350.0), 
    P(289.0, 351.0), P(289.0, 373.0), P(289.0, 376.0), P(289.0, 377.0), 
    P(289.0, 378.0), P(289.0, 379.0), P(289.0, 380.0), P(289.0, 381.0), 
    P(289.0, 382.0), P(289.0, 383.0), P(290.0, 352.0), P(290.0, 373.0), 
    P(291.0, 84.0), P(291.0, 353.0), P(291.0, 371.0), P(291.0, 385.0), 
    P(292.0, 84.0), P(292.0, 355.0), P(292.0, 356.0), P(292.0, 371.0), 
    P(293.0, 84.0), P(293.0, 358.0), P(293.0, 386.0), P(294.0, 85.0), 
    P(294.0, 360.0), P(294.0, 386.0), P(295.0, 93.0), P(295.0, 94.0), 
    P(295.0, 95.0), P(295.0, 98.0), P(295.0, 374.0), P(295.0, 386.0), 
    P(296.0, 87.0), P(296.0, 100.0), P(296.0, 101.0), P(296.0, 363.0), 
    P(297.0, 88.0), P(297.0, 89.0), P(297.0, 90.0), P(297.0, 103.0), 
    P(297.0, 365.0), P(297.0, 387.0), P(298.0, 387.0), P(299.0, 105.0), 
    P(299.0, 368.0), P(299.0, 369.0), P(299.0, 370.0), P(299.0, 371.0), 
    P(299.0, 373.0), P(299.0, 387.0), P(300.0, 373.0), P(300.0, 387.0), 
    P(301.0, 107.0), P(301.0, 108.0), P(301.0, 376.0), P(301.0, 377.0), 
    P(301.0, 395.0), P(301.0, 396.0), P(302.0, 110.0), P(302.0, 389.0), 
    P(302.0, 392.0), P(302.0, 393.0), P(302.0, 398.0), P(303.0, 112.0), 
    P(303.0, 400.0), P(304.0, 411.0), P(304.0, 418.0), P(304.0, 419.0), 
    P(304.0, 420.0), P(305.0, 410.0), P(305.0, 411.0), P(305.0, 413.0), 
    P(305.0, 414.0), P(305.0, 415.0), P(305.0, 416.0), P(305.0, 421.0), 
    P(306.0, 116.0), P(306.0, 117.0), P(306.0, 118.0), P(306.0, 119.0), 
    P(306.0, 121.0), P(306.0, 123.0), P(306.0, 196.0), P(306.0, 410.0), 
    P(306.0, 421.0), P(307.0, 121.0), P(307.0, 124.0), P(307.0, 125.0), 
    P(307.0, 126.0), P(307.0, 127.0), P(307.0, 187.0), P(307.0, 188.0), 
    P(307.0, 189.0), P(307.0, 190.0), P(307.0, 191.0), P(307.0, 193.0), 
    P(307.0, 405.0), P(307.0, 407.0), P(307.0, 408.0), P(307.0, 409.0), 
    P(308.0, 129.0), P(308.0, 130.0), P(308.0, 131.0), P(308.0, 133.0), 
    P(308.0, 193.0), P(308.0, 212.0), P(308.0, 421.0), P(308.0, 422.0), 
    P(309.0, 133.0), P(309.0, 165.0), P(309.0, 183.0), P(309.0, 184.0), 
    P(309.0, 207.0), P(309.0, 209.0), P(309.0, 210.0), P(309.0, 211.0), 
    P(310.0, 136.0), P(310.0, 137.0), P(310.0, 160.0), P(310.0, 161.0), 
    P(310.0, 162.0), P(310.0, 172.0), P(310.0, 173.0), P(310.0, 174.0), 
    P(310.0, 176.0), P(310.0, 180.0), P(310.0, 181.0), P(310.0, 201.0), 
    P(310.0, 202.0), P(310.0, 203.0), P(310.0, 204.0), P(310.0, 205.0), 
    P(310.0, 215.0), P(310.0, 216.0), P(310.0, 217.0), P(310.0, 218.0), 
    P(310.0, 219.0), P(310.0, 220.0), P(310.0, 221.0), P(310.0, 222.0), 
    P(310.0, 223.0), P(311.0, 138.0), P(311.0, 144.0), P(311.0, 145.0), 
    P(311.0, 146.0), P(311.0, 147.0), P(311.0, 148.0), P(311.0, 149.0), 
    P(311.0, 150.0), P(311.0, 151.0), P(311.0, 152.0), P(311.0, 153.0), 
    P(311.0, 158.0), P(311.0, 167.0), P(311.0, 176.0), P(311.0, 225.0), 
    P(311.0, 226.0), P(311.0, 227.0), P(311.0, 230.0), P(311.0, 231.0), 
    P(311.0, 232.0), P(311.0, 419.0), P(312.0, 155.0), P(312.0, 156.0), 
    P(312.0, 168.0), P(312.0, 169.0), P(312.0, 234.0), P(312.0, 235.0), 
    P(312.0, 237.0), P(312.0, 239.0), P(312.0, 240.0), P(312.0, 242.0), 
    P(312.0, 419.0), P(313.0, 140.0), P(313.0, 141.0), P(313.0, 237.0), 
    P(313.0, 242.0), P(313.0, 420.0), P(313.0, 421.0), P(313.0, 422.0), 
    P(313.0, 423.0), P(313.0, 424.0), P(313.0, 425.0), P(313.0, 426.0), 
    P(313.0, 427.0), P(313.0, 428.0), P(314.0, 245.0), P(314.0, 263.0), 
    P(314.0, 264.0), P(314.0, 429.0), P(315.0, 246.0), P(315.0, 262.0), 
    P(315.0, 264.0), P(316.0, 246.0), P(316.0, 262.0), P(316.0, 264.0), 
    P(317.0, 260.0), P(317.0, 261.0), P(317.0, 264.0), P(317.0, 432.0), 
    P(318.0, 248.0), P(318.0, 258.0), P(318.0, 264.0), P(318.0, 434.0), 
    P(318.0, 435.0), P(319.0, 250.0), P(319.0, 251.0), P(319.0, 256.0), 
    P(320.0, 253.0), P(320.0, 254.0), P(321.0, 267.0), P(321.0, 268.0), 
    P(321.0, 269.0), P(321.0, 294.0), P(322.0, 296.0), P(322.0, 297.0), 
    P(322.0, 298.0), P(322.0, 299.0), P(322.0, 439.0), P(323.0, 272.0), 
    P(323.0, 292.0), P(323.0, 293.0), P(323.0, 299.0), P(324.0, 273.0), 
    P(324.0, 281.0), P(324.0, 282.0), P(324.0, 290.0), P(324.0, 292.0), 
    P(324.0, 299.0), P(324.0, 441.0), P(325.0, 280.0), P(325.0, 282.0), 
    P(325.0, 283.0), P(325.0, 300.0), P(325.0, 301.0), P(325.0, 443.0), 
    P(325.0, 444.0), P(325.0, 445.0), P(325.0, 446.0), P(325.0, 447.0), 
    P(325.0, 448.0), P(325.0, 449.0), P(325.0, 451.0), P(325.0, 454.0), 
    P(326.0, 275.0), P(326.0, 277.0), P(326.0, 279.0), P(326.0, 290.0), 
    P(326.0, 451.0), P(326.0, 454.0), P(326.0, 456.0), P(327.0, 277.0), 
    P(327.0, 285.0), P(327.0, 287.0), P(327.0, 289.0), P(328.0, 287.0), 
    P(328.0, 305.0), P(328.0, 307.0), P(328.0, 309.0), P(328.0, 312.0), 
    P(328.0, 313.0), P(328.0, 314.0), P(329.0, 307.0), P(329.0, 316.0), 
    P(329.0, 460.0), P(330.0, 317.0), P(330.0, 462.0), P(331.0, 317.0), 
    P(332.0, 317.0), P(332.0, 464.0), P(333.0, 328.0), P(333.0, 329.0), 
    P(333.0, 330.0), P(333.0, 331.0), P(333.0, 332.0), P(333.0, 333.0), 
    P(333.0, 334.0), P(333.0, 335.0), P(333.0, 336.0), P(333.0, 337.0), 
    P(333.0, 339.0), P(333.0, 464.0), P(334.0, 317.0), P(334.0, 327.0), 
    P(334.0, 340.0), P(334.0, 341.0), P(334.0, 342.0), P(334.0, 464.0), 
    P(335.0, 317.0), P(335.0, 464.0), P(336.0, 317.0), P(336.0, 344.0), 
    P(337.0, 317.0), P(338.0, 324.0), P(338.0, 346.0), P(338.0, 361.0), 
    P(338.0, 362.0), P(338.0, 363.0), P(338.0, 364.0), P(339.0, 318.0), 
    P(339.0, 348.0), P(339.0, 358.0), P(339.0, 359.0), P(340.0, 319.0), 
    P(340.0, 320.0), P(340.0, 321.0), P(340.0, 322.0), P(340.0, 468.0), 
    P(340.0, 469.0), P(341.0, 350.0), P(341.0, 367.0), P(341.0, 471.0), 
    P(341.0, 472.0), P(341.0, 473.0), P(342.0, 351.0), P(342.0, 352.0), 
    P(342.0, 353.0), P(342.0, 354.0), P(342.0, 368.0), P(342.0, 475.0), 
    P(343.0, 369.0), P(343.0, 476.0), P(344.0, 369.0), P(344.0, 376.0), 
    P(344.0, 377.0), P(344.0, 378.0), P(344.0, 380.0), P(344.0, 391.0), 
    P(344.0, 392.0), P(344.0, 476.0), P(345.0, 369.0), P(345.0, 375.0), 
    P(345.0, 380.0), P(345.0, 383.0), P(345.0, 384.0), P(345.0, 385.0), 
    P(345.0, 386.0), P(345.0, 391.0), P(345.0, 394.0), P(346.0, 395.0), 
    P(347.0, 372.0), P(347.0, 396.0), P(347.0, 477.0), P(348.0, 372.0), 
    P(348.0, 395.0), P(348.0, 477.0), P(349.0, 394.0), P(349.0, 395.0), 
    P(350.0, 478.0), P(351.0, 395.0), P(351.0, 479.0), P(352.0, 395.0), 
    P(352.0, 481.0), P(352.0, 482.0), P(353.0, 484.0), P(353.0, 485.0), 
    P(353.0, 486.0), P(353.0, 487.0), P(353.0, 488.0), P(353.0, 489.0), 
    P(354.0, 396.0), P(354.0, 490.0), P(355.0, 397.0), P(355.0, 403.0), 
    P(356.0, 399.0), P(356.0, 400.0), P(356.0, 401.0), P(356.0, 405.0), 
    P(356.0, 491.0), P(357.0, 416.0), P(357.0, 491.0), P(358.0, 408.0), 
    P(358.0, 416.0), P(358.0, 418.0), P(358.0, 419.0), P(358.0, 491.0), 
    P(359.0, 410.0), P(359.0, 411.0), P(359.0, 412.0), P(359.0, 419.0), 
    P(359.0, 420.0), P(359.0, 492.0), P(360.0, 421.0), P(360.0, 493.0), 
    P(361.0, 423.0), P(361.0, 424.0), P(361.0, 426.0), P(361.0, 428.0), 
    P(362.0, 426.0), P(363.0, 430.0), P(363.0, 495.0), P(364.0, 432.0), 
    P(365.0, 497.0), P(366.0, 434.0), P(367.0, 435.0), P(367.0, 498.0), 
    P(367.0, 499.0), P(367.0, 500.0), P(368.0, 499.0), P(368.0, 500.0), 
    P(369.0, 438.0), P(369.0, 502.0), P(370.0, 440.0), P(370.0, 502.0), 
    P(371.0, 441.0), P(372.0, 442.0), P(372.0, 443.0), P(372.0, 444.0), 
    P(372.0, 447.0), P(372.0, 503.0), P(373.0, 449.0), P(373.0, 503.0), 
    P(374.0, 503.0), P(375.0, 451.0), P(375.0, 503.0), P(376.0, 504.0), 
    P(377.0, 449.0), P(377.0, 450.0), P(377.0, 505.0), P(378.0, 507.0), 
    P(378.0, 508.0), P(379.0, 451.0), P(379.0, 509.0), P(380.0, 452.0), 
    P(381.0, 452.0), P(381.0, 510.0), P(382.0, 511.0), P(384.0, 454.0), 
    P(385.0, 454.0), P(387.0, 455.0), P(388.0, 455.0), P(391.0, 466.0), 
    P(391.0, 467.0), P(391.0, 468.0), P(392.0, 463.0), P(392.0, 464.0), 
    P(393.0, 460.0), P(393.0, 461.0), P(393.0, 471.0), P(394.0, 471.0), 
    P(397.0, 473.0), P(398.0, 473.0), P(400.0, 474.0), P(403.0, 477.0), 
    P(404.0, 479.0), P(406.0, 482.0), P(406.0, 483.0), P(407.0, 484.0), 
    P(407.0, 485.0), P(408.0, 486.0), P(409.0, 484.0), P(409.0, 485.0), 
    P(410.0, 484.0), P(413.0, 486.0), P(414.0, 487.0), P(414.0, 488.0), 
    P(414.0, 489.0), P(414.0, 490.0), P(414.0, 491.0), P(416.0, 494.0), 
    P(417.0, 494.0), P(418.0, 494.0), P(420.0, 495.0), P(423.0, 497.0), 
    P(424.0, 497.0), P(425.0, 497.0), P(426.0, 498.0), P(427.0, 499.0), 
    P(428.0, 499.0), P(430.0, 498.0), P(430.0, 499.0), P(436.0, 503.0), 
    P(438.0, 504.0), P(440.0, 504.0), P(440.0, 505.0), P(442.0, 503.0), 
    P(442.0, 505.0), P(444.0, 501.0), P(445.0, 501.0), P(448.0, 499.0), 
    P(448.0, 500.0), P(450.0, 501.0), P(450.0, 502.0), P(452.0, 504.0), 
    P(453.0, 505.0), P(453.0, 506.0), P(454.0, 508.0), P(455.0, 510.0), 
    P(455.0, 511.0)
};

#endif // VIGRA_CONVEX_HULL_TEST_HXX
