// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "FS_gfx.h"




FS::FS_gfx::FS_gfx()
{
    init();
    
} // FS::FS_gfx::FS_gfx

FS::FS_gfx::~FS_gfx()
{
    // clean up
    for ( int i = 0; i < NUM_SPRITES; ++i )
    {
        glDeleteTextures( 1, &(my_textures[i].tex_handle) );
    } // for
    
    for ( int i = 0; i < NUM_BACKGROUNDS; ++i )
    {
        delete my_backgrounds[i];
    } // for
    
    for ( int i = 0; i < NUM_FONTS; ++i )
    {
        delete my_fonts[i];
    } // for
    
} // FS::FS_gfx::~FS_gfx




void FS::FS_gfx::init()
{
    std::string path;
    char digits[4];
    
    // sprites
    // store texture dimensions here
    int w;
    int h;
    
    for ( int i = 0; i < NUM_SPRITES; ++i )
    {
        path = (PKG_DATA_DIR "/images/fs_sprite_");
        sprintf(digits, "%03d", i);
        path += digits;
        path += ".png";
        
        GLuint th = Mafferyew::Useful_gl::create_opengl_texture_rgba(path, &w, &h);
        Texture tex = { th, w, h };
        my_textures.push_back(tex);
    } // for 
    
    // backgrounds
    for ( int i = 0; i < NUM_BACKGROUNDS; ++i )
    {
        path = (PKG_DATA_DIR "/images/fs_bg_");
        sprintf(digits, "%03d", i);
        path += digits;
        path += ".png";
        
        Mafferyew::Background_image* bg_img = new Mafferyew::Background_image(path);
        my_backgrounds.push_back(bg_img);
    } // for
    
    // fonts
    for ( int i = 0; i < NUM_FONTS; ++i )
    {
        path = (PKG_DATA_DIR "/images/fs_font_");
        sprintf(digits, "%03d", i);
        path += digits;
        path += ".png";
        
        Mafferyew::SFont_gl* font = new Mafferyew::SFont_gl(path);
        my_fonts.push_back(font);
    } // for
    
} // FS::FS_gfx::init   

void FS::FS_gfx::clear_screen()
{
    glClearColor( 0.42, 0.81, 0.93, 0.0 );
    glClear(GL_COLOR_BUFFER_BIT);
    
} // FS::FS_gfx::clear_screen
