# Kubernetes tab

The Netdata dashboards feature enhanced visualizations for the resource utilization of Kubernetes (k8s) clusters, embedded in the default [Metrics tab](/docs/dashboards-and-charts/metrics-tab-and-single-node-tabs.md) dashboard.

These visualizations include a health map for viewing the status of k8s pods/containers, in addition to [Netdata charts](/docs/dashboards-and-charts/netdata-charts.md) for viewing per-second CPU, memory, disk, and networking metrics from k8s nodes.

See our [Kubernetes deployment instructions](/packaging/installer/methods/kubernetes.md) for details on deploying Netdata on your Kubernetes cluster.

## Available Kubernetes metrics

Netdata Cloud organizes and visualizes the following metrics from your Kubernetes cluster from every container:

| Metric                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                             |
|------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `k8s.cgroup.cpu_limit`             | CPU utilization as a percentage of the limit defined by the [pod specification `spec.containers[].resources.limits.cpu`](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#resource-requests-and-limits-of-pod-and-container) or a [`LimitRange` object](https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/cpu-default-namespace/#create-a-limitrange-and-a-pod).                       |
| `k8s.cgroup.cpu`                   | CPU utilization of the pod/container. 100% usage equals 1 fully-utilized core, 200% equals 2 fully-utilized cores, and so on.                                                                                                                                                                                                                                                                                                           |
| `k8s.cgroup.throttled`             | The percentage of runnable periods when tasks in a cgroup have been throttled.                                                                                                                                                                                                                                                                                                                                                          |
| `k8s.cgroup.throttled_duration`    | The total time duration for which tasks in a cgroup have been throttled.                                                                                                                                                                                                                                                                                                                                                                |
| `k8s.cgroup.mem_utilization`       | Memory utilization within the configured or system-wide (if not set) limits.                                                                                                                                                                                                                                                                                                                                                            |
| `k8s.cgroup.mem_usage_limit`       | Memory utilization, without cache, as a percentage of the limit defined by the [pod specification `spec.containers[].resources.limits.memory`](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#resource-requests-and-limits-of-pod-and-container) or a [`LimitRange` object](https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/cpu-default-namespace/#create-a-limitrange-and-a-pod). |
| `k8s.cgroup.mem_usage`             | Used memory, without cache.                                                                                                                                                                                                                                                                                                                                                                                                             |
| `k8s.cgroup.mem`                   | The sum of `cache` and `rss` (resident set size) memory usage.                                                                                                                                                                                                                                                                                                                                                                          |
| `k8s.cgroup.writeback`             | The size of `dirty` and `writeback` cache.                                                                                                                                                                                                                                                                                                                                                                                              |
| `k8s.cgroup.pgfaults`              | Sum of page fault bandwidth, which are raised when the Kubernetes cluster tries accessing a memory page that is mapped into the virtual address space, but not actually loaded into main memory.                                                                                                                                                                                                                                        |
| `k8s.cgroup.throttle_io`           | Sum of `read` and `write` per second across all PVs/PVCs attached to the container.                                                                                                                                                                                                                                                                                                                                                     |
| `k8s.cgroup.throttle_serviced_ops` | Sum of the `read` and `write` operations per second across all PVs/PVCs attached to the container.                                                                                                                                                                                                                                                                                                                                      |
| `k8s.cgroup.net_net`               | Sum of `received` and `sent` bandwidth per second.                                                                                                                                                                                                                                                                                                                                                                                      |
| `k8s.cgroup.net_packets`           | Sum of `multicast`, `received`, and `sent` packets.                                                                                                                                                                                                                                                                                                                                                                                     |


When viewing the [overview of this dashboard](#kubernetes-containers-overview), Netdata presents the above metrics per container, or aggregated based on
their associated pods.

## Kubernetes Containers overview

At the top of the Kubernetes containers section there is a map, that with a given context colorizes the containers in terms of their utilization.

The filtering of this map is controlled by using the [NIDL framework](/docs/dashboards-and-charts/netdata-charts.md#nidl-framework) from the definition bar of the chart.

### Detailed information

Hover over any of the pods/containers in the map to display a modal window, which contains contextual information and real-time metrics from that resource.
