import pkgcheck.addons
import pkgcheck.checks.acct
import pkgcheck.checks.cleanup
import pkgcheck.checks.codingstyle
import pkgcheck.checks.dropped_keywords
import pkgcheck.checks.eclass
import pkgcheck.checks.git
import pkgcheck.checks.glsa
import pkgcheck.checks.header
import pkgcheck.checks.imlate
import pkgcheck.checks.metadata
import pkgcheck.checks.metadata_xml
import pkgcheck.checks.network
import pkgcheck.checks.overlays
import pkgcheck.checks.perl
import pkgcheck.checks.pkgdir
import pkgcheck.checks.profiles
import pkgcheck.checks.python
import pkgcheck.checks.repo
import pkgcheck.checks.repo_metadata
import pkgcheck.checks.reserved
import pkgcheck.checks.ruby
import pkgcheck.checks.rust
import pkgcheck.checks.stablereq
import pkgcheck.checks.unstable_only
import pkgcheck.checks.visibility
import pkgcheck.checks.whitespace
import pkgcheck.reporters

CHECKS = (
  ('AbsoluteSymlinkCheck', pkgcheck.checks.codingstyle.AbsoluteSymlinkCheck),
  ('AcctCheck', pkgcheck.checks.acct.AcctCheck),
  ('BadCommandsCheck', pkgcheck.checks.codingstyle.BadCommandsCheck),
  ('BetterCompressionCheck', pkgcheck.checks.codingstyle.BetterCompressionCheck),
  ('CategoryMetadataXmlCheck', pkgcheck.checks.metadata_xml.CategoryMetadataXmlCheck),
  ('DeclarationShadowedCheck', pkgcheck.checks.codingstyle.DeclarationShadowedCheck),
  ('DependencyCheck', pkgcheck.checks.metadata.DependencyCheck),
  ('DescriptionCheck', pkgcheck.checks.metadata.DescriptionCheck),
  ('DoCompressedFilesCheck', pkgcheck.checks.codingstyle.DoCompressedFilesCheck),
  ('DroppedKeywordsCheck', pkgcheck.checks.dropped_keywords.DroppedKeywordsCheck),
  ('EapiCheck', pkgcheck.checks.metadata.EapiCheck),
  ('EbuildHeaderCheck', pkgcheck.checks.header.EbuildHeaderCheck),
  ('EbuildReservedCheck', pkgcheck.checks.reserved.EbuildReservedCheck),
  ('EbuildUnquotedVariablesCheck', pkgcheck.checks.codingstyle.EbuildUnquotedVariablesCheck),
  ('EclassCheck', pkgcheck.checks.eclass.EclassCheck),
  ('EclassHeaderCheck', pkgcheck.checks.header.EclassHeaderCheck),
  ('EclassManualDepsCheck', pkgcheck.checks.eclass.EclassManualDepsCheck),
  ('EclassParseCheck', pkgcheck.checks.eclass.EclassParseCheck),
  ('EclassReservedCheck', pkgcheck.checks.reserved.EclassReservedCheck),
  ('EclassUnquotedVariablesCheck', pkgcheck.checks.codingstyle.EclassUnquotedVariablesCheck),
  ('EclassUsageCheck', pkgcheck.checks.eclass.EclassUsageCheck),
  ('EendMissingArgCheck', pkgcheck.checks.codingstyle.EendMissingArgCheck),
  ('EmptyDirsCheck', pkgcheck.checks.repo.EmptyDirsCheck),
  ('EqualVersionsCheck', pkgcheck.checks.pkgdir.EqualVersionsCheck),
  ('FetchablesUrlCheck', pkgcheck.checks.network.FetchablesUrlCheck),
  ('GitCommitMessageCheck', pkgcheck.checks.git.GitCommitMessageCheck),
  ('GitEclassCommitsCheck', pkgcheck.checks.git.GitEclassCommitsCheck),
  ('GitPkgCommitsCheck', pkgcheck.checks.git.GitPkgCommitsCheck),
  ('GlobCheck', pkgcheck.checks.codingstyle.GlobCheck),
  ('GlobalUseCheck', pkgcheck.checks.repo_metadata.GlobalUseCheck),
  ('GlsaCheck', pkgcheck.checks.glsa.GlsaCheck),
  ('HomepageCheck', pkgcheck.checks.metadata.HomepageCheck),
  ('HomepageUrlCheck', pkgcheck.checks.network.HomepageUrlCheck),
  ('ImlateCheck', pkgcheck.checks.imlate.ImlateCheck),
  ('InheritsCheck', pkgcheck.checks.codingstyle.InheritsCheck),
  ('InsintoCheck', pkgcheck.checks.codingstyle.InsintoCheck),
  ('IuseCheck', pkgcheck.checks.metadata.IuseCheck),
  ('KeywordsCheck', pkgcheck.checks.metadata.KeywordsCheck),
  ('LicenseCheck', pkgcheck.checks.metadata.LicenseCheck),
  ('LicenseGroupsCheck', pkgcheck.checks.repo_metadata.LicenseGroupsCheck),
  ('LineLengthCheck', pkgcheck.checks.codingstyle.LineLengthCheck),
  ('LiveOnlyCheck', pkgcheck.checks.pkgdir.LiveOnlyCheck),
  ('LocalUseCheck', pkgcheck.checks.metadata.LocalUseCheck),
  ('ManifestCheck', pkgcheck.checks.repo_metadata.ManifestCheck),
  ('ManifestCollisionCheck', pkgcheck.checks.repo_metadata.ManifestCollisionCheck),
  ('MasterPackageClobberedCheck', pkgcheck.checks.overlays.MasterPackageClobberedCheck),
  ('MetadataUrlCheck', pkgcheck.checks.network.MetadataUrlCheck),
  ('MetadataVarCheck', pkgcheck.checks.codingstyle.MetadataVarCheck),
  ('MissingRemoteIdCheck', pkgcheck.checks.metadata_xml.MissingRemoteIdCheck),
  ('MissingSlotDepCheck', pkgcheck.checks.metadata.MissingSlotDepCheck),
  ('MissingUnpackerDepCheck', pkgcheck.checks.metadata.MissingUnpackerDepCheck),
  ('MissingWhitespaceCheck', pkgcheck.checks.whitespace.MissingWhitespaceCheck),
  ('NonPosixCheck', pkgcheck.checks.codingstyle.NonPosixCheck),
  ('ObsoleteUriCheck', pkgcheck.checks.codingstyle.ObsoleteUriCheck),
  ('OutdatedBlockersCheck', pkgcheck.checks.metadata.OutdatedBlockersCheck),
  ('PackageMetadataXmlCheck', pkgcheck.checks.metadata_xml.PackageMetadataXmlCheck),
  ('PackageUpdatesCheck', pkgcheck.checks.repo_metadata.PackageUpdatesCheck),
  ('PathVariablesCheck', pkgcheck.checks.codingstyle.PathVariablesCheck),
  ('PerlCheck', pkgcheck.checks.perl.PerlCheck),
  ('PkgDirCheck', pkgcheck.checks.pkgdir.PkgDirCheck),
  ('ProfilesCheck', pkgcheck.checks.profiles.ProfilesCheck),
  ('ProjectMetadataCheck', pkgcheck.checks.repo_metadata.ProjectMetadataCheck),
  ('PropertiesCheck', pkgcheck.checks.metadata.PropertiesCheck),
  ('PyPIAttestationAvailableCheck', pkgcheck.checks.network.PyPIAttestationAvailableCheck),
  ('PythonCheck', pkgcheck.checks.python.PythonCheck),
  ('PythonCompatCheck', pkgcheck.checks.python.PythonCompatCheck),
  ('PythonFetchableCheck', pkgcheck.checks.python.PythonFetchableCheck),
  ('PythonPackageNameCheck', pkgcheck.checks.python.PythonPackageNameCheck),
  ('ReadonlyVariableCheck', pkgcheck.checks.codingstyle.ReadonlyVariableCheck),
  ('RedundantDodirCheck', pkgcheck.checks.codingstyle.RedundantDodirCheck),
  ('RedundantVersionCheck', pkgcheck.checks.cleanup.RedundantVersionCheck),
  ('RepoDirCheck', pkgcheck.checks.repo.RepoDirCheck),
  ('RepoManifestHashCheck', pkgcheck.checks.repo_metadata.RepoManifestHashCheck),
  ('RepoProfilesCheck', pkgcheck.checks.profiles.RepoProfilesCheck),
  ('RepositoryCategories', pkgcheck.checks.repo.RepositoryCategories),
  ('RequiredUseCheck', pkgcheck.checks.metadata.RequiredUseCheck),
  ('RestrictCheck', pkgcheck.checks.metadata.RestrictCheck),
  ('RestrictTestCheck', pkgcheck.checks.metadata.RestrictTestCheck),
  ('RubyCompatCheck', pkgcheck.checks.ruby.RubyCompatCheck),
  ('RustCheck', pkgcheck.checks.rust.RustCheck),
  ('SandboxCallCheck', pkgcheck.checks.codingstyle.SandboxCallCheck),
  ('SourcingCheck', pkgcheck.checks.metadata.SourcingCheck),
  ('SrcUriCheck', pkgcheck.checks.metadata.SrcUriCheck),
  ('StableRequestCheck', pkgcheck.checks.stablereq.StableRequestCheck),
  ('StaleLiveCheck', pkgcheck.checks.metadata.StaleLiveCheck),
  ('UnstableOnlyCheck', pkgcheck.checks.unstable_only.UnstableOnlyCheck),
  ('UnusedEclassesCheck', pkgcheck.checks.repo_metadata.UnusedEclassesCheck),
  ('UnusedInMastersCheck', pkgcheck.checks.overlays.UnusedInMastersCheck),
  ('UnusedLicensesCheck', pkgcheck.checks.repo_metadata.UnusedLicensesCheck),
  ('UnusedMirrorsCheck', pkgcheck.checks.repo_metadata.UnusedMirrorsCheck),
  ('UseFlagsWithoutEffectsCheck', pkgcheck.checks.metadata.UseFlagsWithoutEffectsCheck),
  ('VariableOrderCheck', pkgcheck.checks.codingstyle.VariableOrderCheck),
  ('VariableScopeCheck', pkgcheck.checks.codingstyle.VariableScopeCheck),
  ('VirtualProvidersCheck', pkgcheck.checks.metadata.VirtualProvidersCheck),
  ('VisibilityCheck', pkgcheck.checks.visibility.VisibilityCheck),
  ('WhitespaceCheck', pkgcheck.checks.whitespace.WhitespaceCheck),
)

KEYWORDS = (
  ('AbsoluteSymlink', pkgcheck.checks.codingstyle.AbsoluteSymlink),
  ('ArchesOutOfSync', pkgcheck.checks.profiles.ArchesOutOfSync),
  ('ArchesWithoutProfiles', pkgcheck.checks.profiles.ArchesWithoutProfiles),
  ('BadCommitSummary', pkgcheck.checks.git.BadCommitSummary),
  ('BadDefaultUseFlags', pkgcheck.checks.metadata.BadDefaultUseFlags),
  ('BadDependency', pkgcheck.checks.metadata.BadDependency),
  ('BadDescription', pkgcheck.checks.metadata.BadDescription),
  ('BadFilename', pkgcheck.checks.metadata.BadFilename),
  ('BadHomepage', pkgcheck.checks.metadata.BadHomepage),
  ('BadKeywords', pkgcheck.checks.metadata.BadKeywords),
  ('BadPackageUpdate', pkgcheck.checks.repo_metadata.BadPackageUpdate),
  ('BadProtocol', pkgcheck.checks.metadata.BadProtocol),
  ('BadWhitespaceCharacter', pkgcheck.checks.whitespace.BadWhitespaceCharacter),
  ('BannedCharacter', pkgcheck.checks.pkgdir.BannedCharacter),
  ('BannedEapi', pkgcheck.checks.metadata.BannedEapi),
  ('BannedEapiCommand', pkgcheck.checks.codingstyle.BannedEapiCommand),
  ('BannedPhaseCall', pkgcheck.checks.codingstyle.BannedPhaseCall),
  ('BannedProfileEapi', pkgcheck.checks.profiles.BannedProfileEapi),
  ('BetterCompressionUri', pkgcheck.checks.codingstyle.BetterCompressionUri),
  ('BinaryFile', pkgcheck.checks.repo.BinaryFile),
  ('CatBadlyFormedXml', pkgcheck.checks.metadata_xml.CatBadlyFormedXml),
  ('CatInvalidXml', pkgcheck.checks.metadata_xml.CatInvalidXml),
  ('CatMetadataXmlEmptyElement', pkgcheck.checks.metadata_xml.CatMetadataXmlEmptyElement),
  ('CatMetadataXmlIndentation', pkgcheck.checks.metadata_xml.CatMetadataXmlIndentation),
  ('CatMetadataXmlInvalidCatRef', pkgcheck.checks.metadata_xml.CatMetadataXmlInvalidCatRef),
  ('CatMetadataXmlInvalidPkgRef', pkgcheck.checks.metadata_xml.CatMetadataXmlInvalidPkgRef),
  ('CatMissingMetadataXml', pkgcheck.checks.metadata_xml.CatMissingMetadataXml),
  ('CategoryIsNotDirectory', pkgcheck.checks.repo.CategoryIsNotDirectory),
  ('ConflictingAccountIdentifiers', pkgcheck.checks.acct.ConflictingAccountIdentifiers),
  ('ConflictingChksums', pkgcheck.checks.repo_metadata.ConflictingChksums),
  ('DeadUrl', pkgcheck.checks.network.DeadUrl),
  ('DependencyMoved', pkgcheck.checks.visibility.DependencyMoved),
  ('DeprecatedChksum', pkgcheck.checks.repo_metadata.DeprecatedChksum),
  ('DeprecatedDep', pkgcheck.checks.metadata.DeprecatedDep),
  ('DeprecatedEapi', pkgcheck.checks.metadata.DeprecatedEapi),
  ('DeprecatedEapiCommand', pkgcheck.checks.codingstyle.DeprecatedEapiCommand),
  ('DeprecatedEclass', pkgcheck.checks.eclass.DeprecatedEclass),
  ('DeprecatedEclassFunction', pkgcheck.checks.eclass.DeprecatedEclassFunction),
  ('DeprecatedEclassVariable', pkgcheck.checks.eclass.DeprecatedEclassVariable),
  ('DeprecatedInsinto', pkgcheck.checks.codingstyle.DeprecatedInsinto),
  ('DeprecatedLicense', pkgcheck.checks.metadata.DeprecatedLicense),
  ('DeprecatedManifestHash', pkgcheck.checks.repo_metadata.DeprecatedManifestHash),
  ('DeprecatedProfileEapi', pkgcheck.checks.profiles.DeprecatedProfileEapi),
  ('DeprecatedRepoHash', pkgcheck.checks.repo_metadata.DeprecatedRepoHash),
  ('DirectNoMaintainer', pkgcheck.checks.git.DirectNoMaintainer),
  ('DirectStableKeywords', pkgcheck.checks.git.DirectStableKeywords),
  ('DistutilsNonPEP517Build', pkgcheck.checks.python.DistutilsNonPEP517Build),
  ('DoubleEmptyLine', pkgcheck.checks.whitespace.DoubleEmptyLine),
  ('DoublePrefixInPath', pkgcheck.checks.codingstyle.DoublePrefixInPath),
  ('DroppedKeywords', pkgcheck.checks.dropped_keywords.DroppedKeywords),
  ('DroppedStableKeywords', pkgcheck.checks.git.DroppedStableKeywords),
  ('DroppedUnstableKeywords', pkgcheck.checks.git.DroppedUnstableKeywords),
  ('DuplicateEclassInherit', pkgcheck.checks.eclass.DuplicateEclassInherit),
  ('DuplicateFiles', pkgcheck.checks.pkgdir.DuplicateFiles),
  ('DuplicateFunctionDefinition', pkgcheck.checks.codingstyle.DuplicateFunctionDefinition),
  ('DuplicateKeywords', pkgcheck.checks.metadata.DuplicateKeywords),
  ('EAPIChangeWithoutRevbump', pkgcheck.checks.git.EAPIChangeWithoutRevbump),
  ('EPyTestPluginsSuggestion', pkgcheck.checks.python.EPyTestPluginsSuggestion),
  ('EbuildIncorrectCopyright', pkgcheck.checks.git.EbuildIncorrectCopyright),
  ('EbuildInvalidCopyright', pkgcheck.checks.header.EbuildInvalidCopyright),
  ('EbuildInvalidLicenseHeader', pkgcheck.checks.header.EbuildInvalidLicenseHeader),
  ('EbuildNonGentooAuthorsCopyright', pkgcheck.checks.header.EbuildNonGentooAuthorsCopyright),
  ('EbuildOldGentooCopyright', pkgcheck.checks.header.EbuildOldGentooCopyright),
  ('EbuildReservedName', pkgcheck.checks.reserved.EbuildReservedName),
  ('EbuildSemiReservedName', pkgcheck.checks.reserved.EbuildSemiReservedName),
  ('EbuildUnquotedVariable', pkgcheck.checks.codingstyle.EbuildUnquotedVariable),
  ('EbuildVariableScope', pkgcheck.checks.codingstyle.EbuildVariableScope),
  ('EclassBashSyntaxError', pkgcheck.checks.eclass.EclassBashSyntaxError),
  ('EclassDocError', pkgcheck.checks.eclass.EclassDocError),
  ('EclassDocMissingFunc', pkgcheck.checks.eclass.EclassDocMissingFunc),
  ('EclassDocMissingVar', pkgcheck.checks.eclass.EclassDocMissingVar),
  ('EclassExportFuncsBeforeInherit', pkgcheck.checks.eclass.EclassExportFuncsBeforeInherit),
  ('EclassIncorrectCopyright', pkgcheck.checks.git.EclassIncorrectCopyright),
  ('EclassInvalidCopyright', pkgcheck.checks.header.EclassInvalidCopyright),
  ('EclassInvalidLicenseHeader', pkgcheck.checks.header.EclassInvalidLicenseHeader),
  ('EclassNonGentooAuthorsCopyright', pkgcheck.checks.header.EclassNonGentooAuthorsCopyright),
  ('EclassOldGentooCopyright', pkgcheck.checks.header.EclassOldGentooCopyright),
  ('EclassReservedName', pkgcheck.checks.reserved.EclassReservedName),
  ('EclassUnquotedVariable', pkgcheck.checks.codingstyle.EclassUnquotedVariable),
  ('EclassUserVariableUsage', pkgcheck.checks.eclass.EclassUserVariableUsage),
  ('EclassVariableScope', pkgcheck.checks.eclass.EclassVariableScope),
  ('EendMissingArg', pkgcheck.checks.codingstyle.EendMissingArg),
  ('EmptyCategoryDir', pkgcheck.checks.repo.EmptyCategoryDir),
  ('EmptyFile', pkgcheck.checks.pkgdir.EmptyFile),
  ('EmptyGlobalAssignment', pkgcheck.checks.codingstyle.EmptyGlobalAssignment),
  ('EmptyPackageDir', pkgcheck.checks.repo.EmptyPackageDir),
  ('EmptyProject', pkgcheck.checks.repo_metadata.EmptyProject),
  ('EqualVersions', pkgcheck.checks.pkgdir.EqualVersions),
  ('ExcessiveLineLength', pkgcheck.checks.codingstyle.ExcessiveLineLength),
  ('ExecutableFile', pkgcheck.checks.pkgdir.ExecutableFile),
  ('GlobDistdir', pkgcheck.checks.codingstyle.GlobDistdir),
  ('GoMissingDeps', pkgcheck.checks.eclass.GoMissingDeps),
  ('HomepageInSrcUri', pkgcheck.checks.codingstyle.HomepageInSrcUri),
  ('HttpsUrlAvailable', pkgcheck.checks.network.HttpsUrlAvailable),
  ('IncorrectCopyright', pkgcheck.checks.git.IncorrectCopyright),
  ('IndirectInherits', pkgcheck.checks.codingstyle.IndirectInherits),
  ('InstallCompressedInfo', pkgcheck.checks.codingstyle.InstallCompressedInfo),
  ('InstallCompressedManpage', pkgcheck.checks.codingstyle.InstallCompressedManpage),
  ('InternalEclassUsage', pkgcheck.checks.codingstyle.InternalEclassUsage),
  ('InvalidBdepend', pkgcheck.checks.metadata.InvalidBdepend),
  ('InvalidCommitMessage', pkgcheck.checks.git.InvalidCommitMessage),
  ('InvalidCommitTag', pkgcheck.checks.git.InvalidCommitTag),
  ('InvalidCopyright', pkgcheck.checks.header.InvalidCopyright),
  ('InvalidDepend', pkgcheck.checks.metadata.InvalidDepend),
  ('InvalidEapi', pkgcheck.checks.metadata.InvalidEapi),
  ('InvalidIdepend', pkgcheck.checks.metadata.InvalidIdepend),
  ('InvalidLicense', pkgcheck.checks.metadata.InvalidLicense),
  ('InvalidLicenseHeader', pkgcheck.checks.header.InvalidLicenseHeader),
  ('InvalidManifest', pkgcheck.checks.repo_metadata.InvalidManifest),
  ('InvalidMetadataRestrict', pkgcheck.checks.metadata_xml.InvalidMetadataRestrict),
  ('InvalidPN', pkgcheck.checks.pkgdir.InvalidPN),
  ('InvalidPdepend', pkgcheck.checks.metadata.InvalidPdepend),
  ('InvalidProperties', pkgcheck.checks.metadata.InvalidProperties),
  ('InvalidRdepend', pkgcheck.checks.metadata.InvalidRdepend),
  ('InvalidRemoteID', pkgcheck.checks.metadata_xml.InvalidRemoteID),
  ('InvalidRequiredUse', pkgcheck.checks.metadata.InvalidRequiredUse),
  ('InvalidRestrict', pkgcheck.checks.metadata.InvalidRestrict),
  ('InvalidSandboxCall', pkgcheck.checks.codingstyle.InvalidSandboxCall),
  ('InvalidSlot', pkgcheck.checks.metadata.InvalidSlot),
  ('InvalidSrcUri', pkgcheck.checks.metadata.InvalidSrcUri),
  ('InvalidUTF8', pkgcheck.checks.pkgdir.InvalidUTF8),
  ('InvalidUseFlags', pkgcheck.checks.metadata.InvalidUseFlags),
  ('LaggingProfileEapi', pkgcheck.checks.profiles.LaggingProfileEapi),
  ('LaggingStable', pkgcheck.checks.imlate.LaggingStable),
  ('LiveOnlyPackage', pkgcheck.checks.pkgdir.LiveOnlyPackage),
  ('MaintainerNeeded', pkgcheck.checks.metadata_xml.MaintainerNeeded),
  ('MaintainerWithoutProxy', pkgcheck.checks.metadata_xml.MaintainerWithoutProxy),
  ('MasterPackageClobbered', pkgcheck.checks.overlays.MasterPackageClobbered),
  ('MatchingChksums', pkgcheck.checks.repo_metadata.MatchingChksums),
  ('MatchingGlobalUse', pkgcheck.checks.metadata.MatchingGlobalUse),
  ('MismatchedPN', pkgcheck.checks.pkgdir.MismatchedPN),
  ('MismatchedPerlVersion', pkgcheck.checks.perl.MismatchedPerlVersion),
  ('MisplacedEPyTestVar', pkgcheck.checks.python.MisplacedEPyTestVar),
  ('MisplacedEclassVar', pkgcheck.checks.eclass.MisplacedEclassVar),
  ('MisplacedWeakBlocker', pkgcheck.checks.metadata.MisplacedWeakBlocker),
  ('MissingAccountIdentifier', pkgcheck.checks.acct.MissingAccountIdentifier),
  ('MissingChksum', pkgcheck.checks.repo_metadata.MissingChksum),
  ('MissingEAPIBlankLine', pkgcheck.checks.whitespace.MissingEAPIBlankLine),
  ('MissingInherits', pkgcheck.checks.codingstyle.MissingInherits),
  ('MissingLicense', pkgcheck.checks.metadata.MissingLicense),
  ('MissingLicenseRestricts', pkgcheck.checks.metadata.MissingLicenseRestricts),
  ('MissingLocalUseDesc', pkgcheck.checks.metadata.MissingLocalUseDesc),
  ('MissingManifest', pkgcheck.checks.repo_metadata.MissingManifest),
  ('MissingMove', pkgcheck.checks.git.MissingMove),
  ('MissingPackageRevision', pkgcheck.checks.metadata.MissingPackageRevision),
  ('MissingPythonEclass', pkgcheck.checks.python.MissingPythonEclass),
  ('MissingRemoteId', pkgcheck.checks.metadata_xml.MissingRemoteId),
  ('MissingSignOff', pkgcheck.checks.git.MissingSignOff),
  ('MissingSlash', pkgcheck.checks.codingstyle.MissingSlash),
  ('MissingSlotDep', pkgcheck.checks.metadata.MissingSlotDep),
  ('MissingSlotmove', pkgcheck.checks.git.MissingSlotmove),
  ('MissingTestRestrict', pkgcheck.checks.metadata.MissingTestRestrict),
  ('MissingUnpackerDep', pkgcheck.checks.metadata.MissingUnpackerDep),
  ('MissingUri', pkgcheck.checks.metadata.MissingUri),
  ('MissingUseDepDefault', pkgcheck.checks.metadata.MissingUseDepDefault),
  ('MissingVersionedVirtualPerlDependency', pkgcheck.checks.perl.MissingVersionedVirtualPerlDependency),
  ('MovedPackageUpdate', pkgcheck.checks.repo_metadata.MovedPackageUpdate),
  ('MultiMovePackageUpdate', pkgcheck.checks.repo_metadata.MultiMovePackageUpdate),
  ('MultipleKeywordsLines', pkgcheck.checks.codingstyle.MultipleKeywordsLines),
  ('NewerEAPIAvailable', pkgcheck.checks.git.NewerEAPIAvailable),
  ('NoFinalNewline', pkgcheck.checks.whitespace.NoFinalNewline),
  ('NonConsistentTarUsage', pkgcheck.checks.codingstyle.NonConsistentTarUsage),
  ('NonGentooAuthorsCopyright', pkgcheck.checks.header.NonGentooAuthorsCopyright),
  ('NonPosixHeadTailUsage', pkgcheck.checks.codingstyle.NonPosixHeadTailUsage),
  ('NonexistentBlocker', pkgcheck.checks.metadata.NonexistentBlocker),
  ('NonexistentCategories', pkgcheck.checks.profiles.NonexistentCategories),
  ('NonexistentDeps', pkgcheck.checks.visibility.NonexistentDeps),
  ('NonexistentProfilePath', pkgcheck.checks.profiles.NonexistentProfilePath),
  ('NonexistentProjectMaintainer', pkgcheck.checks.metadata_xml.NonexistentProjectMaintainer),
  ('NonsolvableDeps', pkgcheck.checks.visibility.NonsolvableDeps),
  ('NonsolvableDepsInDev', pkgcheck.checks.visibility.NonsolvableDepsInDev),
  ('NonsolvableDepsInExp', pkgcheck.checks.visibility.NonsolvableDepsInExp),
  ('NonsolvableDepsInStable', pkgcheck.checks.visibility.NonsolvableDepsInStable),
  ('ObsoleteUri', pkgcheck.checks.codingstyle.ObsoleteUri),
  ('OldGentooCopyright', pkgcheck.checks.header.OldGentooCopyright),
  ('OldMultiMovePackageUpdate', pkgcheck.checks.repo_metadata.OldMultiMovePackageUpdate),
  ('OldPackageName', pkgcheck.checks.visibility.OldPackageName),
  ('OldPackageNameDep', pkgcheck.checks.visibility.OldPackageNameDep),
  ('OldPackageUpdate', pkgcheck.checks.repo_metadata.OldPackageUpdate),
  ('OldPythonCompat', pkgcheck.checks.git.OldPythonCompat),
  ('OutdatedBlocker', pkgcheck.checks.metadata.OutdatedBlocker),
  ('OutdatedProfilePackage', pkgcheck.checks.profiles.OutdatedProfilePackage),
  ('OutsideRangeAccountIdentifier', pkgcheck.checks.acct.OutsideRangeAccountIdentifier),
  ('OverlappingKeywords', pkgcheck.checks.metadata.OverlappingKeywords),
  ('PkgBadlyFormedXml', pkgcheck.checks.metadata_xml.PkgBadlyFormedXml),
  ('PkgInvalidXml', pkgcheck.checks.metadata_xml.PkgInvalidXml),
  ('PkgMetadataXmlEmptyElement', pkgcheck.checks.metadata_xml.PkgMetadataXmlEmptyElement),
  ('PkgMetadataXmlIndentation', pkgcheck.checks.metadata_xml.PkgMetadataXmlIndentation),
  ('PkgMetadataXmlInvalidCatRef', pkgcheck.checks.metadata_xml.PkgMetadataXmlInvalidCatRef),
  ('PkgMetadataXmlInvalidPkgRef', pkgcheck.checks.metadata_xml.PkgMetadataXmlInvalidPkgRef),
  ('PkgMissingMetadataXml', pkgcheck.checks.metadata_xml.PkgMissingMetadataXml),
  ('PotentialGlobalUse', pkgcheck.checks.repo_metadata.PotentialGlobalUse),
  ('PotentialLocalUse', pkgcheck.checks.repo_metadata.PotentialLocalUse),
  ('PotentialStable', pkgcheck.checks.imlate.PotentialStable),
  ('ProbableGlobalUse', pkgcheck.checks.metadata.ProbableGlobalUse),
  ('ProbableUseExpand', pkgcheck.checks.metadata.ProbableUseExpand),
  ('ProfileError', pkgcheck.checks.profiles.ProfileError),
  ('ProfileMissingImplicitExpandValues', pkgcheck.checks.profiles.ProfileMissingImplicitExpandValues),
  ('ProfileWarning', pkgcheck.checks.profiles.ProfileWarning),
  ('ProvidedEclassInherit', pkgcheck.checks.eclass.ProvidedEclassInherit),
  ('ProxyWithoutProxied', pkgcheck.checks.metadata_xml.ProxyWithoutProxied),
  ('PyPIAttestationAvailable', pkgcheck.checks.network.PyPIAttestationAvailable),
  ('PythonAnyMismatchedDepHasVersionCheck', pkgcheck.checks.python.PythonAnyMismatchedDepHasVersionCheck),
  ('PythonAnyMismatchedUseHasVersionCheck', pkgcheck.checks.python.PythonAnyMismatchedUseHasVersionCheck),
  ('PythonCompatUpdate', pkgcheck.checks.python.PythonCompatUpdate),
  ('PythonEclassError', pkgcheck.checks.python.PythonEclassError),
  ('PythonGHDistfileSuffix', pkgcheck.checks.python.PythonGHDistfileSuffix),
  ('PythonHasVersionMissingPythonUseDep', pkgcheck.checks.python.PythonHasVersionMissingPythonUseDep),
  ('PythonHasVersionUsage', pkgcheck.checks.python.PythonHasVersionUsage),
  ('PythonInlinePyPIURI', pkgcheck.checks.python.PythonInlinePyPIURI),
  ('PythonMismatchedPackageName', pkgcheck.checks.python.PythonMismatchedPackageName),
  ('PythonMissingDeps', pkgcheck.checks.python.PythonMissingDeps),
  ('PythonMissingRequiredUse', pkgcheck.checks.python.PythonMissingRequiredUse),
  ('PythonMissingSCMDependency', pkgcheck.checks.python.PythonMissingSCMDependency),
  ('PythonPEP517WithoutRevbump', pkgcheck.checks.git.PythonPEP517WithoutRevbump),
  ('PythonRuntimeDepInAnyR1', pkgcheck.checks.python.PythonRuntimeDepInAnyR1),
  ('RdependChange', pkgcheck.checks.git.RdependChange),
  ('ReadonlyVariable', pkgcheck.checks.codingstyle.ReadonlyVariable),
  ('RedirectedUrl', pkgcheck.checks.network.RedirectedUrl),
  ('RedundantDodir', pkgcheck.checks.codingstyle.RedundantDodir),
  ('RedundantLongDescription', pkgcheck.checks.metadata_xml.RedundantLongDescription),
  ('RedundantPackageUpdate', pkgcheck.checks.repo_metadata.RedundantPackageUpdate),
  ('RedundantPyTestDisablePluginAutoload', pkgcheck.checks.python.RedundantPyTestDisablePluginAutoload),
  ('RedundantUriRename', pkgcheck.checks.metadata.RedundantUriRename),
  ('RedundantVersion', pkgcheck.checks.cleanup.RedundantVersion),
  ('ReferenceInMetadataVar', pkgcheck.checks.codingstyle.ReferenceInMetadataVar),
  ('RequiredUseDefaults', pkgcheck.checks.metadata.RequiredUseDefaults),
  ('RubyCompatUpdate', pkgcheck.checks.ruby.RubyCompatUpdate),
  ('RubyMissingDeps', pkgcheck.checks.eclass.RubyMissingDeps),
  ('RustMissingDeps', pkgcheck.checks.eclass.RustMissingDeps),
  ('SSLCertificateError', pkgcheck.checks.network.SSLCertificateError),
  ('SelfAssignment', pkgcheck.checks.codingstyle.SelfAssignment),
  ('ShadowedEPyTestTimeout', pkgcheck.checks.python.ShadowedEPyTestTimeout),
  ('SizeViolation', pkgcheck.checks.pkgdir.SizeViolation),
  ('SourcingError', pkgcheck.checks.metadata.SourcingError),
  ('SrcUriChecksumChange', pkgcheck.checks.git.SrcUriChecksumChange),
  ('SrcUriFilenameDotPrefix', pkgcheck.checks.metadata.SrcUriFilenameDotPrefix),
  ('StableKeywordsOnTestingEapi', pkgcheck.checks.metadata.StableKeywordsOnTestingEapi),
  ('StableRequest', pkgcheck.checks.stablereq.StableRequest),
  ('StaleLiveEAPI', pkgcheck.checks.metadata.StaleLiveEAPI),
  ('StaticSrcUri', pkgcheck.checks.codingstyle.StaticSrcUri),
  ('SuboptimalCratesSeparator', pkgcheck.checks.rust.SuboptimalCratesSeparator),
  ('SuboptimalCratesURICall', pkgcheck.checks.rust.SuboptimalCratesURICall),
  ('SuspiciousSrcUriChange', pkgcheck.checks.git.SuspiciousSrcUriChange),
  ('SystemSetMissingKeywords', pkgcheck.checks.profiles.SystemSetMissingKeywords),
  ('TarballAvailable', pkgcheck.checks.metadata.TarballAvailable),
  ('TmpfilesMissingDeps', pkgcheck.checks.eclass.TmpfilesMissingDeps),
  ('TooManyCrates', pkgcheck.checks.rust.TooManyCrates),
  ('TotalSizeViolation', pkgcheck.checks.pkgdir.TotalSizeViolation),
  ('TrailingEmptyLine', pkgcheck.checks.whitespace.TrailingEmptyLine),
  ('UncheckableDep', pkgcheck.checks.visibility.UncheckableDep),
  ('UnderscoreInUseFlag', pkgcheck.checks.metadata.UnderscoreInUseFlag),
  ('UnknownCategoryDirs', pkgcheck.checks.profiles.UnknownCategoryDirs),
  ('UnknownKeywords', pkgcheck.checks.metadata.UnknownKeywords),
  ('UnknownLicense', pkgcheck.checks.metadata.UnknownLicense),
  ('UnknownLicenses', pkgcheck.checks.repo_metadata.UnknownLicenses),
  ('UnknownManifest', pkgcheck.checks.repo_metadata.UnknownManifest),
  ('UnknownMirror', pkgcheck.checks.metadata.UnknownMirror),
  ('UnknownPkgDirEntry', pkgcheck.checks.pkgdir.UnknownPkgDirEntry),
  ('UnknownProfileArch', pkgcheck.checks.profiles.UnknownProfileArch),
  ('UnknownProfilePackage', pkgcheck.checks.profiles.UnknownProfilePackage),
  ('UnknownProfilePackageKeywords', pkgcheck.checks.profiles.UnknownProfilePackageKeywords),
  ('UnknownProfilePackageUse', pkgcheck.checks.profiles.UnknownProfilePackageUse),
  ('UnknownProfileUse', pkgcheck.checks.profiles.UnknownProfileUse),
  ('UnknownProfileUseExpand', pkgcheck.checks.profiles.UnknownProfileUseExpand),
  ('UnknownProfileUseExpandValue', pkgcheck.checks.profiles.UnknownProfileUseExpandValue),
  ('UnknownProperties', pkgcheck.checks.metadata.UnknownProperties),
  ('UnknownRestrict', pkgcheck.checks.metadata.UnknownRestrict),
  ('UnknownUseFlags', pkgcheck.checks.metadata.UnknownUseFlags),
  ('UnmatchedProfilePackageUnmask', pkgcheck.checks.profiles.UnmatchedProfilePackageUnmask),
  ('UnnecessaryLicense', pkgcheck.checks.metadata.UnnecessaryLicense),
  ('UnnecessaryManifest', pkgcheck.checks.repo_metadata.UnnecessaryManifest),
  ('UnnecessarySlashStrip', pkgcheck.checks.codingstyle.UnnecessarySlashStrip),
  ('UnquotedVariable', pkgcheck.checks.codingstyle.UnquotedVariable),
  ('UnsortedKeywords', pkgcheck.checks.metadata.UnsortedKeywords),
  ('UnstableOnly', pkgcheck.checks.unstable_only.UnstableOnly),
  ('UnstableSrcUri', pkgcheck.checks.metadata.UnstableSrcUri),
  ('UnstatedIuse', pkgcheck.addons.UnstatedIuse),
  ('UnsupportedEclassEapi', pkgcheck.checks.metadata.UnsupportedEclassEapi),
  ('UnusedEclasses', pkgcheck.checks.repo_metadata.UnusedEclasses),
  ('UnusedGlobalUse', pkgcheck.checks.repo_metadata.UnusedGlobalUse),
  ('UnusedGlobalUseExpand', pkgcheck.checks.repo_metadata.UnusedGlobalUseExpand),
  ('UnusedInMastersEclasses', pkgcheck.checks.overlays.UnusedInMastersEclasses),
  ('UnusedInMastersGlobalUse', pkgcheck.checks.overlays.UnusedInMastersGlobalUse),
  ('UnusedInMastersLicenses', pkgcheck.checks.overlays.UnusedInMastersLicenses),
  ('UnusedInMastersMirrors', pkgcheck.checks.overlays.UnusedInMastersMirrors),
  ('UnusedInherits', pkgcheck.checks.codingstyle.UnusedInherits),
  ('UnusedLicenses', pkgcheck.checks.repo_metadata.UnusedLicenses),
  ('UnusedLocalUse', pkgcheck.checks.metadata.UnusedLocalUse),
  ('UnusedMirrors', pkgcheck.checks.repo_metadata.UnusedMirrors),
  ('UnusedProfileDirs', pkgcheck.checks.profiles.UnusedProfileDirs),
  ('UseFlagWithoutDeps', pkgcheck.checks.metadata.UseFlagWithoutDeps),
  ('VariableOrderWrong', pkgcheck.checks.codingstyle.VariableOrderWrong),
  ('VariableScope', pkgcheck.checks.codingstyle.VariableScope),
  ('VariableShadowed', pkgcheck.checks.codingstyle.VariableShadowed),
  ('VirtualKeywordsUpdate', pkgcheck.checks.metadata.VirtualKeywordsUpdate),
  ('VirtualWithBdepend', pkgcheck.checks.metadata.VirtualWithBdepend),
  ('VirtualWithDepend', pkgcheck.checks.metadata.VirtualWithDepend),
  ('VirtualWithSingleProvider', pkgcheck.checks.metadata.VirtualWithSingleProvider),
  ('VisibleVcsPkg', pkgcheck.checks.visibility.VisibleVcsPkg),
  ('VulnerablePackage', pkgcheck.checks.glsa.VulnerablePackage),
  ('WhitespaceFound', pkgcheck.checks.whitespace.WhitespaceFound),
  ('WrongIndentFound', pkgcheck.checks.whitespace.WrongIndentFound),
  ('WrongMaintainerType', pkgcheck.checks.metadata_xml.WrongMaintainerType),
)

REPORTERS = (
  ('CsvReporter', pkgcheck.reporters.CsvReporter),
  ('FancyReporter', pkgcheck.reporters.FancyReporter),
  ('FlycheckReporter', pkgcheck.reporters.FlycheckReporter),
  ('FormatReporter', pkgcheck.reporters.FormatReporter),
  ('JsonReporter', pkgcheck.reporters.JsonReporter),
  ('JsonStream', pkgcheck.reporters.JsonStream),
  ('StrReporter', pkgcheck.reporters.StrReporter),
  ('XmlReporter', pkgcheck.reporters.XmlReporter),
)
