Example of illegal code:

```ada
function F (X : out Integer) return Integer;
```

This error is issued on functions which declare parameters of mode `out` or `in
out`. This side-effect is not allowed in functions in SPARK for two reasons:
this could lead to different behaviors on code with problematic aliasing
depending on various choices made by the compiler (the choice to pass
parameters by copy or by reference, and the choice in the order in which
parameters are copied back when passed by copy); and functions can be called in
assertions and contracts, and as such should have a logical interpretation as
mathematical functions from inputs to result, which excludes the possibility of
side-effects.

The fix is to declare that the function has side-effects, which has the effect
of restricting its use so that the cases mentioned above cannot occur.
This is achieved by declaring `F` with the aspect `Side_Effects`:

```ada
function F (X : out Integer) return Integer
  with Side_Effects;
```

As a result, calls to `F` can only appear as the right-hand side of
assignments, which may require adapting `F`'s callers:

```ada
declare
   X : Integer;
   Y : Integer := F (X); -- error
begin
   Y := F (X); -- ok
   Y := F (X) + 1; -- error
end;
```
