// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv32 -target-feature +v -target-feature +zfh -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV32 %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +zfh -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

#define p27_26 (0b11)
#define p26    (0b1)
#define p11_7  (0b11111)
#define simm5  (10)

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv1i8.nxv1i8.i32(i32 3, i32 31, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv1i8.nxv1i8.i64(i64 3, i64 31, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8mf8(vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8mf8(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv2i8.nxv2i8.i32(i32 3, i32 31, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv2i8.nxv2i8.i64(i64 3, i64 31, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8mf4(vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8mf4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv4i8.nxv4i8.i32(i32 3, i32 31, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv4i8.nxv4i8.i64(i64 3, i64 31, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8mf2(vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8mf2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv8i8.nxv8i8.i32(i32 3, i32 31, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv8i8.nxv8i8.i64(i64 3, i64 31, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8m1(vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8m1(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv16i8.nxv16i8.i32(i32 3, i32 31, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv16i8.nxv16i8.i64(i64 3, i64 31, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8m2(vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8m2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv32i8.nxv32i8.i32(i32 3, i32 31, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv32i8.nxv32i8.i64(i64 3, i64 31, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8m4(vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8m4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv64i8.nxv64i8.i32(i32 3, i32 31, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv64i8.nxv64i8.i64(i64 3, i64 31, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u8m8(vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u8m8(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv1i16.nxv1i16.i32(i32 3, i32 31, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv1i16.nxv1i16.i64(i64 3, i64 31, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16mf4(vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16mf4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv2i16.nxv2i16.i32(i32 3, i32 31, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv2i16.nxv2i16.i64(i64 3, i64 31, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16mf2(vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16mf2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv4i16.nxv4i16.i32(i32 3, i32 31, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv4i16.nxv4i16.i64(i64 3, i64 31, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16m1(vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16m1(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv8i16.nxv8i16.i32(i32 3, i32 31, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv8i16.nxv8i16.i64(i64 3, i64 31, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16m2(vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16m2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv16i16.nxv16i16.i32(i32 3, i32 31, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv16i16.nxv16i16.i64(i64 3, i64 31, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16m4(vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16m4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv32i16.nxv32i16.i32(i32 3, i32 31, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv32i16.nxv32i16.i64(i64 3, i64 31, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u16m8(vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u16m8(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv1i32.nxv1i32.i32(i32 3, i32 31, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv1i32.nxv1i32.i64(i64 3, i64 31, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u32mf2(vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u32mf2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv2i32.nxv2i32.i32(i32 3, i32 31, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv2i32.nxv2i32.i64(i64 3, i64 31, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u32m1(vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u32m1(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv4i32.nxv4i32.i32(i32 3, i32 31, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv4i32.nxv4i32.i64(i64 3, i64 31, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u32m2(vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u32m2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv8i32.nxv8i32.i32(i32 3, i32 31, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv8i32.nxv8i32.i64(i64 3, i64 31, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u32m4(vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u32m4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv16i32.nxv16i32.i32(i32 3, i32 31, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv16i32.nxv16i32.i64(i64 3, i64 31, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u32m8(vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u32m8(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv1i64.nxv1i64.i32(i32 3, i32 31, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv1i64.nxv1i64.i64(i64 3, i64 31, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u64m1(vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u64m1(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv2i64.nxv2i64.i32(i32 3, i32 31, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv2i64.nxv2i64.i64(i64 3, i64 31, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u64m2(vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u64m2(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv4i64.nxv4i64.i32(i32 3, i32 31, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv4i64.nxv4i64.i64(i64 3, i64 31, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u64m4(vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u64m4(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i32.nxv8i64.nxv8i64.i32(i32 3, i32 31, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vv.se.i64.nxv8i64.nxv8i64.i64(i64 3, i64 31, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vv_se_u64m8(vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  __riscv_sf_vc_vv_se_u64m8(p27_26, p11_7, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.i32.nxv1i8.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.i64.nxv1i8.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_vv_se_u8mf8(vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8mf8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.i32.nxv2i8.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.i64.nxv2i8.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_vv_se_u8mf4(vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8mf4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.i32.nxv4i8.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.i64.nxv4i8.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_vv_se_u8mf2(vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.i32.nxv8i8.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.i64.nxv8i8.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_vv_se_u8m1(vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.i32.nxv16i8.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.i64.nxv16i8.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_vv_se_u8m2(vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.i32.nxv32i8.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.i64.nxv32i8.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_vv_se_u8m4(vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.i32.nxv64i8.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.i64.nxv64i8.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_vv_se_u8m8(vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u8m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.i32.nxv1i16.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.i64.nxv1i16.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_vv_se_u16mf4(vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16mf4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.i32.nxv2i16.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.i64.nxv2i16.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_vv_se_u16mf2(vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.i32.nxv4i16.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.i64.nxv4i16.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_vv_se_u16m1(vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.i32.nxv8i16.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.i64.nxv8i16.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_vv_se_u16m2(vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.i32.nxv16i16.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.i64.nxv16i16.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_vv_se_u16m4(vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.i32.nxv32i16.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.i64.nxv32i16.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_vv_se_u16m8(vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u16m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.i32.nxv1i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.i64.nxv1i32.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_vv_se_u32mf2(vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u32mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.i32.nxv2i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.i64.nxv2i32.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_vv_se_u32m1(vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u32m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.i32.nxv4i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.i64.nxv4i32.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_vv_se_u32m2(vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u32m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.i32.nxv8i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.i64.nxv8i32.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_vv_se_u32m4(vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u32m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.i32.nxv16i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.i64.nxv16i32.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_vv_se_u32m8(vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u32m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.i32.nxv1i64.i32(i32 3, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.i64.nxv1i64.i64(i64 3, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_vv_se_u64m1(vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u64m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.i32.nxv2i64.i32(i32 3, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.i64.nxv2i64.i64(i64 3, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_vv_se_u64m2(vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u64m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.i32.nxv4i64.i32(i32 3, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.i64.nxv4i64.i64(i64 3, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_vv_se_u64m4(vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u64m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.i32.nxv8i64.i32(i32 3, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.i64.nxv8i64.i64(i64 3, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_vv_se_u64m8(vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_se_u64m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.i32.nxv1i8.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.i64.nxv1i8.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_vv_u8mf8(vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8mf8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.i32.nxv2i8.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.i64.nxv2i8.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_vv_u8mf4(vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8mf4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.i32.nxv4i8.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.i64.nxv4i8.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_vv_u8mf2(vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.i32.nxv8i8.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.i64.nxv8i8.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_vv_u8m1(vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.i32.nxv16i8.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.i64.nxv16i8.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_vv_u8m2(vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.i32.nxv32i8.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.i64.nxv32i8.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_vv_u8m4(vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.i32.nxv64i8.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.i64.nxv64i8.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_vv_u8m8(vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u8m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.i32.nxv1i16.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.i64.nxv1i16.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_vv_u16mf4(vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16mf4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.i32.nxv2i16.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.i64.nxv2i16.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_vv_u16mf2(vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.i32.nxv4i16.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.i64.nxv4i16.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_vv_u16m1(vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.i32.nxv8i16.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.i64.nxv8i16.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_vv_u16m2(vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.i32.nxv16i16.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.i64.nxv16i16.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_vv_u16m4(vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.i32.nxv32i16.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.i64.nxv32i16.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_vv_u16m8(vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u16m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.i32.nxv1i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.i64.nxv1i32.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_vv_u32mf2(vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u32mf2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.i32.nxv2i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.i64.nxv2i32.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_vv_u32m1(vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u32m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.i32.nxv4i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.i64.nxv4i32.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_vv_u32m2(vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u32m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.i32.nxv8i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.i64.nxv8i32.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_vv_u32m4(vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u32m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.i32.nxv16i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.i64.nxv16i32.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_vv_u32m8(vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u32m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.i32.nxv1i64.i32(i32 3, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.i64.nxv1i64.i64(i64 3, <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_vv_u64m1(vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u64m1(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.i32.nxv2i64.i32(i32 3, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.i64.nxv2i64.i64(i64 3, <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_vv_u64m2(vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u64m2(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.i32.nxv4i64.i32(i32 3, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.i64.nxv4i64.i64(i64 3, <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_vv_u64m4(vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u64m4(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.i32.nxv8i64.i32(i32 3, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.i64.nxv8i64.i64(i64 3, <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_vv_u64m8(vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vv_u64m8(p27_26, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv1i8.i8.i32(i32 3, i32 31, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv1i8.i8.i64(i64 3, i64 31, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8mf8(vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8mf8(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv2i8.i8.i32(i32 3, i32 31, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv2i8.i8.i64(i64 3, i64 31, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8mf4(vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8mf4(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv4i8.i8.i32(i32 3, i32 31, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv4i8.i8.i64(i64 3, i64 31, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8mf2(vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8mf2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv8i8.i8.i32(i32 3, i32 31, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv8i8.i8.i64(i64 3, i64 31, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8m1(vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8m1(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv16i8.i8.i32(i32 3, i32 31, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv16i8.i8.i64(i64 3, i64 31, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8m2(vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8m2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv32i8.i8.i32(i32 3, i32 31, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv32i8.i8.i64(i64 3, i64 31, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8m4(vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8m4(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv64i8.i8.i32(i32 3, i32 31, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv64i8.i8.i64(i64 3, i64 31, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u8m8(vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u8m8(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv1i16.i16.i32(i32 3, i32 31, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv1i16.i16.i64(i64 3, i64 31, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16mf4(vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16mf4(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv2i16.i16.i32(i32 3, i32 31, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv2i16.i16.i64(i64 3, i64 31, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16mf2(vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16mf2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv4i16.i16.i32(i32 3, i32 31, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv4i16.i16.i64(i64 3, i64 31, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16m1(vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16m1(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv8i16.i16.i32(i32 3, i32 31, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv8i16.i16.i64(i64 3, i64 31, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16m2(vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16m2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv16i16.i16.i32(i32 3, i32 31, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv16i16.i16.i64(i64 3, i64 31, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16m4(vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16m4(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv32i16.i16.i32(i32 3, i32 31, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv32i16.i16.i64(i64 3, i64 31, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u16m8(vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u16m8(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv1i32.i32.i32(i32 3, i32 31, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv1i32.i32.i64(i64 3, i64 31, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u32mf2(vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u32mf2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv2i32.i32.i32(i32 3, i32 31, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv2i32.i32.i64(i64 3, i64 31, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u32m1(vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u32m1(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv4i32.i32.i32(i32 3, i32 31, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv4i32.i32.i64(i64 3, i64 31, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u32m2(vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u32m2(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv8i32.i32.i32(i32 3, i32 31, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv8i32.i32.i64(i64 3, i64 31, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u32m4(vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u32m4(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i32.nxv16i32.i32.i32(i32 3, i32 31, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xv.se.i64.nxv16i32.i32.i64(i64 3, i64 31, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xv_se_u32m8(vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xv_se_u32m8(p27_26, p11_7, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.i32.i8.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.i64.i8.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_xv_se_u8mf8(vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8mf8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.i32.i8.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.i64.i8.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_xv_se_u8mf4(vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8mf4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.i32.i8.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.i64.i8.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_xv_se_u8mf2(vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.i32.i8.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.i64.i8.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_xv_se_u8m1(vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.i32.i8.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.i64.i8.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_xv_se_u8m2(vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.i32.i8.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.i64.i8.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_xv_se_u8m4(vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.i32.i8.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.i64.i8.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_xv_se_u8m8(vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u8m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.i32.i16.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.i64.i16.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_xv_se_u16mf4(vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16mf4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.i32.i16.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.i64.i16.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_xv_se_u16mf2(vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.i32.i16.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.i64.i16.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_xv_se_u16m1(vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.i32.i16.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.i64.i16.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_xv_se_u16m2(vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.i32.i16.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.i64.i16.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_xv_se_u16m4(vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.i32.i16.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.i64.i16.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_xv_se_u16m8(vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u16m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i64.i32.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_xv_se_u32mf2(vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u32mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i64.i32.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_xv_se_u32m1(vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u32m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i64.i32.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_xv_se_u32m2(vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u32m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i64.i32.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_xv_se_u32m4(vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u32m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i64.i32.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_xv_se_u32m8(vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_se_u32m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.i32.i8.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.i64.i8.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_xv_u8mf8(vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8mf8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.i32.i8.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.i64.i8.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_xv_u8mf4(vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8mf4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.i32.i8.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.i64.i8.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_xv_u8mf2(vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.i32.i8.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.i64.i8.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_xv_u8m1(vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.i32.i8.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.i64.i8.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_xv_u8m2(vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.i32.i8.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.i64.i8.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_xv_u8m4(vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.i32.i8.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.i64.i8.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_xv_u8m8(vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u8m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.i32.i16.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.i64.i16.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_xv_u16mf4(vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16mf4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.i32.i16.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.i64.i16.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_xv_u16mf2(vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.i32.i16.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.i64.i16.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_xv_u16m1(vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.i32.i16.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.i64.i16.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_xv_u16m2(vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.i32.i16.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.i64.i16.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_xv_u16m4(vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.i32.i16.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.i64.i16.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_xv_u16m8(vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u16m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i64.i32.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_xv_u32mf2(vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u32mf2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i64.i32.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_xv_u32m1(vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u32m1(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i64.i32.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_xv_u32m2(vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u32m2(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i64.i32.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_xv_u32m4(vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u32m4(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i64.i32.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_xv_u32m8(vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xv_u32m8(p27_26, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv1i8.i32.i32(i32 3, i32 31, <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv1i8.i64.i64(i64 3, i64 31, <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8mf8(vuint8mf8_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8mf8(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv2i8.i32.i32(i32 3, i32 31, <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv2i8.i64.i64(i64 3, i64 31, <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8mf4(vuint8mf4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8mf4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv4i8.i32.i32(i32 3, i32 31, <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv4i8.i64.i64(i64 3, i64 31, <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8mf2(vuint8mf2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8mf2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv8i8.i32.i32(i32 3, i32 31, <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv8i8.i64.i64(i64 3, i64 31, <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8m1(vuint8m1_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8m1(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv16i8.i32.i32(i32 3, i32 31, <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv16i8.i64.i64(i64 3, i64 31, <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8m2(vuint8m2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8m2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv32i8.i32.i32(i32 3, i32 31, <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv32i8.i64.i64(i64 3, i64 31, <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8m4(vuint8m4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8m4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv64i8.i32.i32(i32 3, i32 31, <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv64i8.i64.i64(i64 3, i64 31, <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u8m8(vuint8m8_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u8m8(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv1i16.i32.i32(i32 3, i32 31, <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv1i16.i64.i64(i64 3, i64 31, <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16mf4(vuint16mf4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16mf4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv2i16.i32.i32(i32 3, i32 31, <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv2i16.i64.i64(i64 3, i64 31, <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16mf2(vuint16mf2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16mf2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv4i16.i32.i32(i32 3, i32 31, <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv4i16.i64.i64(i64 3, i64 31, <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16m1(vuint16m1_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16m1(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv8i16.i32.i32(i32 3, i32 31, <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv8i16.i64.i64(i64 3, i64 31, <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16m2(vuint16m2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16m2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv16i16.i32.i32(i32 3, i32 31, <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv16i16.i64.i64(i64 3, i64 31, <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16m4(vuint16m4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16m4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv32i16.i32.i32(i32 3, i32 31, <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv32i16.i64.i64(i64 3, i64 31, <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u16m8(vuint16m8_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u16m8(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv1i32.i32.i32(i32 3, i32 31, <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv1i32.i64.i64(i64 3, i64 31, <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u32mf2(vuint32mf2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u32mf2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv2i32.i32.i32(i32 3, i32 31, <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv2i32.i64.i64(i64 3, i64 31, <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u32m1(vuint32m1_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u32m1(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv4i32.i32.i32(i32 3, i32 31, <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv4i32.i64.i64(i64 3, i64 31, <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u32m2(vuint32m2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u32m2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv8i32.i32.i32(i32 3, i32 31, <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv8i32.i64.i64(i64 3, i64 31, <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u32m4(vuint32m4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u32m4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv16i32.i32.i32(i32 3, i32 31, <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv16i32.i64.i64(i64 3, i64 31, <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u32m8(vuint32m8_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u32m8(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv1i64.i32.i32(i32 3, i32 31, <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv1i64.i64.i64(i64 3, i64 31, <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u64m1(vuint64m1_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u64m1(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv2i64.i32.i32(i32 3, i32 31, <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv2i64.i64.i64(i64 3, i64 31, <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u64m2(vuint64m2_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u64m2(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv4i64.i32.i32(i32 3, i32 31, <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv4i64.i64.i64(i64 3, i64 31, <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u64m4(vuint64m4_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u64m4(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_iv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i32.nxv8i64.i32.i32(i32 3, i32 31, <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_iv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.iv.se.i64.nxv8i64.i64.i64(i64 3, i64 31, <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_iv_se_u64m8(vuint64m8_t vs2, size_t vl) {
  __riscv_sf_vc_iv_se_u64m8(p27_26, p11_7, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.i32.i32.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.i64.i64.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_iv_se_u8mf8(vuint8mf8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8mf8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.i32.i32.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.i64.i64.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_iv_se_u8mf4(vuint8mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8mf4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.i32.i32.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.i64.i64.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_iv_se_u8mf2(vuint8mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.i32.i32.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.i64.i64.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_iv_se_u8m1(vuint8m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.i32.i32.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.i64.i64.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_iv_se_u8m2(vuint8m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.i32.i32.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.i64.i64.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_iv_se_u8m4(vuint8m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.i32.i32.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.i64.i64.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_iv_se_u8m8(vuint8m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u8m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.i32.i32.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.i64.i64.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_iv_se_u16mf4(vuint16mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16mf4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.i32.i32.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.i64.i64.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_iv_se_u16mf2(vuint16mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.i32.i32.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.i64.i64.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_iv_se_u16m1(vuint16m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.i32.i32.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.i64.i64.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_iv_se_u16m2(vuint16m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.i32.i32.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.i64.i64.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_iv_se_u16m4(vuint16m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.i32.i32.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.i64.i64.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_iv_se_u16m8(vuint16m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u16m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.i64.i64.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_iv_se_u32mf2(vuint32mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u32mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.i64.i64.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_iv_se_u32m1(vuint32m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u32m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.i64.i64.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_iv_se_u32m2(vuint32m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u32m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.i64.i64.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_iv_se_u32m4(vuint32m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u32m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.i64.i64.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_iv_se_u32m8(vuint32m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u32m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.i32.i32.i32(i32 3, <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.i64.i64.i64(i64 3, <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_iv_se_u64m1(vuint64m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u64m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.i32.i32.i32(i32 3, <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.i64.i64.i64(i64 3, <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_iv_se_u64m2(vuint64m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u64m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.i32.i32.i32(i32 3, <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.i64.i64.i64(i64 3, <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_iv_se_u64m4(vuint64m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u64m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.i32.i32.i32(i32 3, <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.i64.i64.i64(i64 3, <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_iv_se_u64m8(vuint64m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_se_u64m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.i32.i32.i32(i32 3, <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.i64.i64.i64(i64 3, <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_iv_u8mf8(vuint8mf8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8mf8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.i32.i32.i32(i32 3, <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.i64.i64.i64(i64 3, <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_iv_u8mf4(vuint8mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8mf4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.i32.i32.i32(i32 3, <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.i64.i64.i64(i64 3, <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_iv_u8mf2(vuint8mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.i32.i32.i32(i32 3, <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.i64.i64.i64(i64 3, <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_iv_u8m1(vuint8m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.i32.i32.i32(i32 3, <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.i64.i64.i64(i64 3, <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_iv_u8m2(vuint8m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.i32.i32.i32(i32 3, <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.i64.i64.i64(i64 3, <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_iv_u8m4(vuint8m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.i32.i32.i32(i32 3, <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.i64.i64.i64(i64 3, <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_iv_u8m8(vuint8m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u8m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.i32.i32.i32(i32 3, <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.i64.i64.i64(i64 3, <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_iv_u16mf4(vuint16mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16mf4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.i32.i32.i32(i32 3, <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.i64.i64.i64(i64 3, <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_iv_u16mf2(vuint16mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.i32.i32.i32(i32 3, <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.i64.i64.i64(i64 3, <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_iv_u16m1(vuint16m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.i32.i32.i32(i32 3, <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.i64.i64.i64(i64 3, <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_iv_u16m2(vuint16m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.i32.i32.i32(i32 3, <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.i64.i64.i64(i64 3, <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_iv_u16m4(vuint16m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.i32.i32.i32(i32 3, <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.i64.i64.i64(i64 3, <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_iv_u16m8(vuint16m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u16m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.i64.i64.i64(i64 3, <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_iv_u32mf2(vuint32mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u32mf2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.i64.i64.i64(i64 3, <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_iv_u32m1(vuint32m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u32m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.i64.i64.i64(i64 3, <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_iv_u32m2(vuint32m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u32m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.i64.i64.i64(i64 3, <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_iv_u32m4(vuint32m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u32m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.i64.i64.i64(i64 3, <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_iv_u32m8(vuint32m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u32m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.i32.i32.i32(i32 3, <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.i64.i64.i64(i64 3, <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_iv_u64m1(vuint64m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u64m1(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.i32.i32.i32(i32 3, <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.i64.i64.i64(i64 3, <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_iv_u64m2(vuint64m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u64m2(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.i32.i32.i32(i32 3, <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.i64.i64.i64(i64 3, <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_iv_u64m4(vuint64m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u64m4(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_iv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.i32.i32.i32(i32 3, <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_iv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.i64.i64.i64(i64 3, <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_iv_u64m8(vuint64m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_iv_u64m8(p27_26, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv1i16.f16.i32(i32 1, i32 31, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv1i16.f16.i64(i64 1, i64 31, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16mf4(vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16mf4(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv2i16.f16.i32(i32 1, i32 31, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv2i16.f16.i64(i64 1, i64 31, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16mf2(vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16mf2(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv4i16.f16.i32(i32 1, i32 31, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv4i16.f16.i64(i64 1, i64 31, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16m1(vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16m1(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv8i16.f16.i32(i32 1, i32 31, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv8i16.f16.i64(i64 1, i64 31, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16m2(vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16m2(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv16i16.f16.i32(i32 1, i32 31, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv16i16.f16.i64(i64 1, i64 31, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16m4(vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16m4(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv32i16.f16.i32(i32 1, i32 31, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv32i16.f16.i64(i64 1, i64 31, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u16m8(vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u16m8(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv1i32.f32.i32(i32 1, i32 31, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv1i32.f32.i64(i64 1, i64 31, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u32mf2(vuint32mf2_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u32mf2(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv2i32.f32.i32(i32 1, i32 31, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv2i32.f32.i64(i64 1, i64 31, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u32m1(vuint32m1_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u32m1(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv4i32.f32.i32(i32 1, i32 31, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv4i32.f32.i64(i64 1, i64 31, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u32m2(vuint32m2_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u32m2(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv8i32.f32.i32(i32 1, i32 31, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv8i32.f32.i64(i64 1, i64 31, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u32m4(vuint32m4_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u32m4(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv16i32.f32.i32(i32 1, i32 31, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv16i32.f32.i64(i64 1, i64 31, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u32m8(vuint32m8_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u32m8(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv1i64.f64.i32(i32 1, i32 31, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv1i64.f64.i64(i64 1, i64 31, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u64m1(vuint64m1_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u64m1(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv2i64.f64.i32(i32 1, i32 31, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv2i64.f64.i64(i64 1, i64 31, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u64m2(vuint64m2_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u64m2(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv4i64.f64.i32(i32 1, i32 31, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv4i64.f64.i64(i64 1, i64 31, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u64m4(vuint64m4_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u64m4(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i32.nxv8i64.f64.i32(i32 1, i32 31, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fv.se.i64.nxv8i64.f64.i64(i64 1, i64 31, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fv_se_u64m8(vuint64m8_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fv_se_u64m8(p26, p11_7, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv1i16.i32.f16.i32(i32 1, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv1i16.i64.f16.i64(i64 1, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_fv_se_u16mf4(vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16mf4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv2i16.i32.f16.i32(i32 1, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv2i16.i64.f16.i64(i64 1, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_fv_se_u16mf2(vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16mf2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv4i16.i32.f16.i32(i32 1, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv4i16.i64.f16.i64(i64 1, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_fv_se_u16m1(vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv8i16.i32.f16.i32(i32 1, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv8i16.i64.f16.i64(i64 1, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_fv_se_u16m2(vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv16i16.i32.f16.i32(i32 1, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv16i16.i64.f16.i64(i64 1, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_fv_se_u16m4(vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv32i16.i32.f16.i32(i32 1, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv32i16.i64.f16.i64(i64 1, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_fv_se_u16m8(vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u16m8(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv1i32.i32.f32.i32(i32 1, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv1i32.i64.f32.i64(i64 1, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_fv_se_u32mf2(vuint32mf2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u32mf2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv2i32.i32.f32.i32(i32 1, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv2i32.i64.f32.i64(i64 1, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_fv_se_u32m1(vuint32m1_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u32m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv4i32.i32.f32.i32(i32 1, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv4i32.i64.f32.i64(i64 1, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_fv_se_u32m2(vuint32m2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u32m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv8i32.i32.f32.i32(i32 1, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv8i32.i64.f32.i64(i64 1, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_fv_se_u32m4(vuint32m4_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u32m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv16i32.i32.f32.i32(i32 1, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv16i32.i64.f32.i64(i64 1, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_fv_se_u32m8(vuint32m8_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u32m8(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv1i64.i32.f64.i32(i32 1, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv1i64.i64.f64.i64(i64 1, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_fv_se_u64m1(vuint64m1_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u64m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv2i64.i32.f64.i32(i32 1, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv2i64.i64.f64.i64(i64 1, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_fv_se_u64m2(vuint64m2_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u64m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv4i64.i32.f64.i32(i32 1, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv4i64.i64.f64.i64(i64 1, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_fv_se_u64m4(vuint64m4_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u64m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv8i64.i32.f64.i32(i32 1, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv8i64.i64.f64.i64(i64 1, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_fv_se_u64m8(vuint64m8_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_se_u64m8(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.nxv1i16.i32.f16.i32(i32 1, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.nxv1i16.i64.f16.i64(i64 1, <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_fv_u16mf4(vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16mf4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.nxv2i16.i32.f16.i32(i32 1, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.nxv2i16.i64.f16.i64(i64 1, <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_fv_u16mf2(vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16mf2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.nxv4i16.i32.f16.i32(i32 1, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.nxv4i16.i64.f16.i64(i64 1, <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_fv_u16m1(vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.nxv8i16.i32.f16.i32(i32 1, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.nxv8i16.i64.f16.i64(i64 1, <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_fv_u16m2(vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.nxv16i16.i32.f16.i32(i32 1, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.nxv16i16.i64.f16.i64(i64 1, <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_fv_u16m4(vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.nxv32i16.i32.f16.i32(i32 1, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.nxv32i16.i64.f16.i64(i64 1, <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_fv_u16m8(vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u16m8(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.nxv1i32.i32.f32.i32(i32 1, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.nxv1i32.i64.f32.i64(i64 1, <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_fv_u32mf2(vuint32mf2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u32mf2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.nxv2i32.i32.f32.i32(i32 1, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.nxv2i32.i64.f32.i64(i64 1, <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_fv_u32m1(vuint32m1_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u32m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.nxv4i32.i32.f32.i32(i32 1, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.nxv4i32.i64.f32.i64(i64 1, <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_fv_u32m2(vuint32m2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u32m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.nxv8i32.i32.f32.i32(i32 1, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.nxv8i32.i64.f32.i64(i64 1, <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_fv_u32m4(vuint32m4_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u32m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.nxv16i32.i32.f32.i32(i32 1, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.nxv16i32.i64.f32.i64(i64 1, <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_fv_u32m8(vuint32m8_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u32m8(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.nxv1i64.i32.f64.i32(i32 1, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.nxv1i64.i64.f64.i64(i64 1, <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_fv_u64m1(vuint64m1_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u64m1(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.nxv2i64.i32.f64.i32(i32 1, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.nxv2i64.i64.f64.i64(i64 1, <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_fv_u64m2(vuint64m2_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u64m2(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.nxv4i64.i32.f64.i32(i32 1, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.nxv4i64.i64.f64.i64(i64 1, <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_fv_u64m4(vuint64m4_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u64m4(p26, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.nxv8i64.i32.f64.i32(i32 1, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.nxv8i64.i64.f64.i64(i64 1, <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_fv_u64m8(vuint64m8_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fv_u64m8(p26, vs2, fs1, vl);
}
