# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 15.0.0.

use Test;

plan 2040;

my @list; my @result;
@list = 0x1E0A, 0x0323; @result = 0x1E0C, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0A, 0x0323 -> 0x1E0C, 0x0307 CONCAT';
@list = 0x1E0C, 0x0307; @result = 0x1E0C, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0C, 0x0307 -> 0x1E0C, 0x0307 CONCAT';
@list = 0x0044, 0x0307, 0x0323; @result = 0x1E0C, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0044, 0x0307, 0x0323 -> 0x1E0C, 0x0307 CONCAT';
@list = 0x0044, 0x0323, 0x0307; @result = 0x1E0C, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0044, 0x0323, 0x0307 -> 0x1E0C, 0x0307 CONCAT';
@list = 0x1E0A, 0x031B; @result = 0x1E0A, 0x031B;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0A, 0x031B -> 0x1E0A, 0x031B CONCAT';
@list = 0x1E0C, 0x031B; @result = 0x1E0C, 0x031B;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0C, 0x031B -> 0x1E0C, 0x031B CONCAT';
@list = 0x1E0A, 0x031B, 0x0323; @result = 0x1E0C, 0x031B, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0A, 0x031B, 0x0323 -> 0x1E0C, 0x031B, 0x0307 CONCAT';
@list = 0x1E0C, 0x031B, 0x0307; @result = 0x1E0C, 0x031B, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E0C, 0x031B, 0x0307 -> 0x1E0C, 0x031B, 0x0307 CONCAT';
@list = 0x0044, 0x031B, 0x0307, 0x0323; @result = 0x1E0C, 0x031B, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0044, 0x031B, 0x0307, 0x0323 -> 0x1E0C, 0x031B, 0x0307 CONCAT';
@list = 0x0044, 0x031B, 0x0323, 0x0307; @result = 0x1E0C, 0x031B, 0x0307;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0044, 0x031B, 0x0323, 0x0307 -> 0x1E0C, 0x031B, 0x0307 CONCAT';
@list = 0x0045, 0x0300; @result = 0x00C8;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0045, 0x0300 -> 0x00C8 CONCAT';
@list = 0x0045, 0x0304; @result = 0x0112;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0045, 0x0304 -> 0x0112 CONCAT';
@list = 0x0112, 0x0300; @result = 0x1E14;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0112, 0x0300 -> 0x1E14 CONCAT';
@list = 0x1E14, 0x0304; @result = 0x1E14, 0x0304;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1E14, 0x0304 -> 0x1E14, 0x0304 CONCAT';
@list = 0x0045, 0x0304, 0x0300; @result = 0x1E14;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0045, 0x0304, 0x0300 -> 0x1E14 CONCAT';
@list = 0x0045, 0x0300, 0x0304; @result = 0x00C8, 0x0304;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0045, 0x0300, 0x0304 -> 0x00C8, 0x0304 CONCAT';
@list = 0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F; @result = 0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F -> 0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F CONCAT';
@list = 0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD; @result = 0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD -> 0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4 CONCAT';
@list = 0x1100, 0xAC00, 0x11A8; @result = 0x1100, 0xAC01;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1100, 0xAC00, 0x11A8 -> 0x1100, 0xAC01 CONCAT';
@list = 0x1100, 0xAC00, 0x11A8, 0x11A8; @result = 0x1100, 0xAC01, 0x11A8;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1100, 0xAC00, 0x11A8, 0x11A8 -> 0x1100, 0xAC01, 0x11A8 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0300, 0x0062; @result = 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0300, 0x0062 -> 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0301, 0x0062; @result = 0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0301, 0x0062 -> 0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0301, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0301, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0302, 0x0062; @result = 0x00E0, 0x05AE, 0x0302, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0302, 0x0062 -> 0x00E0, 0x05AE, 0x0302, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0302, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x1EA7, 0x05AE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0302, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x1EA7, 0x05AE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0303, 0x0062; @result = 0x00E0, 0x05AE, 0x0303, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0303, 0x0062 -> 0x00E0, 0x05AE, 0x0303, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0303, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E3, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0303, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E3, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0304, 0x0062; @result = 0x00E0, 0x05AE, 0x0304, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0304, 0x0062 -> 0x00E0, 0x05AE, 0x0304, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0304, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0101, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0304, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0101, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0305, 0x0062; @result = 0x00E0, 0x05AE, 0x0305, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0305, 0x0062 -> 0x00E0, 0x05AE, 0x0305, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0305, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0305, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0305, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0305, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0306, 0x0062; @result = 0x00E0, 0x05AE, 0x0306, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0306, 0x0062 -> 0x00E0, 0x05AE, 0x0306, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0306, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x1EB1, 0x05AE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0306, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x1EB1, 0x05AE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0307, 0x0062; @result = 0x00E0, 0x05AE, 0x0307, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0307, 0x0062 -> 0x00E0, 0x05AE, 0x0307, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0307, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0227, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0307, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0227, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0308, 0x0062; @result = 0x00E0, 0x05AE, 0x0308, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0308, 0x0062 -> 0x00E0, 0x05AE, 0x0308, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0308, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E4, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0308, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E4, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0309, 0x0062; @result = 0x00E0, 0x05AE, 0x0309, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0309, 0x0062 -> 0x00E0, 0x05AE, 0x0309, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0309, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x1EA3, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0309, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x1EA3, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030A, 0x0062; @result = 0x00E0, 0x05AE, 0x030A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030A, 0x0062 -> 0x00E0, 0x05AE, 0x030A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E5, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E5, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030B, 0x0062; @result = 0x00E0, 0x05AE, 0x030B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030B, 0x0062 -> 0x00E0, 0x05AE, 0x030B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x030B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x030B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030C, 0x0062; @result = 0x00E0, 0x05AE, 0x030C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030C, 0x0062 -> 0x00E0, 0x05AE, 0x030C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x01CE, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x01CE, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030D, 0x0062; @result = 0x00E0, 0x05AE, 0x030D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030D, 0x0062 -> 0x00E0, 0x05AE, 0x030D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x030D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x030D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030E, 0x0062; @result = 0x00E0, 0x05AE, 0x030E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030E, 0x0062 -> 0x00E0, 0x05AE, 0x030E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x030E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x030E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x030F, 0x0062; @result = 0x00E0, 0x05AE, 0x030F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x030F, 0x0062 -> 0x00E0, 0x05AE, 0x030F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x030F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0201, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x030F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0201, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0310, 0x0062; @result = 0x00E0, 0x05AE, 0x0310, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0310, 0x0062 -> 0x00E0, 0x05AE, 0x0310, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0310, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0310, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0310, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0310, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0311, 0x0062; @result = 0x00E0, 0x05AE, 0x0311, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0311, 0x0062 -> 0x00E0, 0x05AE, 0x0311, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0311, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0203, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0311, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0203, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0312, 0x0062; @result = 0x00E0, 0x05AE, 0x0312, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0312, 0x0062 -> 0x00E0, 0x05AE, 0x0312, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0312, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0312, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0312, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0312, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0313, 0x0062; @result = 0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0313, 0x0062 -> 0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0313, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0313, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0314, 0x0062; @result = 0x00E0, 0x05AE, 0x0314, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0314, 0x0062 -> 0x00E0, 0x05AE, 0x0314, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0314, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0314, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0314, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0314, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x0315, 0x0062; @result = 0x00E0, 0x0315, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x0315, 0x0062 -> 0x00E0, 0x0315, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x0315, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x0315, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0316, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0316, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0316, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0316, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0317, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0317, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0317, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0317, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0317, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0317, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0317, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0317, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0318, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0318, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0318, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0318, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0318, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0318, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0318, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0318, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0319, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0319, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0319, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0319, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0319, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0319, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0319, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0319, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x031A, 0x0062; @result = 0x00E0, 0x0315, 0x031A, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x031A, 0x0062 -> 0x00E0, 0x0315, 0x031A, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x031A, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x031A, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031A, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x031A, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x031B, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x031B, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x031B, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031B, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x031C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x031C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x031C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x031C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x031C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x031C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x031C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x031D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x031D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x031D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x031D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x031D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x031D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x031D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x031E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x031E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x031E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x031E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x031E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x031E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x031E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x031F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x031F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x031F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x031F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x031F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x031F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x031F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0320, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0320, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0320, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0320, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0320, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0320, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0320, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0320, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0321, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0321, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x0321, 0x1DCE, 0x0321, 0x0F74, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0321, 0x1DCE, 0x0321, 0x0F74, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0322, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x0322, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0322, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x0322, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x0322, 0x1DCE, 0x0321, 0x0F74, 0x0062; @result = 0x0061, 0x0F74, 0x0322, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0322, 0x1DCE, 0x0321, 0x0F74, 0x0062 -> 0x0061, 0x0F74, 0x0322, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0323, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0323, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0323, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0323, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0323, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x1EA1, 0x1DFA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0323, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x1EA1, 0x1DFA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0324, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0324, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0324, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0324, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0324, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0324, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0324, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0324, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0325, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0325, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0325, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0325, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0325, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x1E01, 0x1DFA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0325, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x1E01, 0x1DFA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0326, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0326, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0326, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0326, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0326, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0326, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0326, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0326, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0327, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x0327, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0327, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x0327, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x0327, 0x1DCE, 0x0321, 0x0F74, 0x0062; @result = 0x0061, 0x0F74, 0x0327, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0327, 0x1DCE, 0x0321, 0x0F74, 0x0062 -> 0x0061, 0x0F74, 0x0327, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0328, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x0328, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0328, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x0328, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x0328, 0x1DCE, 0x0321, 0x0F74, 0x0062; @result = 0x0105, 0x0F74, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0328, 0x1DCE, 0x0321, 0x0F74, 0x0062 -> 0x0105, 0x0F74, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0329, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0329, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0329, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0329, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0329, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0329, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0329, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0329, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x032F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x032F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x032F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x032F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x032F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x032F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x032F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x032F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0330, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0330, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0330, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0330, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0330, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0330, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0330, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0330, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0331, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0331, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0331, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0331, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0331, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0331, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0331, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0331, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0332, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0332, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0332, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0332, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0332, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0332, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0332, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0332, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0333, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0333, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0333, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0333, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0333, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0333, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0333, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0333, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x0334, 0x0062; @result = 0x0061, 0x0334, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x0334, 0x0062 -> 0x0061, 0x0334, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0334, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0334, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0334, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0334, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x0335, 0x0062; @result = 0x0061, 0x0334, 0x0335, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x0335, 0x0062 -> 0x0061, 0x0334, 0x0335, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0335, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0335, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0335, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0335, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x0336, 0x0062; @result = 0x0061, 0x0334, 0x0336, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x0336, 0x0062 -> 0x0061, 0x0334, 0x0336, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0336, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0336, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0336, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0336, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x0337, 0x0062; @result = 0x0061, 0x0334, 0x0337, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x0337, 0x0062 -> 0x0061, 0x0334, 0x0337, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0337, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0337, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0337, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0337, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x0338, 0x0062; @result = 0x0061, 0x0334, 0x0338, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x0338, 0x0062 -> 0x0061, 0x0334, 0x0338, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0338, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0338, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0338, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0338, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0339, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0339, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0339, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0339, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0339, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0339, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0339, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0339, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x033A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x033A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x033A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x033A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x033A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x033A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x033A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x033B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x033B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x033B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x033B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x033B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x033B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x033B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x033C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x033C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x033C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x033C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x033C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x033C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x033C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x033D, 0x0062; @result = 0x00E0, 0x05AE, 0x033D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x033D, 0x0062 -> 0x00E0, 0x05AE, 0x033D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x033D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x033D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x033D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x033E, 0x0062; @result = 0x00E0, 0x05AE, 0x033E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x033E, 0x0062 -> 0x00E0, 0x05AE, 0x033E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x033E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x033E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x033E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x033F, 0x0062; @result = 0x00E0, 0x05AE, 0x033F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x033F, 0x0062 -> 0x00E0, 0x05AE, 0x033F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x033F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x033F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x033F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x033F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0340, 0x0062; @result = 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0340, 0x0062 -> 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0340, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0340, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0341, 0x0062; @result = 0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0341, 0x0062 -> 0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0341, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0341, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0342, 0x0062; @result = 0x00E0, 0x05AE, 0x0342, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0342, 0x0062 -> 0x00E0, 0x05AE, 0x0342, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0342, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0342, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0342, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0342, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0343, 0x0062; @result = 0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0343, 0x0062 -> 0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0343, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0343, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0344, 0x0062; @result = 0x00E0, 0x05AE, 0x0308, 0x0301, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0344, 0x0062 -> 0x00E0, 0x05AE, 0x0308, 0x0301, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0344, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x00E4, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0344, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x00E4, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x0345, 0x0062; @result = 0x0061, 0x035D, 0x0345, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x0345, 0x0062 -> 0x0061, 0x035D, 0x0345, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x0345, 0x035D, 0x0062; @result = 0x0061, 0x035D, 0x0345, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x0345, 0x035D, 0x0062 -> 0x0061, 0x035D, 0x0345, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0346, 0x0062; @result = 0x00E0, 0x05AE, 0x0346, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0346, 0x0062 -> 0x00E0, 0x05AE, 0x0346, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0346, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0346, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0346, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0346, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0347, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0347, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0347, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0347, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0347, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0347, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0347, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0347, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0348, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0348, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0348, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0348, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0348, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0348, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0348, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0348, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0349, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0349, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0349, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0349, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0349, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0349, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0349, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0349, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x034A, 0x0062; @result = 0x00E0, 0x05AE, 0x034A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x034A, 0x0062 -> 0x00E0, 0x05AE, 0x034A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x034A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x034A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x034A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x034A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x034B, 0x0062; @result = 0x00E0, 0x05AE, 0x034B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x034B, 0x0062 -> 0x00E0, 0x05AE, 0x034B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x034B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x034B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x034B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x034B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x034C, 0x0062; @result = 0x00E0, 0x05AE, 0x034C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x034C, 0x0062 -> 0x00E0, 0x05AE, 0x034C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x034C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x034C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x034C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x034C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x034D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x034D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x034D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x034D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x034D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x034D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x034D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x034D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x034E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x034E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x034E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x034E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x034E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x034E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x034E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x034E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0350, 0x0062; @result = 0x00E0, 0x05AE, 0x0350, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0350, 0x0062 -> 0x00E0, 0x05AE, 0x0350, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0350, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0350, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0350, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0350, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0351, 0x0062; @result = 0x00E0, 0x05AE, 0x0351, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0351, 0x0062 -> 0x00E0, 0x05AE, 0x0351, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0351, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0351, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0351, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0351, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0352, 0x0062; @result = 0x00E0, 0x05AE, 0x0352, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0352, 0x0062 -> 0x00E0, 0x05AE, 0x0352, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0352, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0352, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0352, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0352, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0353, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0353, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0353, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0353, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0353, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0353, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0353, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0353, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0354, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0354, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0354, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0354, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0354, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0354, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0354, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0354, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0355, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0355, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0355, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0355, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0355, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0355, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0355, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0355, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0356, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0356, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0356, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0356, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0356, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0356, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0356, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0356, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0357, 0x0062; @result = 0x00E0, 0x05AE, 0x0357, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0357, 0x0062 -> 0x00E0, 0x05AE, 0x0357, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0357, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0357, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0357, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0357, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x0358, 0x0062; @result = 0x00E0, 0x0315, 0x0358, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x0358, 0x0062 -> 0x00E0, 0x0315, 0x0358, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x0358, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x0358, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0358, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x0358, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0359, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0359, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0359, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0359, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0359, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0359, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0359, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0359, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x035A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x035A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x035A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x035A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x035A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x035A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x035A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x035B, 0x0062; @result = 0x00E0, 0x05AE, 0x035B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x035B, 0x0062 -> 0x00E0, 0x05AE, 0x035B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x035B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x035B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035D, 0x035C, 0x0315, 0x035C, 0x0062; @result = 0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035D, 0x035C, 0x0315, 0x035C, 0x0062 -> 0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x035D, 0x035C, 0x0315, 0x0062; @result = 0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x035D, 0x035C, 0x0315, 0x0062 -> 0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x035C, 0x035D, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x035C, 0x035D, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x035D, 0x0345, 0x035D, 0x035C, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035D, 0x0345, 0x035D, 0x035C, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x035C, 0x035E, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x035E, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x035C, 0x035E, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x035E, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x035E, 0x0345, 0x035D, 0x035C, 0x0062; @result = 0x0061, 0x035C, 0x035E, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035E, 0x0345, 0x035D, 0x035C, 0x0062 -> 0x0061, 0x035C, 0x035E, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x035D, 0x035C, 0x0315, 0x035F, 0x0062; @result = 0x0061, 0x0315, 0x035C, 0x035F, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035D, 0x035C, 0x0315, 0x035F, 0x0062 -> 0x0061, 0x0315, 0x035C, 0x035F, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x035F, 0x035D, 0x035C, 0x0315, 0x0062; @result = 0x0061, 0x0315, 0x035F, 0x035C, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035F, 0x035D, 0x035C, 0x0315, 0x0062 -> 0x0061, 0x0315, 0x035F, 0x035C, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x035C, 0x0360, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x0360, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x035C, 0x0360, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x0360, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0360, 0x0345, 0x035D, 0x035C, 0x0062; @result = 0x0061, 0x035C, 0x0360, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0360, 0x0345, 0x035D, 0x035C, 0x0062 -> 0x0061, 0x035C, 0x0360, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x035C, 0x0361, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x0361, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x035C, 0x0361, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x0361, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x0361, 0x0345, 0x035D, 0x035C, 0x0062; @result = 0x0061, 0x035C, 0x0361, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0361, 0x0345, 0x035D, 0x035C, 0x0062 -> 0x0061, 0x035C, 0x0361, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x035D, 0x035C, 0x0315, 0x0362, 0x0062; @result = 0x0061, 0x0315, 0x035C, 0x0362, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035D, 0x035C, 0x0315, 0x0362, 0x0062 -> 0x0061, 0x0315, 0x035C, 0x0362, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x0362, 0x035D, 0x035C, 0x0315, 0x0062; @result = 0x0061, 0x0315, 0x0362, 0x035C, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0362, 0x035D, 0x035C, 0x0315, 0x0062 -> 0x0061, 0x0315, 0x0362, 0x035C, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0363, 0x0062; @result = 0x00E0, 0x05AE, 0x0363, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0363, 0x0062 -> 0x00E0, 0x05AE, 0x0363, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0363, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0363, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0363, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0363, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0364, 0x0062; @result = 0x00E0, 0x05AE, 0x0364, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0364, 0x0062 -> 0x00E0, 0x05AE, 0x0364, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0364, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0364, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0364, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0364, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0365, 0x0062; @result = 0x00E0, 0x05AE, 0x0365, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0365, 0x0062 -> 0x00E0, 0x05AE, 0x0365, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0365, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0365, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0365, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0365, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0366, 0x0062; @result = 0x00E0, 0x05AE, 0x0366, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0366, 0x0062 -> 0x00E0, 0x05AE, 0x0366, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0366, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0366, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0366, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0366, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0367, 0x0062; @result = 0x00E0, 0x05AE, 0x0367, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0367, 0x0062 -> 0x00E0, 0x05AE, 0x0367, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0367, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0367, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0367, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0367, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0368, 0x0062; @result = 0x00E0, 0x05AE, 0x0368, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0368, 0x0062 -> 0x00E0, 0x05AE, 0x0368, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0368, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0368, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0368, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0368, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0369, 0x0062; @result = 0x00E0, 0x05AE, 0x0369, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0369, 0x0062 -> 0x00E0, 0x05AE, 0x0369, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0369, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0369, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0369, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0369, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036A, 0x0062; @result = 0x00E0, 0x05AE, 0x036A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036A, 0x0062 -> 0x00E0, 0x05AE, 0x036A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036B, 0x0062; @result = 0x00E0, 0x05AE, 0x036B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036B, 0x0062 -> 0x00E0, 0x05AE, 0x036B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036C, 0x0062; @result = 0x00E0, 0x05AE, 0x036C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036C, 0x0062 -> 0x00E0, 0x05AE, 0x036C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036D, 0x0062; @result = 0x00E0, 0x05AE, 0x036D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036D, 0x0062 -> 0x00E0, 0x05AE, 0x036D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036E, 0x0062; @result = 0x00E0, 0x05AE, 0x036E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036E, 0x0062 -> 0x00E0, 0x05AE, 0x036E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x036F, 0x0062; @result = 0x00E0, 0x05AE, 0x036F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x036F, 0x0062 -> 0x00E0, 0x05AE, 0x036F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x036F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x036F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x036F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x036F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0483, 0x0062; @result = 0x00E0, 0x05AE, 0x0483, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0483, 0x0062 -> 0x00E0, 0x05AE, 0x0483, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0483, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0483, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0483, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0483, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0484, 0x0062; @result = 0x00E0, 0x05AE, 0x0484, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0484, 0x0062 -> 0x00E0, 0x05AE, 0x0484, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0484, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0484, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0484, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0484, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0485, 0x0062; @result = 0x00E0, 0x05AE, 0x0485, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0485, 0x0062 -> 0x00E0, 0x05AE, 0x0485, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0485, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0485, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0485, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0485, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0486, 0x0062; @result = 0x00E0, 0x05AE, 0x0486, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0486, 0x0062 -> 0x00E0, 0x05AE, 0x0486, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0486, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0486, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0486, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0486, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0487, 0x0062; @result = 0x00E0, 0x05AE, 0x0487, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0487, 0x0062 -> 0x00E0, 0x05AE, 0x0487, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0487, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0487, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0487, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0487, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0591, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0591, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0591, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0591, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0591, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0591, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0591, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0591, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0592, 0x0062; @result = 0x00E0, 0x05AE, 0x0592, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0592, 0x0062 -> 0x00E0, 0x05AE, 0x0592, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0592, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0592, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0592, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0592, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0593, 0x0062; @result = 0x00E0, 0x05AE, 0x0593, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0593, 0x0062 -> 0x00E0, 0x05AE, 0x0593, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0593, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0593, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0593, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0593, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0594, 0x0062; @result = 0x00E0, 0x05AE, 0x0594, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0594, 0x0062 -> 0x00E0, 0x05AE, 0x0594, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0594, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0594, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0594, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0594, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0595, 0x0062; @result = 0x00E0, 0x05AE, 0x0595, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0595, 0x0062 -> 0x00E0, 0x05AE, 0x0595, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0595, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0595, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0595, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0595, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0596, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0596, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0596, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0596, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0596, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0596, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0596, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0596, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0597, 0x0062; @result = 0x00E0, 0x05AE, 0x0597, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0597, 0x0062 -> 0x00E0, 0x05AE, 0x0597, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0597, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0597, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0597, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0597, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0598, 0x0062; @result = 0x00E0, 0x05AE, 0x0598, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0598, 0x0062 -> 0x00E0, 0x05AE, 0x0598, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0598, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0598, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0598, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0598, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0599, 0x0062; @result = 0x00E0, 0x05AE, 0x0599, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0599, 0x0062 -> 0x00E0, 0x05AE, 0x0599, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0599, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0599, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0599, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0599, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x302E, 0x059A, 0x0316, 0x059A, 0x0062; @result = 0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302E, 0x059A, 0x0316, 0x059A, 0x0062 -> 0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x302E, 0x059A, 0x0316, 0x0062; @result = 0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x302E, 0x059A, 0x0316, 0x0062 -> 0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x059B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x059B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x059B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x059B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x059B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x059B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x059C, 0x0062; @result = 0x00E0, 0x05AE, 0x059C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x059C, 0x0062 -> 0x00E0, 0x05AE, 0x059C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x059C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x059C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x059D, 0x0062; @result = 0x00E0, 0x05AE, 0x059D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x059D, 0x0062 -> 0x00E0, 0x05AE, 0x059D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x059D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x059D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x059E, 0x0062; @result = 0x00E0, 0x05AE, 0x059E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x059E, 0x0062 -> 0x00E0, 0x05AE, 0x059E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x059E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x059E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x059F, 0x0062; @result = 0x00E0, 0x05AE, 0x059F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x059F, 0x0062 -> 0x00E0, 0x05AE, 0x059F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x059F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x059F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05A0, 0x0062; @result = 0x00E0, 0x05AE, 0x05A0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05A0, 0x0062 -> 0x00E0, 0x05AE, 0x05A0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05A0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05A0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05A0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05A1, 0x0062; @result = 0x00E0, 0x05AE, 0x05A1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05A1, 0x0062 -> 0x00E0, 0x05AE, 0x05A1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05A1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05A1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05A1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A2, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A2, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A2, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A2, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A2, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A2, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A2, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A2, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A4, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A4, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A4, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A4, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A4, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A4, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A4, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A4, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A5, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A5, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A5, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A5, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A5, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A5, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A5, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A5, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A7, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05A7, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05A7, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05A7, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05A7, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05A7, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A7, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05A7, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05A8, 0x0062; @result = 0x00E0, 0x05AE, 0x05A8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05A8, 0x0062 -> 0x00E0, 0x05AE, 0x05A8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05A8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05A8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05A8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05A9, 0x0062; @result = 0x00E0, 0x05AE, 0x05A9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05A9, 0x0062 -> 0x00E0, 0x05AE, 0x05A9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05A9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05A9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05A9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05A9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05AA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05AA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05AA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05AA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05AA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05AA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05AA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05AB, 0x0062; @result = 0x00E0, 0x05AE, 0x05AB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05AB, 0x0062 -> 0x00E0, 0x05AE, 0x05AB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05AB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05AB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05AB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05AC, 0x0062; @result = 0x00E0, 0x05AE, 0x05AC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05AC, 0x0062 -> 0x00E0, 0x05AE, 0x05AC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05AC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05AC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05AC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x302E, 0x059A, 0x0316, 0x05AD, 0x0062; @result = 0x0061, 0x0316, 0x059A, 0x05AD, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302E, 0x059A, 0x0316, 0x05AD, 0x0062 -> 0x0061, 0x0316, 0x059A, 0x05AD, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x05AD, 0x302E, 0x059A, 0x0316, 0x0062; @result = 0x0061, 0x0316, 0x05AD, 0x059A, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AD, 0x302E, 0x059A, 0x0316, 0x0062 -> 0x0061, 0x0316, 0x05AD, 0x059A, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x05AE, 0x1D16D, 0x05AE, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x05AE, 0x1D16D, 0x05AE, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x05AE, 0x0300, 0x05AE, 0x1D16D, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AE, 0x0300, 0x05AE, 0x1D16D, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05AF, 0x0062; @result = 0x00E0, 0x05AE, 0x05AF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05AF, 0x0062 -> 0x00E0, 0x05AE, 0x05AF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05AF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05AF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05AF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B1, 0x05B0, 0x094D, 0x05B0, 0x0062; @result = 0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B1, 0x05B0, 0x094D, 0x05B0, 0x0062 -> 0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x05B1, 0x05B0, 0x094D, 0x0062; @result = 0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x05B1, 0x05B0, 0x094D, 0x0062 -> 0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062 CONCAT';
@list = 0x0061, 0x05B2, 0x05B1, 0x05B0, 0x05B1, 0x0062; @result = 0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B2, 0x05B1, 0x05B0, 0x05B1, 0x0062 -> 0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062 CONCAT';
@list = 0x0061, 0x05B1, 0x05B2, 0x05B1, 0x05B0, 0x0062; @result = 0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B1, 0x05B2, 0x05B1, 0x05B0, 0x0062 -> 0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062 CONCAT';
@list = 0x0061, 0x05B3, 0x05B2, 0x05B1, 0x05B2, 0x0062; @result = 0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B3, 0x05B2, 0x05B1, 0x05B2, 0x0062 -> 0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062 CONCAT';
@list = 0x0061, 0x05B2, 0x05B3, 0x05B2, 0x05B1, 0x0062; @result = 0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B2, 0x05B3, 0x05B2, 0x05B1, 0x0062 -> 0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062 CONCAT';
@list = 0x0061, 0x05B4, 0x05B3, 0x05B2, 0x05B3, 0x0062; @result = 0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B4, 0x05B3, 0x05B2, 0x05B3, 0x0062 -> 0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062 CONCAT';
@list = 0x0061, 0x05B3, 0x05B4, 0x05B3, 0x05B2, 0x0062; @result = 0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B3, 0x05B4, 0x05B3, 0x05B2, 0x0062 -> 0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062 CONCAT';
@list = 0x0061, 0x05B5, 0x05B4, 0x05B3, 0x05B4, 0x0062; @result = 0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B5, 0x05B4, 0x05B3, 0x05B4, 0x0062 -> 0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062 CONCAT';
@list = 0x0061, 0x05B4, 0x05B5, 0x05B4, 0x05B3, 0x0062; @result = 0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B4, 0x05B5, 0x05B4, 0x05B3, 0x0062 -> 0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062 CONCAT';
@list = 0x0061, 0x05B6, 0x05B5, 0x05B4, 0x05B5, 0x0062; @result = 0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B6, 0x05B5, 0x05B4, 0x05B5, 0x0062 -> 0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062 CONCAT';
@list = 0x0061, 0x05B5, 0x05B6, 0x05B5, 0x05B4, 0x0062; @result = 0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B5, 0x05B6, 0x05B5, 0x05B4, 0x0062 -> 0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062 CONCAT';
@list = 0x0061, 0x05B7, 0x05B6, 0x05B5, 0x05B6, 0x0062; @result = 0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B7, 0x05B6, 0x05B5, 0x05B6, 0x0062 -> 0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062 CONCAT';
@list = 0x0061, 0x05B6, 0x05B7, 0x05B6, 0x05B5, 0x0062; @result = 0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B6, 0x05B7, 0x05B6, 0x05B5, 0x0062 -> 0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062 CONCAT';
@list = 0x0061, 0x05B8, 0x05B7, 0x05B6, 0x05B7, 0x0062; @result = 0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B8, 0x05B7, 0x05B6, 0x05B7, 0x0062 -> 0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062 CONCAT';
@list = 0x0061, 0x05B7, 0x05B8, 0x05B7, 0x05B6, 0x0062; @result = 0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B7, 0x05B8, 0x05B7, 0x05B6, 0x0062 -> 0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062 CONCAT';
@list = 0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05B8, 0x0062; @result = 0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05B8, 0x0062 -> 0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062 CONCAT';
@list = 0x0061, 0x05B8, 0x05B9, 0x05B8, 0x05B7, 0x0062; @result = 0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B8, 0x05B9, 0x05B8, 0x05B7, 0x0062 -> 0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062 CONCAT';
@list = 0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05B9, 0x0062; @result = 0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05B9, 0x0062 -> 0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062 CONCAT';
@list = 0x0061, 0x05B9, 0x05BB, 0x05B9, 0x05B8, 0x0062; @result = 0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B9, 0x05BB, 0x05B9, 0x05B8, 0x0062 -> 0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062 CONCAT';
@list = 0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05BA, 0x0062; @result = 0x0061, 0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05BA, 0x0062 -> 0x0061, 0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x0062 CONCAT';
@list = 0x0061, 0x05BA, 0x05BB, 0x05B9, 0x05B8, 0x0062; @result = 0x0061, 0x05B8, 0x05BA, 0x05B9, 0x05BB, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BA, 0x05BB, 0x05B9, 0x05B8, 0x0062 -> 0x0061, 0x05B8, 0x05BA, 0x05B9, 0x05BB, 0x0062 CONCAT';
@list = 0x0061, 0x05BC, 0x05BB, 0x05B9, 0x05BB, 0x0062; @result = 0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BC, 0x05BB, 0x05B9, 0x05BB, 0x0062 -> 0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062 CONCAT';
@list = 0x0061, 0x05BB, 0x05BC, 0x05BB, 0x05B9, 0x0062; @result = 0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BB, 0x05BC, 0x05BB, 0x05B9, 0x0062 -> 0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062 CONCAT';
@list = 0x0061, 0x05BD, 0x05BC, 0x05BB, 0x05BC, 0x0062; @result = 0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BD, 0x05BC, 0x05BB, 0x05BC, 0x0062 -> 0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062 CONCAT';
@list = 0x0061, 0x05BC, 0x05BD, 0x05BC, 0x05BB, 0x0062; @result = 0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BC, 0x05BD, 0x05BC, 0x05BB, 0x0062 -> 0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062 CONCAT';
@list = 0x0061, 0x05BF, 0x05BD, 0x05BC, 0x05BD, 0x0062; @result = 0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BF, 0x05BD, 0x05BC, 0x05BD, 0x0062 -> 0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062 CONCAT';
@list = 0x0061, 0x05BD, 0x05BF, 0x05BD, 0x05BC, 0x0062; @result = 0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BD, 0x05BF, 0x05BD, 0x05BC, 0x0062 -> 0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062 CONCAT';
@list = 0x0061, 0x05C1, 0x05BF, 0x05BD, 0x05BF, 0x0062; @result = 0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C1, 0x05BF, 0x05BD, 0x05BF, 0x0062 -> 0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062 CONCAT';
@list = 0x0061, 0x05BF, 0x05C1, 0x05BF, 0x05BD, 0x0062; @result = 0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05BF, 0x05C1, 0x05BF, 0x05BD, 0x0062 -> 0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062 CONCAT';
@list = 0x0061, 0x05C2, 0x05C1, 0x05BF, 0x05C1, 0x0062; @result = 0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C2, 0x05C1, 0x05BF, 0x05C1, 0x0062 -> 0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062 CONCAT';
@list = 0x0061, 0x05C1, 0x05C2, 0x05C1, 0x05BF, 0x0062; @result = 0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C1, 0x05C2, 0x05C1, 0x05BF, 0x0062 -> 0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062 CONCAT';
@list = 0x0061, 0xFB1E, 0x05C2, 0x05C1, 0x05C2, 0x0062; @result = 0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFB1E, 0x05C2, 0x05C1, 0x05C2, 0x0062 -> 0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062 CONCAT';
@list = 0x0061, 0x05C2, 0xFB1E, 0x05C2, 0x05C1, 0x0062; @result = 0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C2, 0xFB1E, 0x05C2, 0x05C1, 0x0062 -> 0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x05C4, 0x0062; @result = 0x00E0, 0x05AE, 0x05C4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x05C4, 0x0062 -> 0x00E0, 0x05AE, 0x05C4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05C4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x05C4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x05C4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x05C5, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x05C5, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x05C5, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x05C5, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05C5, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x05C5, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C5, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x05C5, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05C7, 0x0062; @result = 0x0061, 0x05B7, 0x05B8, 0x05C7, 0x05B9, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05C7, 0x0062 -> 0x0061, 0x05B7, 0x05B8, 0x05C7, 0x05B9, 0x0062 CONCAT';
@list = 0x0061, 0x05C7, 0x05B9, 0x05B8, 0x05B7, 0x0062; @result = 0x0061, 0x05B7, 0x05C7, 0x05B8, 0x05B9, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05C7, 0x05B9, 0x05B8, 0x05B7, 0x0062 -> 0x0061, 0x05B7, 0x05C7, 0x05B8, 0x05B9, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0610, 0x0062; @result = 0x00E0, 0x05AE, 0x0610, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0610, 0x0062 -> 0x00E0, 0x05AE, 0x0610, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0610, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0610, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0610, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0610, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0611, 0x0062; @result = 0x00E0, 0x05AE, 0x0611, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0611, 0x0062 -> 0x00E0, 0x05AE, 0x0611, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0611, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0611, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0611, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0611, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0612, 0x0062; @result = 0x00E0, 0x05AE, 0x0612, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0612, 0x0062 -> 0x00E0, 0x05AE, 0x0612, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0612, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0612, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0612, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0612, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0613, 0x0062; @result = 0x00E0, 0x05AE, 0x0613, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0613, 0x0062 -> 0x00E0, 0x05AE, 0x0613, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0613, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0613, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0613, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0613, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0614, 0x0062; @result = 0x00E0, 0x05AE, 0x0614, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0614, 0x0062 -> 0x00E0, 0x05AE, 0x0614, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0614, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0614, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0614, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0614, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0615, 0x0062; @result = 0x00E0, 0x05AE, 0x0615, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0615, 0x0062 -> 0x00E0, 0x05AE, 0x0615, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0615, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0615, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0615, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0615, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0616, 0x0062; @result = 0x00E0, 0x05AE, 0x0616, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0616, 0x0062 -> 0x00E0, 0x05AE, 0x0616, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0616, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0616, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0616, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0616, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0617, 0x0062; @result = 0x00E0, 0x05AE, 0x0617, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0617, 0x0062 -> 0x00E0, 0x05AE, 0x0617, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0617, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0617, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0617, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0617, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0619, 0x0618, 0x064D, 0x0618, 0x0062; @result = 0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0619, 0x0618, 0x064D, 0x0618, 0x0062 -> 0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062 CONCAT';
@list = 0x0061, 0x0618, 0x0619, 0x0618, 0x064D, 0x0062; @result = 0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0618, 0x0619, 0x0618, 0x064D, 0x0062 -> 0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062 CONCAT';
@list = 0x0061, 0x061A, 0x0619, 0x0618, 0x0619, 0x0062; @result = 0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x061A, 0x0619, 0x0618, 0x0619, 0x0062 -> 0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062 CONCAT';
@list = 0x0061, 0x0619, 0x061A, 0x0619, 0x0618, 0x0062; @result = 0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0619, 0x061A, 0x0619, 0x0618, 0x0062 -> 0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062 CONCAT';
@list = 0x0061, 0x0651, 0x061A, 0x0619, 0x061A, 0x0062; @result = 0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0651, 0x061A, 0x0619, 0x061A, 0x0062 -> 0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062 CONCAT';
@list = 0x0061, 0x061A, 0x0651, 0x061A, 0x0619, 0x0062; @result = 0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x061A, 0x0651, 0x061A, 0x0619, 0x0062 -> 0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062 CONCAT';
@list = 0x0061, 0x064C, 0x064B, 0xFB1E, 0x064B, 0x0062; @result = 0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064C, 0x064B, 0xFB1E, 0x064B, 0x0062 -> 0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062 CONCAT';
@list = 0x0061, 0x064B, 0x064C, 0x064B, 0xFB1E, 0x0062; @result = 0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064B, 0x064C, 0x064B, 0xFB1E, 0x0062 -> 0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062 CONCAT';
@list = 0x0061, 0x064D, 0x064C, 0x064B, 0x064C, 0x0062; @result = 0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064D, 0x064C, 0x064B, 0x064C, 0x0062 -> 0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062 CONCAT';
@list = 0x0061, 0x064C, 0x064D, 0x064C, 0x064B, 0x0062; @result = 0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064C, 0x064D, 0x064C, 0x064B, 0x0062 -> 0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062 CONCAT';
@list = 0x0061, 0x0618, 0x064D, 0x064C, 0x064D, 0x0062; @result = 0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0618, 0x064D, 0x064C, 0x064D, 0x0062 -> 0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062 CONCAT';
@list = 0x0061, 0x064D, 0x0618, 0x064D, 0x064C, 0x0062; @result = 0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064D, 0x0618, 0x064D, 0x064C, 0x0062 -> 0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062 CONCAT';
@list = 0x0061, 0x0619, 0x0618, 0x064D, 0x064E, 0x0062; @result = 0x0061, 0x064D, 0x0618, 0x064E, 0x0619, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0619, 0x0618, 0x064D, 0x064E, 0x0062 -> 0x0061, 0x064D, 0x0618, 0x064E, 0x0619, 0x0062 CONCAT';
@list = 0x0061, 0x064E, 0x0619, 0x0618, 0x064D, 0x0062; @result = 0x0061, 0x064D, 0x064E, 0x0618, 0x0619, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064E, 0x0619, 0x0618, 0x064D, 0x0062 -> 0x0061, 0x064D, 0x064E, 0x0618, 0x0619, 0x0062 CONCAT';
@list = 0x0061, 0x061A, 0x0619, 0x0618, 0x064F, 0x0062; @result = 0x0061, 0x0618, 0x0619, 0x064F, 0x061A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x061A, 0x0619, 0x0618, 0x064F, 0x0062 -> 0x0061, 0x0618, 0x0619, 0x064F, 0x061A, 0x0062 CONCAT';
@list = 0x0061, 0x064F, 0x061A, 0x0619, 0x0618, 0x0062; @result = 0x0061, 0x0618, 0x064F, 0x0619, 0x061A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064F, 0x061A, 0x0619, 0x0618, 0x0062 -> 0x0061, 0x0618, 0x064F, 0x0619, 0x061A, 0x0062 CONCAT';
@list = 0x0061, 0x0651, 0x061A, 0x0619, 0x0650, 0x0062; @result = 0x0061, 0x0619, 0x061A, 0x0650, 0x0651, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0651, 0x061A, 0x0619, 0x0650, 0x0062 -> 0x0061, 0x0619, 0x061A, 0x0650, 0x0651, 0x0062 CONCAT';
@list = 0x0061, 0x0650, 0x0651, 0x061A, 0x0619, 0x0062; @result = 0x0061, 0x0619, 0x0650, 0x061A, 0x0651, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0650, 0x0651, 0x061A, 0x0619, 0x0062 -> 0x0061, 0x0619, 0x0650, 0x061A, 0x0651, 0x0062 CONCAT';
@list = 0x0061, 0x0652, 0x0651, 0x061A, 0x0651, 0x0062; @result = 0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0652, 0x0651, 0x061A, 0x0651, 0x0062 -> 0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062 CONCAT';
@list = 0x0061, 0x0651, 0x0652, 0x0651, 0x061A, 0x0062; @result = 0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0651, 0x0652, 0x0651, 0x061A, 0x0062 -> 0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062 CONCAT';
@list = 0x0061, 0x0670, 0x0652, 0x0651, 0x0652, 0x0062; @result = 0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0670, 0x0652, 0x0651, 0x0652, 0x0062 -> 0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062 CONCAT';
@list = 0x0061, 0x0652, 0x0670, 0x0652, 0x0651, 0x0062; @result = 0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0652, 0x0670, 0x0652, 0x0651, 0x0062 -> 0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0653, 0x0062; @result = 0x00E0, 0x05AE, 0x0653, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0653, 0x0062 -> 0x00E0, 0x05AE, 0x0653, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0653, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0653, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0653, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0653, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0654, 0x0062; @result = 0x00E0, 0x05AE, 0x0654, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0654, 0x0062 -> 0x00E0, 0x05AE, 0x0654, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0654, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0654, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0654, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0654, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0655, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0655, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0655, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0655, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0655, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0655, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0655, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0655, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0656, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0656, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0656, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0656, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0656, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0656, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0656, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0656, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0657, 0x0062; @result = 0x00E0, 0x05AE, 0x0657, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0657, 0x0062 -> 0x00E0, 0x05AE, 0x0657, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0657, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0657, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0657, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0657, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0658, 0x0062; @result = 0x00E0, 0x05AE, 0x0658, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0658, 0x0062 -> 0x00E0, 0x05AE, 0x0658, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0658, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0658, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0658, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0658, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0659, 0x0062; @result = 0x00E0, 0x05AE, 0x0659, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0659, 0x0062 -> 0x00E0, 0x05AE, 0x0659, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0659, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0659, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0659, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0659, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x065A, 0x0062; @result = 0x00E0, 0x05AE, 0x065A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x065A, 0x0062 -> 0x00E0, 0x05AE, 0x065A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x065A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x065A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x065A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x065B, 0x0062; @result = 0x00E0, 0x05AE, 0x065B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x065B, 0x0062 -> 0x00E0, 0x05AE, 0x065B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x065B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x065B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x065B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x065C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x065C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x065C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x065C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x065C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x065C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x065C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x065D, 0x0062; @result = 0x00E0, 0x05AE, 0x065D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x065D, 0x0062 -> 0x00E0, 0x05AE, 0x065D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x065D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x065D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x065D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x065E, 0x0062; @result = 0x00E0, 0x05AE, 0x065E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x065E, 0x0062 -> 0x00E0, 0x05AE, 0x065E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x065E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x065E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x065E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x065F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x065F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x065F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x065F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x065F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x065F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x065F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x065F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0711, 0x0670, 0x0652, 0x0670, 0x0062; @result = 0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0711, 0x0670, 0x0652, 0x0670, 0x0062 -> 0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062 CONCAT';
@list = 0x0061, 0x0670, 0x0711, 0x0670, 0x0652, 0x0062; @result = 0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0670, 0x0711, 0x0670, 0x0652, 0x0062 -> 0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06D6, 0x0062; @result = 0x00E0, 0x05AE, 0x06D6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06D6, 0x0062 -> 0x00E0, 0x05AE, 0x06D6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06D6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06D6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06D6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06D6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06D7, 0x0062; @result = 0x00E0, 0x05AE, 0x06D7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06D7, 0x0062 -> 0x00E0, 0x05AE, 0x06D7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06D7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06D7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06D7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06D7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06D8, 0x0062; @result = 0x00E0, 0x05AE, 0x06D8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06D8, 0x0062 -> 0x00E0, 0x05AE, 0x06D8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06D8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06D8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06D8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06D8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06D9, 0x0062; @result = 0x00E0, 0x05AE, 0x06D9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06D9, 0x0062 -> 0x00E0, 0x05AE, 0x06D9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06D9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06D9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06D9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06D9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06DA, 0x0062; @result = 0x00E0, 0x05AE, 0x06DA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06DA, 0x0062 -> 0x00E0, 0x05AE, 0x06DA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06DA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06DA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06DA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06DA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06DB, 0x0062; @result = 0x00E0, 0x05AE, 0x06DB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06DB, 0x0062 -> 0x00E0, 0x05AE, 0x06DB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06DB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06DB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06DB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06DB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06DC, 0x0062; @result = 0x00E0, 0x05AE, 0x06DC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06DC, 0x0062 -> 0x00E0, 0x05AE, 0x06DC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06DC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06DC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06DC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06DC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06DF, 0x0062; @result = 0x00E0, 0x05AE, 0x06DF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06DF, 0x0062 -> 0x00E0, 0x05AE, 0x06DF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06DF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06DF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06DF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06DF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E0, 0x0062; @result = 0x00E0, 0x05AE, 0x06E0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E0, 0x0062 -> 0x00E0, 0x05AE, 0x06E0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E1, 0x0062; @result = 0x00E0, 0x05AE, 0x06E1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E1, 0x0062 -> 0x00E0, 0x05AE, 0x06E1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E2, 0x0062; @result = 0x00E0, 0x05AE, 0x06E2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E2, 0x0062 -> 0x00E0, 0x05AE, 0x06E2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x06E3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x06E3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x06E3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x06E3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x06E3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x06E3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x06E3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E4, 0x0062; @result = 0x00E0, 0x05AE, 0x06E4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E4, 0x0062 -> 0x00E0, 0x05AE, 0x06E4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E7, 0x0062; @result = 0x00E0, 0x05AE, 0x06E7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E7, 0x0062 -> 0x00E0, 0x05AE, 0x06E7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06E8, 0x0062; @result = 0x00E0, 0x05AE, 0x06E8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06E8, 0x0062 -> 0x00E0, 0x05AE, 0x06E8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06E8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06E8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06E8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06E8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x06EA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x06EA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x06EA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x06EA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x06EA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x06EA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06EA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x06EA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06EB, 0x0062; @result = 0x00E0, 0x05AE, 0x06EB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06EB, 0x0062 -> 0x00E0, 0x05AE, 0x06EB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06EB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06EB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06EB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06EB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x06EC, 0x0062; @result = 0x00E0, 0x05AE, 0x06EC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x06EC, 0x0062 -> 0x00E0, 0x05AE, 0x06EC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x06EC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x06EC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06EC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x06EC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x06ED, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x06ED, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x06ED, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x06ED, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x06ED, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x06ED, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x06ED, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x06ED, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0C55, 0x0711, 0x0670, 0x0711, 0x0062; @result = 0x0061, 0x0670, 0x0711, 0x0711, 0x0C55, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C55, 0x0711, 0x0670, 0x0711, 0x0062 -> 0x0061, 0x0670, 0x0711, 0x0711, 0x0C55, 0x0062 CONCAT';
@list = 0x0061, 0x0711, 0x0C55, 0x0711, 0x0670, 0x0062; @result = 0x0061, 0x0670, 0x0711, 0x0711, 0x0C55, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0711, 0x0C55, 0x0711, 0x0670, 0x0062 -> 0x0061, 0x0670, 0x0711, 0x0711, 0x0C55, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0730, 0x0062; @result = 0x00E0, 0x05AE, 0x0730, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0730, 0x0062 -> 0x00E0, 0x05AE, 0x0730, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0730, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0730, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0730, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0730, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0731, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0731, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0731, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0731, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0731, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0731, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0731, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0731, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0732, 0x0062; @result = 0x00E0, 0x05AE, 0x0732, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0732, 0x0062 -> 0x00E0, 0x05AE, 0x0732, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0732, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0732, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0732, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0732, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0733, 0x0062; @result = 0x00E0, 0x05AE, 0x0733, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0733, 0x0062 -> 0x00E0, 0x05AE, 0x0733, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0733, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0733, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0733, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0733, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0734, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0734, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0734, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0734, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0734, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0734, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0734, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0734, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0735, 0x0062; @result = 0x00E0, 0x05AE, 0x0735, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0735, 0x0062 -> 0x00E0, 0x05AE, 0x0735, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0735, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0735, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0735, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0735, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0736, 0x0062; @result = 0x00E0, 0x05AE, 0x0736, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0736, 0x0062 -> 0x00E0, 0x05AE, 0x0736, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0736, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0736, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0736, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0736, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0737, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0737, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0737, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0737, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0737, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0737, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0737, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0737, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0738, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0738, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0738, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0738, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0738, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0738, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0738, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0738, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0739, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0739, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0739, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0739, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0739, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0739, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0739, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0739, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x073A, 0x0062; @result = 0x00E0, 0x05AE, 0x073A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x073A, 0x0062 -> 0x00E0, 0x05AE, 0x073A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x073A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x073A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x073A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x073B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x073B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x073B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x073B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x073B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x073B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x073B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x073C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x073C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x073C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x073C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x073C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x073C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x073C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x073D, 0x0062; @result = 0x00E0, 0x05AE, 0x073D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x073D, 0x0062 -> 0x00E0, 0x05AE, 0x073D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x073D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x073D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x073D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x073E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x073E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x073E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x073E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x073E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x073E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x073E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x073F, 0x0062; @result = 0x00E0, 0x05AE, 0x073F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x073F, 0x0062 -> 0x00E0, 0x05AE, 0x073F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x073F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x073F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x073F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x073F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0740, 0x0062; @result = 0x00E0, 0x05AE, 0x0740, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0740, 0x0062 -> 0x00E0, 0x05AE, 0x0740, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0740, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0740, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0740, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0740, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0741, 0x0062; @result = 0x00E0, 0x05AE, 0x0741, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0741, 0x0062 -> 0x00E0, 0x05AE, 0x0741, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0741, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0741, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0741, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0741, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0742, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0742, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0742, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0742, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0742, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0742, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0742, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0742, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0743, 0x0062; @result = 0x00E0, 0x05AE, 0x0743, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0743, 0x0062 -> 0x00E0, 0x05AE, 0x0743, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0743, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0743, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0743, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0743, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0744, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0744, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0744, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0744, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0744, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0744, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0744, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0744, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0745, 0x0062; @result = 0x00E0, 0x05AE, 0x0745, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0745, 0x0062 -> 0x00E0, 0x05AE, 0x0745, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0745, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0745, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0745, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0745, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0746, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0746, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0746, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0746, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0746, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0746, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0746, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0746, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0747, 0x0062; @result = 0x00E0, 0x05AE, 0x0747, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0747, 0x0062 -> 0x00E0, 0x05AE, 0x0747, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0747, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0747, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0747, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0747, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0748, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0748, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0748, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0748, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0748, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0748, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0748, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0748, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0749, 0x0062; @result = 0x00E0, 0x05AE, 0x0749, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0749, 0x0062 -> 0x00E0, 0x05AE, 0x0749, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0749, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0749, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0749, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0749, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x074A, 0x0062; @result = 0x00E0, 0x05AE, 0x074A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x074A, 0x0062 -> 0x00E0, 0x05AE, 0x074A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x074A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x074A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x074A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x074A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07EB, 0x0062; @result = 0x00E0, 0x05AE, 0x07EB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07EB, 0x0062 -> 0x00E0, 0x05AE, 0x07EB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07EB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07EB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07EB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07EB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07EC, 0x0062; @result = 0x00E0, 0x05AE, 0x07EC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07EC, 0x0062 -> 0x00E0, 0x05AE, 0x07EC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07EC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07EC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07EC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07EC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07ED, 0x0062; @result = 0x00E0, 0x05AE, 0x07ED, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07ED, 0x0062 -> 0x00E0, 0x05AE, 0x07ED, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07ED, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07ED, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07ED, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07ED, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07EE, 0x0062; @result = 0x00E0, 0x05AE, 0x07EE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07EE, 0x0062 -> 0x00E0, 0x05AE, 0x07EE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07EE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07EE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07EE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07EE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07EF, 0x0062; @result = 0x00E0, 0x05AE, 0x07EF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07EF, 0x0062 -> 0x00E0, 0x05AE, 0x07EF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07EF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07EF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07EF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07EF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07F0, 0x0062; @result = 0x00E0, 0x05AE, 0x07F0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07F0, 0x0062 -> 0x00E0, 0x05AE, 0x07F0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07F0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07F0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07F0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07F0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07F1, 0x0062; @result = 0x00E0, 0x05AE, 0x07F1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07F1, 0x0062 -> 0x00E0, 0x05AE, 0x07F1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07F1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07F1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07F1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07F1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x07F2, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x07F2, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x07F2, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x07F2, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x07F2, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x07F2, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07F2, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x07F2, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x07F3, 0x0062; @result = 0x00E0, 0x05AE, 0x07F3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x07F3, 0x0062 -> 0x00E0, 0x05AE, 0x07F3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x07F3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x07F3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07F3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x07F3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x07FD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x07FD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x07FD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x07FD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x07FD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x07FD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x07FD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x07FD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0816, 0x0062; @result = 0x00E0, 0x05AE, 0x0816, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0816, 0x0062 -> 0x00E0, 0x05AE, 0x0816, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0816, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0816, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0816, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0816, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0817, 0x0062; @result = 0x00E0, 0x05AE, 0x0817, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0817, 0x0062 -> 0x00E0, 0x05AE, 0x0817, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0817, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0817, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0817, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0817, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0818, 0x0062; @result = 0x00E0, 0x05AE, 0x0818, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0818, 0x0062 -> 0x00E0, 0x05AE, 0x0818, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0818, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0818, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0818, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0818, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0819, 0x0062; @result = 0x00E0, 0x05AE, 0x0819, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0819, 0x0062 -> 0x00E0, 0x05AE, 0x0819, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0819, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0819, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0819, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0819, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x081B, 0x0062; @result = 0x00E0, 0x05AE, 0x081B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x081B, 0x0062 -> 0x00E0, 0x05AE, 0x081B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x081B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x081B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x081B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x081B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x081C, 0x0062; @result = 0x00E0, 0x05AE, 0x081C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x081C, 0x0062 -> 0x00E0, 0x05AE, 0x081C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x081C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x081C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x081C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x081C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x081D, 0x0062; @result = 0x00E0, 0x05AE, 0x081D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x081D, 0x0062 -> 0x00E0, 0x05AE, 0x081D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x081D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x081D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x081D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x081D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x081E, 0x0062; @result = 0x00E0, 0x05AE, 0x081E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x081E, 0x0062 -> 0x00E0, 0x05AE, 0x081E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x081E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x081E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x081E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x081E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x081F, 0x0062; @result = 0x00E0, 0x05AE, 0x081F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x081F, 0x0062 -> 0x00E0, 0x05AE, 0x081F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x081F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x081F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x081F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x081F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0820, 0x0062; @result = 0x00E0, 0x05AE, 0x0820, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0820, 0x0062 -> 0x00E0, 0x05AE, 0x0820, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0820, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0820, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0820, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0820, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0821, 0x0062; @result = 0x00E0, 0x05AE, 0x0821, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0821, 0x0062 -> 0x00E0, 0x05AE, 0x0821, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0821, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0821, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0821, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0821, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0822, 0x0062; @result = 0x00E0, 0x05AE, 0x0822, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0822, 0x0062 -> 0x00E0, 0x05AE, 0x0822, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0822, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0822, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0822, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0822, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0823, 0x0062; @result = 0x00E0, 0x05AE, 0x0823, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0823, 0x0062 -> 0x00E0, 0x05AE, 0x0823, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0823, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0823, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0823, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0823, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0825, 0x0062; @result = 0x00E0, 0x05AE, 0x0825, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0825, 0x0062 -> 0x00E0, 0x05AE, 0x0825, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0825, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0825, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0825, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0825, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0826, 0x0062; @result = 0x00E0, 0x05AE, 0x0826, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0826, 0x0062 -> 0x00E0, 0x05AE, 0x0826, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0826, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0826, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0826, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0826, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0827, 0x0062; @result = 0x00E0, 0x05AE, 0x0827, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0827, 0x0062 -> 0x00E0, 0x05AE, 0x0827, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0827, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0827, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0827, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0827, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0829, 0x0062; @result = 0x00E0, 0x05AE, 0x0829, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0829, 0x0062 -> 0x00E0, 0x05AE, 0x0829, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0829, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0829, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0829, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0829, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x082A, 0x0062; @result = 0x00E0, 0x05AE, 0x082A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x082A, 0x0062 -> 0x00E0, 0x05AE, 0x082A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x082A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x082A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x082A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x082A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x082B, 0x0062; @result = 0x00E0, 0x05AE, 0x082B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x082B, 0x0062 -> 0x00E0, 0x05AE, 0x082B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x082B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x082B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x082B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x082B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x082C, 0x0062; @result = 0x00E0, 0x05AE, 0x082C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x082C, 0x0062 -> 0x00E0, 0x05AE, 0x082C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x082C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x082C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x082C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x082C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x082D, 0x0062; @result = 0x00E0, 0x05AE, 0x082D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x082D, 0x0062 -> 0x00E0, 0x05AE, 0x082D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x082D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x082D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x082D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x082D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0859, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0859, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0859, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0859, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0859, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0859, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0859, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0859, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x085A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x085A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x085A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x085A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x085A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x085A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x085A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x085A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x085B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x085B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x085B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x085B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x085B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x085B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x085B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x085B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0898, 0x0062; @result = 0x00E0, 0x05AE, 0x0898, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0898, 0x0062 -> 0x00E0, 0x05AE, 0x0898, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0898, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0898, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0898, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0898, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0899, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0899, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0899, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0899, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0899, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0899, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0899, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0899, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x089A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x089A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x089A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x089A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x089A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x089A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x089A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x089B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x089B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x089B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x089B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x089B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x089B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x089B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x089C, 0x0062; @result = 0x00E0, 0x05AE, 0x089C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x089C, 0x0062 -> 0x00E0, 0x05AE, 0x089C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x089C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x089C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x089C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x089D, 0x0062; @result = 0x00E0, 0x05AE, 0x089D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x089D, 0x0062 -> 0x00E0, 0x05AE, 0x089D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x089D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x089D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x089D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x089E, 0x0062; @result = 0x00E0, 0x05AE, 0x089E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x089E, 0x0062 -> 0x00E0, 0x05AE, 0x089E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x089E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x089E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x089E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x089F, 0x0062; @result = 0x00E0, 0x05AE, 0x089F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x089F, 0x0062 -> 0x00E0, 0x05AE, 0x089F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x089F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x089F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x089F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x089F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08CA, 0x0062; @result = 0x00E0, 0x05AE, 0x08CA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08CA, 0x0062 -> 0x00E0, 0x05AE, 0x08CA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08CA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08CA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08CA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08CB, 0x0062; @result = 0x00E0, 0x05AE, 0x08CB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08CB, 0x0062 -> 0x00E0, 0x05AE, 0x08CB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08CB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08CB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08CB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08CC, 0x0062; @result = 0x00E0, 0x05AE, 0x08CC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08CC, 0x0062 -> 0x00E0, 0x05AE, 0x08CC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08CC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08CC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08CC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08CD, 0x0062; @result = 0x00E0, 0x05AE, 0x08CD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08CD, 0x0062 -> 0x00E0, 0x05AE, 0x08CD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08CD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08CD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08CD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08CE, 0x0062; @result = 0x00E0, 0x05AE, 0x08CE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08CE, 0x0062 -> 0x00E0, 0x05AE, 0x08CE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08CE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08CE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08CE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08CF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08CF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08CF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08CF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08CF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08CF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08CF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08CF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D0, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08D0, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D0, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08D0, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08D0, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08D0, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D0, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08D0, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D1, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08D1, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D1, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08D1, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08D1, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08D1, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D1, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08D1, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D2, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08D2, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D2, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08D2, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08D2, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08D2, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D2, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08D2, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08D3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08D3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08D3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08D3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08D3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08D3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D4, 0x0062; @result = 0x00E0, 0x05AE, 0x08D4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D4, 0x0062 -> 0x00E0, 0x05AE, 0x08D4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D5, 0x0062; @result = 0x00E0, 0x05AE, 0x08D5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D5, 0x0062 -> 0x00E0, 0x05AE, 0x08D5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D6, 0x0062; @result = 0x00E0, 0x05AE, 0x08D6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D6, 0x0062 -> 0x00E0, 0x05AE, 0x08D6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D7, 0x0062; @result = 0x00E0, 0x05AE, 0x08D7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D7, 0x0062 -> 0x00E0, 0x05AE, 0x08D7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D8, 0x0062; @result = 0x00E0, 0x05AE, 0x08D8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D8, 0x0062 -> 0x00E0, 0x05AE, 0x08D8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08D9, 0x0062; @result = 0x00E0, 0x05AE, 0x08D9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08D9, 0x0062 -> 0x00E0, 0x05AE, 0x08D9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08D9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08D9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08D9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08D9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DA, 0x0062; @result = 0x00E0, 0x05AE, 0x08DA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DA, 0x0062 -> 0x00E0, 0x05AE, 0x08DA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DB, 0x0062; @result = 0x00E0, 0x05AE, 0x08DB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DB, 0x0062 -> 0x00E0, 0x05AE, 0x08DB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DC, 0x0062; @result = 0x00E0, 0x05AE, 0x08DC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DC, 0x0062 -> 0x00E0, 0x05AE, 0x08DC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DD, 0x0062; @result = 0x00E0, 0x05AE, 0x08DD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DD, 0x0062 -> 0x00E0, 0x05AE, 0x08DD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DE, 0x0062; @result = 0x00E0, 0x05AE, 0x08DE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DE, 0x0062 -> 0x00E0, 0x05AE, 0x08DE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08DF, 0x0062; @result = 0x00E0, 0x05AE, 0x08DF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08DF, 0x0062 -> 0x00E0, 0x05AE, 0x08DF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08DF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08DF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08DF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08DF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E0, 0x0062; @result = 0x00E0, 0x05AE, 0x08E0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E0, 0x0062 -> 0x00E0, 0x05AE, 0x08E0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E1, 0x0062; @result = 0x00E0, 0x05AE, 0x08E1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E1, 0x0062 -> 0x00E0, 0x05AE, 0x08E1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08E3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08E3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08E3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08E3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08E3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E4, 0x0062; @result = 0x00E0, 0x05AE, 0x08E4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E4, 0x0062 -> 0x00E0, 0x05AE, 0x08E4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E5, 0x0062; @result = 0x00E0, 0x05AE, 0x08E5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E5, 0x0062 -> 0x00E0, 0x05AE, 0x08E5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08E6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08E6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08E6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08E6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08E6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E7, 0x0062; @result = 0x00E0, 0x05AE, 0x08E7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E7, 0x0062 -> 0x00E0, 0x05AE, 0x08E7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08E8, 0x0062; @result = 0x00E0, 0x05AE, 0x08E8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08E8, 0x0062 -> 0x00E0, 0x05AE, 0x08E8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08E8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08E8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08E8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E9, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08E9, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08E9, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08E9, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08E9, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08E9, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08E9, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08E9, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08EA, 0x0062; @result = 0x00E0, 0x05AE, 0x08EA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08EA, 0x0062 -> 0x00E0, 0x05AE, 0x08EA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08EA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08EA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08EA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08EA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08EB, 0x0062; @result = 0x00E0, 0x05AE, 0x08EB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08EB, 0x0062 -> 0x00E0, 0x05AE, 0x08EB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08EB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08EB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08EB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08EB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08EC, 0x0062; @result = 0x00E0, 0x05AE, 0x08EC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08EC, 0x0062 -> 0x00E0, 0x05AE, 0x08EC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08EC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08EC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08EC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08EC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08ED, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08ED, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08ED, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08ED, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08ED, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08ED, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08ED, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08ED, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08EE, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08EE, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08EE, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08EE, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08EE, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08EE, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08EE, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08EE, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08EF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08EF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08EF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08EF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08EF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08EF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08EF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08EF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x064C, 0x064B, 0xFB1E, 0x08F0, 0x0062; @result = 0x0061, 0xFB1E, 0x064B, 0x08F0, 0x064C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064C, 0x064B, 0xFB1E, 0x08F0, 0x0062 -> 0x0061, 0xFB1E, 0x064B, 0x08F0, 0x064C, 0x0062 CONCAT';
@list = 0x0061, 0x08F0, 0x064C, 0x064B, 0xFB1E, 0x0062; @result = 0x0061, 0xFB1E, 0x08F0, 0x064B, 0x064C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F0, 0x064C, 0x064B, 0xFB1E, 0x0062 -> 0x0061, 0xFB1E, 0x08F0, 0x064B, 0x064C, 0x0062 CONCAT';
@list = 0x0061, 0x064D, 0x064C, 0x064B, 0x08F1, 0x0062; @result = 0x0061, 0x064B, 0x064C, 0x08F1, 0x064D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064D, 0x064C, 0x064B, 0x08F1, 0x0062 -> 0x0061, 0x064B, 0x064C, 0x08F1, 0x064D, 0x0062 CONCAT';
@list = 0x0061, 0x08F1, 0x064D, 0x064C, 0x064B, 0x0062; @result = 0x0061, 0x064B, 0x08F1, 0x064C, 0x064D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F1, 0x064D, 0x064C, 0x064B, 0x0062 -> 0x0061, 0x064B, 0x08F1, 0x064C, 0x064D, 0x0062 CONCAT';
@list = 0x0061, 0x0618, 0x064D, 0x064C, 0x08F2, 0x0062; @result = 0x0061, 0x064C, 0x064D, 0x08F2, 0x0618, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0618, 0x064D, 0x064C, 0x08F2, 0x0062 -> 0x0061, 0x064C, 0x064D, 0x08F2, 0x0618, 0x0062 CONCAT';
@list = 0x0061, 0x08F2, 0x0618, 0x064D, 0x064C, 0x0062; @result = 0x0061, 0x064C, 0x08F2, 0x064D, 0x0618, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F2, 0x0618, 0x064D, 0x064C, 0x0062 -> 0x0061, 0x064C, 0x08F2, 0x064D, 0x0618, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08F3, 0x0062; @result = 0x00E0, 0x05AE, 0x08F3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08F3, 0x0062 -> 0x00E0, 0x05AE, 0x08F3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08F3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08F3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08F3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08F4, 0x0062; @result = 0x00E0, 0x05AE, 0x08F4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08F4, 0x0062 -> 0x00E0, 0x05AE, 0x08F4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08F4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08F4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08F4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08F5, 0x0062; @result = 0x00E0, 0x05AE, 0x08F5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08F5, 0x0062 -> 0x00E0, 0x05AE, 0x08F5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08F5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08F5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08F5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08F6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08F6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08F6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08F6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08F6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08F6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08F6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08F7, 0x0062; @result = 0x00E0, 0x05AE, 0x08F7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08F7, 0x0062 -> 0x00E0, 0x05AE, 0x08F7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08F7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08F7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08F7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08F8, 0x0062; @result = 0x00E0, 0x05AE, 0x08F8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08F8, 0x0062 -> 0x00E0, 0x05AE, 0x08F8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08F8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08F8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08F8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08F9, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08F9, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08F9, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08F9, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08F9, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08F9, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08F9, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08F9, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x08FA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x08FA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x08FA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x08FA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x08FA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x08FA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x08FA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08FB, 0x0062; @result = 0x00E0, 0x05AE, 0x08FB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08FB, 0x0062 -> 0x00E0, 0x05AE, 0x08FB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08FB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08FB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08FB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08FC, 0x0062; @result = 0x00E0, 0x05AE, 0x08FC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08FC, 0x0062 -> 0x00E0, 0x05AE, 0x08FC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08FC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08FC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08FC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08FD, 0x0062; @result = 0x00E0, 0x05AE, 0x08FD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08FD, 0x0062 -> 0x00E0, 0x05AE, 0x08FD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08FD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08FD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08FD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08FE, 0x0062; @result = 0x00E0, 0x05AE, 0x08FE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08FE, 0x0062 -> 0x00E0, 0x05AE, 0x08FE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08FE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08FE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08FE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x08FF, 0x0062; @result = 0x00E0, 0x05AE, 0x08FF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x08FF, 0x0062 -> 0x00E0, 0x05AE, 0x08FF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x08FF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x08FF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x08FF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x08FF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x093C, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x093C, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x093C, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x093C, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x094D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x094D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x094D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x094D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0951, 0x0062; @result = 0x00E0, 0x05AE, 0x0951, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0951, 0x0062 -> 0x00E0, 0x05AE, 0x0951, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0951, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0951, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0951, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0951, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0952, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0952, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0952, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0952, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0952, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0952, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0952, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0952, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0953, 0x0062; @result = 0x00E0, 0x05AE, 0x0953, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0953, 0x0062 -> 0x00E0, 0x05AE, 0x0953, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0953, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0953, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0953, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0953, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0954, 0x0062; @result = 0x00E0, 0x05AE, 0x0954, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0954, 0x0062 -> 0x00E0, 0x05AE, 0x0954, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0954, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0954, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0954, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0954, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x09BC, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x09BC, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x09BC, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x09BC, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x09BC, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x09BC, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x09BC, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x09BC, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x09CD, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x09CD, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x09CD, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x09CD, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x09CD, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x09CD, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x09CD, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x09CD, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x09FE, 0x0062; @result = 0x00E0, 0x05AE, 0x09FE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x09FE, 0x0062 -> 0x00E0, 0x05AE, 0x09FE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x09FE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x09FE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x09FE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x09FE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x0A3C, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x0A3C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x0A3C, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x0A3C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0A3C, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x0A3C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0A3C, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x0A3C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0A4D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0A4D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0A4D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0A4D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0A4D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0A4D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0A4D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0A4D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x0ABC, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x0ABC, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x0ABC, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x0ABC, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0ABC, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x0ABC, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0ABC, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x0ABC, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0ACD, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0ACD, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0ACD, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0ACD, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0ACD, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0ACD, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0ACD, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0ACD, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x0B3C, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x0B3C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x0B3C, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x0B3C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0B3C, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x0B3C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0B3C, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x0B3C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0B4D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0B4D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0B4D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0B4D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0B4D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0B4D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0B4D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0B4D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0BCD, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0BCD, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0BCD, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0BCD, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0BCD, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0BCD, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0BCD, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0BCD, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x0C3C, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x0C3C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x0C3C, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x0C3C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0C3C, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x0C3C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C3C, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x0C3C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0C4D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0C4D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0C4D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0C4D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0C4D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0C4D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C4D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0C4D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0C56, 0x0C55, 0x0711, 0x0C55, 0x0062; @result = 0x0061, 0x0711, 0x0C55, 0x0C55, 0x0C56, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C56, 0x0C55, 0x0711, 0x0C55, 0x0062 -> 0x0061, 0x0711, 0x0C55, 0x0C55, 0x0C56, 0x0062 CONCAT';
@list = 0x0061, 0x0C55, 0x0C56, 0x0C55, 0x0711, 0x0062; @result = 0x0061, 0x0711, 0x0C55, 0x0C55, 0x0C56, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C55, 0x0C56, 0x0C55, 0x0711, 0x0062 -> 0x0061, 0x0711, 0x0C55, 0x0C55, 0x0C56, 0x0062 CONCAT';
@list = 0x0061, 0x0E38, 0x0C56, 0x0C55, 0x0C56, 0x0062; @result = 0x0061, 0x0C55, 0x0C56, 0x0C56, 0x0E38, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E38, 0x0C56, 0x0C55, 0x0C56, 0x0062 -> 0x0061, 0x0C55, 0x0C56, 0x0C56, 0x0E38, 0x0062 CONCAT';
@list = 0x0061, 0x0C56, 0x0E38, 0x0C56, 0x0C55, 0x0062; @result = 0x0061, 0x0C55, 0x0C56, 0x0C56, 0x0E38, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0C56, 0x0E38, 0x0C56, 0x0C55, 0x0062 -> 0x0061, 0x0C55, 0x0C56, 0x0C56, 0x0E38, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x0CBC, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x0CBC, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x0CBC, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x0CBC, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0CBC, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x0CBC, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0CBC, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x0CBC, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0CCD, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0CCD, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0CCD, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0CCD, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0CCD, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0CCD, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0CCD, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0CCD, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0D3B, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0D3B, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0D3B, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0D3B, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0D3B, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0D3B, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0D3B, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0D3B, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0D3C, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0D3C, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0D3C, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0D3C, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0D3C, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0D3C, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0D3C, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0D3C, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0D4D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0D4D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0D4D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0D4D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0D4D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0D4D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0D4D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0D4D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0DCA, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0DCA, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0DCA, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0DCA, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0DCA, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0DCA, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0DCA, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0DCA, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0E48, 0x0E38, 0x0C56, 0x0E38, 0x0062; @result = 0x0061, 0x0C56, 0x0E38, 0x0E38, 0x0E48, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E48, 0x0E38, 0x0C56, 0x0E38, 0x0062 -> 0x0061, 0x0C56, 0x0E38, 0x0E38, 0x0E48, 0x0062 CONCAT';
@list = 0x0061, 0x0E38, 0x0E48, 0x0E38, 0x0C56, 0x0062; @result = 0x0061, 0x0C56, 0x0E38, 0x0E38, 0x0E48, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E38, 0x0E48, 0x0E38, 0x0C56, 0x0062 -> 0x0061, 0x0C56, 0x0E38, 0x0E38, 0x0E48, 0x0062 CONCAT';
@list = 0x0061, 0x0E48, 0x0E38, 0x0C56, 0x0E39, 0x0062; @result = 0x0061, 0x0C56, 0x0E38, 0x0E39, 0x0E48, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E48, 0x0E38, 0x0C56, 0x0E39, 0x0062 -> 0x0061, 0x0C56, 0x0E38, 0x0E39, 0x0E48, 0x0062 CONCAT';
@list = 0x0061, 0x0E39, 0x0E48, 0x0E38, 0x0C56, 0x0062; @result = 0x0061, 0x0C56, 0x0E39, 0x0E38, 0x0E48, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E39, 0x0E48, 0x0E38, 0x0C56, 0x0062 -> 0x0061, 0x0C56, 0x0E39, 0x0E38, 0x0E48, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0E3A, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0E3A, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0E3A, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0E3A, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0E3A, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0E3A, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E3A, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0E3A, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E48, 0x0062; @result = 0x0061, 0x0E38, 0x0E48, 0x0E48, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E48, 0x0062 -> 0x0061, 0x0E38, 0x0E48, 0x0E48, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0E48, 0x0EB8, 0x0E48, 0x0E38, 0x0062; @result = 0x0061, 0x0E38, 0x0E48, 0x0E48, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E48, 0x0EB8, 0x0E48, 0x0E38, 0x0062 -> 0x0061, 0x0E38, 0x0E48, 0x0E48, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E49, 0x0062; @result = 0x0061, 0x0E38, 0x0E48, 0x0E49, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E49, 0x0062 -> 0x0061, 0x0E38, 0x0E48, 0x0E49, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0E49, 0x0EB8, 0x0E48, 0x0E38, 0x0062; @result = 0x0061, 0x0E38, 0x0E49, 0x0E48, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E49, 0x0EB8, 0x0E48, 0x0E38, 0x0062 -> 0x0061, 0x0E38, 0x0E49, 0x0E48, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E4A, 0x0062; @result = 0x0061, 0x0E38, 0x0E48, 0x0E4A, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E4A, 0x0062 -> 0x0061, 0x0E38, 0x0E48, 0x0E4A, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0E4A, 0x0EB8, 0x0E48, 0x0E38, 0x0062; @result = 0x0061, 0x0E38, 0x0E4A, 0x0E48, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E4A, 0x0EB8, 0x0E48, 0x0E38, 0x0062 -> 0x0061, 0x0E38, 0x0E4A, 0x0E48, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E4B, 0x0062; @result = 0x0061, 0x0E38, 0x0E48, 0x0E4B, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB8, 0x0E48, 0x0E38, 0x0E4B, 0x0062 -> 0x0061, 0x0E38, 0x0E48, 0x0E4B, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0E4B, 0x0EB8, 0x0E48, 0x0E38, 0x0062; @result = 0x0061, 0x0E38, 0x0E4B, 0x0E48, 0x0EB8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0E4B, 0x0EB8, 0x0E48, 0x0E38, 0x0062 -> 0x0061, 0x0E38, 0x0E4B, 0x0E48, 0x0EB8, 0x0062 CONCAT';
@list = 0x0061, 0x0EC8, 0x0EB8, 0x0E48, 0x0EB8, 0x0062; @result = 0x0061, 0x0E48, 0x0EB8, 0x0EB8, 0x0EC8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EC8, 0x0EB8, 0x0E48, 0x0EB8, 0x0062 -> 0x0061, 0x0E48, 0x0EB8, 0x0EB8, 0x0EC8, 0x0062 CONCAT';
@list = 0x0061, 0x0EB8, 0x0EC8, 0x0EB8, 0x0E48, 0x0062; @result = 0x0061, 0x0E48, 0x0EB8, 0x0EB8, 0x0EC8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB8, 0x0EC8, 0x0EB8, 0x0E48, 0x0062 -> 0x0061, 0x0E48, 0x0EB8, 0x0EB8, 0x0EC8, 0x0062 CONCAT';
@list = 0x0061, 0x0EC8, 0x0EB8, 0x0E48, 0x0EB9, 0x0062; @result = 0x0061, 0x0E48, 0x0EB8, 0x0EB9, 0x0EC8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EC8, 0x0EB8, 0x0E48, 0x0EB9, 0x0062 -> 0x0061, 0x0E48, 0x0EB8, 0x0EB9, 0x0EC8, 0x0062 CONCAT';
@list = 0x0061, 0x0EB9, 0x0EC8, 0x0EB8, 0x0E48, 0x0062; @result = 0x0061, 0x0E48, 0x0EB9, 0x0EB8, 0x0EC8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EB9, 0x0EC8, 0x0EB8, 0x0E48, 0x0062 -> 0x0061, 0x0E48, 0x0EB9, 0x0EB8, 0x0EC8, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0EBA, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0EBA, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0EBA, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0EBA, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0EBA, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0EBA, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EBA, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0EBA, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0EC8, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC8, 0x0EC8, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0EC8, 0x0062 -> 0x0061, 0x0EB8, 0x0EC8, 0x0EC8, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0EC8, 0x0F71, 0x0EC8, 0x0EB8, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC8, 0x0EC8, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EC8, 0x0F71, 0x0EC8, 0x0EB8, 0x0062 -> 0x0061, 0x0EB8, 0x0EC8, 0x0EC8, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0EC9, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC8, 0x0EC9, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0EC9, 0x0062 -> 0x0061, 0x0EB8, 0x0EC8, 0x0EC9, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0EC9, 0x0F71, 0x0EC8, 0x0EB8, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC9, 0x0EC8, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0EC9, 0x0F71, 0x0EC8, 0x0EB8, 0x0062 -> 0x0061, 0x0EB8, 0x0EC9, 0x0EC8, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0ECA, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC8, 0x0ECA, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0ECA, 0x0062 -> 0x0061, 0x0EB8, 0x0EC8, 0x0ECA, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0ECA, 0x0F71, 0x0EC8, 0x0EB8, 0x0062; @result = 0x0061, 0x0EB8, 0x0ECA, 0x0EC8, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0ECA, 0x0F71, 0x0EC8, 0x0EB8, 0x0062 -> 0x0061, 0x0EB8, 0x0ECA, 0x0EC8, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0ECB, 0x0062; @result = 0x0061, 0x0EB8, 0x0EC8, 0x0ECB, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F71, 0x0EC8, 0x0EB8, 0x0ECB, 0x0062 -> 0x0061, 0x0EB8, 0x0EC8, 0x0ECB, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x0ECB, 0x0F71, 0x0EC8, 0x0EB8, 0x0062; @result = 0x0061, 0x0EB8, 0x0ECB, 0x0EC8, 0x0F71, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0ECB, 0x0F71, 0x0EC8, 0x0EB8, 0x0062 -> 0x0061, 0x0EB8, 0x0ECB, 0x0EC8, 0x0F71, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F18, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0F18, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F18, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0F18, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0F18, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0F18, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F18, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0F18, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F19, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0F19, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F19, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0F19, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0F19, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0F19, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F19, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0F19, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F35, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0F35, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F35, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0F35, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0F35, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0F35, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F35, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0F35, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F37, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0F37, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0F37, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0F37, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0F37, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0F37, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F37, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0F37, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x0F39, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x0F39, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x0F39, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x0F39, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x0F39, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x0F39, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F39, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x0F39, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x0F72, 0x0F71, 0x0EC8, 0x0F71, 0x0062; @result = 0x0061, 0x0EC8, 0x0F71, 0x0F71, 0x0F72, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F72, 0x0F71, 0x0EC8, 0x0F71, 0x0062 -> 0x0061, 0x0EC8, 0x0F71, 0x0F71, 0x0F72, 0x0062 CONCAT';
@list = 0x0061, 0x0F71, 0x0F72, 0x0F71, 0x0EC8, 0x0062; @result = 0x0061, 0x0EC8, 0x0F71, 0x0F71, 0x0F72, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F71, 0x0F72, 0x0F71, 0x0EC8, 0x0062 -> 0x0061, 0x0EC8, 0x0F71, 0x0F71, 0x0F72, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F72, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F72, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F72, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F72, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0321, 0x0F74, 0x0F72, 0x0F74, 0x0062; @result = 0x0061, 0x0F72, 0x0F74, 0x0F74, 0x0321, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0321, 0x0F74, 0x0F72, 0x0F74, 0x0062 -> 0x0061, 0x0F72, 0x0F74, 0x0F74, 0x0321, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0321, 0x0F74, 0x0F72, 0x0062; @result = 0x0061, 0x0F72, 0x0F74, 0x0F74, 0x0321, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0321, 0x0F74, 0x0F72, 0x0062 -> 0x0061, 0x0F72, 0x0F74, 0x0F74, 0x0321, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7A, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F7A, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7A, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F7A, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F7A, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F7A, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F7A, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F7A, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7B, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F7B, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7B, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F7B, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F7B, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F7B, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F7B, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F7B, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7C, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F7C, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7C, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F7C, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F7C, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F7C, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F7C, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F7C, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7D, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F7D, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F7D, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F7D, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F7D, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F7D, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F7D, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F7D, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F80, 0x0062; @result = 0x0061, 0x0F71, 0x0F72, 0x0F80, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F74, 0x0F72, 0x0F71, 0x0F80, 0x0062 -> 0x0061, 0x0F71, 0x0F72, 0x0F80, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0F80, 0x0F74, 0x0F72, 0x0F71, 0x0062; @result = 0x0061, 0x0F71, 0x0F80, 0x0F72, 0x0F74, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F80, 0x0F74, 0x0F72, 0x0F71, 0x0062 -> 0x0061, 0x0F71, 0x0F80, 0x0F72, 0x0F74, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0F82, 0x0062; @result = 0x00E0, 0x05AE, 0x0F82, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0F82, 0x0062 -> 0x00E0, 0x05AE, 0x0F82, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0F82, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0F82, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F82, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0F82, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0F83, 0x0062; @result = 0x00E0, 0x05AE, 0x0F83, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0F83, 0x0062 -> 0x00E0, 0x05AE, 0x0F83, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0F83, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0F83, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F83, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0F83, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x0F84, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x0F84, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x0F84, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x0F84, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0F84, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x0F84, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F84, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x0F84, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0F86, 0x0062; @result = 0x00E0, 0x05AE, 0x0F86, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0F86, 0x0062 -> 0x00E0, 0x05AE, 0x0F86, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0F86, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0F86, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F86, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0F86, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x0F87, 0x0062; @result = 0x00E0, 0x05AE, 0x0F87, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x0F87, 0x0062 -> 0x00E0, 0x05AE, 0x0F87, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0F87, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x0F87, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0F87, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x0F87, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x0FC6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x0FC6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x0FC6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x0FC6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0FC6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x0FC6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0FC6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x0FC6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1037, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1037, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1037, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1037, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1037, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1037, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1037, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1037, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1039, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1039, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1039, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1039, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1039, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1039, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1039, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1039, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x103A, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x103A, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x103A, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x103A, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x103A, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x103A, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x103A, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x103A, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x108D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x108D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x108D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x108D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x108D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x108D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x108D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x108D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x135D, 0x0062; @result = 0x00E0, 0x05AE, 0x135D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x135D, 0x0062 -> 0x00E0, 0x05AE, 0x135D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x135D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x135D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x135D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x135D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x135E, 0x0062; @result = 0x00E0, 0x05AE, 0x135E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x135E, 0x0062 -> 0x00E0, 0x05AE, 0x135E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x135E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x135E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x135E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x135E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x135F, 0x0062; @result = 0x00E0, 0x05AE, 0x135F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x135F, 0x0062 -> 0x00E0, 0x05AE, 0x135F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x135F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x135F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x135F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x135F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1714, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1714, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1714, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1714, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1714, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1714, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1714, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1714, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1715, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1715, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1715, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1715, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1715, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1715, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1715, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1715, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1734, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1734, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1734, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1734, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1734, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1734, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1734, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1734, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x17D2, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x17D2, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x17D2, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x17D2, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x17D2, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x17D2, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x17D2, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x17D2, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x17DD, 0x0062; @result = 0x00E0, 0x05AE, 0x17DD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x17DD, 0x0062 -> 0x00E0, 0x05AE, 0x17DD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x17DD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x17DD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x17DD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x17DD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x05AE, 0x1D16D, 0x18A9, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x18A9, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x05AE, 0x1D16D, 0x18A9, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x18A9, 0x0062 CONCAT';
@list = 0x0061, 0x18A9, 0x0300, 0x05AE, 0x1D16D, 0x0062; @result = 0x00E0, 0x1D16D, 0x18A9, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x18A9, 0x0300, 0x05AE, 0x1D16D, 0x0062 -> 0x00E0, 0x1D16D, 0x18A9, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x302E, 0x059A, 0x0316, 0x1939, 0x0062; @result = 0x0061, 0x0316, 0x059A, 0x1939, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302E, 0x059A, 0x0316, 0x1939, 0x0062 -> 0x0061, 0x0316, 0x059A, 0x1939, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x1939, 0x302E, 0x059A, 0x0316, 0x0062; @result = 0x0061, 0x0316, 0x1939, 0x059A, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1939, 0x302E, 0x059A, 0x0316, 0x0062 -> 0x0061, 0x0316, 0x1939, 0x059A, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x193A, 0x0062; @result = 0x00E0, 0x05AE, 0x193A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x193A, 0x0062 -> 0x00E0, 0x05AE, 0x193A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x193A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x193A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x193A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x193A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x193B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x193B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x193B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x193B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x193B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x193B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x193B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x193B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A17, 0x0062; @result = 0x00E0, 0x05AE, 0x1A17, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A17, 0x0062 -> 0x00E0, 0x05AE, 0x1A17, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A17, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A17, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A17, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A17, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1A18, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1A18, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1A18, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1A18, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1A18, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1A18, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A18, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1A18, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1A60, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1A60, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1A60, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1A60, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1A60, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1A60, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A60, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1A60, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A75, 0x0062; @result = 0x00E0, 0x05AE, 0x1A75, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A75, 0x0062 -> 0x00E0, 0x05AE, 0x1A75, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A75, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A75, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A75, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A75, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A76, 0x0062; @result = 0x00E0, 0x05AE, 0x1A76, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A76, 0x0062 -> 0x00E0, 0x05AE, 0x1A76, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A76, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A76, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A76, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A76, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A77, 0x0062; @result = 0x00E0, 0x05AE, 0x1A77, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A77, 0x0062 -> 0x00E0, 0x05AE, 0x1A77, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A77, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A77, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A77, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A77, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A78, 0x0062; @result = 0x00E0, 0x05AE, 0x1A78, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A78, 0x0062 -> 0x00E0, 0x05AE, 0x1A78, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A78, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A78, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A78, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A78, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A79, 0x0062; @result = 0x00E0, 0x05AE, 0x1A79, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A79, 0x0062 -> 0x00E0, 0x05AE, 0x1A79, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A79, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A79, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A79, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A79, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7A, 0x0062; @result = 0x00E0, 0x05AE, 0x1A7A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7A, 0x0062 -> 0x00E0, 0x05AE, 0x1A7A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A7A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A7A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A7A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A7A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7B, 0x0062; @result = 0x00E0, 0x05AE, 0x1A7B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7B, 0x0062 -> 0x00E0, 0x05AE, 0x1A7B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A7B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A7B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A7B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A7B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7C, 0x0062; @result = 0x00E0, 0x05AE, 0x1A7C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1A7C, 0x0062 -> 0x00E0, 0x05AE, 0x1A7C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1A7C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1A7C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A7C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1A7C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1A7F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1A7F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1A7F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1A7F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1A7F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1A7F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1A7F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1A7F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB0, 0x0062; @result = 0x00E0, 0x05AE, 0x1AB0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB0, 0x0062 -> 0x00E0, 0x05AE, 0x1AB0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AB0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AB0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AB0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB1, 0x0062; @result = 0x00E0, 0x05AE, 0x1AB1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB1, 0x0062 -> 0x00E0, 0x05AE, 0x1AB1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AB1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AB1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AB1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB2, 0x0062; @result = 0x00E0, 0x05AE, 0x1AB2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB2, 0x0062 -> 0x00E0, 0x05AE, 0x1AB2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AB2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AB2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AB2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB3, 0x0062; @result = 0x00E0, 0x05AE, 0x1AB3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB3, 0x0062 -> 0x00E0, 0x05AE, 0x1AB3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AB3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AB3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AB3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB4, 0x0062; @result = 0x00E0, 0x05AE, 0x1AB4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AB4, 0x0062 -> 0x00E0, 0x05AE, 0x1AB4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AB4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AB4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AB4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB5, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AB5, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB5, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AB5, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AB5, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AB5, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB5, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AB5, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AB6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AB6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AB6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AB6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AB6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB7, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AB7, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB7, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AB7, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AB7, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AB7, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB7, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AB7, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB8, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AB8, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB8, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AB8, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AB8, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AB8, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB8, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AB8, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB9, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AB9, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AB9, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AB9, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AB9, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AB9, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AB9, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AB9, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1ABA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1ABA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1ABA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1ABA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ABA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1ABA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ABB, 0x0062; @result = 0x00E0, 0x05AE, 0x1ABB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ABB, 0x0062 -> 0x00E0, 0x05AE, 0x1ABB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ABB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ABB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ABB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ABB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ABC, 0x0062; @result = 0x00E0, 0x05AE, 0x1ABC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ABC, 0x0062 -> 0x00E0, 0x05AE, 0x1ABC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ABC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ABC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ABC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ABC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1ABD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1ABD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1ABD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1ABD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ABD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1ABD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1ABF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ABF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1ABF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1ABF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1ABF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ABF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1ABF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC0, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AC0, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC0, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AC0, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AC0, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AC0, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC0, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AC0, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC1, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC1, 0x0062 -> 0x00E0, 0x05AE, 0x1AC1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC2, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC2, 0x0062 -> 0x00E0, 0x05AE, 0x1AC2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AC3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AC3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AC3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AC3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AC3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC4, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1AC4, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1AC4, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1AC4, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1AC4, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1AC4, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC4, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1AC4, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC5, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC5, 0x0062 -> 0x00E0, 0x05AE, 0x1AC5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC6, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC6, 0x0062 -> 0x00E0, 0x05AE, 0x1AC6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC7, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC7, 0x0062 -> 0x00E0, 0x05AE, 0x1AC7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC8, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC8, 0x0062 -> 0x00E0, 0x05AE, 0x1AC8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC9, 0x0062; @result = 0x00E0, 0x05AE, 0x1AC9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1AC9, 0x0062 -> 0x00E0, 0x05AE, 0x1AC9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1AC9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1AC9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1AC9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1AC9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ACA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1ACA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1ACA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1ACA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1ACA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1ACA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ACA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1ACA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACB, 0x0062; @result = 0x00E0, 0x05AE, 0x1ACB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACB, 0x0062 -> 0x00E0, 0x05AE, 0x1ACB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ACB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ACB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ACB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ACB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACC, 0x0062; @result = 0x00E0, 0x05AE, 0x1ACC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACC, 0x0062 -> 0x00E0, 0x05AE, 0x1ACC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ACC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ACC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ACC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ACC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACD, 0x0062; @result = 0x00E0, 0x05AE, 0x1ACD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACD, 0x0062 -> 0x00E0, 0x05AE, 0x1ACD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ACD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ACD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ACD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ACD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACE, 0x0062; @result = 0x00E0, 0x05AE, 0x1ACE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1ACE, 0x0062 -> 0x00E0, 0x05AE, 0x1ACE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1ACE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1ACE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1ACE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1ACE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1B34, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1B34, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1B34, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1B34, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1B34, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1B34, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B34, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1B34, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1B44, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1B44, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1B44, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1B44, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1B44, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1B44, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B44, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1B44, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6B, 0x0062; @result = 0x00E0, 0x05AE, 0x1B6B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6B, 0x0062 -> 0x00E0, 0x05AE, 0x1B6B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B6B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B6B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B6B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B6B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1B6C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1B6C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1B6C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1B6C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1B6C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1B6C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B6C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1B6C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6D, 0x0062; @result = 0x00E0, 0x05AE, 0x1B6D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6D, 0x0062 -> 0x00E0, 0x05AE, 0x1B6D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B6D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B6D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B6D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B6D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6E, 0x0062; @result = 0x00E0, 0x05AE, 0x1B6E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6E, 0x0062 -> 0x00E0, 0x05AE, 0x1B6E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B6E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B6E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B6E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B6E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6F, 0x0062; @result = 0x00E0, 0x05AE, 0x1B6F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B6F, 0x0062 -> 0x00E0, 0x05AE, 0x1B6F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B6F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B6F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B6F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B6F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B70, 0x0062; @result = 0x00E0, 0x05AE, 0x1B70, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B70, 0x0062 -> 0x00E0, 0x05AE, 0x1B70, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B70, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B70, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B70, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B70, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B71, 0x0062; @result = 0x00E0, 0x05AE, 0x1B71, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B71, 0x0062 -> 0x00E0, 0x05AE, 0x1B71, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B71, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B71, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B71, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B71, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B72, 0x0062; @result = 0x00E0, 0x05AE, 0x1B72, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B72, 0x0062 -> 0x00E0, 0x05AE, 0x1B72, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B72, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B72, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B72, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B72, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1B73, 0x0062; @result = 0x00E0, 0x05AE, 0x1B73, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1B73, 0x0062 -> 0x00E0, 0x05AE, 0x1B73, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1B73, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1B73, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1B73, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1B73, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1BAA, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1BAA, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1BAA, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1BAA, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1BAA, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1BAA, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BAA, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1BAA, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1BAB, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1BAB, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1BAB, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1BAB, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1BAB, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1BAB, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BAB, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1BAB, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1BE6, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1BE6, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1BE6, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1BE6, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1BE6, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1BE6, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BE6, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1BE6, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF2, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1BF2, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF2, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1BF2, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1BF2, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1BF2, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BF2, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1BF2, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF3, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1BF3, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF3, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1BF3, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1BF3, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1BF3, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BF3, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1BF3, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1C37, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1C37, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1C37, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1C37, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1C37, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1C37, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1C37, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1C37, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD0, 0x0062; @result = 0x00E0, 0x05AE, 0x1CD0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD0, 0x0062 -> 0x00E0, 0x05AE, 0x1CD0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CD0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CD0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CD0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD1, 0x0062; @result = 0x00E0, 0x05AE, 0x1CD1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD1, 0x0062 -> 0x00E0, 0x05AE, 0x1CD1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CD1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CD1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CD1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD2, 0x0062; @result = 0x00E0, 0x05AE, 0x1CD2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD2, 0x0062 -> 0x00E0, 0x05AE, 0x1CD2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CD2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CD2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CD2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CD4, 0x0062; @result = 0x0061, 0x0334, 0x1CD4, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CD4, 0x0062 -> 0x0061, 0x0334, 0x1CD4, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CD4, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CD4, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD4, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CD4, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD5, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CD5, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD5, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CD5, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CD5, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CD5, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD5, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CD5, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CD6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CD6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CD6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CD6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CD6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD7, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CD7, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD7, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CD7, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CD7, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CD7, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD7, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CD7, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD8, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CD8, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD8, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CD8, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CD8, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CD8, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD8, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CD8, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD9, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CD9, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD9, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CD9, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CD9, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CD9, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CD9, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CD9, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDA, 0x0062; @result = 0x00E0, 0x05AE, 0x1CDA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDA, 0x0062 -> 0x00E0, 0x05AE, 0x1CDA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CDA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CDA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CDA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDB, 0x0062; @result = 0x00E0, 0x05AE, 0x1CDB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDB, 0x0062 -> 0x00E0, 0x05AE, 0x1CDB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CDB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CDB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CDB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDC, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CDC, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDC, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CDC, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CDC, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CDC, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDC, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CDC, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CDD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CDD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CDD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CDD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CDD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDE, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CDE, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDE, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CDE, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CDE, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CDE, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDE, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CDE, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CDF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CDF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CDF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CDF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CDF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CDF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CE0, 0x0062; @result = 0x00E0, 0x05AE, 0x1CE0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CE0, 0x0062 -> 0x00E0, 0x05AE, 0x1CE0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CE0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CE0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CE0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE2, 0x0062; @result = 0x0061, 0x0334, 0x1CE2, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE2, 0x0062 -> 0x0061, 0x0334, 0x1CE2, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE2, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE2, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE2, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE2, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE3, 0x0062; @result = 0x0061, 0x0334, 0x1CE3, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE3, 0x0062 -> 0x0061, 0x0334, 0x1CE3, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE3, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE3, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE3, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE3, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE4, 0x0062; @result = 0x0061, 0x0334, 0x1CE4, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE4, 0x0062 -> 0x0061, 0x0334, 0x1CE4, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE4, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE4, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE4, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE4, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE5, 0x0062; @result = 0x0061, 0x0334, 0x1CE5, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE5, 0x0062 -> 0x0061, 0x0334, 0x1CE5, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE5, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE5, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE5, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE5, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE6, 0x0062; @result = 0x0061, 0x0334, 0x1CE6, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE6, 0x0062 -> 0x0061, 0x0334, 0x1CE6, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE6, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE6, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE6, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE6, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE7, 0x0062; @result = 0x0061, 0x0334, 0x1CE7, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE7, 0x0062 -> 0x0061, 0x0334, 0x1CE7, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE7, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE7, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE7, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE7, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1CE8, 0x0062; @result = 0x0061, 0x0334, 0x1CE8, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1CE8, 0x0062 -> 0x0061, 0x0334, 0x1CE8, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1CE8, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1CE8, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CE8, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1CE8, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CED, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1CED, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CED, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1CED, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1CED, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1CED, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CED, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1CED, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF4, 0x0062; @result = 0x00E0, 0x05AE, 0x1CF4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF4, 0x0062 -> 0x00E0, 0x05AE, 0x1CF4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CF4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CF4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CF4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CF4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF8, 0x0062; @result = 0x00E0, 0x05AE, 0x1CF8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF8, 0x0062 -> 0x00E0, 0x05AE, 0x1CF8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CF8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CF8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CF8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CF8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF9, 0x0062; @result = 0x00E0, 0x05AE, 0x1CF9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF9, 0x0062 -> 0x00E0, 0x05AE, 0x1CF9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1CF9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1CF9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1CF9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1CF9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC0, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC0, 0x0062 -> 0x00E0, 0x05AE, 0x1DC0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC1, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC1, 0x0062 -> 0x00E0, 0x05AE, 0x1DC1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DC2, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DC2, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DC2, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DC2, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DC2, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DC2, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC2, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DC2, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC3, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC3, 0x0062 -> 0x00E0, 0x05AE, 0x1DC3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC4, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC4, 0x0062 -> 0x00E0, 0x05AE, 0x1DC4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC5, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC5, 0x0062 -> 0x00E0, 0x05AE, 0x1DC5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC6, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC6, 0x0062 -> 0x00E0, 0x05AE, 0x1DC6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC7, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC7, 0x0062 -> 0x00E0, 0x05AE, 0x1DC7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC8, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC8, 0x0062 -> 0x00E0, 0x05AE, 0x1DC8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC9, 0x0062; @result = 0x00E0, 0x05AE, 0x1DC9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC9, 0x0062 -> 0x00E0, 0x05AE, 0x1DC9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DC9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DC9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DC9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DC9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCA, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DCA, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCA, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DCA, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DCA, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DCA, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCA, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DCA, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCB, 0x0062; @result = 0x00E0, 0x05AE, 0x1DCB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCB, 0x0062 -> 0x00E0, 0x05AE, 0x1DCB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DCB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DCB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DCB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCC, 0x0062; @result = 0x00E0, 0x05AE, 0x1DCC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCC, 0x0062 -> 0x00E0, 0x05AE, 0x1DCC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DCC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DCC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DCC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0345, 0x035D, 0x035C, 0x1DCD, 0x0062; @result = 0x0061, 0x035C, 0x035D, 0x1DCD, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0345, 0x035D, 0x035C, 0x1DCD, 0x0062 -> 0x0061, 0x035C, 0x035D, 0x1DCD, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x1DCD, 0x0345, 0x035D, 0x035C, 0x0062; @result = 0x0061, 0x035C, 0x1DCD, 0x035D, 0x0345, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCD, 0x0345, 0x035D, 0x035C, 0x0062 -> 0x0061, 0x035C, 0x1DCD, 0x035D, 0x0345, 0x0062 CONCAT';
@list = 0x0061, 0x031B, 0x1DCE, 0x0321, 0x1DCE, 0x0062; @result = 0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x031B, 0x1DCE, 0x0321, 0x1DCE, 0x0062 -> 0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x031B, 0x1DCE, 0x0321, 0x0062; @result = 0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x031B, 0x1DCE, 0x0321, 0x0062 -> 0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DCF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DCF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DCF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DCF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DCF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DCE, 0x0321, 0x0F74, 0x1DD0, 0x0062; @result = 0x0061, 0x0F74, 0x0321, 0x1DD0, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DCE, 0x0321, 0x0F74, 0x1DD0, 0x0062 -> 0x0061, 0x0F74, 0x0321, 0x1DD0, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x1DD0, 0x1DCE, 0x0321, 0x0F74, 0x0062; @result = 0x0061, 0x0F74, 0x1DD0, 0x0321, 0x1DCE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD0, 0x1DCE, 0x0321, 0x0F74, 0x0062 -> 0x0061, 0x0F74, 0x1DD0, 0x0321, 0x1DCE, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD1, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD1, 0x0062 -> 0x00E0, 0x05AE, 0x1DD1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD2, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD2, 0x0062 -> 0x00E0, 0x05AE, 0x1DD2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD3, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD3, 0x0062 -> 0x00E0, 0x05AE, 0x1DD3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD4, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD4, 0x0062 -> 0x00E0, 0x05AE, 0x1DD4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD5, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD5, 0x0062 -> 0x00E0, 0x05AE, 0x1DD5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD6, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD6, 0x0062 -> 0x00E0, 0x05AE, 0x1DD6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD7, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD7, 0x0062 -> 0x00E0, 0x05AE, 0x1DD7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD8, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD8, 0x0062 -> 0x00E0, 0x05AE, 0x1DD8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD9, 0x0062; @result = 0x00E0, 0x05AE, 0x1DD9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD9, 0x0062 -> 0x00E0, 0x05AE, 0x1DD9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DD9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DD9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DD9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DD9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDA, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDA, 0x0062 -> 0x00E0, 0x05AE, 0x1DDA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDB, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDB, 0x0062 -> 0x00E0, 0x05AE, 0x1DDB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDC, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDC, 0x0062 -> 0x00E0, 0x05AE, 0x1DDC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDD, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDD, 0x0062 -> 0x00E0, 0x05AE, 0x1DDD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDE, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDE, 0x0062 -> 0x00E0, 0x05AE, 0x1DDE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDF, 0x0062; @result = 0x00E0, 0x05AE, 0x1DDF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDF, 0x0062 -> 0x00E0, 0x05AE, 0x1DDF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DDF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DDF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DDF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DDF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE0, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE0, 0x0062 -> 0x00E0, 0x05AE, 0x1DE0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE1, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE1, 0x0062 -> 0x00E0, 0x05AE, 0x1DE1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE2, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE2, 0x0062 -> 0x00E0, 0x05AE, 0x1DE2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE3, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE3, 0x0062 -> 0x00E0, 0x05AE, 0x1DE3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE4, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE4, 0x0062 -> 0x00E0, 0x05AE, 0x1DE4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE5, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE5, 0x0062 -> 0x00E0, 0x05AE, 0x1DE5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE6, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE6, 0x0062 -> 0x00E0, 0x05AE, 0x1DE6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE7, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE7, 0x0062 -> 0x00E0, 0x05AE, 0x1DE7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE8, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE8, 0x0062 -> 0x00E0, 0x05AE, 0x1DE8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE9, 0x0062; @result = 0x00E0, 0x05AE, 0x1DE9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE9, 0x0062 -> 0x00E0, 0x05AE, 0x1DE9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DE9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DE9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DE9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DE9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEA, 0x0062; @result = 0x00E0, 0x05AE, 0x1DEA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEA, 0x0062 -> 0x00E0, 0x05AE, 0x1DEA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DEA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DEA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DEA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DEA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEB, 0x0062; @result = 0x00E0, 0x05AE, 0x1DEB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEB, 0x0062 -> 0x00E0, 0x05AE, 0x1DEB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DEB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DEB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DEB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DEB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEC, 0x0062; @result = 0x00E0, 0x05AE, 0x1DEC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEC, 0x0062 -> 0x00E0, 0x05AE, 0x1DEC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DEC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DEC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DEC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DEC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DED, 0x0062; @result = 0x00E0, 0x05AE, 0x1DED, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DED, 0x0062 -> 0x00E0, 0x05AE, 0x1DED, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DED, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DED, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DED, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DED, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEE, 0x0062; @result = 0x00E0, 0x05AE, 0x1DEE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEE, 0x0062 -> 0x00E0, 0x05AE, 0x1DEE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DEE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DEE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DEE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DEE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEF, 0x0062; @result = 0x00E0, 0x05AE, 0x1DEF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEF, 0x0062 -> 0x00E0, 0x05AE, 0x1DEF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DEF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DEF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DEF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DEF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF0, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF0, 0x0062 -> 0x00E0, 0x05AE, 0x1DF0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF1, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF1, 0x0062 -> 0x00E0, 0x05AE, 0x1DF1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF2, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF2, 0x0062 -> 0x00E0, 0x05AE, 0x1DF2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF3, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF3, 0x0062 -> 0x00E0, 0x05AE, 0x1DF3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF4, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF4, 0x0062 -> 0x00E0, 0x05AE, 0x1DF4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF5, 0x0062; @result = 0x00E0, 0x05AE, 0x1DF5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF5, 0x0062 -> 0x00E0, 0x05AE, 0x1DF5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DF5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DF5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DF5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x1DF6, 0x0062; @result = 0x00E0, 0x0315, 0x1DF6, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x1DF6, 0x0062 -> 0x00E0, 0x0315, 0x1DF6, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x1DF6, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x1DF6, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF6, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x1DF6, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF7, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x1DF7, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF7, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x1DF7, 0x0062 CONCAT';
@list = 0x0061, 0x1DF7, 0x0300, 0x05AE, 0x1D16D, 0x0062; @result = 0x00E0, 0x1D16D, 0x1DF7, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF7, 0x0300, 0x05AE, 0x1D16D, 0x0062 -> 0x00E0, 0x1D16D, 0x1DF7, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF8, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x1DF8, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF8, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x1DF8, 0x0062 CONCAT';
@list = 0x0061, 0x1DF8, 0x0300, 0x05AE, 0x1D16D, 0x0062; @result = 0x00E0, 0x1D16D, 0x1DF8, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF8, 0x0300, 0x05AE, 0x1D16D, 0x0062 -> 0x00E0, 0x1D16D, 0x1DF8, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DF9, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DF9, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DF9, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DF9, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DF9, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DF9, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DF9, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DF9, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0316, 0x1DFA, 0x031B, 0x1DFA, 0x0062; @result = 0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0316, 0x1DFA, 0x031B, 0x1DFA, 0x0062 -> 0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x0316, 0x1DFA, 0x031B, 0x0062; @result = 0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x0316, 0x1DFA, 0x031B, 0x0062 -> 0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFB, 0x0062; @result = 0x00E0, 0x05AE, 0x1DFB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFB, 0x0062 -> 0x00E0, 0x05AE, 0x1DFB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DFB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DFB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DFB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035D, 0x035C, 0x0315, 0x1DFC, 0x0062; @result = 0x0061, 0x0315, 0x035C, 0x1DFC, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035D, 0x035C, 0x0315, 0x1DFC, 0x0062 -> 0x0061, 0x0315, 0x035C, 0x1DFC, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x1DFC, 0x035D, 0x035C, 0x0315, 0x0062; @result = 0x0061, 0x0315, 0x1DFC, 0x035C, 0x035D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFC, 0x035D, 0x035C, 0x0315, 0x0062 -> 0x0061, 0x0315, 0x1DFC, 0x035C, 0x035D, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DFD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DFD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DFD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DFD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DFD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFE, 0x0062; @result = 0x00E0, 0x05AE, 0x1DFE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFE, 0x0062 -> 0x00E0, 0x05AE, 0x1DFE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1DFE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1DFE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1DFE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1DFF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1DFF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1DFF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1DFF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1DFF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D0, 0x0062; @result = 0x00E0, 0x05AE, 0x20D0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D0, 0x0062 -> 0x00E0, 0x05AE, 0x20D0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D1, 0x0062; @result = 0x00E0, 0x05AE, 0x20D1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D1, 0x0062 -> 0x00E0, 0x05AE, 0x20D1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20D2, 0x0062; @result = 0x0061, 0x0334, 0x20D2, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20D2, 0x0062 -> 0x0061, 0x0334, 0x20D2, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20D2, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20D2, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D2, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20D2, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20D3, 0x0062; @result = 0x0061, 0x0334, 0x20D3, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20D3, 0x0062 -> 0x0061, 0x0334, 0x20D3, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20D3, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20D3, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D3, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20D3, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D4, 0x0062; @result = 0x00E0, 0x05AE, 0x20D4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D4, 0x0062 -> 0x00E0, 0x05AE, 0x20D4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D5, 0x0062; @result = 0x00E0, 0x05AE, 0x20D5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D5, 0x0062 -> 0x00E0, 0x05AE, 0x20D5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D6, 0x0062; @result = 0x00E0, 0x05AE, 0x20D6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D6, 0x0062 -> 0x00E0, 0x05AE, 0x20D6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20D7, 0x0062; @result = 0x00E0, 0x05AE, 0x20D7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20D7, 0x0062 -> 0x00E0, 0x05AE, 0x20D7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20D7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20D7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20D7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20D8, 0x0062; @result = 0x0061, 0x0334, 0x20D8, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20D8, 0x0062 -> 0x0061, 0x0334, 0x20D8, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20D8, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20D8, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D8, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20D8, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20D9, 0x0062; @result = 0x0061, 0x0334, 0x20D9, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20D9, 0x0062 -> 0x0061, 0x0334, 0x20D9, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20D9, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20D9, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20D9, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20D9, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20DA, 0x0062; @result = 0x0061, 0x0334, 0x20DA, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20DA, 0x0062 -> 0x0061, 0x0334, 0x20DA, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20DA, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20DA, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20DA, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20DA, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20DB, 0x0062; @result = 0x00E0, 0x05AE, 0x20DB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20DB, 0x0062 -> 0x00E0, 0x05AE, 0x20DB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20DB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20DB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20DB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20DB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20DC, 0x0062; @result = 0x00E0, 0x05AE, 0x20DC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20DC, 0x0062 -> 0x00E0, 0x05AE, 0x20DC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20DC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20DC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20DC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20DC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20E1, 0x0062; @result = 0x00E0, 0x05AE, 0x20E1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20E1, 0x0062 -> 0x00E0, 0x05AE, 0x20E1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20E1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20E1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20E1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20E5, 0x0062; @result = 0x0061, 0x0334, 0x20E5, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20E5, 0x0062 -> 0x0061, 0x0334, 0x20E5, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20E5, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20E5, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E5, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20E5, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20E6, 0x0062; @result = 0x0061, 0x0334, 0x20E6, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20E6, 0x0062 -> 0x0061, 0x0334, 0x20E6, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20E6, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20E6, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E6, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20E6, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20E7, 0x0062; @result = 0x00E0, 0x05AE, 0x20E7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20E7, 0x0062 -> 0x00E0, 0x05AE, 0x20E7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20E7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20E7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20E7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x20E8, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x20E8, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x20E8, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x20E8, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x20E8, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x20E8, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E8, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x20E8, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20E9, 0x0062; @result = 0x00E0, 0x05AE, 0x20E9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20E9, 0x0062 -> 0x00E0, 0x05AE, 0x20E9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20E9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20E9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20E9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20E9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20EA, 0x0062; @result = 0x0061, 0x0334, 0x20EA, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20EA, 0x0062 -> 0x0061, 0x0334, 0x20EA, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20EA, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20EA, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20EA, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20EA, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x20EB, 0x0062; @result = 0x0061, 0x0334, 0x20EB, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x20EB, 0x0062 -> 0x0061, 0x0334, 0x20EB, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x20EB, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x20EB, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20EB, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x20EB, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EC, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x20EC, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EC, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x20EC, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x20EC, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x20EC, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20EC, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x20EC, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x20ED, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x20ED, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x20ED, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x20ED, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x20ED, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x20ED, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20ED, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x20ED, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EE, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x20EE, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EE, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x20EE, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x20EE, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x20EE, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20EE, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x20EE, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x20EF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x20EF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x20EF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x20EF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20EF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x20EF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x20F0, 0x0062; @result = 0x00E0, 0x05AE, 0x20F0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x20F0, 0x0062 -> 0x00E0, 0x05AE, 0x20F0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x20F0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x20F0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x20F0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x20F0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2CEF, 0x0062; @result = 0x00E0, 0x05AE, 0x2CEF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2CEF, 0x0062 -> 0x00E0, 0x05AE, 0x2CEF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2CEF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2CEF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2CEF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2CEF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF0, 0x0062; @result = 0x00E0, 0x05AE, 0x2CF0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF0, 0x0062 -> 0x00E0, 0x05AE, 0x2CF0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2CF0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2CF0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2CF0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2CF0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF1, 0x0062; @result = 0x00E0, 0x05AE, 0x2CF1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF1, 0x0062 -> 0x00E0, 0x05AE, 0x2CF1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2CF1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2CF1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2CF1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2CF1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x2D7F, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x2D7F, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x2D7F, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x2D7F, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x2D7F, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x2D7F, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2D7F, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x2D7F, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE0, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE0, 0x0062 -> 0x00E0, 0x05AE, 0x2DE0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE1, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE1, 0x0062 -> 0x00E0, 0x05AE, 0x2DE1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE2, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE2, 0x0062 -> 0x00E0, 0x05AE, 0x2DE2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE3, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE3, 0x0062 -> 0x00E0, 0x05AE, 0x2DE3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE4, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE4, 0x0062 -> 0x00E0, 0x05AE, 0x2DE4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE5, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE5, 0x0062 -> 0x00E0, 0x05AE, 0x2DE5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE6, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE6, 0x0062 -> 0x00E0, 0x05AE, 0x2DE6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE7, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE7, 0x0062 -> 0x00E0, 0x05AE, 0x2DE7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE8, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE8, 0x0062 -> 0x00E0, 0x05AE, 0x2DE8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE9, 0x0062; @result = 0x00E0, 0x05AE, 0x2DE9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE9, 0x0062 -> 0x00E0, 0x05AE, 0x2DE9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DE9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DE9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DE9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DE9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEA, 0x0062; @result = 0x00E0, 0x05AE, 0x2DEA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEA, 0x0062 -> 0x00E0, 0x05AE, 0x2DEA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DEA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DEA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DEA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DEA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEB, 0x0062; @result = 0x00E0, 0x05AE, 0x2DEB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEB, 0x0062 -> 0x00E0, 0x05AE, 0x2DEB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DEB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DEB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DEB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DEB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEC, 0x0062; @result = 0x00E0, 0x05AE, 0x2DEC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEC, 0x0062 -> 0x00E0, 0x05AE, 0x2DEC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DEC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DEC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DEC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DEC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DED, 0x0062; @result = 0x00E0, 0x05AE, 0x2DED, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DED, 0x0062 -> 0x00E0, 0x05AE, 0x2DED, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DED, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DED, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DED, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DED, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEE, 0x0062; @result = 0x00E0, 0x05AE, 0x2DEE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEE, 0x0062 -> 0x00E0, 0x05AE, 0x2DEE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DEE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DEE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DEE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DEE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEF, 0x0062; @result = 0x00E0, 0x05AE, 0x2DEF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEF, 0x0062 -> 0x00E0, 0x05AE, 0x2DEF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DEF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DEF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DEF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DEF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF0, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF0, 0x0062 -> 0x00E0, 0x05AE, 0x2DF0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF1, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF1, 0x0062 -> 0x00E0, 0x05AE, 0x2DF1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF2, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF2, 0x0062 -> 0x00E0, 0x05AE, 0x2DF2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF3, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF3, 0x0062 -> 0x00E0, 0x05AE, 0x2DF3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF4, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF4, 0x0062 -> 0x00E0, 0x05AE, 0x2DF4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF5, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF5, 0x0062 -> 0x00E0, 0x05AE, 0x2DF5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF6, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF6, 0x0062 -> 0x00E0, 0x05AE, 0x2DF6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF7, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF7, 0x0062 -> 0x00E0, 0x05AE, 0x2DF7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF8, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF8, 0x0062 -> 0x00E0, 0x05AE, 0x2DF8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF9, 0x0062; @result = 0x00E0, 0x05AE, 0x2DF9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF9, 0x0062 -> 0x00E0, 0x05AE, 0x2DF9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DF9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DF9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DF9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DF9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFA, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFA, 0x0062 -> 0x00E0, 0x05AE, 0x2DFA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFB, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFB, 0x0062 -> 0x00E0, 0x05AE, 0x2DFB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFC, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFC, 0x0062 -> 0x00E0, 0x05AE, 0x2DFC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFD, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFD, 0x0062 -> 0x00E0, 0x05AE, 0x2DFD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFE, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFE, 0x0062 -> 0x00E0, 0x05AE, 0x2DFE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFF, 0x0062; @result = 0x00E0, 0x05AE, 0x2DFF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFF, 0x0062 -> 0x00E0, 0x05AE, 0x2DFF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x2DFF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x2DFF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x2DFF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x2DFF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0316, 0x1DFA, 0x031B, 0x302A, 0x0062; @result = 0x0061, 0x031B, 0x1DFA, 0x302A, 0x0316, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0316, 0x1DFA, 0x031B, 0x302A, 0x0062 -> 0x0061, 0x031B, 0x1DFA, 0x302A, 0x0316, 0x0062 CONCAT';
@list = 0x0061, 0x302A, 0x0316, 0x1DFA, 0x031B, 0x0062; @result = 0x0061, 0x031B, 0x302A, 0x1DFA, 0x0316, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302A, 0x0316, 0x1DFA, 0x031B, 0x0062 -> 0x0061, 0x031B, 0x302A, 0x1DFA, 0x0316, 0x0062 CONCAT';
@list = 0x0061, 0x0300, 0x05AE, 0x1D16D, 0x302B, 0x0062; @result = 0x00E0, 0x1D16D, 0x05AE, 0x302B, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0300, 0x05AE, 0x1D16D, 0x302B, 0x0062 -> 0x00E0, 0x1D16D, 0x05AE, 0x302B, 0x0062 CONCAT';
@list = 0x0061, 0x302B, 0x0300, 0x05AE, 0x1D16D, 0x0062; @result = 0x00E0, 0x1D16D, 0x302B, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302B, 0x0300, 0x05AE, 0x1D16D, 0x0062 -> 0x00E0, 0x1D16D, 0x302B, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x302C, 0x0062; @result = 0x00E0, 0x0315, 0x302C, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x302C, 0x0062 -> 0x00E0, 0x0315, 0x302C, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x302C, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x302C, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302C, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x302C, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x302E, 0x059A, 0x0316, 0x302D, 0x0062; @result = 0x0061, 0x0316, 0x059A, 0x302D, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302E, 0x059A, 0x0316, 0x302D, 0x0062 -> 0x0061, 0x0316, 0x059A, 0x302D, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x302D, 0x302E, 0x059A, 0x0316, 0x0062; @result = 0x0061, 0x0316, 0x302D, 0x059A, 0x302E, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302D, 0x302E, 0x059A, 0x0316, 0x0062 -> 0x0061, 0x0316, 0x302D, 0x059A, 0x302E, 0x0062 CONCAT';
@list = 0x0061, 0x1D16D, 0x302E, 0x059A, 0x302E, 0x0062; @result = 0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D16D, 0x302E, 0x059A, 0x302E, 0x0062 -> 0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062 CONCAT';
@list = 0x0061, 0x302E, 0x1D16D, 0x302E, 0x059A, 0x0062; @result = 0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302E, 0x1D16D, 0x302E, 0x059A, 0x0062 -> 0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062 CONCAT';
@list = 0x0061, 0x1D16D, 0x302E, 0x059A, 0x302F, 0x0062; @result = 0x0061, 0x059A, 0x302E, 0x302F, 0x1D16D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D16D, 0x302E, 0x059A, 0x302F, 0x0062 -> 0x0061, 0x059A, 0x302E, 0x302F, 0x1D16D, 0x0062 CONCAT';
@list = 0x0061, 0x302F, 0x1D16D, 0x302E, 0x059A, 0x0062; @result = 0x0061, 0x059A, 0x302F, 0x302E, 0x1D16D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x302F, 0x1D16D, 0x302E, 0x059A, 0x0062 -> 0x0061, 0x059A, 0x302F, 0x302E, 0x1D16D, 0x0062 CONCAT';
@list = 0x0061, 0x094D, 0x3099, 0x093C, 0x3099, 0x0062; @result = 0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x094D, 0x3099, 0x093C, 0x3099, 0x0062 -> 0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x094D, 0x3099, 0x093C, 0x0062; @result = 0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x094D, 0x3099, 0x093C, 0x0062 -> 0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062 CONCAT';
@list = 0x0061, 0x094D, 0x3099, 0x093C, 0x309A, 0x0062; @result = 0x0061, 0x093C, 0x3099, 0x309A, 0x094D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x094D, 0x3099, 0x093C, 0x309A, 0x0062 -> 0x0061, 0x093C, 0x3099, 0x309A, 0x094D, 0x0062 CONCAT';
@list = 0x0061, 0x309A, 0x094D, 0x3099, 0x093C, 0x0062; @result = 0x0061, 0x093C, 0x309A, 0x3099, 0x094D, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x309A, 0x094D, 0x3099, 0x093C, 0x0062 -> 0x0061, 0x093C, 0x309A, 0x3099, 0x094D, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA66F, 0x0062; @result = 0x00E0, 0x05AE, 0xA66F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA66F, 0x0062 -> 0x00E0, 0x05AE, 0xA66F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA66F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA66F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA66F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA66F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA674, 0x0062; @result = 0x00E0, 0x05AE, 0xA674, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA674, 0x0062 -> 0x00E0, 0x05AE, 0xA674, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA674, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA674, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA674, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA674, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA675, 0x0062; @result = 0x00E0, 0x05AE, 0xA675, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA675, 0x0062 -> 0x00E0, 0x05AE, 0xA675, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA675, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA675, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA675, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA675, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA676, 0x0062; @result = 0x00E0, 0x05AE, 0xA676, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA676, 0x0062 -> 0x00E0, 0x05AE, 0xA676, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA676, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA676, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA676, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA676, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA677, 0x0062; @result = 0x00E0, 0x05AE, 0xA677, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA677, 0x0062 -> 0x00E0, 0x05AE, 0xA677, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA677, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA677, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA677, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA677, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA678, 0x0062; @result = 0x00E0, 0x05AE, 0xA678, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA678, 0x0062 -> 0x00E0, 0x05AE, 0xA678, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA678, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA678, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA678, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA678, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA679, 0x0062; @result = 0x00E0, 0x05AE, 0xA679, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA679, 0x0062 -> 0x00E0, 0x05AE, 0xA679, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA679, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA679, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA679, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA679, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA67A, 0x0062; @result = 0x00E0, 0x05AE, 0xA67A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA67A, 0x0062 -> 0x00E0, 0x05AE, 0xA67A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA67A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA67A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA67A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA67A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA67B, 0x0062; @result = 0x00E0, 0x05AE, 0xA67B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA67B, 0x0062 -> 0x00E0, 0x05AE, 0xA67B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA67B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA67B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA67B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA67B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA67C, 0x0062; @result = 0x00E0, 0x05AE, 0xA67C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA67C, 0x0062 -> 0x00E0, 0x05AE, 0xA67C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA67C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA67C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA67C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA67C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA67D, 0x0062; @result = 0x00E0, 0x05AE, 0xA67D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA67D, 0x0062 -> 0x00E0, 0x05AE, 0xA67D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA67D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA67D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA67D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA67D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA69E, 0x0062; @result = 0x00E0, 0x05AE, 0xA69E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA69E, 0x0062 -> 0x00E0, 0x05AE, 0xA69E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA69E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA69E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA69E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA69E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA69F, 0x0062; @result = 0x00E0, 0x05AE, 0xA69F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA69F, 0x0062 -> 0x00E0, 0x05AE, 0xA69F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA69F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA69F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA69F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA69F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F0, 0x0062; @result = 0x00E0, 0x05AE, 0xA6F0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F0, 0x0062 -> 0x00E0, 0x05AE, 0xA6F0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA6F0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA6F0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA6F0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA6F0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F1, 0x0062; @result = 0x00E0, 0x05AE, 0xA6F1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F1, 0x0062 -> 0x00E0, 0x05AE, 0xA6F1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA6F1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA6F1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA6F1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA6F1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xA806, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xA806, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xA806, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xA806, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xA806, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xA806, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA806, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xA806, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xA82C, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xA82C, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xA82C, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xA82C, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xA82C, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xA82C, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA82C, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xA82C, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xA8C4, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xA8C4, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xA8C4, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xA8C4, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xA8C4, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xA8C4, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8C4, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xA8C4, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E0, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E0, 0x0062 -> 0x00E0, 0x05AE, 0xA8E0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E1, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E1, 0x0062 -> 0x00E0, 0x05AE, 0xA8E1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E2, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E2, 0x0062 -> 0x00E0, 0x05AE, 0xA8E2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E3, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E3, 0x0062 -> 0x00E0, 0x05AE, 0xA8E3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E4, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E4, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E4, 0x0062 -> 0x00E0, 0x05AE, 0xA8E4, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E4, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E4, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E4, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E4, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E5, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E5, 0x0062 -> 0x00E0, 0x05AE, 0xA8E5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E6, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E6, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E6, 0x0062 -> 0x00E0, 0x05AE, 0xA8E6, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E6, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E6, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E6, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E6, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E7, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E7, 0x0062 -> 0x00E0, 0x05AE, 0xA8E7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E8, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E8, 0x0062 -> 0x00E0, 0x05AE, 0xA8E8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E9, 0x0062; @result = 0x00E0, 0x05AE, 0xA8E9, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E9, 0x0062 -> 0x00E0, 0x05AE, 0xA8E9, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8E9, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8E9, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8E9, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8E9, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EA, 0x0062; @result = 0x00E0, 0x05AE, 0xA8EA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EA, 0x0062 -> 0x00E0, 0x05AE, 0xA8EA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8EA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8EA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8EA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8EA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EB, 0x0062; @result = 0x00E0, 0x05AE, 0xA8EB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EB, 0x0062 -> 0x00E0, 0x05AE, 0xA8EB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8EB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8EB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8EB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8EB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EC, 0x0062; @result = 0x00E0, 0x05AE, 0xA8EC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EC, 0x0062 -> 0x00E0, 0x05AE, 0xA8EC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8EC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8EC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8EC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8EC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8ED, 0x0062; @result = 0x00E0, 0x05AE, 0xA8ED, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8ED, 0x0062 -> 0x00E0, 0x05AE, 0xA8ED, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8ED, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8ED, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8ED, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8ED, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EE, 0x0062; @result = 0x00E0, 0x05AE, 0xA8EE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EE, 0x0062 -> 0x00E0, 0x05AE, 0xA8EE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8EE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8EE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8EE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8EE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EF, 0x0062; @result = 0x00E0, 0x05AE, 0xA8EF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EF, 0x0062 -> 0x00E0, 0x05AE, 0xA8EF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8EF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8EF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8EF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8EF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F0, 0x0062; @result = 0x00E0, 0x05AE, 0xA8F0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F0, 0x0062 -> 0x00E0, 0x05AE, 0xA8F0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8F0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8F0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8F0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8F0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F1, 0x0062; @result = 0x00E0, 0x05AE, 0xA8F1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F1, 0x0062 -> 0x00E0, 0x05AE, 0xA8F1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xA8F1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xA8F1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA8F1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xA8F1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xA92B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xA92B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xA92B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xA92B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA92B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xA92B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xA92C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xA92C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xA92C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xA92C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA92C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xA92C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xA92D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xA92D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xA92D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xA92D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA92D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xA92D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xA953, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xA953, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xA953, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xA953, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xA953, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xA953, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA953, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xA953, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0xA9B3, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0xA9B3, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0xA9B3, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0xA9B3, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0xA9B3, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0xA9B3, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA9B3, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0xA9B3, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xA9C0, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xA9C0, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xA9C0, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xA9C0, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xA9C0, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xA9C0, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xA9C0, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xA9C0, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB0, 0x0062; @result = 0x00E0, 0x05AE, 0xAAB0, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB0, 0x0062 -> 0x00E0, 0x05AE, 0xAAB0, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAB0, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAB0, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB0, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAB0, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB2, 0x0062; @result = 0x00E0, 0x05AE, 0xAAB2, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB2, 0x0062 -> 0x00E0, 0x05AE, 0xAAB2, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAB2, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAB2, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB2, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAB2, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB3, 0x0062; @result = 0x00E0, 0x05AE, 0xAAB3, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB3, 0x0062 -> 0x00E0, 0x05AE, 0xAAB3, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAB3, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAB3, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB3, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAB3, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xAAB4, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xAAB4, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xAAB4, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xAAB4, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xAAB4, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xAAB4, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB4, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xAAB4, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB7, 0x0062; @result = 0x00E0, 0x05AE, 0xAAB7, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB7, 0x0062 -> 0x00E0, 0x05AE, 0xAAB7, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAB7, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAB7, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB7, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAB7, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB8, 0x0062; @result = 0x00E0, 0x05AE, 0xAAB8, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB8, 0x0062 -> 0x00E0, 0x05AE, 0xAAB8, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAB8, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAB8, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAB8, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAB8, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAABE, 0x0062; @result = 0x00E0, 0x05AE, 0xAABE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAABE, 0x0062 -> 0x00E0, 0x05AE, 0xAABE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAABE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAABE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAABE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAABE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAABF, 0x0062; @result = 0x00E0, 0x05AE, 0xAABF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAABF, 0x0062 -> 0x00E0, 0x05AE, 0xAABF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAABF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAABF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAABF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAABF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xAAC1, 0x0062; @result = 0x00E0, 0x05AE, 0xAAC1, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xAAC1, 0x0062 -> 0x00E0, 0x05AE, 0xAAC1, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xAAC1, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xAAC1, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAC1, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xAAC1, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xAAF6, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xAAF6, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xAAF6, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xAAF6, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xAAF6, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xAAF6, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xAAF6, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xAAF6, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0xABED, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0xABED, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0xABED, 0x0062 -> 0x0061, 0x3099, 0x094D, 0xABED, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0xABED, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0xABED, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xABED, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0xABED, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x064B, 0xFB1E, 0x05C2, 0xFB1E, 0x0062; @result = 0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x064B, 0xFB1E, 0x05C2, 0xFB1E, 0x0062 -> 0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062 CONCAT';
@list = 0x0061, 0xFB1E, 0x064B, 0xFB1E, 0x05C2, 0x0062; @result = 0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFB1E, 0x064B, 0xFB1E, 0x05C2, 0x0062 -> 0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE20, 0x0062; @result = 0x00E0, 0x05AE, 0xFE20, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE20, 0x0062 -> 0x00E0, 0x05AE, 0xFE20, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE20, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE20, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE20, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE20, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE21, 0x0062; @result = 0x00E0, 0x05AE, 0xFE21, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE21, 0x0062 -> 0x00E0, 0x05AE, 0xFE21, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE21, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE21, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE21, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE21, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE22, 0x0062; @result = 0x00E0, 0x05AE, 0xFE22, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE22, 0x0062 -> 0x00E0, 0x05AE, 0xFE22, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE22, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE22, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE22, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE22, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE23, 0x0062; @result = 0x00E0, 0x05AE, 0xFE23, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE23, 0x0062 -> 0x00E0, 0x05AE, 0xFE23, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE23, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE23, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE23, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE23, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE24, 0x0062; @result = 0x00E0, 0x05AE, 0xFE24, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE24, 0x0062 -> 0x00E0, 0x05AE, 0xFE24, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE24, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE24, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE24, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE24, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE25, 0x0062; @result = 0x00E0, 0x05AE, 0xFE25, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE25, 0x0062 -> 0x00E0, 0x05AE, 0xFE25, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE25, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE25, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE25, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE25, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE26, 0x0062; @result = 0x00E0, 0x05AE, 0xFE26, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE26, 0x0062 -> 0x00E0, 0x05AE, 0xFE26, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE26, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE26, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE26, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE26, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE27, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE27, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE27, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE27, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE27, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE27, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE27, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE27, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE28, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE28, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE28, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE28, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE28, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE28, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE28, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE28, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE29, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE29, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE29, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE29, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE29, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE29, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE29, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE29, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE2A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE2A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE2A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE2A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE2A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE2B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE2B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE2B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE2B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE2B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE2C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE2C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE2C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE2C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE2C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0xFE2D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0xFE2D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0xFE2D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0xFE2D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0xFE2D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2E, 0x0062; @result = 0x00E0, 0x05AE, 0xFE2E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2E, 0x0062 -> 0x00E0, 0x05AE, 0xFE2E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE2E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE2E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE2E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2F, 0x0062; @result = 0x00E0, 0x05AE, 0xFE2F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2F, 0x0062 -> 0x00E0, 0x05AE, 0xFE2F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0xFE2F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0xFE2F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0xFE2F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0xFE2F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x101FD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x101FD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x101FD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x101FD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x101FD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x101FD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x101FD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x101FD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x102E0, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x102E0, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x102E0, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x102E0, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x102E0, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x102E0, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x102E0, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x102E0, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10376, 0x0062; @result = 0x00E0, 0x05AE, 0x10376, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10376, 0x0062 -> 0x00E0, 0x05AE, 0x10376, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10376, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10376, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10376, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10376, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10377, 0x0062; @result = 0x00E0, 0x05AE, 0x10377, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10377, 0x0062 -> 0x00E0, 0x05AE, 0x10377, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10377, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10377, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10377, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10377, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10378, 0x0062; @result = 0x00E0, 0x05AE, 0x10378, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10378, 0x0062 -> 0x00E0, 0x05AE, 0x10378, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10378, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10378, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10378, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10378, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10379, 0x0062; @result = 0x00E0, 0x05AE, 0x10379, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10379, 0x0062 -> 0x00E0, 0x05AE, 0x10379, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10379, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10379, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10379, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10379, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1037A, 0x0062; @result = 0x00E0, 0x05AE, 0x1037A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1037A, 0x0062 -> 0x00E0, 0x05AE, 0x1037A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1037A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1037A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1037A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1037A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A0D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10A0D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A0D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10A0D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10A0D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10A0D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A0D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10A0D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10A0F, 0x0062; @result = 0x00E0, 0x05AE, 0x10A0F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10A0F, 0x0062 -> 0x00E0, 0x05AE, 0x10A0F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10A0F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10A0F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A0F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10A0F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10A38, 0x0062; @result = 0x00E0, 0x05AE, 0x10A38, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10A38, 0x0062 -> 0x00E0, 0x05AE, 0x10A38, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10A38, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10A38, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A38, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10A38, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x10A39, 0x0062; @result = 0x0061, 0x0334, 0x10A39, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x10A39, 0x0062 -> 0x0061, 0x0334, 0x10A39, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x10A39, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x10A39, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A39, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x10A39, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A3A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10A3A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A3A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10A3A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10A3A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10A3A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A3A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10A3A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x10A3F, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x10A3F, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x10A3F, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x10A3F, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x10A3F, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x10A3F, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10A3F, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x10A3F, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10AE5, 0x0062; @result = 0x00E0, 0x05AE, 0x10AE5, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10AE5, 0x0062 -> 0x00E0, 0x05AE, 0x10AE5, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10AE5, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10AE5, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10AE5, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10AE5, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10AE6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10AE6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10AE6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10AE6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10AE6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10AE6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10AE6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10AE6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10D24, 0x0062; @result = 0x00E0, 0x05AE, 0x10D24, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10D24, 0x0062 -> 0x00E0, 0x05AE, 0x10D24, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10D24, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10D24, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10D24, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10D24, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10D25, 0x0062; @result = 0x00E0, 0x05AE, 0x10D25, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10D25, 0x0062 -> 0x00E0, 0x05AE, 0x10D25, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10D25, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10D25, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10D25, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10D25, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10D26, 0x0062; @result = 0x00E0, 0x05AE, 0x10D26, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10D26, 0x0062 -> 0x00E0, 0x05AE, 0x10D26, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10D26, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10D26, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10D26, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10D26, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10D27, 0x0062; @result = 0x00E0, 0x05AE, 0x10D27, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10D27, 0x0062 -> 0x00E0, 0x05AE, 0x10D27, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10D27, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10D27, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10D27, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10D27, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAB, 0x0062; @result = 0x00E0, 0x05AE, 0x10EAB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAB, 0x0062 -> 0x00E0, 0x05AE, 0x10EAB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10EAB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10EAB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10EAB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10EAB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAC, 0x0062; @result = 0x00E0, 0x05AE, 0x10EAC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAC, 0x0062 -> 0x00E0, 0x05AE, 0x10EAC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10EAC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10EAC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10EAC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10EAC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFD, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10EFD, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFD, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10EFD, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10EFD, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10EFD, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10EFD, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10EFD, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFE, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10EFE, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFE, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10EFE, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10EFE, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10EFE, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10EFE, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10EFE, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFF, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10EFF, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFF, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10EFF, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10EFF, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10EFF, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10EFF, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10EFF, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F46, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F46, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F46, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F46, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F46, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F46, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F46, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F46, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F47, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F47, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F47, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F47, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F47, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F47, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F47, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F47, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F48, 0x0062; @result = 0x00E0, 0x05AE, 0x10F48, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F48, 0x0062 -> 0x00E0, 0x05AE, 0x10F48, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F48, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F48, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F48, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F48, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F49, 0x0062; @result = 0x00E0, 0x05AE, 0x10F49, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F49, 0x0062 -> 0x00E0, 0x05AE, 0x10F49, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F49, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F49, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F49, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F49, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4A, 0x0062; @result = 0x00E0, 0x05AE, 0x10F4A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4A, 0x0062 -> 0x00E0, 0x05AE, 0x10F4A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F4A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F4A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F4A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F4B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F4B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F4B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F4B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F4B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4C, 0x0062; @result = 0x00E0, 0x05AE, 0x10F4C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4C, 0x0062 -> 0x00E0, 0x05AE, 0x10F4C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F4C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F4C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F4C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F4D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F4D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F4D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F4D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F4D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F4E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F4E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F4E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F4E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F4E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F4F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F4F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F4F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F4F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F4F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F4F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F50, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F50, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F50, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F50, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F50, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F50, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F50, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F50, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F82, 0x0062; @result = 0x00E0, 0x05AE, 0x10F82, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F82, 0x0062 -> 0x00E0, 0x05AE, 0x10F82, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F82, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F82, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F82, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F82, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F83, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F83, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F83, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F83, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F83, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F83, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F83, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F83, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x10F84, 0x0062; @result = 0x00E0, 0x05AE, 0x10F84, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x10F84, 0x0062 -> 0x00E0, 0x05AE, 0x10F84, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x10F84, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x10F84, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F84, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x10F84, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F85, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x10F85, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F85, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x10F85, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x10F85, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x10F85, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x10F85, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x10F85, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11046, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11046, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11046, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11046, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11046, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11046, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11046, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11046, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11070, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11070, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11070, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11070, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11070, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11070, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11070, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11070, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1107F, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1107F, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1107F, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1107F, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1107F, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1107F, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1107F, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1107F, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x110B9, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x110B9, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x110B9, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x110B9, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x110B9, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x110B9, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x110B9, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x110B9, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x110BA, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x110BA, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x110BA, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x110BA, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x110BA, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x110BA, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x110BA, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x110BA, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11100, 0x0062; @result = 0x00E0, 0x05AE, 0x11100, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11100, 0x0062 -> 0x00E0, 0x05AE, 0x11100, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11100, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11100, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11100, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11100, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11101, 0x0062; @result = 0x00E0, 0x05AE, 0x11101, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11101, 0x0062 -> 0x00E0, 0x05AE, 0x11101, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11101, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11101, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11101, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11101, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11102, 0x0062; @result = 0x00E0, 0x05AE, 0x11102, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11102, 0x0062 -> 0x00E0, 0x05AE, 0x11102, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11102, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11102, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11102, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11102, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11133, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11133, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11133, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11133, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11133, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11133, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11133, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11133, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11134, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11134, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11134, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11134, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11134, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11134, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11134, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11134, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x11173, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x11173, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x11173, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x11173, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x11173, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x11173, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11173, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x11173, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x111C0, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x111C0, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x111C0, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x111C0, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x111C0, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x111C0, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x111C0, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x111C0, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x111CA, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x111CA, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x111CA, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x111CA, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x111CA, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x111CA, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x111CA, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x111CA, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11235, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11235, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11235, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11235, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11235, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11235, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11235, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11235, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x11236, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x11236, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x11236, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x11236, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x11236, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x11236, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11236, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x11236, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x112E9, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x112E9, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x112E9, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x112E9, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x112E9, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x112E9, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x112E9, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x112E9, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x112EA, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x112EA, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x112EA, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x112EA, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x112EA, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x112EA, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x112EA, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x112EA, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133B, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1133B, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133B, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1133B, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1133B, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1133B, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1133B, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1133B, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133C, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1133C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133C, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1133C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1133C, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1133C, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1133C, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1133C, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1134D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1134D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1134D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1134D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1134D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1134D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1134D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1134D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11366, 0x0062; @result = 0x00E0, 0x05AE, 0x11366, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11366, 0x0062 -> 0x00E0, 0x05AE, 0x11366, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11366, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11366, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11366, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11366, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11367, 0x0062; @result = 0x00E0, 0x05AE, 0x11367, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11367, 0x0062 -> 0x00E0, 0x05AE, 0x11367, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11367, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11367, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11367, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11367, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11368, 0x0062; @result = 0x00E0, 0x05AE, 0x11368, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11368, 0x0062 -> 0x00E0, 0x05AE, 0x11368, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11368, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11368, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11368, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11368, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11369, 0x0062; @result = 0x00E0, 0x05AE, 0x11369, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11369, 0x0062 -> 0x00E0, 0x05AE, 0x11369, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11369, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11369, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11369, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11369, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1136A, 0x0062; @result = 0x00E0, 0x05AE, 0x1136A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1136A, 0x0062 -> 0x00E0, 0x05AE, 0x1136A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1136A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1136A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1136A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1136A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1136B, 0x0062; @result = 0x00E0, 0x05AE, 0x1136B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1136B, 0x0062 -> 0x00E0, 0x05AE, 0x1136B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1136B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1136B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1136B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1136B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1136C, 0x0062; @result = 0x00E0, 0x05AE, 0x1136C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1136C, 0x0062 -> 0x00E0, 0x05AE, 0x1136C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1136C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1136C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1136C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1136C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11370, 0x0062; @result = 0x00E0, 0x05AE, 0x11370, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11370, 0x0062 -> 0x00E0, 0x05AE, 0x11370, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11370, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11370, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11370, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11370, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11371, 0x0062; @result = 0x00E0, 0x05AE, 0x11371, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11371, 0x0062 -> 0x00E0, 0x05AE, 0x11371, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11371, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11371, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11371, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11371, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11372, 0x0062; @result = 0x00E0, 0x05AE, 0x11372, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11372, 0x0062 -> 0x00E0, 0x05AE, 0x11372, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11372, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11372, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11372, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11372, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11373, 0x0062; @result = 0x00E0, 0x05AE, 0x11373, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11373, 0x0062 -> 0x00E0, 0x05AE, 0x11373, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11373, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11373, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11373, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11373, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x11374, 0x0062; @result = 0x00E0, 0x05AE, 0x11374, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x11374, 0x0062 -> 0x00E0, 0x05AE, 0x11374, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x11374, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x11374, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11374, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x11374, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11442, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11442, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11442, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11442, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11442, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11442, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11442, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11442, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x11446, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x11446, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x11446, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x11446, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x11446, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x11446, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11446, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x11446, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1145E, 0x0062; @result = 0x00E0, 0x05AE, 0x1145E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1145E, 0x0062 -> 0x00E0, 0x05AE, 0x1145E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1145E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1145E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1145E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1145E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x114C2, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x114C2, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x114C2, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x114C2, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x114C2, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x114C2, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x114C2, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x114C2, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x114C3, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x114C3, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x114C3, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x114C3, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x114C3, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x114C3, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x114C3, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x114C3, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x115BF, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x115BF, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x115BF, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x115BF, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x115BF, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x115BF, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x115BF, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x115BF, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x115C0, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x115C0, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x115C0, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x115C0, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x115C0, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x115C0, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x115C0, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x115C0, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1163F, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1163F, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1163F, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1163F, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1163F, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1163F, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1163F, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1163F, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x116B6, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x116B6, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x116B6, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x116B6, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x116B6, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x116B6, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x116B6, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x116B6, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x116B7, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x116B7, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x116B7, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x116B7, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x116B7, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x116B7, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x116B7, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x116B7, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1172B, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1172B, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1172B, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1172B, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1172B, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1172B, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1172B, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1172B, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11839, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11839, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11839, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11839, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11839, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11839, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11839, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11839, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1183A, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1183A, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1183A, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1183A, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1183A, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1183A, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1183A, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1183A, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1193D, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1193D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1193D, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1193D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1193D, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1193D, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1193D, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1193D, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x1193E, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x1193E, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x1193E, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x1193E, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x1193E, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x1193E, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1193E, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x1193E, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x11943, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x11943, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x11943, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x11943, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x11943, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x11943, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11943, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x11943, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x119E0, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x119E0, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x119E0, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x119E0, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x119E0, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x119E0, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x119E0, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x119E0, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11A34, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11A34, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11A34, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11A34, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11A34, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11A34, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11A34, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11A34, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11A47, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11A47, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11A47, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11A47, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11A47, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11A47, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11A47, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11A47, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11A99, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11A99, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11A99, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11A99, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11A99, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11A99, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11A99, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11A99, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11C3F, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11C3F, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11C3F, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11C3F, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11C3F, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11C3F, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11C3F, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11C3F, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x11D42, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x11D42, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x11D42, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x11D42, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x11D42, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x11D42, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11D42, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x11D42, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11D44, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11D44, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11D44, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11D44, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11D44, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11D44, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11D44, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11D44, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11D45, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11D45, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11D45, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11D45, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11D45, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11D45, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11D45, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11D45, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11D97, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11D97, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11D97, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11D97, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11D97, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11D97, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11D97, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11D97, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11F41, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11F41, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11F41, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11F41, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11F41, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11F41, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11F41, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11F41, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x05B0, 0x094D, 0x3099, 0x11F42, 0x0062; @result = 0x0061, 0x3099, 0x094D, 0x11F42, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05B0, 0x094D, 0x3099, 0x11F42, 0x0062 -> 0x0061, 0x3099, 0x094D, 0x11F42, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x11F42, 0x05B0, 0x094D, 0x3099, 0x0062; @result = 0x0061, 0x3099, 0x11F42, 0x094D, 0x05B0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x11F42, 0x05B0, 0x094D, 0x3099, 0x0062 -> 0x0061, 0x3099, 0x11F42, 0x094D, 0x05B0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x16AF0, 0x0062; @result = 0x0061, 0x0334, 0x16AF0, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x16AF0, 0x0062 -> 0x0061, 0x0334, 0x16AF0, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16AF0, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x16AF0, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16AF0, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x16AF0, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x16AF1, 0x0062; @result = 0x0061, 0x0334, 0x16AF1, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x16AF1, 0x0062 -> 0x0061, 0x0334, 0x16AF1, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16AF1, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x16AF1, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16AF1, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x16AF1, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x16AF2, 0x0062; @result = 0x0061, 0x0334, 0x16AF2, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x16AF2, 0x0062 -> 0x0061, 0x0334, 0x16AF2, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16AF2, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x16AF2, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16AF2, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x16AF2, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x16AF3, 0x0062; @result = 0x0061, 0x0334, 0x16AF3, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x16AF3, 0x0062 -> 0x0061, 0x0334, 0x16AF3, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16AF3, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x16AF3, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16AF3, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x16AF3, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x16AF4, 0x0062; @result = 0x0061, 0x0334, 0x16AF4, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x16AF4, 0x0062 -> 0x0061, 0x0334, 0x16AF4, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16AF4, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x16AF4, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16AF4, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x16AF4, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B30, 0x0062; @result = 0x00E0, 0x05AE, 0x16B30, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B30, 0x0062 -> 0x00E0, 0x05AE, 0x16B30, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B30, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B30, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B30, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B30, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B31, 0x0062; @result = 0x00E0, 0x05AE, 0x16B31, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B31, 0x0062 -> 0x00E0, 0x05AE, 0x16B31, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B31, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B31, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B31, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B31, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B32, 0x0062; @result = 0x00E0, 0x05AE, 0x16B32, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B32, 0x0062 -> 0x00E0, 0x05AE, 0x16B32, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B32, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B32, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B32, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B32, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B33, 0x0062; @result = 0x00E0, 0x05AE, 0x16B33, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B33, 0x0062 -> 0x00E0, 0x05AE, 0x16B33, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B33, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B33, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B33, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B33, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B34, 0x0062; @result = 0x00E0, 0x05AE, 0x16B34, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B34, 0x0062 -> 0x00E0, 0x05AE, 0x16B34, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B34, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B34, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B34, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B34, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B35, 0x0062; @result = 0x00E0, 0x05AE, 0x16B35, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B35, 0x0062 -> 0x00E0, 0x05AE, 0x16B35, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B35, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B35, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B35, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B35, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x16B36, 0x0062; @result = 0x00E0, 0x05AE, 0x16B36, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x16B36, 0x0062 -> 0x00E0, 0x05AE, 0x16B36, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x16B36, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x16B36, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16B36, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x16B36, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF0, 0x0062; @result = 0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF0, 0x0062 -> 0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x093C, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x093C, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062 CONCAT';
@list = 0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF1, 0x0062; @result = 0x0061, 0x0334, 0x16FF0, 0x16FF1, 0x093C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF1, 0x0062 -> 0x0061, 0x0334, 0x16FF0, 0x16FF1, 0x093C, 0x0062 CONCAT';
@list = 0x0061, 0x16FF1, 0x093C, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x0334, 0x16FF1, 0x16FF0, 0x093C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF1, 0x093C, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x0334, 0x16FF1, 0x16FF0, 0x093C, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1BC9E, 0x0062; @result = 0x0061, 0x0334, 0x1BC9E, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1BC9E, 0x0062 -> 0x0061, 0x0334, 0x1BC9E, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1BC9E, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1BC9E, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1BC9E, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1BC9E, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D165, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D165, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D165, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D165, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D165, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D165, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D165, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D165, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D166, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D166, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D166, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D166, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D166, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D166, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D166, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D166, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1D167, 0x0062; @result = 0x0061, 0x0334, 0x1D167, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1D167, 0x0062 -> 0x0061, 0x0334, 0x1D167, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1D167, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1D167, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D167, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1D167, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1D168, 0x0062; @result = 0x0061, 0x0334, 0x1D168, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1D168, 0x0062 -> 0x0061, 0x0334, 0x1D168, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1D168, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1D168, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D168, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1D168, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x16FF0, 0x0334, 0x1D169, 0x0062; @result = 0x0061, 0x0334, 0x1D169, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x16FF0, 0x0334, 0x1D169, 0x0062 -> 0x0061, 0x0334, 0x1D169, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x1D169, 0x16FF0, 0x0334, 0x0062; @result = 0x0061, 0x1D169, 0x0334, 0x16FF0, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D169, 0x16FF0, 0x0334, 0x0062 -> 0x0061, 0x1D169, 0x0334, 0x16FF0, 0x0062 CONCAT';
@list = 0x0061, 0x05AE, 0x1D16D, 0x302E, 0x1D16D, 0x0062; @result = 0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x05AE, 0x1D16D, 0x302E, 0x1D16D, 0x0062 -> 0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x1D16D, 0x05AE, 0x1D16D, 0x302E, 0x0062; @result = 0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D16D, 0x05AE, 0x1D16D, 0x302E, 0x0062 -> 0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16E, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D16E, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16E, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D16E, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D16E, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D16E, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D16E, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D16E, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16F, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D16F, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16F, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D16F, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D16F, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D16F, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D16F, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D16F, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D170, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D170, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D170, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D170, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D170, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D170, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D170, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D170, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D171, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D171, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D171, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D171, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D171, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D171, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D171, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D171, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D172, 0x0062; @result = 0x0061, 0x1DCE, 0x031B, 0x1D172, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D172, 0x0062 -> 0x0061, 0x1DCE, 0x031B, 0x1D172, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x1D172, 0x1DFA, 0x031B, 0x1DCE, 0x0062; @result = 0x0061, 0x1DCE, 0x1D172, 0x031B, 0x1DFA, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D172, 0x1DFA, 0x031B, 0x1DCE, 0x0062 -> 0x0061, 0x1DCE, 0x1D172, 0x031B, 0x1DFA, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D17B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D17B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D17B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D17B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D17B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D17B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17C, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D17C, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17C, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D17C, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D17C, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D17C, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D17C, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D17C, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17D, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D17D, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17D, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D17D, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D17D, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D17D, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D17D, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D17D, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17E, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D17E, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17E, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D17E, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D17E, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D17E, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D17E, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D17E, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17F, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D17F, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17F, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D17F, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D17F, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D17F, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D17F, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D17F, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D180, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D180, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D180, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D180, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D180, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D180, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D180, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D180, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D181, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D181, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D181, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D181, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D181, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D181, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D181, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D181, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D182, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D182, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D182, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D182, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D182, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D182, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D182, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D182, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D185, 0x0062; @result = 0x00E0, 0x05AE, 0x1D185, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D185, 0x0062 -> 0x00E0, 0x05AE, 0x1D185, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D185, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D185, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D185, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D185, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D186, 0x0062; @result = 0x00E0, 0x05AE, 0x1D186, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D186, 0x0062 -> 0x00E0, 0x05AE, 0x1D186, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D186, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D186, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D186, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D186, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D187, 0x0062; @result = 0x00E0, 0x05AE, 0x1D187, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D187, 0x0062 -> 0x00E0, 0x05AE, 0x1D187, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D187, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D187, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D187, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D187, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D188, 0x0062; @result = 0x00E0, 0x05AE, 0x1D188, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D188, 0x0062 -> 0x00E0, 0x05AE, 0x1D188, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D188, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D188, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D188, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D188, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D189, 0x0062; @result = 0x00E0, 0x05AE, 0x1D189, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D189, 0x0062 -> 0x00E0, 0x05AE, 0x1D189, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D189, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D189, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D189, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D189, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18A, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D18A, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18A, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D18A, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D18A, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D18A, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D18A, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D18A, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18B, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1D18B, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18B, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1D18B, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1D18B, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1D18B, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D18B, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1D18B, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AA, 0x0062; @result = 0x00E0, 0x05AE, 0x1D1AA, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AA, 0x0062 -> 0x00E0, 0x05AE, 0x1D1AA, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D1AA, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D1AA, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D1AA, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D1AA, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AB, 0x0062; @result = 0x00E0, 0x05AE, 0x1D1AB, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AB, 0x0062 -> 0x00E0, 0x05AE, 0x1D1AB, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D1AB, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D1AB, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D1AB, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D1AB, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AC, 0x0062; @result = 0x00E0, 0x05AE, 0x1D1AC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AC, 0x0062 -> 0x00E0, 0x05AE, 0x1D1AC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D1AC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D1AC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D1AC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D1AC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AD, 0x0062; @result = 0x00E0, 0x05AE, 0x1D1AD, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AD, 0x0062 -> 0x00E0, 0x05AE, 0x1D1AD, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D1AD, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D1AD, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D1AD, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D1AD, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D242, 0x0062; @result = 0x00E0, 0x05AE, 0x1D242, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D242, 0x0062 -> 0x00E0, 0x05AE, 0x1D242, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D242, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D242, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D242, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D242, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D243, 0x0062; @result = 0x00E0, 0x05AE, 0x1D243, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D243, 0x0062 -> 0x00E0, 0x05AE, 0x1D243, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D243, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D243, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D243, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D243, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1D244, 0x0062; @result = 0x00E0, 0x05AE, 0x1D244, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1D244, 0x0062 -> 0x00E0, 0x05AE, 0x1D244, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1D244, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1D244, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1D244, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1D244, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E000, 0x0062; @result = 0x00E0, 0x05AE, 0x1E000, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E000, 0x0062 -> 0x00E0, 0x05AE, 0x1E000, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E000, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E000, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E000, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E000, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E001, 0x0062; @result = 0x00E0, 0x05AE, 0x1E001, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E001, 0x0062 -> 0x00E0, 0x05AE, 0x1E001, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E001, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E001, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E001, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E001, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E002, 0x0062; @result = 0x00E0, 0x05AE, 0x1E002, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E002, 0x0062 -> 0x00E0, 0x05AE, 0x1E002, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E002, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E002, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E002, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E002, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E003, 0x0062; @result = 0x00E0, 0x05AE, 0x1E003, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E003, 0x0062 -> 0x00E0, 0x05AE, 0x1E003, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E003, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E003, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E003, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E003, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E004, 0x0062; @result = 0x00E0, 0x05AE, 0x1E004, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E004, 0x0062 -> 0x00E0, 0x05AE, 0x1E004, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E004, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E004, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E004, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E004, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E005, 0x0062; @result = 0x00E0, 0x05AE, 0x1E005, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E005, 0x0062 -> 0x00E0, 0x05AE, 0x1E005, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E005, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E005, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E005, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E005, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E006, 0x0062; @result = 0x00E0, 0x05AE, 0x1E006, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E006, 0x0062 -> 0x00E0, 0x05AE, 0x1E006, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E006, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E006, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E006, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E006, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E008, 0x0062; @result = 0x00E0, 0x05AE, 0x1E008, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E008, 0x0062 -> 0x00E0, 0x05AE, 0x1E008, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E008, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E008, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E008, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E008, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E009, 0x0062; @result = 0x00E0, 0x05AE, 0x1E009, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E009, 0x0062 -> 0x00E0, 0x05AE, 0x1E009, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E009, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E009, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E009, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E009, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00A, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00A, 0x0062 -> 0x00E0, 0x05AE, 0x1E00A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00B, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00B, 0x0062 -> 0x00E0, 0x05AE, 0x1E00B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00C, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00C, 0x0062 -> 0x00E0, 0x05AE, 0x1E00C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00D, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00D, 0x0062 -> 0x00E0, 0x05AE, 0x1E00D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00E, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00E, 0x0062 -> 0x00E0, 0x05AE, 0x1E00E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00F, 0x0062; @result = 0x00E0, 0x05AE, 0x1E00F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00F, 0x0062 -> 0x00E0, 0x05AE, 0x1E00F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E00F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E00F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E00F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E00F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E010, 0x0062; @result = 0x00E0, 0x05AE, 0x1E010, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E010, 0x0062 -> 0x00E0, 0x05AE, 0x1E010, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E010, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E010, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E010, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E010, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E011, 0x0062; @result = 0x00E0, 0x05AE, 0x1E011, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E011, 0x0062 -> 0x00E0, 0x05AE, 0x1E011, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E011, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E011, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E011, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E011, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E012, 0x0062; @result = 0x00E0, 0x05AE, 0x1E012, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E012, 0x0062 -> 0x00E0, 0x05AE, 0x1E012, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E012, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E012, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E012, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E012, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E013, 0x0062; @result = 0x00E0, 0x05AE, 0x1E013, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E013, 0x0062 -> 0x00E0, 0x05AE, 0x1E013, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E013, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E013, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E013, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E013, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E014, 0x0062; @result = 0x00E0, 0x05AE, 0x1E014, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E014, 0x0062 -> 0x00E0, 0x05AE, 0x1E014, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E014, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E014, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E014, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E014, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E015, 0x0062; @result = 0x00E0, 0x05AE, 0x1E015, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E015, 0x0062 -> 0x00E0, 0x05AE, 0x1E015, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E015, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E015, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E015, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E015, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E016, 0x0062; @result = 0x00E0, 0x05AE, 0x1E016, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E016, 0x0062 -> 0x00E0, 0x05AE, 0x1E016, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E016, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E016, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E016, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E016, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E017, 0x0062; @result = 0x00E0, 0x05AE, 0x1E017, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E017, 0x0062 -> 0x00E0, 0x05AE, 0x1E017, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E017, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E017, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E017, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E017, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E018, 0x0062; @result = 0x00E0, 0x05AE, 0x1E018, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E018, 0x0062 -> 0x00E0, 0x05AE, 0x1E018, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E018, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E018, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E018, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E018, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01B, 0x0062; @result = 0x00E0, 0x05AE, 0x1E01B, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01B, 0x0062 -> 0x00E0, 0x05AE, 0x1E01B, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E01B, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E01B, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E01B, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E01B, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01C, 0x0062; @result = 0x00E0, 0x05AE, 0x1E01C, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01C, 0x0062 -> 0x00E0, 0x05AE, 0x1E01C, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E01C, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E01C, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E01C, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E01C, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01D, 0x0062; @result = 0x00E0, 0x05AE, 0x1E01D, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01D, 0x0062 -> 0x00E0, 0x05AE, 0x1E01D, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E01D, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E01D, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E01D, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E01D, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01E, 0x0062; @result = 0x00E0, 0x05AE, 0x1E01E, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01E, 0x0062 -> 0x00E0, 0x05AE, 0x1E01E, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E01E, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E01E, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E01E, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E01E, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01F, 0x0062; @result = 0x00E0, 0x05AE, 0x1E01F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01F, 0x0062 -> 0x00E0, 0x05AE, 0x1E01F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E01F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E01F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E01F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E01F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E020, 0x0062; @result = 0x00E0, 0x05AE, 0x1E020, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E020, 0x0062 -> 0x00E0, 0x05AE, 0x1E020, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E020, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E020, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E020, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E020, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E021, 0x0062; @result = 0x00E0, 0x05AE, 0x1E021, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E021, 0x0062 -> 0x00E0, 0x05AE, 0x1E021, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E021, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E021, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E021, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E021, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E023, 0x0062; @result = 0x00E0, 0x05AE, 0x1E023, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E023, 0x0062 -> 0x00E0, 0x05AE, 0x1E023, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E023, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E023, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E023, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E023, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E024, 0x0062; @result = 0x00E0, 0x05AE, 0x1E024, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E024, 0x0062 -> 0x00E0, 0x05AE, 0x1E024, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E024, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E024, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E024, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E024, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E026, 0x0062; @result = 0x00E0, 0x05AE, 0x1E026, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E026, 0x0062 -> 0x00E0, 0x05AE, 0x1E026, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E026, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E026, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E026, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E026, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E027, 0x0062; @result = 0x00E0, 0x05AE, 0x1E027, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E027, 0x0062 -> 0x00E0, 0x05AE, 0x1E027, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E027, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E027, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E027, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E027, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E028, 0x0062; @result = 0x00E0, 0x05AE, 0x1E028, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E028, 0x0062 -> 0x00E0, 0x05AE, 0x1E028, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E028, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E028, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E028, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E028, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E029, 0x0062; @result = 0x00E0, 0x05AE, 0x1E029, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E029, 0x0062 -> 0x00E0, 0x05AE, 0x1E029, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E029, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E029, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E029, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E029, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E02A, 0x0062; @result = 0x00E0, 0x05AE, 0x1E02A, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E02A, 0x0062 -> 0x00E0, 0x05AE, 0x1E02A, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E02A, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E02A, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E02A, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E02A, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E08F, 0x0062; @result = 0x00E0, 0x05AE, 0x1E08F, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E08F, 0x0062 -> 0x00E0, 0x05AE, 0x1E08F, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E08F, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E08F, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E08F, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E08F, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E130, 0x0062; @result = 0x00E0, 0x05AE, 0x1E130, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E130, 0x0062 -> 0x00E0, 0x05AE, 0x1E130, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E130, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E130, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E130, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E130, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E131, 0x0062; @result = 0x00E0, 0x05AE, 0x1E131, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E131, 0x0062 -> 0x00E0, 0x05AE, 0x1E131, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E131, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E131, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E131, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E131, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E132, 0x0062; @result = 0x00E0, 0x05AE, 0x1E132, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E132, 0x0062 -> 0x00E0, 0x05AE, 0x1E132, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E132, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E132, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E132, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E132, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E133, 0x0062; @result = 0x00E0, 0x05AE, 0x1E133, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E133, 0x0062 -> 0x00E0, 0x05AE, 0x1E133, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E133, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E133, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E133, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E133, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E134, 0x0062; @result = 0x00E0, 0x05AE, 0x1E134, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E134, 0x0062 -> 0x00E0, 0x05AE, 0x1E134, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E134, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E134, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E134, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E134, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E135, 0x0062; @result = 0x00E0, 0x05AE, 0x1E135, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E135, 0x0062 -> 0x00E0, 0x05AE, 0x1E135, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E135, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E135, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E135, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E135, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E136, 0x0062; @result = 0x00E0, 0x05AE, 0x1E136, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E136, 0x0062 -> 0x00E0, 0x05AE, 0x1E136, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E136, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E136, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E136, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E136, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2AE, 0x0062; @result = 0x00E0, 0x05AE, 0x1E2AE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2AE, 0x0062 -> 0x00E0, 0x05AE, 0x1E2AE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E2AE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E2AE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E2AE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E2AE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EC, 0x0062; @result = 0x00E0, 0x05AE, 0x1E2EC, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EC, 0x0062 -> 0x00E0, 0x05AE, 0x1E2EC, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E2EC, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E2EC, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E2EC, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E2EC, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2ED, 0x0062; @result = 0x00E0, 0x05AE, 0x1E2ED, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2ED, 0x0062 -> 0x00E0, 0x05AE, 0x1E2ED, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E2ED, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E2ED, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E2ED, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E2ED, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EE, 0x0062; @result = 0x00E0, 0x05AE, 0x1E2EE, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EE, 0x0062 -> 0x00E0, 0x05AE, 0x1E2EE, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E2EE, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E2EE, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E2EE, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E2EE, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EF, 0x0062; @result = 0x00E0, 0x05AE, 0x1E2EF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EF, 0x0062 -> 0x00E0, 0x05AE, 0x1E2EF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E2EF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E2EF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E2EF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E2EF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x1E4EC, 0x0062; @result = 0x00E0, 0x0315, 0x1E4EC, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x1E4EC, 0x0062 -> 0x00E0, 0x0315, 0x1E4EC, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x1E4EC, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x1E4EC, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E4EC, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x1E4EC, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x035C, 0x0315, 0x0300, 0x1E4ED, 0x0062; @result = 0x00E0, 0x0315, 0x1E4ED, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x035C, 0x0315, 0x0300, 0x1E4ED, 0x0062 -> 0x00E0, 0x0315, 0x1E4ED, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x1E4ED, 0x035C, 0x0315, 0x0300, 0x0062; @result = 0x00E0, 0x1E4ED, 0x0315, 0x035C, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E4ED, 0x035C, 0x0315, 0x0300, 0x0062 -> 0x00E0, 0x1E4ED, 0x0315, 0x035C, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E4EE, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E4EE, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E4EE, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E4EE, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E4EE, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E4EE, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E4EE, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E4EE, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E4EF, 0x0062; @result = 0x00E0, 0x05AE, 0x1E4EF, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E4EF, 0x0062 -> 0x00E0, 0x05AE, 0x1E4EF, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E4EF, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E4EF, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E4EF, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E4EF, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D0, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D0, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D0, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D0, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D0, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D0, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D0, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D0, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D1, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D1, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D1, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D1, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D1, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D1, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D1, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D1, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D2, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D2, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D2, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D2, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D2, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D2, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D2, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D2, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D3, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D3, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D3, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D3, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D3, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D3, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D3, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D3, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D4, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D4, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D4, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D4, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D4, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D4, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D4, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D4, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D5, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D5, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D5, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D5, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D5, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D5, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D5, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D5, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D6, 0x0062; @result = 0x0061, 0x1DFA, 0x0316, 0x1E8D6, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D6, 0x0062 -> 0x0061, 0x1DFA, 0x0316, 0x1E8D6, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x1E8D6, 0x059A, 0x0316, 0x1DFA, 0x0062; @result = 0x0061, 0x1DFA, 0x1E8D6, 0x0316, 0x059A, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E8D6, 0x059A, 0x0316, 0x1DFA, 0x0062 -> 0x0061, 0x1DFA, 0x1E8D6, 0x0316, 0x059A, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E944, 0x0062; @result = 0x00E0, 0x05AE, 0x1E944, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E944, 0x0062 -> 0x00E0, 0x05AE, 0x1E944, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E944, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E944, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E944, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E944, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E945, 0x0062; @result = 0x00E0, 0x05AE, 0x1E945, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E945, 0x0062 -> 0x00E0, 0x05AE, 0x1E945, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E945, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E945, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E945, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E945, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E946, 0x0062; @result = 0x00E0, 0x05AE, 0x1E946, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E946, 0x0062 -> 0x00E0, 0x05AE, 0x1E946, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E946, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E946, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E946, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E946, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E947, 0x0062; @result = 0x00E0, 0x05AE, 0x1E947, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E947, 0x0062 -> 0x00E0, 0x05AE, 0x1E947, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E947, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E947, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E947, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E947, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E948, 0x0062; @result = 0x00E0, 0x05AE, 0x1E948, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E948, 0x0062 -> 0x00E0, 0x05AE, 0x1E948, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E948, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E948, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E948, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E948, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x0315, 0x0300, 0x05AE, 0x1E949, 0x0062; @result = 0x00E0, 0x05AE, 0x1E949, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x0315, 0x0300, 0x05AE, 0x1E949, 0x0062 -> 0x00E0, 0x05AE, 0x1E949, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x1E949, 0x0315, 0x0300, 0x05AE, 0x0062; @result = 0x0061, 0x05AE, 0x1E949, 0x0300, 0x0315, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E949, 0x0315, 0x0300, 0x05AE, 0x0062 -> 0x0061, 0x05AE, 0x1E949, 0x0300, 0x0315, 0x0062 CONCAT';
@list = 0x0061, 0x3099, 0x093C, 0x16FF0, 0x1E94A, 0x0062; @result = 0x0061, 0x16FF0, 0x093C, 0x1E94A, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x3099, 0x093C, 0x16FF0, 0x1E94A, 0x0062 -> 0x0061, 0x16FF0, 0x093C, 0x1E94A, 0x3099, 0x0062 CONCAT';
@list = 0x0061, 0x1E94A, 0x3099, 0x093C, 0x16FF0, 0x0062; @result = 0x0061, 0x16FF0, 0x1E94A, 0x093C, 0x3099, 0x0062;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0061, 0x1E94A, 0x3099, 0x093C, 0x16FF0, 0x0062 -> 0x0061, 0x16FF0, 0x1E94A, 0x093C, 0x3099, 0x0062 CONCAT';
@list = 0x09C7, 0x0334, 0x09BE; @result = 0x09C7, 0x0334, 0x09BE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x09C7, 0x0334, 0x09BE -> 0x09C7, 0x0334, 0x09BE CONCAT';
@list = 0x09C7, 0x0334, 0x09D7; @result = 0x09C7, 0x0334, 0x09D7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x09C7, 0x0334, 0x09D7 -> 0x09C7, 0x0334, 0x09D7 CONCAT';
@list = 0x0B47, 0x0334, 0x0B3E; @result = 0x0B47, 0x0334, 0x0B3E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0B47, 0x0334, 0x0B3E -> 0x0B47, 0x0334, 0x0B3E CONCAT';
@list = 0x0B47, 0x0334, 0x0B56; @result = 0x0B47, 0x0334, 0x0B56;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0B47, 0x0334, 0x0B56 -> 0x0B47, 0x0334, 0x0B56 CONCAT';
@list = 0x0B47, 0x0334, 0x0B57; @result = 0x0B47, 0x0334, 0x0B57;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0B47, 0x0334, 0x0B57 -> 0x0B47, 0x0334, 0x0B57 CONCAT';
@list = 0x0B92, 0x0334, 0x0BD7; @result = 0x0B92, 0x0334, 0x0BD7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0B92, 0x0334, 0x0BD7 -> 0x0B92, 0x0334, 0x0BD7 CONCAT';
@list = 0x0BC6, 0x0334, 0x0BBE; @result = 0x0BC6, 0x0334, 0x0BBE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0BC6, 0x0334, 0x0BBE -> 0x0BC6, 0x0334, 0x0BBE CONCAT';
@list = 0x0BC6, 0x0334, 0x0BD7; @result = 0x0BC6, 0x0334, 0x0BD7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0BC6, 0x0334, 0x0BD7 -> 0x0BC6, 0x0334, 0x0BD7 CONCAT';
@list = 0x0BC7, 0x0334, 0x0BBE; @result = 0x0BC7, 0x0334, 0x0BBE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0BC7, 0x0334, 0x0BBE -> 0x0BC7, 0x0334, 0x0BBE CONCAT';
@list = 0x0CBF, 0x0334, 0x0CD5; @result = 0x0CBF, 0x0334, 0x0CD5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0CBF, 0x0334, 0x0CD5 -> 0x0CBF, 0x0334, 0x0CD5 CONCAT';
@list = 0x0CC6, 0x0334, 0x0CC2; @result = 0x0CC6, 0x0334, 0x0CC2;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0CC6, 0x0334, 0x0CC2 -> 0x0CC6, 0x0334, 0x0CC2 CONCAT';
@list = 0x0CC6, 0x0334, 0x0CD5; @result = 0x0CC6, 0x0334, 0x0CD5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0CC6, 0x0334, 0x0CD5 -> 0x0CC6, 0x0334, 0x0CD5 CONCAT';
@list = 0x0CC6, 0x0334, 0x0CD6; @result = 0x0CC6, 0x0334, 0x0CD6;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0CC6, 0x0334, 0x0CD6 -> 0x0CC6, 0x0334, 0x0CD6 CONCAT';
@list = 0x0CCA, 0x0334, 0x0CD5; @result = 0x0CCA, 0x0334, 0x0CD5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0CCA, 0x0334, 0x0CD5 -> 0x0CCA, 0x0334, 0x0CD5 CONCAT';
@list = 0x0D46, 0x0334, 0x0D3E; @result = 0x0D46, 0x0334, 0x0D3E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0D46, 0x0334, 0x0D3E -> 0x0D46, 0x0334, 0x0D3E CONCAT';
@list = 0x0D46, 0x0334, 0x0D57; @result = 0x0D46, 0x0334, 0x0D57;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0D46, 0x0334, 0x0D57 -> 0x0D46, 0x0334, 0x0D57 CONCAT';
@list = 0x0D47, 0x0334, 0x0D3E; @result = 0x0D47, 0x0334, 0x0D3E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0D47, 0x0334, 0x0D3E -> 0x0D47, 0x0334, 0x0D3E CONCAT';
@list = 0x0DD9, 0x0334, 0x0DCF; @result = 0x0DD9, 0x0334, 0x0DCF;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0DD9, 0x0334, 0x0DCF -> 0x0DD9, 0x0334, 0x0DCF CONCAT';
@list = 0x0DD9, 0x0334, 0x0DDF; @result = 0x0DD9, 0x0334, 0x0DDF;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0DD9, 0x0334, 0x0DDF -> 0x0DD9, 0x0334, 0x0DDF CONCAT';
@list = 0x0F40, 0x0334, 0x0FB5; @result = 0x0F40, 0x0334, 0x0FB5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F40, 0x0334, 0x0FB5 -> 0x0F40, 0x0334, 0x0FB5 CONCAT';
@list = 0x0F42, 0x0334, 0x0FB7; @result = 0x0F42, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F42, 0x0334, 0x0FB7 -> 0x0F42, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F4C, 0x0334, 0x0FB7; @result = 0x0F4C, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F4C, 0x0334, 0x0FB7 -> 0x0F4C, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F51, 0x0334, 0x0FB7; @result = 0x0F51, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F51, 0x0334, 0x0FB7 -> 0x0F51, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F56, 0x0334, 0x0FB7; @result = 0x0F56, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F56, 0x0334, 0x0FB7 -> 0x0F56, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F5B, 0x0334, 0x0FB7; @result = 0x0F5B, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F5B, 0x0334, 0x0FB7 -> 0x0F5B, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F90, 0x0334, 0x0FB5; @result = 0x0F90, 0x0334, 0x0FB5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F90, 0x0334, 0x0FB5 -> 0x0F90, 0x0334, 0x0FB5 CONCAT';
@list = 0x0F92, 0x0334, 0x0FB7; @result = 0x0F92, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F92, 0x0334, 0x0FB7 -> 0x0F92, 0x0334, 0x0FB7 CONCAT';
@list = 0x0F9C, 0x0334, 0x0FB7; @result = 0x0F9C, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0F9C, 0x0334, 0x0FB7 -> 0x0F9C, 0x0334, 0x0FB7 CONCAT';
@list = 0x0FA1, 0x0334, 0x0FB7; @result = 0x0FA1, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0FA1, 0x0334, 0x0FB7 -> 0x0FA1, 0x0334, 0x0FB7 CONCAT';
@list = 0x0FA6, 0x0334, 0x0FB7; @result = 0x0FA6, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0FA6, 0x0334, 0x0FB7 -> 0x0FA6, 0x0334, 0x0FB7 CONCAT';
@list = 0x0FAB, 0x0334, 0x0FB7; @result = 0x0FAB, 0x0334, 0x0FB7;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x0FAB, 0x0334, 0x0FB7 -> 0x0FAB, 0x0334, 0x0FB7 CONCAT';
@list = 0x1025, 0x0334, 0x102E; @result = 0x1025, 0x0334, 0x102E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1025, 0x0334, 0x102E -> 0x1025, 0x0334, 0x102E CONCAT';
@list = 0x1100, 0x0334, 0x1161; @result = 0x1100, 0x0334, 0x1161;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1100, 0x0334, 0x1161 -> 0x1100, 0x0334, 0x1161 CONCAT';
@list = 0x1100, 0x0334, 0x116E; @result = 0x1100, 0x0334, 0x116E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1100, 0x0334, 0x116E -> 0x1100, 0x0334, 0x116E CONCAT';
@list = 0x1101, 0x0334, 0x1166; @result = 0x1101, 0x0334, 0x1166;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1101, 0x0334, 0x1166 -> 0x1101, 0x0334, 0x1166 CONCAT';
@list = 0x1101, 0x0334, 0x1173; @result = 0x1101, 0x0334, 0x1173;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1101, 0x0334, 0x1173 -> 0x1101, 0x0334, 0x1173 CONCAT';
@list = 0x1102, 0x0334, 0x116B; @result = 0x1102, 0x0334, 0x116B;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1102, 0x0334, 0x116B -> 0x1102, 0x0334, 0x116B CONCAT';
@list = 0x1103, 0x0334, 0x1163; @result = 0x1103, 0x0334, 0x1163;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1103, 0x0334, 0x1163 -> 0x1103, 0x0334, 0x1163 CONCAT';
@list = 0x1103, 0x0334, 0x1170; @result = 0x1103, 0x0334, 0x1170;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1103, 0x0334, 0x1170 -> 0x1103, 0x0334, 0x1170 CONCAT';
@list = 0x1104, 0x0334, 0x1168; @result = 0x1104, 0x0334, 0x1168;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1104, 0x0334, 0x1168 -> 0x1104, 0x0334, 0x1168 CONCAT';
@list = 0x1104, 0x0334, 0x1175; @result = 0x1104, 0x0334, 0x1175;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1104, 0x0334, 0x1175 -> 0x1104, 0x0334, 0x1175 CONCAT';
@list = 0x1105, 0x0334, 0x116D; @result = 0x1105, 0x0334, 0x116D;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1105, 0x0334, 0x116D -> 0x1105, 0x0334, 0x116D CONCAT';
@list = 0x1106, 0x0334, 0x1165; @result = 0x1106, 0x0334, 0x1165;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1106, 0x0334, 0x1165 -> 0x1106, 0x0334, 0x1165 CONCAT';
@list = 0x1106, 0x0334, 0x1172; @result = 0x1106, 0x0334, 0x1172;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1106, 0x0334, 0x1172 -> 0x1106, 0x0334, 0x1172 CONCAT';
@list = 0x1107, 0x0334, 0x116A; @result = 0x1107, 0x0334, 0x116A;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1107, 0x0334, 0x116A -> 0x1107, 0x0334, 0x116A CONCAT';
@list = 0x1108, 0x0334, 0x1162; @result = 0x1108, 0x0334, 0x1162;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1108, 0x0334, 0x1162 -> 0x1108, 0x0334, 0x1162 CONCAT';
@list = 0x1108, 0x0334, 0x116F; @result = 0x1108, 0x0334, 0x116F;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1108, 0x0334, 0x116F -> 0x1108, 0x0334, 0x116F CONCAT';
@list = 0x1109, 0x0334, 0x1167; @result = 0x1109, 0x0334, 0x1167;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1109, 0x0334, 0x1167 -> 0x1109, 0x0334, 0x1167 CONCAT';
@list = 0x1109, 0x0334, 0x1174; @result = 0x1109, 0x0334, 0x1174;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1109, 0x0334, 0x1174 -> 0x1109, 0x0334, 0x1174 CONCAT';
@list = 0x110A, 0x0334, 0x116C; @result = 0x110A, 0x0334, 0x116C;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110A, 0x0334, 0x116C -> 0x110A, 0x0334, 0x116C CONCAT';
@list = 0x110B, 0x0334, 0x1164; @result = 0x110B, 0x0334, 0x1164;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110B, 0x0334, 0x1164 -> 0x110B, 0x0334, 0x1164 CONCAT';
@list = 0x110B, 0x0334, 0x1171; @result = 0x110B, 0x0334, 0x1171;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110B, 0x0334, 0x1171 -> 0x110B, 0x0334, 0x1171 CONCAT';
@list = 0x110C, 0x0334, 0x1169; @result = 0x110C, 0x0334, 0x1169;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110C, 0x0334, 0x1169 -> 0x110C, 0x0334, 0x1169 CONCAT';
@list = 0x110D, 0x0334, 0x1161; @result = 0x110D, 0x0334, 0x1161;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110D, 0x0334, 0x1161 -> 0x110D, 0x0334, 0x1161 CONCAT';
@list = 0x110D, 0x0334, 0x116E; @result = 0x110D, 0x0334, 0x116E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110D, 0x0334, 0x116E -> 0x110D, 0x0334, 0x116E CONCAT';
@list = 0x110E, 0x0334, 0x1166; @result = 0x110E, 0x0334, 0x1166;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110E, 0x0334, 0x1166 -> 0x110E, 0x0334, 0x1166 CONCAT';
@list = 0x110E, 0x0334, 0x1173; @result = 0x110E, 0x0334, 0x1173;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110E, 0x0334, 0x1173 -> 0x110E, 0x0334, 0x1173 CONCAT';
@list = 0x110F, 0x0334, 0x116B; @result = 0x110F, 0x0334, 0x116B;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x110F, 0x0334, 0x116B -> 0x110F, 0x0334, 0x116B CONCAT';
@list = 0x1110, 0x0334, 0x1163; @result = 0x1110, 0x0334, 0x1163;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1110, 0x0334, 0x1163 -> 0x1110, 0x0334, 0x1163 CONCAT';
@list = 0x1110, 0x0334, 0x1170; @result = 0x1110, 0x0334, 0x1170;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1110, 0x0334, 0x1170 -> 0x1110, 0x0334, 0x1170 CONCAT';
@list = 0x1111, 0x0334, 0x1168; @result = 0x1111, 0x0334, 0x1168;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1111, 0x0334, 0x1168 -> 0x1111, 0x0334, 0x1168 CONCAT';
@list = 0x1111, 0x0334, 0x1175; @result = 0x1111, 0x0334, 0x1175;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1111, 0x0334, 0x1175 -> 0x1111, 0x0334, 0x1175 CONCAT';
@list = 0x1112, 0x0334, 0x116D; @result = 0x1112, 0x0334, 0x116D;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1112, 0x0334, 0x116D -> 0x1112, 0x0334, 0x116D CONCAT';
@list = 0x1B05, 0x0334, 0x1B35; @result = 0x1B05, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B05, 0x0334, 0x1B35 -> 0x1B05, 0x0334, 0x1B35 CONCAT';
@list = 0x1B07, 0x0334, 0x1B35; @result = 0x1B07, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B07, 0x0334, 0x1B35 -> 0x1B07, 0x0334, 0x1B35 CONCAT';
@list = 0x1B09, 0x0334, 0x1B35; @result = 0x1B09, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B09, 0x0334, 0x1B35 -> 0x1B09, 0x0334, 0x1B35 CONCAT';
@list = 0x1B0B, 0x0334, 0x1B35; @result = 0x1B0B, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B0B, 0x0334, 0x1B35 -> 0x1B0B, 0x0334, 0x1B35 CONCAT';
@list = 0x1B0D, 0x0334, 0x1B35; @result = 0x1B0D, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B0D, 0x0334, 0x1B35 -> 0x1B0D, 0x0334, 0x1B35 CONCAT';
@list = 0x1B11, 0x0334, 0x1B35; @result = 0x1B11, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B11, 0x0334, 0x1B35 -> 0x1B11, 0x0334, 0x1B35 CONCAT';
@list = 0x1B3A, 0x0334, 0x1B35; @result = 0x1B3A, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B3A, 0x0334, 0x1B35 -> 0x1B3A, 0x0334, 0x1B35 CONCAT';
@list = 0x1B3C, 0x0334, 0x1B35; @result = 0x1B3C, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B3C, 0x0334, 0x1B35 -> 0x1B3C, 0x0334, 0x1B35 CONCAT';
@list = 0x1B3E, 0x0334, 0x1B35; @result = 0x1B3E, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B3E, 0x0334, 0x1B35 -> 0x1B3E, 0x0334, 0x1B35 CONCAT';
@list = 0x1B3F, 0x0334, 0x1B35; @result = 0x1B3F, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B3F, 0x0334, 0x1B35 -> 0x1B3F, 0x0334, 0x1B35 CONCAT';
@list = 0x1B42, 0x0334, 0x1B35; @result = 0x1B42, 0x0334, 0x1B35;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x1B42, 0x0334, 0x1B35 -> 0x1B42, 0x0334, 0x1B35 CONCAT';
@list = 0xAC54, 0x0334, 0x11AE; @result = 0xAC54, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAC54, 0x0334, 0x11AE -> 0xAC54, 0x0334, 0x11AE CONCAT';
@list = 0xACA8, 0x0334, 0x11B5; @result = 0xACA8, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xACA8, 0x0334, 0x11B5 -> 0xACA8, 0x0334, 0x11B5 CONCAT';
@list = 0xACFC, 0x0334, 0x11BC; @result = 0xACFC, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xACFC, 0x0334, 0x11BC -> 0xACFC, 0x0334, 0x11BC CONCAT';
@list = 0xADC0, 0x0334, 0x11AE; @result = 0xADC0, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xADC0, 0x0334, 0x11AE -> 0xADC0, 0x0334, 0x11AE CONCAT';
@list = 0xAE14, 0x0334, 0x11B5; @result = 0xAE14, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAE14, 0x0334, 0x11B5 -> 0xAE14, 0x0334, 0x11B5 CONCAT';
@list = 0xAE68, 0x0334, 0x11BC; @result = 0xAE68, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAE68, 0x0334, 0x11BC -> 0xAE68, 0x0334, 0x11BC CONCAT';
@list = 0xAF2C, 0x0334, 0x11AE; @result = 0xAF2C, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAF2C, 0x0334, 0x11AE -> 0xAF2C, 0x0334, 0x11AE CONCAT';
@list = 0xAF80, 0x0334, 0x11B5; @result = 0xAF80, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAF80, 0x0334, 0x11B5 -> 0xAF80, 0x0334, 0x11B5 CONCAT';
@list = 0xAFD4, 0x0334, 0x11BC; @result = 0xAFD4, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xAFD4, 0x0334, 0x11BC -> 0xAFD4, 0x0334, 0x11BC CONCAT';
@list = 0xB098, 0x0334, 0x11AE; @result = 0xB098, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB098, 0x0334, 0x11AE -> 0xB098, 0x0334, 0x11AE CONCAT';
@list = 0xB0EC, 0x0334, 0x11B5; @result = 0xB0EC, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB0EC, 0x0334, 0x11B5 -> 0xB0EC, 0x0334, 0x11B5 CONCAT';
@list = 0xB140, 0x0334, 0x11BC; @result = 0xB140, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB140, 0x0334, 0x11BC -> 0xB140, 0x0334, 0x11BC CONCAT';
@list = 0xB204, 0x0334, 0x11AE; @result = 0xB204, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB204, 0x0334, 0x11AE -> 0xB204, 0x0334, 0x11AE CONCAT';
@list = 0xB258, 0x0334, 0x11B5; @result = 0xB258, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB258, 0x0334, 0x11B5 -> 0xB258, 0x0334, 0x11B5 CONCAT';
@list = 0xB2AC, 0x0334, 0x11BC; @result = 0xB2AC, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB2AC, 0x0334, 0x11BC -> 0xB2AC, 0x0334, 0x11BC CONCAT';
@list = 0xB370, 0x0334, 0x11AE; @result = 0xB370, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB370, 0x0334, 0x11AE -> 0xB370, 0x0334, 0x11AE CONCAT';
@list = 0xB3C4, 0x0334, 0x11B5; @result = 0xB3C4, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB3C4, 0x0334, 0x11B5 -> 0xB3C4, 0x0334, 0x11B5 CONCAT';
@list = 0xB418, 0x0334, 0x11BC; @result = 0xB418, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB418, 0x0334, 0x11BC -> 0xB418, 0x0334, 0x11BC CONCAT';
@list = 0xB4DC, 0x0334, 0x11AE; @result = 0xB4DC, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB4DC, 0x0334, 0x11AE -> 0xB4DC, 0x0334, 0x11AE CONCAT';
@list = 0xB530, 0x0334, 0x11B5; @result = 0xB530, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB530, 0x0334, 0x11B5 -> 0xB530, 0x0334, 0x11B5 CONCAT';
@list = 0xB584, 0x0334, 0x11BC; @result = 0xB584, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB584, 0x0334, 0x11BC -> 0xB584, 0x0334, 0x11BC CONCAT';
@list = 0xB648, 0x0334, 0x11AE; @result = 0xB648, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB648, 0x0334, 0x11AE -> 0xB648, 0x0334, 0x11AE CONCAT';
@list = 0xB69C, 0x0334, 0x11B5; @result = 0xB69C, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB69C, 0x0334, 0x11B5 -> 0xB69C, 0x0334, 0x11B5 CONCAT';
@list = 0xB6F0, 0x0334, 0x11BC; @result = 0xB6F0, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB6F0, 0x0334, 0x11BC -> 0xB6F0, 0x0334, 0x11BC CONCAT';
@list = 0xB7B4, 0x0334, 0x11AE; @result = 0xB7B4, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB7B4, 0x0334, 0x11AE -> 0xB7B4, 0x0334, 0x11AE CONCAT';
@list = 0xB808, 0x0334, 0x11B5; @result = 0xB808, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB808, 0x0334, 0x11B5 -> 0xB808, 0x0334, 0x11B5 CONCAT';
@list = 0xB85C, 0x0334, 0x11BC; @result = 0xB85C, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB85C, 0x0334, 0x11BC -> 0xB85C, 0x0334, 0x11BC CONCAT';
@list = 0xB920, 0x0334, 0x11AE; @result = 0xB920, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB920, 0x0334, 0x11AE -> 0xB920, 0x0334, 0x11AE CONCAT';
@list = 0xB974, 0x0334, 0x11B5; @result = 0xB974, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB974, 0x0334, 0x11B5 -> 0xB974, 0x0334, 0x11B5 CONCAT';
@list = 0xB9C8, 0x0334, 0x11BC; @result = 0xB9C8, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xB9C8, 0x0334, 0x11BC -> 0xB9C8, 0x0334, 0x11BC CONCAT';
@list = 0xBA8C, 0x0334, 0x11AE; @result = 0xBA8C, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBA8C, 0x0334, 0x11AE -> 0xBA8C, 0x0334, 0x11AE CONCAT';
@list = 0xBAE0, 0x0334, 0x11B5; @result = 0xBAE0, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBAE0, 0x0334, 0x11B5 -> 0xBAE0, 0x0334, 0x11B5 CONCAT';
@list = 0xBB34, 0x0334, 0x11BC; @result = 0xBB34, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBB34, 0x0334, 0x11BC -> 0xBB34, 0x0334, 0x11BC CONCAT';
@list = 0xBBF8, 0x0334, 0x11AE; @result = 0xBBF8, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBBF8, 0x0334, 0x11AE -> 0xBBF8, 0x0334, 0x11AE CONCAT';
@list = 0xBC4C, 0x0334, 0x11B5; @result = 0xBC4C, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBC4C, 0x0334, 0x11B5 -> 0xBC4C, 0x0334, 0x11B5 CONCAT';
@list = 0xBCA0, 0x0334, 0x11BC; @result = 0xBCA0, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBCA0, 0x0334, 0x11BC -> 0xBCA0, 0x0334, 0x11BC CONCAT';
@list = 0xBD64, 0x0334, 0x11AE; @result = 0xBD64, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBD64, 0x0334, 0x11AE -> 0xBD64, 0x0334, 0x11AE CONCAT';
@list = 0xBDB8, 0x0334, 0x11B5; @result = 0xBDB8, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBDB8, 0x0334, 0x11B5 -> 0xBDB8, 0x0334, 0x11B5 CONCAT';
@list = 0xBE0C, 0x0334, 0x11BC; @result = 0xBE0C, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBE0C, 0x0334, 0x11BC -> 0xBE0C, 0x0334, 0x11BC CONCAT';
@list = 0xBED0, 0x0334, 0x11AE; @result = 0xBED0, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBED0, 0x0334, 0x11AE -> 0xBED0, 0x0334, 0x11AE CONCAT';
@list = 0xBF24, 0x0334, 0x11B5; @result = 0xBF24, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBF24, 0x0334, 0x11B5 -> 0xBF24, 0x0334, 0x11B5 CONCAT';
@list = 0xBF78, 0x0334, 0x11BC; @result = 0xBF78, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xBF78, 0x0334, 0x11BC -> 0xBF78, 0x0334, 0x11BC CONCAT';
@list = 0xC03C, 0x0334, 0x11AE; @result = 0xC03C, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC03C, 0x0334, 0x11AE -> 0xC03C, 0x0334, 0x11AE CONCAT';
@list = 0xC090, 0x0334, 0x11B5; @result = 0xC090, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC090, 0x0334, 0x11B5 -> 0xC090, 0x0334, 0x11B5 CONCAT';
@list = 0xC0E4, 0x0334, 0x11BC; @result = 0xC0E4, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC0E4, 0x0334, 0x11BC -> 0xC0E4, 0x0334, 0x11BC CONCAT';
@list = 0xC1A8, 0x0334, 0x11AE; @result = 0xC1A8, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC1A8, 0x0334, 0x11AE -> 0xC1A8, 0x0334, 0x11AE CONCAT';
@list = 0xC1FC, 0x0334, 0x11B5; @result = 0xC1FC, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC1FC, 0x0334, 0x11B5 -> 0xC1FC, 0x0334, 0x11B5 CONCAT';
@list = 0xC250, 0x0334, 0x11BC; @result = 0xC250, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC250, 0x0334, 0x11BC -> 0xC250, 0x0334, 0x11BC CONCAT';
@list = 0xC314, 0x0334, 0x11AE; @result = 0xC314, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC314, 0x0334, 0x11AE -> 0xC314, 0x0334, 0x11AE CONCAT';
@list = 0xC368, 0x0334, 0x11B5; @result = 0xC368, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC368, 0x0334, 0x11B5 -> 0xC368, 0x0334, 0x11B5 CONCAT';
@list = 0xC3BC, 0x0334, 0x11BC; @result = 0xC3BC, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC3BC, 0x0334, 0x11BC -> 0xC3BC, 0x0334, 0x11BC CONCAT';
@list = 0xC480, 0x0334, 0x11AE; @result = 0xC480, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC480, 0x0334, 0x11AE -> 0xC480, 0x0334, 0x11AE CONCAT';
@list = 0xC4D4, 0x0334, 0x11B5; @result = 0xC4D4, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC4D4, 0x0334, 0x11B5 -> 0xC4D4, 0x0334, 0x11B5 CONCAT';
@list = 0xC528, 0x0334, 0x11BC; @result = 0xC528, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC528, 0x0334, 0x11BC -> 0xC528, 0x0334, 0x11BC CONCAT';
@list = 0xC5EC, 0x0334, 0x11AE; @result = 0xC5EC, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC5EC, 0x0334, 0x11AE -> 0xC5EC, 0x0334, 0x11AE CONCAT';
@list = 0xC640, 0x0334, 0x11B5; @result = 0xC640, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC640, 0x0334, 0x11B5 -> 0xC640, 0x0334, 0x11B5 CONCAT';
@list = 0xC694, 0x0334, 0x11BC; @result = 0xC694, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC694, 0x0334, 0x11BC -> 0xC694, 0x0334, 0x11BC CONCAT';
@list = 0xC758, 0x0334, 0x11AE; @result = 0xC758, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC758, 0x0334, 0x11AE -> 0xC758, 0x0334, 0x11AE CONCAT';
@list = 0xC7AC, 0x0334, 0x11B5; @result = 0xC7AC, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC7AC, 0x0334, 0x11B5 -> 0xC7AC, 0x0334, 0x11B5 CONCAT';
@list = 0xC800, 0x0334, 0x11BC; @result = 0xC800, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC800, 0x0334, 0x11BC -> 0xC800, 0x0334, 0x11BC CONCAT';
@list = 0xC8C4, 0x0334, 0x11AE; @result = 0xC8C4, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC8C4, 0x0334, 0x11AE -> 0xC8C4, 0x0334, 0x11AE CONCAT';
@list = 0xC918, 0x0334, 0x11B5; @result = 0xC918, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC918, 0x0334, 0x11B5 -> 0xC918, 0x0334, 0x11B5 CONCAT';
@list = 0xC96C, 0x0334, 0x11BC; @result = 0xC96C, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xC96C, 0x0334, 0x11BC -> 0xC96C, 0x0334, 0x11BC CONCAT';
@list = 0xCA30, 0x0334, 0x11AE; @result = 0xCA30, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCA30, 0x0334, 0x11AE -> 0xCA30, 0x0334, 0x11AE CONCAT';
@list = 0xCA84, 0x0334, 0x11B5; @result = 0xCA84, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCA84, 0x0334, 0x11B5 -> 0xCA84, 0x0334, 0x11B5 CONCAT';
@list = 0xCAD8, 0x0334, 0x11BC; @result = 0xCAD8, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCAD8, 0x0334, 0x11BC -> 0xCAD8, 0x0334, 0x11BC CONCAT';
@list = 0xCB9C, 0x0334, 0x11AE; @result = 0xCB9C, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCB9C, 0x0334, 0x11AE -> 0xCB9C, 0x0334, 0x11AE CONCAT';
@list = 0xCBF0, 0x0334, 0x11B5; @result = 0xCBF0, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCBF0, 0x0334, 0x11B5 -> 0xCBF0, 0x0334, 0x11B5 CONCAT';
@list = 0xCC44, 0x0334, 0x11BC; @result = 0xCC44, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCC44, 0x0334, 0x11BC -> 0xCC44, 0x0334, 0x11BC CONCAT';
@list = 0xCD08, 0x0334, 0x11AE; @result = 0xCD08, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCD08, 0x0334, 0x11AE -> 0xCD08, 0x0334, 0x11AE CONCAT';
@list = 0xCD5C, 0x0334, 0x11B5; @result = 0xCD5C, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCD5C, 0x0334, 0x11B5 -> 0xCD5C, 0x0334, 0x11B5 CONCAT';
@list = 0xCDB0, 0x0334, 0x11BC; @result = 0xCDB0, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCDB0, 0x0334, 0x11BC -> 0xCDB0, 0x0334, 0x11BC CONCAT';
@list = 0xCE74, 0x0334, 0x11AE; @result = 0xCE74, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCE74, 0x0334, 0x11AE -> 0xCE74, 0x0334, 0x11AE CONCAT';
@list = 0xCEC8, 0x0334, 0x11B5; @result = 0xCEC8, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCEC8, 0x0334, 0x11B5 -> 0xCEC8, 0x0334, 0x11B5 CONCAT';
@list = 0xCF1C, 0x0334, 0x11BC; @result = 0xCF1C, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCF1C, 0x0334, 0x11BC -> 0xCF1C, 0x0334, 0x11BC CONCAT';
@list = 0xCFE0, 0x0334, 0x11AE; @result = 0xCFE0, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xCFE0, 0x0334, 0x11AE -> 0xCFE0, 0x0334, 0x11AE CONCAT';
@list = 0xD034, 0x0334, 0x11B5; @result = 0xD034, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD034, 0x0334, 0x11B5 -> 0xD034, 0x0334, 0x11B5 CONCAT';
@list = 0xD088, 0x0334, 0x11BC; @result = 0xD088, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD088, 0x0334, 0x11BC -> 0xD088, 0x0334, 0x11BC CONCAT';
@list = 0xD14C, 0x0334, 0x11AE; @result = 0xD14C, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD14C, 0x0334, 0x11AE -> 0xD14C, 0x0334, 0x11AE CONCAT';
@list = 0xD1A0, 0x0334, 0x11B5; @result = 0xD1A0, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD1A0, 0x0334, 0x11B5 -> 0xD1A0, 0x0334, 0x11B5 CONCAT';
@list = 0xD1F4, 0x0334, 0x11BC; @result = 0xD1F4, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD1F4, 0x0334, 0x11BC -> 0xD1F4, 0x0334, 0x11BC CONCAT';
@list = 0xD2B8, 0x0334, 0x11AE; @result = 0xD2B8, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD2B8, 0x0334, 0x11AE -> 0xD2B8, 0x0334, 0x11AE CONCAT';
@list = 0xD30C, 0x0334, 0x11B5; @result = 0xD30C, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD30C, 0x0334, 0x11B5 -> 0xD30C, 0x0334, 0x11B5 CONCAT';
@list = 0xD360, 0x0334, 0x11BC; @result = 0xD360, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD360, 0x0334, 0x11BC -> 0xD360, 0x0334, 0x11BC CONCAT';
@list = 0xD424, 0x0334, 0x11AE; @result = 0xD424, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD424, 0x0334, 0x11AE -> 0xD424, 0x0334, 0x11AE CONCAT';
@list = 0xD478, 0x0334, 0x11B5; @result = 0xD478, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD478, 0x0334, 0x11B5 -> 0xD478, 0x0334, 0x11B5 CONCAT';
@list = 0xD4CC, 0x0334, 0x11BC; @result = 0xD4CC, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD4CC, 0x0334, 0x11BC -> 0xD4CC, 0x0334, 0x11BC CONCAT';
@list = 0xD590, 0x0334, 0x11AE; @result = 0xD590, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD590, 0x0334, 0x11AE -> 0xD590, 0x0334, 0x11AE CONCAT';
@list = 0xD5E4, 0x0334, 0x11B5; @result = 0xD5E4, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD5E4, 0x0334, 0x11B5 -> 0xD5E4, 0x0334, 0x11B5 CONCAT';
@list = 0xD638, 0x0334, 0x11BC; @result = 0xD638, 0x0334, 0x11BC;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD638, 0x0334, 0x11BC -> 0xD638, 0x0334, 0x11BC CONCAT';
@list = 0xD6FC, 0x0334, 0x11AE; @result = 0xD6FC, 0x0334, 0x11AE;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD6FC, 0x0334, 0x11AE -> 0xD6FC, 0x0334, 0x11AE CONCAT';
@list = 0xD750, 0x0334, 0x11B5; @result = 0xD750, 0x0334, 0x11B5;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0xD750, 0x0334, 0x11B5 -> 0xD750, 0x0334, 0x11B5 CONCAT';
@list = 0x11131, 0x0334, 0x11127; @result = 0x11131, 0x0334, 0x11127;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x11131, 0x0334, 0x11127 -> 0x11131, 0x0334, 0x11127 CONCAT';
@list = 0x11132, 0x0334, 0x11127; @result = 0x11132, 0x0334, 0x11127;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x11132, 0x0334, 0x11127 -> 0x11132, 0x0334, 0x11127 CONCAT';
@list = 0x11347, 0x0334, 0x1133E; @result = 0x11347, 0x0334, 0x1133E;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x11347, 0x0334, 0x1133E -> 0x11347, 0x0334, 0x1133E CONCAT';
@list = 0x11347, 0x0334, 0x11357; @result = 0x11347, 0x0334, 0x11357;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x11347, 0x0334, 0x11357 -> 0x11347, 0x0334, 0x11357 CONCAT';
@list = 0x114B9, 0x0334, 0x114B0; @result = 0x114B9, 0x0334, 0x114B0;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x114B9, 0x0334, 0x114B0 -> 0x114B9, 0x0334, 0x114B0 CONCAT';
@list = 0x114B9, 0x0334, 0x114BA; @result = 0x114B9, 0x0334, 0x114BA;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x114B9, 0x0334, 0x114BA -> 0x114B9, 0x0334, 0x114BA CONCAT';
@list = 0x114B9, 0x0334, 0x114BD; @result = 0x114B9, 0x0334, 0x114BD;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x114B9, 0x0334, 0x114BD -> 0x114B9, 0x0334, 0x114BD CONCAT';
@list = 0x115B8, 0x0334, 0x115AF; @result = 0x115B8, 0x0334, 0x115AF;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x115B8, 0x0334, 0x115AF -> 0x115B8, 0x0334, 0x115AF CONCAT';
@list = 0x115B9, 0x0334, 0x115AF; @result = 0x115B9, 0x0334, 0x115AF;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x115B9, 0x0334, 0x115AF -> 0x115B9, 0x0334, 0x115AF CONCAT';
@list = 0x11935, 0x0334, 0x11930; @result = 0x11935, 0x0334, 0x11930;
ok all(((Uni.new(@list[0..($_ - 1)]) ~ Uni.new(@list[$_..*])).NFC.list ~~ @result for 1..(@list-1))), '0x11935, 0x0334, 0x11930 -> 0x11935, 0x0334, 0x11930 CONCAT';
