/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfrog.build.api.release.PromotionStatus;

public class PromotionStatusBuilder {
    private String status;
    private String comment;
    private String repository;
    private String timestamp;
    private String user;
    private String ciUser;

    public PromotionStatusBuilder(String status) {
        this.status = status;
    }

    public PromotionStatusBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public PromotionStatusBuilder repository(String repository) {
        this.repository = repository;
        return this;
    }

    public PromotionStatusBuilder timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public PromotionStatusBuilder timestampDate(Date timestampDate) {
        if (timestampDate == null) {
            throw new IllegalArgumentException("Cannot format a null date.");
        }
        this.timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(timestampDate);
        return this;
    }

    public PromotionStatusBuilder user(String user) {
        this.user = user;
        return this;
    }

    public PromotionStatusBuilder ciUser(String ciUser) {
        this.ciUser = ciUser;
        return this;
    }

    public PromotionStatus build() {
        if (this.status == null) {
            throw new IllegalArgumentException("Status must have a type.");
        }
        if (this.timestamp == null) {
            throw new IllegalArgumentException("Status must have a timestamp.");
        }
        return new PromotionStatus(this.status, this.comment, this.repository, this.timestamp, this.user, this.ciUser);
    }
}

