/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import java.security.SecureRandom;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public class BackupKey
extends ByteArray {
    public static final int SIZE = 32;

    public BackupKey(byte[] contents) throws InvalidInputException {
        super(contents, 32);
    }

    public static BackupKey generateRandom() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[32];
        secureRandom.nextBytes(bytes);
        return FilterExceptions.filterExceptions(() -> new BackupKey(bytes));
    }

    public byte[] deriveBackupId(ServiceId.Aci aci) {
        return Native.BackupKey_DeriveBackupId(this.getInternalContentsForJNI(), aci.toServiceIdFixedWidthBinary());
    }

    public ECPrivateKey deriveEcKey(ServiceId.Aci aci) {
        return new ECPrivateKey(Native.BackupKey_DeriveEcKey(this.getInternalContentsForJNI(), aci.toServiceIdFixedWidthBinary()));
    }

    public byte[] deriveLocalBackupMetadataKey() {
        return Native.BackupKey_DeriveLocalBackupMetadataKey(this.getInternalContentsForJNI());
    }

    public byte[] deriveMediaId(String mediaName) {
        return Native.BackupKey_DeriveMediaId(this.getInternalContentsForJNI(), mediaName);
    }

    public byte[] deriveMediaEncryptionKey(byte[] mediaId) {
        return Native.BackupKey_DeriveMediaEncryptionKey(this.getInternalContentsForJNI(), mediaId);
    }

    public byte[] deriveThumbnailTransitEncryptionKey(byte[] mediaId) {
        return Native.BackupKey_DeriveThumbnailTransitEncryptionKey(this.getInternalContentsForJNI(), mediaId);
    }
}

