/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.util.Locale;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.internal.TokioAsyncContext;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.FakeChatRemote;
import org.signal.libsignal.net.KeyTransparencyClient;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.internal.BridgeChatListener;
import org.signal.libsignal.protocol.util.Pair;

public class UnauthenticatedChatConnection
extends ChatConnection {
    private KeyTransparencyClient keyTransparencyClient;

    private UnauthenticatedChatConnection(TokioAsyncContext tokioAsyncContext, long nativeHandle, ChatConnectionListener listener, Network.Environment ktEnvironment) {
        super(tokioAsyncContext, nativeHandle, listener);
        this.keyTransparencyClient = new KeyTransparencyClient(this, tokioAsyncContext, ktEnvironment);
    }

    static CompletableFuture<UnauthenticatedChatConnection> connect(TokioAsyncContext tokioAsyncContext, Network.ConnectionManager connectionManager, Locale locale, ChatConnectionListener chatListener) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> connectionManager.guardedMap(connectionManagerHandle -> Native.UnauthenticatedChatConnection_connect(asyncContextHandle, connectionManagerHandle, Network.languageCodesForLocale(locale)).makeCancelable(tokioAsyncContext).thenApply(nativeHandle -> new UnauthenticatedChatConnection(tokioAsyncContext, (long)nativeHandle, chatListener, connectionManager.environment()))));
    }

    public KeyTransparencyClient keyTransparencyClient() {
        return this.keyTransparencyClient;
    }

    public static Pair<UnauthenticatedChatConnection, FakeChatRemote> fakeConnect(TokioAsyncContext tokioAsyncContext, ChatConnectionListener listener, Network.Environment ktEnvironment) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> {
            ChatConnection.SetChatLaterListenerBridge bridgeListener = new ChatConnection.SetChatLaterListenerBridge();
            long fakeChatConnection = NativeTesting.TESTING_FakeChatConnection_Create(asyncContextHandle, bridgeListener, "");
            UnauthenticatedChatConnection chat = new UnauthenticatedChatConnection(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeUnauthenticatedChat(fakeChatConnection), listener, ktEnvironment);
            bridgeListener.setChat(chat);
            FakeChatRemote fakeRemote = new FakeChatRemote(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeRemote(fakeChatConnection));
            NativeTesting.FakeChatConnection_Destroy(fakeChatConnection);
            return new Pair<UnauthenticatedChatConnection, FakeChatRemote>(chat, fakeRemote);
        });
    }

    @Override
    protected CompletableFuture disconnectWrapper(long nativeAsyncContextHandle, long nativeChatServiceHandle) {
        return Native.UnauthenticatedChatConnection_disconnect(nativeAsyncContextHandle, nativeChatServiceHandle);
    }

    @Override
    protected void startWrapper(long nativeChatConnectionHandle, BridgeChatListener listener) {
        Native.UnauthenticatedChatConnection_init_listener(nativeChatConnectionHandle, listener);
    }

    @Override
    protected CompletableFuture<Object> sendWrapper(long nativeAsyncContextHandle, long nativeChatConnectionHandle, long nativeRequestHandle, int timeoutMillis) {
        return Native.UnauthenticatedChatConnection_send(nativeAsyncContextHandle, nativeChatConnectionHandle, nativeRequestHandle, timeoutMillis);
    }

    @Override
    protected void release(long nativeChatConnectionHandle) {
        Native.UnauthenticatedChatConnection_Destroy(nativeChatConnectionHandle);
    }
}

