/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import java.security.SecureRandom;
import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.calllinks.CallLinkAuthCredentialPresentation;
import org.signal.libsignal.zkgroup.calllinks.CallLinkSecretParams;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CallLinkAuthCredential
extends ByteArray {
    public CallLinkAuthCredential(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.CallLinkAuthCredential_CheckValidContents(contents));
    }

    public CallLinkAuthCredentialPresentation present(ServiceId.Aci userId, Instant redemptionTime, GenericServerPublicParams serverParams, CallLinkSecretParams callLinkParams) {
        return this.present(userId, redemptionTime, serverParams, callLinkParams, new SecureRandom());
    }

    public CallLinkAuthCredentialPresentation present(ServiceId.Aci userId, Instant redemptionTime, GenericServerPublicParams serverParams, CallLinkSecretParams callLinkParams, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = FilterExceptions.filterExceptions(() -> Native.CallLinkAuthCredential_PresentDeterministic(this.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary(), redemptionTime.getEpochSecond(), serverParams.getInternalContentsForJNI(), callLinkParams.getInternalContentsForJNI(), random));
        try {
            return new CallLinkAuthCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

