/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.signal.core.util.concurrent.ListenableFuture;
import org.signal.core.util.concurrent.SettableFuture;

public final class CascadingFuture<T>
implements ListenableFuture<T> {
    private static final String TAG = CascadingFuture.class.getSimpleName();
    private SettableFuture<T> result;

    public CascadingFuture(List<Callable<ListenableFuture<T>>> callables, ExceptionChecker exceptionChecker) {
        if (callables.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one callable!");
        }
        this.result = new SettableFuture();
        this.doNext(new ArrayList<Callable<ListenableFuture<T>>>(callables), exceptionChecker);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.result.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.result.isDone();
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return this.result.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.result.get(timeout, unit);
    }

    @Override
    public void addListener(ListenableFuture.Listener<T> listener) {
        this.result.addListener(listener);
    }

    private void doNext(final List<Callable<ListenableFuture<T>>> callables, final ExceptionChecker exceptionChecker) {
        block3: {
            Callable<ListenableFuture<T>> callable = callables.remove(0);
            try {
                ListenableFuture<T> future = callable.call();
                future.addListener(new ListenableFuture.Listener<T>(){

                    @Override
                    public void onSuccess(T value) {
                        CascadingFuture.this.result.set(value);
                    }

                    @Override
                    public void onFailure(ExecutionException e) {
                        if (callables.isEmpty() || !exceptionChecker.shouldContinue(e)) {
                            CascadingFuture.this.result.setException(e.getCause());
                        } else if (!CascadingFuture.this.result.isCancelled()) {
                            CascadingFuture.this.doNext(callables, exceptionChecker);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (callables.isEmpty() || !exceptionChecker.shouldContinue(e)) {
                    this.result.setException(e.getCause());
                }
                if (this.result.isCancelled()) break block3;
                this.doNext(callables, exceptionChecker);
            }
        }
    }

    public static interface ExceptionChecker {
        public boolean shouldContinue(Exception var1);
    }
}

