/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;

public class UpdateContactCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "updateContact";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Update the details of a given contact");
        subparser.addArgument(new String[]{"recipient"}).help("Contact number");
        subparser.addArgument(new String[]{"-n", "--name"}).help("New contact name");
        subparser.addArgument(new String[]{"--given-name"}).help("New system given name");
        subparser.addArgument(new String[]{"--family-name"}).help("New system family name");
        subparser.addArgument(new String[]{"--nick-given-name"}).help("New nick given name");
        subparser.addArgument(new String[]{"--nick-family-name"}).help("New nick family name");
        subparser.addArgument(new String[]{"--note"}).help("New note");
        subparser.addArgument(new String[]{"-e", "--expiration"}).type(Integer.TYPE).help("Set expiration time of messages (seconds)");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String recipientString = ns.getString("recipient");
        RecipientIdentifier.Single recipient = CommandUtil.getSingleRecipientIdentifier(recipientString, m.getSelfNumber());
        try {
            Integer expiration = ns.getInt("expiration");
            if (expiration != null) {
                m.setExpirationTimer(recipient, expiration.intValue());
            }
            String givenName = ns.getString("given-name");
            String familyName = ns.getString("family-name");
            if (givenName == null && (givenName = ns.getString("name")) != null && familyName == null) {
                familyName = "";
            }
            String nickGivenName = ns.getString("nick-given-name");
            String nickFamilyName = ns.getString("nick-family-name");
            String note = ns.getString("note");
            m.setContactName(recipient, givenName, familyName, nickGivenName, nickFamilyName, note);
        }
        catch (IOException e) {
            throw new IOErrorException("Update contact error: " + e.getMessage(), e);
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
        catch (UnregisteredRecipientException e) {
            throw new UserErrorException("The user " + e.getSender().getIdentifier() + " is not registered.");
        }
    }
}

