/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import net.sf.clipsrules.jni.CLIPSType;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.PrimitiveValue;

public class ExternalAddressValue
extends PrimitiveValue {
    private Environment owner;
    private long value = 0L;

    public ExternalAddressValue(Object object, Environment environment) {
        this.owner = environment;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public CLIPSType getCLIPSType() {
        return CLIPSType.EXTERNAL_ADDRESS;
    }

    public Environment getEnvironment() {
        return this.owner;
    }

    public long getExternalAddress() {
        return this.getValue();
    }

    @Override
    public void retain() {
        this.owner.incrementAddressCount(this);
    }

    @Override
    public void release() {
        this.owner.decrementAddressCount(this);
    }

    @Override
    public String toString() {
        return "<ExternalAddress-" + this.getValue() + ">";
    }

    @Override
    public boolean isExternalAddress() {
        return true;
    }
}

