package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeliveryHistoryJob invokes the actiontrail.DeleteDeliveryHistoryJob API synchronously
func (client *Client) DeleteDeliveryHistoryJob(request *DeleteDeliveryHistoryJobRequest) (response *DeleteDeliveryHistoryJobResponse, err error) {
	response = CreateDeleteDeliveryHistoryJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeliveryHistoryJobWithChan invokes the actiontrail.DeleteDeliveryHistoryJob API asynchronously
func (client *Client) DeleteDeliveryHistoryJobWithChan(request *DeleteDeliveryHistoryJobRequest) (<-chan *DeleteDeliveryHistoryJobResponse, <-chan error) {
	responseChan := make(chan *DeleteDeliveryHistoryJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeliveryHistoryJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeliveryHistoryJobWithCallback invokes the actiontrail.DeleteDeliveryHistoryJob API asynchronously
func (client *Client) DeleteDeliveryHistoryJobWithCallback(request *DeleteDeliveryHistoryJobRequest, callback func(response *DeleteDeliveryHistoryJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeliveryHistoryJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeliveryHistoryJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeliveryHistoryJobRequest is the request struct for api DeleteDeliveryHistoryJob
type DeleteDeliveryHistoryJobRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
}

// DeleteDeliveryHistoryJobResponse is the response struct for api DeleteDeliveryHistoryJob
type DeleteDeliveryHistoryJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDeliveryHistoryJobRequest creates a request to invoke DeleteDeliveryHistoryJob API
func CreateDeleteDeliveryHistoryJobRequest() (request *DeleteDeliveryHistoryJobRequest) {
	request = &DeleteDeliveryHistoryJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "DeleteDeliveryHistoryJob", "actiontrail", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDeliveryHistoryJobResponse creates a response to parse from DeleteDeliveryHistoryJob response
func CreateDeleteDeliveryHistoryJobResponse() (response *DeleteDeliveryHistoryJobResponse) {
	response = &DeleteDeliveryHistoryJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
