package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResumePdnsService invokes the alidns.ResumePdnsService API synchronously
func (client *Client) ResumePdnsService(request *ResumePdnsServiceRequest) (response *ResumePdnsServiceResponse, err error) {
	response = CreateResumePdnsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ResumePdnsServiceWithChan invokes the alidns.ResumePdnsService API asynchronously
func (client *Client) ResumePdnsServiceWithChan(request *ResumePdnsServiceRequest) (<-chan *ResumePdnsServiceResponse, <-chan error) {
	responseChan := make(chan *ResumePdnsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResumePdnsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResumePdnsServiceWithCallback invokes the alidns.ResumePdnsService API asynchronously
func (client *Client) ResumePdnsServiceWithCallback(request *ResumePdnsServiceRequest, callback func(response *ResumePdnsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResumePdnsServiceResponse
		var err error
		defer close(result)
		response, err = client.ResumePdnsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResumePdnsServiceRequest is the request struct for api ResumePdnsService
type ResumePdnsServiceRequest struct {
	*requests.RpcRequest
	ServiceType string `position:"Query" name:"ServiceType"`
	Lang        string `position:"Query" name:"Lang"`
}

// ResumePdnsServiceResponse is the response struct for api ResumePdnsService
type ResumePdnsServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResumePdnsServiceRequest creates a request to invoke ResumePdnsService API
func CreateResumePdnsServiceRequest() (request *ResumePdnsServiceRequest) {
	request = &ResumePdnsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "ResumePdnsService", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResumePdnsServiceResponse creates a response to parse from ResumePdnsService response
func CreateResumePdnsServiceResponse() (response *ResumePdnsServiceResponse) {
	response = &ResumePdnsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
