package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeviceMeeting invokes the aliyuncvc.CreateDeviceMeeting API synchronously
func (client *Client) CreateDeviceMeeting(request *CreateDeviceMeetingRequest) (response *CreateDeviceMeetingResponse, err error) {
	response = CreateCreateDeviceMeetingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceMeetingWithChan invokes the aliyuncvc.CreateDeviceMeeting API asynchronously
func (client *Client) CreateDeviceMeetingWithChan(request *CreateDeviceMeetingRequest) (<-chan *CreateDeviceMeetingResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceMeetingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeviceMeeting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceMeetingWithCallback invokes the aliyuncvc.CreateDeviceMeeting API asynchronously
func (client *Client) CreateDeviceMeetingWithCallback(request *CreateDeviceMeetingRequest, callback func(response *CreateDeviceMeetingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceMeetingResponse
		var err error
		defer close(result)
		response, err = client.CreateDeviceMeeting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceMeetingRequest is the request struct for api CreateDeviceMeeting
type CreateDeviceMeetingRequest struct {
	*requests.RpcRequest
	MeetingName     string           `position:"Body" name:"MeetingName"`
	OpenPasswordtag requests.Boolean `position:"Body" name:"OpenPasswordtag"`
	Token           string           `position:"Body" name:"Token"`
	Password        string           `position:"Body" name:"Password"`
	SN              string           `position:"Body" name:"SN"`
}

// CreateDeviceMeetingResponse is the response struct for api CreateDeviceMeeting
type CreateDeviceMeetingResponse struct {
	*responses.BaseResponse
	ErrorCode int     `json:"ErrorCode" xml:"ErrorCode"`
	Message   string  `json:"Message" xml:"Message"`
	Success   bool    `json:"Success" xml:"Success"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Devices   Devices `json:"Devices" xml:"Devices"`
}

// CreateCreateDeviceMeetingRequest creates a request to invoke CreateDeviceMeeting API
func CreateCreateDeviceMeetingRequest() (request *CreateDeviceMeetingRequest) {
	request = &CreateDeviceMeetingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "CreateDeviceMeeting", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceMeetingResponse creates a response to parse from CreateDeviceMeeting response
func CreateCreateDeviceMeetingResponse() (response *CreateDeviceMeetingResponse) {
	response = &CreateDeviceMeetingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
