package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PaginateProject invokes the cdrs.PaginateProject API synchronously
func (client *Client) PaginateProject(request *PaginateProjectRequest) (response *PaginateProjectResponse, err error) {
	response = CreatePaginateProjectResponse()
	err = client.DoAction(request, response)
	return
}

// PaginateProjectWithChan invokes the cdrs.PaginateProject API asynchronously
func (client *Client) PaginateProjectWithChan(request *PaginateProjectRequest) (<-chan *PaginateProjectResponse, <-chan error) {
	responseChan := make(chan *PaginateProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PaginateProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PaginateProjectWithCallback invokes the cdrs.PaginateProject API asynchronously
func (client *Client) PaginateProjectWithCallback(request *PaginateProjectRequest, callback func(response *PaginateProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PaginateProjectResponse
		var err error
		defer close(result)
		response, err = client.PaginateProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PaginateProjectRequest is the request struct for api PaginateProject
type PaginateProjectRequest struct {
	*requests.RpcRequest
	Type          string           `position:"Body" name:"Type"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	CountTotalNum requests.Boolean `position:"Body" name:"CountTotalNum"`
	AppName       string           `position:"Body" name:"AppName"`
	NameSpace     string           `position:"Body" name:"NameSpace"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	NameLike      string           `position:"Body" name:"NameLike"`
}

// PaginateProjectResponse is the response struct for api PaginateProject
type PaginateProjectResponse struct {
	*responses.BaseResponse
	Code      string                `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Data      DataInPaginateProject `json:"Data" xml:"Data"`
}

// CreatePaginateProjectRequest creates a request to invoke PaginateProject API
func CreatePaginateProjectRequest() (request *PaginateProjectRequest) {
	request = &PaginateProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "PaginateProject", "", "")
	request.Method = requests.POST
	return
}

// CreatePaginateProjectResponse creates a response to parse from PaginateProject response
func CreatePaginateProjectResponse() (response *PaginateProjectResponse) {
	response = &PaginateProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
