package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFunctionMetas invokes the cloudcallcenter.ListFunctionMetas API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listfunctionmetas.html
func (client *Client) ListFunctionMetas(request *ListFunctionMetasRequest) (response *ListFunctionMetasResponse, err error) {
	response = CreateListFunctionMetasResponse()
	err = client.DoAction(request, response)
	return
}

// ListFunctionMetasWithChan invokes the cloudcallcenter.ListFunctionMetas API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listfunctionmetas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFunctionMetasWithChan(request *ListFunctionMetasRequest) (<-chan *ListFunctionMetasResponse, <-chan error) {
	responseChan := make(chan *ListFunctionMetasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFunctionMetas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFunctionMetasWithCallback invokes the cloudcallcenter.ListFunctionMetas API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listfunctionmetas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFunctionMetasWithCallback(request *ListFunctionMetasRequest, callback func(response *ListFunctionMetasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFunctionMetasResponse
		var err error
		defer close(result)
		response, err = client.ListFunctionMetas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFunctionMetasRequest is the request struct for api ListFunctionMetas
type ListFunctionMetasRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListFunctionMetasResponse is the response struct for api ListFunctionMetas
type ListFunctionMetasResponse struct {
	*responses.BaseResponse
	RequestId      string        `json:"RequestId" xml:"RequestId"`
	Success        bool          `json:"Success" xml:"Success"`
	Code           string        `json:"Code" xml:"Code"`
	Message        string        `json:"Message" xml:"Message"`
	HttpStatusCode int           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FunctionMetas  FunctionMetas `json:"FunctionMetas" xml:"FunctionMetas"`
}

// CreateListFunctionMetasRequest creates a request to invoke ListFunctionMetas API
func CreateListFunctionMetasRequest() (request *ListFunctionMetasRequest) {
	request = &ListFunctionMetasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListFunctionMetas", "", "")
	request.Method = requests.POST
	return
}

// CreateListFunctionMetasResponse creates a response to parse from ListFunctionMetas response
func CreateListFunctionMetasResponse() (response *ListFunctionMetasResponse) {
	response = &ListFunctionMetasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
