package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivilegesByLoginName invokes the cloudcallcenter.ListPrivilegesByLoginName API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesbyloginname.html
func (client *Client) ListPrivilegesByLoginName(request *ListPrivilegesByLoginNameRequest) (response *ListPrivilegesByLoginNameResponse, err error) {
	response = CreateListPrivilegesByLoginNameResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivilegesByLoginNameWithChan invokes the cloudcallcenter.ListPrivilegesByLoginName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesbyloginname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPrivilegesByLoginNameWithChan(request *ListPrivilegesByLoginNameRequest) (<-chan *ListPrivilegesByLoginNameResponse, <-chan error) {
	responseChan := make(chan *ListPrivilegesByLoginNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivilegesByLoginName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivilegesByLoginNameWithCallback invokes the cloudcallcenter.ListPrivilegesByLoginName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listprivilegesbyloginname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPrivilegesByLoginNameWithCallback(request *ListPrivilegesByLoginNameRequest, callback func(response *ListPrivilegesByLoginNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivilegesByLoginNameResponse
		var err error
		defer close(result)
		response, err = client.ListPrivilegesByLoginName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivilegesByLoginNameRequest is the request struct for api ListPrivilegesByLoginName
type ListPrivilegesByLoginNameRequest struct {
	*requests.RpcRequest
	InstanceName string `position:"Query" name:"InstanceName"`
	LoginName    string `position:"Query" name:"LoginName"`
}

// ListPrivilegesByLoginNameResponse is the response struct for api ListPrivilegesByLoginName
type ListPrivilegesByLoginNameResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PrivilegeInfos PrivilegeInfos `json:"PrivilegeInfos" xml:"PrivilegeInfos"`
}

// CreateListPrivilegesByLoginNameRequest creates a request to invoke ListPrivilegesByLoginName API
func CreateListPrivilegesByLoginNameRequest() (request *ListPrivilegesByLoginNameRequest) {
	request = &ListPrivilegesByLoginNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPrivilegesByLoginName", "", "")
	request.Method = requests.POST
	return
}

// CreateListPrivilegesByLoginNameResponse creates a response to parse from ListPrivilegesByLoginName response
func CreateListPrivilegesByLoginNameResponse() (response *ListPrivilegesByLoginNameResponse) {
	response = &ListPrivilegesByLoginNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
