package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnGreetingConfig invokes the cloudcallcenter.ModifyVnGreetingConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvngreetingconfig.html
func (client *Client) ModifyVnGreetingConfig(request *ModifyVnGreetingConfigRequest) (response *ModifyVnGreetingConfigResponse, err error) {
	response = CreateModifyVnGreetingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnGreetingConfigWithChan invokes the cloudcallcenter.ModifyVnGreetingConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvngreetingconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnGreetingConfigWithChan(request *ModifyVnGreetingConfigRequest) (<-chan *ModifyVnGreetingConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyVnGreetingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnGreetingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnGreetingConfigWithCallback invokes the cloudcallcenter.ModifyVnGreetingConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvngreetingconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnGreetingConfigWithCallback(request *ModifyVnGreetingConfigRequest, callback func(response *ModifyVnGreetingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnGreetingConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnGreetingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnGreetingConfigRequest is the request struct for api ModifyVnGreetingConfig
type ModifyVnGreetingConfigRequest struct {
	*requests.RpcRequest
	GreetingWords string `position:"Query" name:"GreetingWords"`
	IntentTrigger string `position:"Query" name:"IntentTrigger"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SourceType    string `position:"Query" name:"SourceType"`
}

// ModifyVnGreetingConfigResponse is the response struct for api ModifyVnGreetingConfig
type ModifyVnGreetingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnGreetingConfigRequest creates a request to invoke ModifyVnGreetingConfig API
func CreateModifyVnGreetingConfigRequest() (request *ModifyVnGreetingConfigRequest) {
	request = &ModifyVnGreetingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnGreetingConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnGreetingConfigResponse creates a response to parse from ModifyVnGreetingConfig response
func CreateModifyVnGreetingConfigResponse() (response *ModifyVnGreetingConfigResponse) {
	response = &ModifyVnGreetingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
