package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreCheck invokes the cloudcallcenter.PreCheck API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precheck.html
func (client *Client) PreCheck(request *PreCheckRequest) (response *PreCheckResponse, err error) {
	response = CreatePreCheckResponse()
	err = client.DoAction(request, response)
	return
}

// PreCheckWithChan invokes the cloudcallcenter.PreCheck API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precheck.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCheckWithChan(request *PreCheckRequest) (<-chan *PreCheckResponse, <-chan error) {
	responseChan := make(chan *PreCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreCheckWithCallback invokes the cloudcallcenter.PreCheck API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precheck.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCheckWithCallback(request *PreCheckRequest, callback func(response *PreCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreCheckResponse
		var err error
		defer close(result)
		response, err = client.PreCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreCheckRequest is the request struct for api PreCheck
type PreCheckRequest struct {
	*requests.RpcRequest
	Number *[]string `position:"Query" name:"Number"  type:"Repeated"`
}

// PreCheckResponse is the response struct for api PreCheck
type PreCheckResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Avaliable      bool   `json:"Avaliable" xml:"Avaliable"`
}

// CreatePreCheckRequest creates a request to invoke PreCheck API
func CreatePreCheckRequest() (request *PreCheckRequest) {
	request = &PreCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PreCheck", "", "")
	request.Method = requests.POST
	return
}

// CreatePreCheckResponse creates a response to parse from PreCheck response
func CreatePreCheckResponse() (response *PreCheckResponse) {
	response = &PreCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
