package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveRolesFromUser invokes the cloudcallcenter.RemoveRolesFromUser API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removerolesfromuser.html
func (client *Client) RemoveRolesFromUser(request *RemoveRolesFromUserRequest) (response *RemoveRolesFromUserResponse, err error) {
	response = CreateRemoveRolesFromUserResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveRolesFromUserWithChan invokes the cloudcallcenter.RemoveRolesFromUser API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removerolesfromuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveRolesFromUserWithChan(request *RemoveRolesFromUserRequest) (<-chan *RemoveRolesFromUserResponse, <-chan error) {
	responseChan := make(chan *RemoveRolesFromUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveRolesFromUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveRolesFromUserWithCallback invokes the cloudcallcenter.RemoveRolesFromUser API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removerolesfromuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveRolesFromUserWithCallback(request *RemoveRolesFromUserRequest, callback func(response *RemoveRolesFromUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveRolesFromUserResponse
		var err error
		defer close(result)
		response, err = client.RemoveRolesFromUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveRolesFromUserRequest is the request struct for api RemoveRolesFromUser
type RemoveRolesFromUserRequest struct {
	*requests.RpcRequest
	InstanceId string    `position:"Query" name:"InstanceId"`
	RoleId     *[]string `position:"Query" name:"RoleId"  type:"Repeated"`
	UserId     string    `position:"Query" name:"UserId"`
}

// RemoveRolesFromUserResponse is the response struct for api RemoveRolesFromUser
type RemoveRolesFromUserResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	User           User   `json:"User" xml:"User"`
}

// CreateRemoveRolesFromUserRequest creates a request to invoke RemoveRolesFromUser API
func CreateRemoveRolesFromUserRequest() (request *RemoveRolesFromUserRequest) {
	request = &RemoveRolesFromUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemoveRolesFromUser", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveRolesFromUserResponse creates a response to parse from RemoveRolesFromUser response
func CreateRemoveRolesFromUserResponse() (response *RemoveRolesFromUserResponse) {
	response = &RemoveRolesFromUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
