package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPhotoStore invokes the cloudphoto.GetPhotoStore API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotostore.html
func (client *Client) GetPhotoStore(request *GetPhotoStoreRequest) (response *GetPhotoStoreResponse, err error) {
	response = CreateGetPhotoStoreResponse()
	err = client.DoAction(request, response)
	return
}

// GetPhotoStoreWithChan invokes the cloudphoto.GetPhotoStore API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotostore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotoStoreWithChan(request *GetPhotoStoreRequest) (<-chan *GetPhotoStoreResponse, <-chan error) {
	responseChan := make(chan *GetPhotoStoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPhotoStore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPhotoStoreWithCallback invokes the cloudphoto.GetPhotoStore API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotostore.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotoStoreWithCallback(request *GetPhotoStoreRequest, callback func(response *GetPhotoStoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPhotoStoreResponse
		var err error
		defer close(result)
		response, err = client.GetPhotoStore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPhotoStoreRequest is the request struct for api GetPhotoStore
type GetPhotoStoreRequest struct {
	*requests.RpcRequest
	StoreName string `position:"Query" name:"StoreName"`
}

// GetPhotoStoreResponse is the response struct for api GetPhotoStore
type GetPhotoStoreResponse struct {
	*responses.BaseResponse
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Action     string     `json:"Action" xml:"Action"`
	PhotoStore PhotoStore `json:"PhotoStore" xml:"PhotoStore"`
}

// CreateGetPhotoStoreRequest creates a request to invoke GetPhotoStore API
func CreateGetPhotoStoreRequest() (request *GetPhotoStoreRequest) {
	request = &GetPhotoStoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "GetPhotoStore", "cloudphoto", "openAPI")
	return
}

// CreateGetPhotoStoreResponse creates a response to parse from GetPhotoStore response
func CreateGetPhotoStoreResponse() (response *GetPhotoStoreResponse) {
	response = &GetPhotoStoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
