package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSiteMonitorStatistics invokes the cms.DescribeSiteMonitorStatistics API synchronously
func (client *Client) DescribeSiteMonitorStatistics(request *DescribeSiteMonitorStatisticsRequest) (response *DescribeSiteMonitorStatisticsResponse, err error) {
	response = CreateDescribeSiteMonitorStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSiteMonitorStatisticsWithChan invokes the cms.DescribeSiteMonitorStatistics API asynchronously
func (client *Client) DescribeSiteMonitorStatisticsWithChan(request *DescribeSiteMonitorStatisticsRequest) (<-chan *DescribeSiteMonitorStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeSiteMonitorStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSiteMonitorStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSiteMonitorStatisticsWithCallback invokes the cms.DescribeSiteMonitorStatistics API asynchronously
func (client *Client) DescribeSiteMonitorStatisticsWithCallback(request *DescribeSiteMonitorStatisticsRequest, callback func(response *DescribeSiteMonitorStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSiteMonitorStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSiteMonitorStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSiteMonitorStatisticsRequest is the request struct for api DescribeSiteMonitorStatistics
type DescribeSiteMonitorStatisticsRequest struct {
	*requests.RpcRequest
	TimeRange  string `position:"Query" name:"TimeRange"`
	StartTime  string `position:"Query" name:"StartTime"`
	MetricName string `position:"Query" name:"MetricName"`
	TaskId     string `position:"Query" name:"TaskId"`
}

// DescribeSiteMonitorStatisticsResponse is the response struct for api DescribeSiteMonitorStatistics
type DescribeSiteMonitorStatisticsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDescribeSiteMonitorStatisticsRequest creates a request to invoke DescribeSiteMonitorStatistics API
func CreateDescribeSiteMonitorStatisticsRequest() (request *DescribeSiteMonitorStatisticsRequest) {
	request = &DescribeSiteMonitorStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeSiteMonitorStatistics", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSiteMonitorStatisticsResponse creates a response to parse from DescribeSiteMonitorStatistics response
func CreateDescribeSiteMonitorStatisticsResponse() (response *DescribeSiteMonitorStatisticsResponse) {
	response = &DescribeSiteMonitorStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
