package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMergeRequestSetting invokes the codeup.GetMergeRequestSetting API synchronously
func (client *Client) GetMergeRequestSetting(request *GetMergeRequestSettingRequest) (response *GetMergeRequestSettingResponse, err error) {
	response = CreateGetMergeRequestSettingResponse()
	err = client.DoAction(request, response)
	return
}

// GetMergeRequestSettingWithChan invokes the codeup.GetMergeRequestSetting API asynchronously
func (client *Client) GetMergeRequestSettingWithChan(request *GetMergeRequestSettingRequest) (<-chan *GetMergeRequestSettingResponse, <-chan error) {
	responseChan := make(chan *GetMergeRequestSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMergeRequestSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMergeRequestSettingWithCallback invokes the codeup.GetMergeRequestSetting API asynchronously
func (client *Client) GetMergeRequestSettingWithCallback(request *GetMergeRequestSettingRequest, callback func(response *GetMergeRequestSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMergeRequestSettingResponse
		var err error
		defer close(result)
		response, err = client.GetMergeRequestSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMergeRequestSettingRequest is the request struct for api GetMergeRequestSetting
type GetMergeRequestSettingRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// GetMergeRequestSettingResponse is the response struct for api GetMergeRequestSetting
type GetMergeRequestSettingResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetMergeRequestSettingRequest creates a request to invoke GetMergeRequestSetting API
func CreateGetMergeRequestSettingRequest() (request *GetMergeRequestSettingRequest) {
	request = &GetMergeRequestSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetMergeRequestSetting", "/api/v4/projects/[ProjectId]/settings/merge_requests", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMergeRequestSettingResponse creates a response to parse from GetMergeRequestSetting response
func CreateGetMergeRequestSettingResponse() (response *GetMergeRequestSettingResponse) {
	response = &GetMergeRequestSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
