package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepoSyncRule invokes the cr.ListRepoSyncRule API synchronously
// api document: https://help.aliyun.com/api/cr/listreposyncrule.html
func (client *Client) ListRepoSyncRule(request *ListRepoSyncRuleRequest) (response *ListRepoSyncRuleResponse, err error) {
	response = CreateListRepoSyncRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepoSyncRuleWithChan invokes the cr.ListRepoSyncRule API asynchronously
// api document: https://help.aliyun.com/api/cr/listreposyncrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoSyncRuleWithChan(request *ListRepoSyncRuleRequest) (<-chan *ListRepoSyncRuleResponse, <-chan error) {
	responseChan := make(chan *ListRepoSyncRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepoSyncRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepoSyncRuleWithCallback invokes the cr.ListRepoSyncRule API asynchronously
// api document: https://help.aliyun.com/api/cr/listreposyncrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoSyncRuleWithCallback(request *ListRepoSyncRuleRequest, callback func(response *ListRepoSyncRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepoSyncRuleResponse
		var err error
		defer close(result)
		response, err = client.ListRepoSyncRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepoSyncRuleRequest is the request struct for api ListRepoSyncRule
type ListRepoSyncRuleRequest struct {
	*requests.RpcRequest
	NamespaceName    string           `position:"Query" name:"NamespaceName"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	TargetInstanceId string           `position:"Query" name:"TargetInstanceId"`
	RepoName         string           `position:"Query" name:"RepoName"`
	PageNo           requests.Integer `position:"Query" name:"PageNo"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	TargetRegionId   string           `position:"Query" name:"TargetRegionId"`
}

// ListRepoSyncRuleResponse is the response struct for api ListRepoSyncRule
type ListRepoSyncRuleResponse struct {
	*responses.BaseResponse
	ListRepoSyncRuleIsSuccess bool            `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string          `json:"Code" xml:"Code"`
	RequestId                 string          `json:"RequestId" xml:"RequestId"`
	PageNo                    int             `json:"PageNo" xml:"PageNo"`
	PageSize                  int             `json:"PageSize" xml:"PageSize"`
	TotalCount                int             `json:"TotalCount" xml:"TotalCount"`
	SyncRules                 []SyncRulesItem `json:"SyncRules" xml:"SyncRules"`
}

// CreateListRepoSyncRuleRequest creates a request to invoke ListRepoSyncRule API
func CreateListRepoSyncRuleRequest() (request *ListRepoSyncRuleRequest) {
	request = &ListRepoSyncRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListRepoSyncRule", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRepoSyncRuleResponse creates a response to parse from ListRepoSyncRule response
func CreateListRepoSyncRuleResponse() (response *ListRepoSyncRuleResponse) {
	response = &ListRepoSyncRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
