package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewCredentials invokes the csb.RenewCredentials API synchronously
// api document: https://help.aliyun.com/api/csb/renewcredentials.html
func (client *Client) RenewCredentials(request *RenewCredentialsRequest) (response *RenewCredentialsResponse, err error) {
	response = CreateRenewCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// RenewCredentialsWithChan invokes the csb.RenewCredentials API asynchronously
// api document: https://help.aliyun.com/api/csb/renewcredentials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenewCredentialsWithChan(request *RenewCredentialsRequest) (<-chan *RenewCredentialsResponse, <-chan error) {
	responseChan := make(chan *RenewCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewCredentialsWithCallback invokes the csb.RenewCredentials API asynchronously
// api document: https://help.aliyun.com/api/csb/renewcredentials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenewCredentialsWithCallback(request *RenewCredentialsRequest, callback func(response *RenewCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewCredentialsResponse
		var err error
		defer close(result)
		response, err = client.RenewCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewCredentialsRequest is the request struct for api RenewCredentials
type RenewCredentialsRequest struct {
	*requests.RpcRequest
	CredentialId requests.Integer `position:"Query" name:"CredentialId"`
}

// RenewCredentialsResponse is the response struct for api RenewCredentials
type RenewCredentialsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRenewCredentialsRequest creates a request to invoke RenewCredentials API
func CreateRenewCredentialsRequest() (request *RenewCredentialsRequest) {
	request = &RenewCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "RenewCredentials", "", "")
	request.Method = requests.POST
	return
}

// CreateRenewCredentialsResponse creates a response to parse from RenewCredentials response
func CreateRenewCredentialsResponse() (response *RenewCredentialsResponse) {
	response = &RenewCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
