package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConstants invokes the dbfs.CreateConstants API synchronously
func (client *Client) CreateConstants(request *CreateConstantsRequest) (response *CreateConstantsResponse, err error) {
	response = CreateCreateConstantsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConstantsWithChan invokes the dbfs.CreateConstants API asynchronously
func (client *Client) CreateConstantsWithChan(request *CreateConstantsRequest) (<-chan *CreateConstantsResponse, <-chan error) {
	responseChan := make(chan *CreateConstantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConstants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConstantsWithCallback invokes the dbfs.CreateConstants API asynchronously
func (client *Client) CreateConstantsWithCallback(request *CreateConstantsRequest, callback func(response *CreateConstantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConstantsResponse
		var err error
		defer close(result)
		response, err = client.CreateConstants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConstantsRequest is the request struct for api CreateConstants
type CreateConstantsRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ConstantsData string           `position:"Query" name:"ConstantsData"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// CreateConstantsResponse is the response struct for api CreateConstants
type CreateConstantsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Data       string `json:"Data" xml:"Data"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	PageNumber int64  `json:"PageNumber" xml:"PageNumber"`
}

// CreateCreateConstantsRequest creates a request to invoke CreateConstants API
func CreateCreateConstantsRequest() (request *CreateConstantsRequest) {
	request = &CreateConstantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "CreateConstants", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateConstantsResponse creates a response to parse from CreateConstants response
func CreateCreateConstantsResponse() (response *CreateConstantsResponse) {
	response = &CreateConstantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
