package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnEsExceptionData invokes the dcdn.DescribeDcdnEsExceptionData API synchronously
func (client *Client) DescribeDcdnEsExceptionData(request *DescribeDcdnEsExceptionDataRequest) (response *DescribeDcdnEsExceptionDataResponse, err error) {
	response = CreateDescribeDcdnEsExceptionDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnEsExceptionDataWithChan invokes the dcdn.DescribeDcdnEsExceptionData API asynchronously
func (client *Client) DescribeDcdnEsExceptionDataWithChan(request *DescribeDcdnEsExceptionDataRequest) (<-chan *DescribeDcdnEsExceptionDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnEsExceptionDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnEsExceptionData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnEsExceptionDataWithCallback invokes the dcdn.DescribeDcdnEsExceptionData API asynchronously
func (client *Client) DescribeDcdnEsExceptionDataWithCallback(request *DescribeDcdnEsExceptionDataRequest, callback func(response *DescribeDcdnEsExceptionDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnEsExceptionDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnEsExceptionData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnEsExceptionDataRequest is the request struct for api DescribeDcdnEsExceptionData
type DescribeDcdnEsExceptionDataRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	RuleId    string           `position:"Query" name:"RuleId"`
}

// DescribeDcdnEsExceptionDataResponse is the response struct for api DescribeDcdnEsExceptionData
type DescribeDcdnEsExceptionDataResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Contents  []Content `json:"Contents" xml:"Contents"`
}

// CreateDescribeDcdnEsExceptionDataRequest creates a request to invoke DescribeDcdnEsExceptionData API
func CreateDescribeDcdnEsExceptionDataRequest() (request *DescribeDcdnEsExceptionDataRequest) {
	request = &DescribeDcdnEsExceptionDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnEsExceptionData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnEsExceptionDataResponse creates a response to parse from DescribeDcdnEsExceptionData response
func CreateDescribeDcdnEsExceptionDataResponse() (response *DescribeDcdnEsExceptionDataResponse) {
	response = &DescribeDcdnEsExceptionDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
