package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyConsumerChannel invokes the dts.ModifyConsumerChannel API synchronously
func (client *Client) ModifyConsumerChannel(request *ModifyConsumerChannelRequest) (response *ModifyConsumerChannelResponse, err error) {
	response = CreateModifyConsumerChannelResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyConsumerChannelWithChan invokes the dts.ModifyConsumerChannel API asynchronously
func (client *Client) ModifyConsumerChannelWithChan(request *ModifyConsumerChannelRequest) (<-chan *ModifyConsumerChannelResponse, <-chan error) {
	responseChan := make(chan *ModifyConsumerChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyConsumerChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyConsumerChannelWithCallback invokes the dts.ModifyConsumerChannel API asynchronously
func (client *Client) ModifyConsumerChannelWithCallback(request *ModifyConsumerChannelRequest, callback func(response *ModifyConsumerChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyConsumerChannelResponse
		var err error
		defer close(result)
		response, err = client.ModifyConsumerChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyConsumerChannelRequest is the request struct for api ModifyConsumerChannel
type ModifyConsumerChannelRequest struct {
	*requests.RpcRequest
	ConsumerGroupName     string `position:"Query" name:"ConsumerGroupName"`
	ConsumerGroupId       string `position:"Query" name:"ConsumerGroupId"`
	ConsumerGroupPassword string `position:"Query" name:"ConsumerGroupPassword"`
	ConsumerGroupUserName string `position:"Query" name:"ConsumerGroupUserName"`
	DtsJobId              string `position:"Query" name:"DtsJobId"`
	DtsInstanceId         string `position:"Query" name:"DtsInstanceId"`
}

// ModifyConsumerChannelResponse is the response struct for api ModifyConsumerChannel
type ModifyConsumerChannelResponse struct {
	*responses.BaseResponse
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        string `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateModifyConsumerChannelRequest creates a request to invoke ModifyConsumerChannel API
func CreateModifyConsumerChannelRequest() (request *ModifyConsumerChannelRequest) {
	request = &ModifyConsumerChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifyConsumerChannel", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyConsumerChannelResponse creates a response to parse from ModifyConsumerChannel response
func CreateModifyConsumerChannelResponse() (response *ModifyConsumerChannelResponse) {
	response = &ModifyConsumerChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
