package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSecurityGroup invokes the ehpc.AddSecurityGroup API synchronously
func (client *Client) AddSecurityGroup(request *AddSecurityGroupRequest) (response *AddSecurityGroupResponse, err error) {
	response = CreateAddSecurityGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddSecurityGroupWithChan invokes the ehpc.AddSecurityGroup API asynchronously
func (client *Client) AddSecurityGroupWithChan(request *AddSecurityGroupRequest) (<-chan *AddSecurityGroupResponse, <-chan error) {
	responseChan := make(chan *AddSecurityGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSecurityGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSecurityGroupWithCallback invokes the ehpc.AddSecurityGroup API asynchronously
func (client *Client) AddSecurityGroupWithCallback(request *AddSecurityGroupRequest, callback func(response *AddSecurityGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSecurityGroupResponse
		var err error
		defer close(result)
		response, err = client.AddSecurityGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSecurityGroupRequest is the request struct for api AddSecurityGroup
type AddSecurityGroupRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	SecurityGroupId string `position:"Query" name:"SecurityGroupId"`
	ClusterId       string `position:"Query" name:"ClusterId"`
}

// AddSecurityGroupResponse is the response struct for api AddSecurityGroup
type AddSecurityGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddSecurityGroupRequest creates a request to invoke AddSecurityGroup API
func CreateAddSecurityGroupRequest() (request *AddSecurityGroupRequest) {
	request = &AddSecurityGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "AddSecurityGroup", "", "")
	request.Method = requests.GET
	return
}

// CreateAddSecurityGroupResponse creates a response to parse from AddSecurityGroup response
func CreateAddSecurityGroupResponse() (response *AddSecurityGroupResponse) {
	response = &AddSecurityGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
